/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi.stubs.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.stubs.PsiJetModifierListStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetModifierListElementType;
import org.jetbrains.jet.lang.psi.stubs.impl.JetStubBaseImpl;
import org.jetbrains.jet.lexer.JetModifierKeywordToken;
import org.jetbrains.jet.lexer.JetTokens;

public class PsiJetModifierListStubImpl
extends JetStubBaseImpl<JetModifierList>
implements PsiJetModifierListStub {
    private final int mask;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static int computeMaskFromPsi(@NotNull JetModifierList modifierList) {
        if (modifierList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierList", "org/jetbrains/jet/lang/psi/stubs/impl/PsiJetModifierListStubImpl", "computeMaskFromPsi"));
        }
        int mask = 0;
        JetModifierKeywordToken[] orderedKeywords = JetTokens.MODIFIER_KEYWORDS_ARRAY;
        for (int i = 0; i < orderedKeywords.length; ++i) {
            JetModifierKeywordToken modifierKeywordToken = orderedKeywords[i];
            if (!modifierList.hasModifier(modifierKeywordToken)) continue;
            mask |= 1 << i;
        }
        return mask;
    }

    public PsiJetModifierListStubImpl(StubElement parent, int mask, @NotNull JetModifierListElementType<?> elementType) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "org/jetbrains/jet/lang/psi/stubs/impl/PsiJetModifierListStubImpl", "<init>"));
        }
        super((StubElement<? extends PsiElement>)parent, elementType);
        this.mask = mask;
    }

    @Override
    public boolean hasModifier(@NotNull JetModifierKeywordToken modifierToken) {
        if (modifierToken == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierToken", "org/jetbrains/jet/lang/psi/stubs/impl/PsiJetModifierListStubImpl", "hasModifier"));
        }
        int index = ArrayUtil.indexOf(JetTokens.MODIFIER_KEYWORDS_ARRAY, modifierToken);
        if (!$assertionsDisabled && index < 0) {
            throw new AssertionError((Object)"All JetModifierKeywordTokens should present in MODIFIER_KEYWORDS_ARRAY");
        }
        return (this.mask & 1 << index) != 0;
    }

    public int getMask() {
        return this.mask;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("[");
        boolean first = true;
        for (JetModifierKeywordToken modifierKeyword : JetTokens.MODIFIER_KEYWORDS_ARRAY) {
            if (!this.hasModifier(modifierKeyword)) continue;
            if (!first) {
                sb.append(" ");
            }
            sb.append(modifierKeyword.getValue());
            first = false;
        }
        sb.append("]");
        return sb.toString();
    }

    static {
        boolean bl = $assertionsDisabled = !PsiJetModifierListStubImpl.class.desiredAssertionStatus();
        if (!$assertionsDisabled && JetTokens.MODIFIER_KEYWORDS_ARRAY.length > 32) {
            throw new AssertionError((Object)"Current implementation depends on the ability to represent modifier list as bit mask");
        }
    }
}

