/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.intellij.openapi.util.Key;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.MutablePackageFragmentDescriptor;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.MutablePackageFragmentProvider;
import org.jetbrains.jet.lang.resolve.ScriptNameUtil;
import org.jetbrains.jet.lang.resolve.ScriptParameterResolver;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisContext;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.RedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;

public class ScriptHeaderResolver {
    public static final Key<Integer> PRIORITY_KEY = Key.create(JetScript.class.getName() + ".priority");
    @NotNull
    private MutablePackageFragmentProvider packageFragmentProvider;
    @NotNull
    private ScriptParameterResolver scriptParameterResolver;
    @NotNull
    private BindingTrace trace;

    public void setPackageFragmentProvider(@NotNull MutablePackageFragmentProvider packageFragmentProvider) {
        if (packageFragmentProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFragmentProvider", "org/jetbrains/jet/lang/resolve/ScriptHeaderResolver", "setPackageFragmentProvider"));
        }
        this.packageFragmentProvider = packageFragmentProvider;
    }

    public void setScriptParameterResolver(@NotNull ScriptParameterResolver scriptParameterResolver) {
        if (scriptParameterResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptParameterResolver", "org/jetbrains/jet/lang/resolve/ScriptHeaderResolver", "setScriptParameterResolver"));
        }
        this.scriptParameterResolver = scriptParameterResolver;
    }

    public void setTrace(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/ScriptHeaderResolver", "setTrace"));
        }
        this.trace = trace;
    }

    public void processScriptHierarchy(@NotNull TopDownAnalysisContext c, @NotNull JetScript script, @NotNull WritableScope outerScope) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/ScriptHeaderResolver", "processScriptHierarchy"));
        }
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/jet/lang/resolve/ScriptHeaderResolver", "processScriptHierarchy"));
        }
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/jet/lang/resolve/ScriptHeaderResolver", "processScriptHierarchy"));
        }
        JetFile file = script.getContainingJetFile();
        FqName fqName = file.getPackageFqName();
        MutablePackageFragmentDescriptor ns = this.packageFragmentProvider.getOrCreateFragment(fqName);
        Integer priority = ScriptHeaderResolver.getScriptPriority(script);
        FqName nameForScript = ScriptNameUtil.classNameForScript(script);
        Name className = nameForScript.shortName();
        ScriptDescriptorImpl scriptDescriptor = new ScriptDescriptorImpl(ns, priority, outerScope, className);
        WritableScopeImpl scriptScope = new WritableScopeImpl(outerScope, scriptDescriptor, RedeclarationHandler.DO_NOTHING, "script");
        scriptScope.changeLockLevel(WritableScope.LockLevel.BOTH);
        scriptDescriptor.setScopeForBodyResolution(scriptScope);
        c.getScripts().put(script, scriptDescriptor);
        this.trace.record(BindingContext.SCRIPT, script, scriptDescriptor);
        outerScope.addClassifierDescriptor(scriptDescriptor.getClassDescriptor());
    }

    public static int getScriptPriority(@NotNull JetScript script) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/jet/lang/resolve/ScriptHeaderResolver", "getScriptPriority"));
        }
        Integer priority = script.getUserData(PRIORITY_KEY);
        return priority == null ? 0 : priority;
    }

    public void resolveScriptDeclarations(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/ScriptHeaderResolver", "resolveScriptDeclarations"));
        }
        for (Map.Entry<JetScript, ScriptDescriptor> e : c.getScripts().entrySet()) {
            JetScript declaration = e.getKey();
            ScriptDescriptorImpl descriptor = (ScriptDescriptorImpl)e.getValue();
            List<ValueParameterDescriptor> valueParameters = this.scriptParameterResolver.resolveScriptParameters(declaration, descriptor);
            descriptor.setValueParameters(valueParameters);
            WritableScope scope = descriptor.getScopeForBodyResolution();
            scope.setImplicitReceiver(descriptor.getThisAsReceiverParameter());
            for (ValueParameterDescriptor valueParameterDescriptor : valueParameters) {
                scope.addVariableDescriptor(valueParameterDescriptor);
            }
        }
    }
}

