/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.structure.impl;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.resolve.java.jetAsJava.JetJavaMirrorMarker;
import org.jetbrains.jet.lang.resolve.java.structure.JavaAnnotation;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClassifierType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaField;
import org.jetbrains.jet.lang.resolve.java.structure.JavaMethod;
import org.jetbrains.jet.lang.resolve.java.structure.JavaTypeParameter;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaAnnotationOwnerImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaClassifierImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaClassifierTypeImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaElementCollectionFromPsiArrayUtil;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaElementUtil;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaModifierListOwnerImpl;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public class JavaClassImpl
extends JavaClassifierImpl<PsiClass>
implements JavaClass,
JavaAnnotationOwnerImpl,
JavaModifierListOwnerImpl {
    public JavaClassImpl(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaClassImpl", "<init>"));
        }
        super(psiClass);
        assert (!(psiClass instanceof PsiTypeParameter)) : "PsiTypeParameter should be wrapped in JavaTypeParameter, not JavaClass: use JavaClassifier.create()";
    }

    @Override
    @NotNull
    public Collection<JavaClass> getInnerClasses() {
        Collection<JavaClass> collection = JavaElementCollectionFromPsiArrayUtil.classes(((PsiClass)this.getPsi()).getInnerClasses());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaClassImpl", "getInnerClasses"));
        }
        return collection;
    }

    @Override
    @Nullable
    public FqName getFqName() {
        String qualifiedName = ((PsiClass)this.getPsi()).getQualifiedName();
        return qualifiedName == null ? null : new FqName(qualifiedName);
    }

    @Override
    @NotNull
    public Name getName() {
        Name name = Name.identifier(((PsiClass)this.getPsi()).getName());
        if (name == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaClassImpl", "getName"));
        }
        return name;
    }

    @Override
    public boolean isInterface() {
        return ((PsiClass)this.getPsi()).isInterface();
    }

    @Override
    public boolean isAnnotationType() {
        return ((PsiClass)this.getPsi()).isAnnotationType();
    }

    @Override
    public boolean isEnum() {
        return ((PsiClass)this.getPsi()).isEnum();
    }

    @Override
    @Nullable
    public JavaClass getOuterClass() {
        PsiClass outer = ((PsiClass)this.getPsi()).getContainingClass();
        return outer == null ? null : new JavaClassImpl(outer);
    }

    @Override
    @NotNull
    public List<JavaTypeParameter> getTypeParameters() {
        List<JavaTypeParameter> list = JavaElementCollectionFromPsiArrayUtil.typeParameters(((PsiClass)this.getPsi()).getTypeParameters());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaClassImpl", "getTypeParameters"));
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<JavaClassifierType> getSupertypes() {
        Collection<JavaClassifierType> superClasses = JavaElementCollectionFromPsiArrayUtil.classifierTypes(((PsiClass)this.getPsi()).getExtendsListTypes());
        Collection<JavaClassifierType> superInterfaces = JavaElementCollectionFromPsiArrayUtil.classifierTypes(((PsiClass)this.getPsi()).getImplementsListTypes());
        List<JavaClassifierType> list = ContainerUtil.collect(ContainerUtil.concat(superClasses, superInterfaces).iterator());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaClassImpl", "getSupertypes"));
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<JavaMethod> getMethods() {
        Collection<JavaMethod> collection = JavaElementCollectionFromPsiArrayUtil.methods(((PsiClass)this.getPsi()).getMethods());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaClassImpl", "getMethods"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<JavaMethod> getAllMethods() {
        Collection<JavaMethod> collection = JavaElementCollectionFromPsiArrayUtil.methods(((PsiClass)this.getPsi()).getAllMethods());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaClassImpl", "getAllMethods"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<JavaField> getFields() {
        Collection<JavaField> collection = JavaElementCollectionFromPsiArrayUtil.fields(((PsiClass)this.getPsi()).getFields());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaClassImpl", "getFields"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<JavaField> getAllFields() {
        Collection<JavaField> collection = JavaElementCollectionFromPsiArrayUtil.fields(((PsiClass)this.getPsi()).getAllFields());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaClassImpl", "getAllFields"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<JavaMethod> getConstructors() {
        Collection<JavaMethod> collection = JavaElementCollectionFromPsiArrayUtil.methods(((PsiClass)this.getPsi()).getConstructors());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaClassImpl", "getConstructors"));
        }
        return collection;
    }

    @Override
    public boolean isAbstract() {
        return JavaElementUtil.isAbstract(this);
    }

    @Override
    public boolean isStatic() {
        return JavaElementUtil.isStatic(this);
    }

    @Override
    public boolean isFinal() {
        return JavaElementUtil.isFinal(this);
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        Visibility visibility = JavaElementUtil.getVisibility(this);
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaClassImpl", "getVisibility"));
        }
        return visibility;
    }

    @Override
    @NotNull
    public Collection<JavaAnnotation> getAnnotations() {
        Collection<JavaAnnotation> collection = JavaElementUtil.getAnnotations(this);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaClassImpl", "getAnnotations"));
        }
        return collection;
    }

    @Override
    @Nullable
    public JavaAnnotation findAnnotation(@NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaClassImpl", "findAnnotation"));
        }
        return JavaElementUtil.findAnnotation(this, fqName);
    }

    @Override
    @NotNull
    public JavaClassifierType getDefaultType() {
        JavaClassifierTypeImpl javaClassifierTypeImpl = new JavaClassifierTypeImpl(JavaPsiFacade.getElementFactory(((PsiClass)this.getPsi()).getProject()).createType((PsiClass)this.getPsi()));
        if (javaClassifierTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaClassImpl", "getDefaultType"));
        }
        return javaClassifierTypeImpl;
    }

    @Override
    @NotNull
    public JavaClass.OriginKind getOriginKind() {
        PsiClass psiClass = (PsiClass)this.getPsi();
        if (psiClass instanceof JetJavaMirrorMarker) {
            JavaClass.OriginKind originKind = JavaClass.OriginKind.KOTLIN_LIGHT_CLASS;
            if (originKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaClassImpl", "getOriginKind"));
            }
            return originKind;
        }
        if (psiClass instanceof PsiCompiledElement) {
            JavaClass.OriginKind originKind = JavaClass.OriginKind.COMPILED;
            if (originKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaClassImpl", "getOriginKind"));
            }
            return originKind;
        }
        JavaClass.OriginKind originKind = JavaClass.OriginKind.SOURCE;
        if (originKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaClassImpl", "getOriginKind"));
        }
        return originKind;
    }
}

