/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.structure.impl;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.structure.JavaArrayType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaType;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaArrayTypeImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaClassifierTypeImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaPrimitiveTypeImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaWildcardTypeImpl;

public abstract class JavaTypeImpl<Psi extends PsiType>
implements JavaType {
    private final Psi psiType;

    public JavaTypeImpl(@NotNull Psi psiType) {
        if (psiType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiType", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaTypeImpl", "<init>"));
        }
        this.psiType = psiType;
    }

    @NotNull
    public Psi getPsi() {
        Psi Psi = this.psiType;
        if (Psi == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaTypeImpl", "getPsi"));
        }
        return Psi;
    }

    @NotNull
    public static JavaTypeImpl<?> create(@NotNull PsiType psiType) {
        if (psiType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiType", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaTypeImpl", "create"));
        }
        JavaTypeImpl javaTypeImpl = (JavaTypeImpl)psiType.accept(new PsiTypeVisitor<JavaTypeImpl<?>>(){

            @Override
            @Nullable
            public JavaTypeImpl<?> visitType(PsiType type) {
                throw new UnsupportedOperationException("Unsupported PsiType: " + type);
            }

            @Override
            @Nullable
            public JavaTypeImpl<?> visitPrimitiveType(PsiPrimitiveType primitiveType) {
                return new JavaPrimitiveTypeImpl(primitiveType);
            }

            @Override
            @Nullable
            public JavaTypeImpl<?> visitArrayType(PsiArrayType arrayType) {
                return new JavaArrayTypeImpl(arrayType);
            }

            @Override
            @Nullable
            public JavaTypeImpl<?> visitClassType(PsiClassType classType) {
                return new JavaClassifierTypeImpl(classType);
            }

            @Override
            @Nullable
            public JavaTypeImpl<?> visitWildcardType(PsiWildcardType wildcardType) {
                return new JavaWildcardTypeImpl(wildcardType);
            }
        });
        if (javaTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaTypeImpl", "create"));
        }
        return javaTypeImpl;
    }

    @Override
    @NotNull
    public JavaArrayType createArrayType() {
        JavaArrayTypeImpl javaArrayTypeImpl = new JavaArrayTypeImpl(((PsiType)this.getPsi()).createArrayType());
        if (javaArrayTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaTypeImpl", "createArrayType"));
        }
        return javaArrayTypeImpl;
    }

    public int hashCode() {
        return this.getPsi().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof JavaTypeImpl && this.getPsi().equals(((JavaTypeImpl)obj).getPsi());
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.getPsi();
    }
}

