/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.checker;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.TypingConstraints;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class TypeCheckingProcedure {
    private final TypingConstraints constraints;

    @Nullable
    public static JetType findCorrespondingSupertype(@NotNull JetType subtype, @NotNull JetType supertype) {
        if (subtype == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subtype", "org/jetbrains/jet/lang/types/checker/TypeCheckingProcedure", "findCorrespondingSupertype"));
        }
        if (supertype == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertype", "org/jetbrains/jet/lang/types/checker/TypeCheckingProcedure", "findCorrespondingSupertype"));
        }
        TypeConstructor constructor = subtype.getConstructor();
        if (constructor.equals(supertype.getConstructor())) {
            return subtype;
        }
        for (JetType immediateSupertype : constructor.getSupertypes()) {
            JetType correspondingSupertype = TypeCheckingProcedure.findCorrespondingSupertype(immediateSupertype, supertype);
            if (correspondingSupertype == null) continue;
            return TypeSubstitutor.create(subtype).safeSubstitute(correspondingSupertype, Variance.INVARIANT);
        }
        return null;
    }

    public static JetType getOutType(TypeParameterDescriptor parameter, TypeProjection argument) {
        boolean isOutProjected = argument.getProjectionKind() == Variance.IN_VARIANCE || parameter.getVariance() == Variance.IN_VARIANCE;
        return isOutProjected ? parameter.getUpperBoundsAsType() : argument.getType();
    }

    public static JetType getInType(TypeParameterDescriptor parameter, TypeProjection argument) {
        boolean isOutProjected = argument.getProjectionKind() == Variance.OUT_VARIANCE || parameter.getVariance() == Variance.OUT_VARIANCE;
        return isOutProjected ? KotlinBuiltIns.getInstance().getNothingType() : argument.getType();
    }

    public TypeCheckingProcedure(TypingConstraints constraints) {
        this.constraints = constraints;
    }

    public boolean equalTypes(@NotNull JetType type1, @NotNull JetType type2) {
        TypeConstructor constructor2;
        if (type1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type1", "org/jetbrains/jet/lang/types/checker/TypeCheckingProcedure", "equalTypes"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type2", "org/jetbrains/jet/lang/types/checker/TypeCheckingProcedure", "equalTypes"));
        }
        if (type1.isNullable() != type2.isNullable()) {
            return false;
        }
        if (type1.isNullable()) {
            return this.constraints.assertEqualTypes(TypeUtils.makeNotNullable(type1), TypeUtils.makeNotNullable(type2), this);
        }
        TypeConstructor constructor1 = type1.getConstructor();
        if (!this.constraints.assertEqualTypeConstructors(constructor1, constructor2 = type2.getConstructor())) {
            return false;
        }
        List<TypeProjection> type1Arguments = type1.getArguments();
        List<TypeProjection> type2Arguments = type2.getArguments();
        if (type1Arguments.size() != type2Arguments.size()) {
            return false;
        }
        for (int i = 0; i < type1Arguments.size(); ++i) {
            TypeParameterDescriptor typeParameter1 = constructor1.getParameters().get(i);
            TypeProjection typeProjection1 = type1Arguments.get(i);
            TypeParameterDescriptor typeParameter2 = constructor2.getParameters().get(i);
            TypeProjection typeProjection2 = type2Arguments.get(i);
            if (TypeCheckingProcedure.getEffectiveProjectionKind(typeParameter1, typeProjection1) != TypeCheckingProcedure.getEffectiveProjectionKind(typeParameter2, typeProjection2)) {
                return false;
            }
            if (this.constraints.assertEqualTypes(typeProjection1.getType(), typeProjection2.getType(), this)) continue;
            return false;
        }
        return true;
    }

    public static EnrichedProjectionKind getEffectiveProjectionKind(@NotNull TypeParameterDescriptor typeParameter, @NotNull TypeProjection typeArgument) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "org/jetbrains/jet/lang/types/checker/TypeCheckingProcedure", "getEffectiveProjectionKind"));
        }
        if (typeArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeArgument", "org/jetbrains/jet/lang/types/checker/TypeCheckingProcedure", "getEffectiveProjectionKind"));
        }
        Variance a = typeParameter.getVariance();
        Variance b = typeArgument.getProjectionKind();
        if (b == Variance.INVARIANT) {
            Variance t = a;
            a = b;
            b = t;
        }
        if (a == Variance.IN_VARIANCE && b == Variance.OUT_VARIANCE) {
            return EnrichedProjectionKind.STAR;
        }
        if (a == Variance.OUT_VARIANCE && b == Variance.IN_VARIANCE) {
            return EnrichedProjectionKind.STAR;
        }
        return EnrichedProjectionKind.fromVariance(b);
    }

    public boolean isSubtypeOf(@NotNull JetType subtype, @NotNull JetType supertype) {
        if (subtype == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subtype", "org/jetbrains/jet/lang/types/checker/TypeCheckingProcedure", "isSubtypeOf"));
        }
        if (supertype == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertype", "org/jetbrains/jet/lang/types/checker/TypeCheckingProcedure", "isSubtypeOf"));
        }
        if (subtype.isError() || supertype.isError()) {
            return true;
        }
        if (!supertype.isNullable() && subtype.isNullable()) {
            return false;
        }
        subtype = TypeUtils.makeNotNullable(subtype);
        supertype = TypeUtils.makeNotNullable(supertype);
        if (KotlinBuiltIns.getInstance().isNothingOrNullableNothing(subtype)) {
            return true;
        }
        JetType closestSupertype = TypeCheckingProcedure.findCorrespondingSupertype(subtype, supertype);
        if (closestSupertype == null) {
            return this.constraints.noCorrespondingSupertype(subtype, supertype);
        }
        return this.checkSubtypeForTheSameConstructor(closestSupertype, supertype);
    }

    private boolean checkSubtypeForTheSameConstructor(@NotNull JetType subtype, @NotNull JetType supertype) {
        if (subtype == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subtype", "org/jetbrains/jet/lang/types/checker/TypeCheckingProcedure", "checkSubtypeForTheSameConstructor"));
        }
        if (supertype == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertype", "org/jetbrains/jet/lang/types/checker/TypeCheckingProcedure", "checkSubtypeForTheSameConstructor"));
        }
        TypeConstructor constructor = subtype.getConstructor();
        assert (constructor.equals(supertype.getConstructor())) : constructor + " is not " + supertype.getConstructor();
        List<TypeProjection> subArguments = subtype.getArguments();
        List<TypeProjection> superArguments = supertype.getArguments();
        if (subArguments.size() != superArguments.size()) {
            return false;
        }
        List<TypeParameterDescriptor> parameters = constructor.getParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            boolean argumentIsErrorType;
            TypeParameterDescriptor parameter = parameters.get(i);
            TypeProjection subArgument = subArguments.get(i);
            JetType subIn = TypeCheckingProcedure.getInType(parameter, subArgument);
            JetType subOut = TypeCheckingProcedure.getOutType(parameter, subArgument);
            TypeProjection superArgument = superArguments.get(i);
            JetType superIn = TypeCheckingProcedure.getInType(parameter, superArgument);
            JetType superOut = TypeCheckingProcedure.getOutType(parameter, superArgument);
            boolean bl = argumentIsErrorType = subArgument.getType().isError() || superArgument.getType().isError();
            if (!argumentIsErrorType && parameter.getVariance() == Variance.INVARIANT && subArgument.getProjectionKind() == Variance.INVARIANT && superArgument.getProjectionKind() == Variance.INVARIANT) {
                if (this.constraints.assertEqualTypes(subArgument.getType(), superArgument.getType(), this)) continue;
                return false;
            }
            if (!this.constraints.assertSubtype(subOut, superOut, this)) {
                return false;
            }
            if (this.constraints.assertSubtype(superIn, subIn, this)) continue;
            return false;
        }
        return true;
    }

    public static enum EnrichedProjectionKind {
        IN,
        OUT,
        INV,
        STAR;


        @NotNull
        public static EnrichedProjectionKind fromVariance(@NotNull Variance variance) {
            if (variance == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variance", "org/jetbrains/jet/lang/types/checker/TypeCheckingProcedure$EnrichedProjectionKind", "fromVariance"));
            }
            switch (variance) {
                case INVARIANT: {
                    EnrichedProjectionKind enrichedProjectionKind = INV;
                    if (enrichedProjectionKind == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/checker/TypeCheckingProcedure$EnrichedProjectionKind", "fromVariance"));
                    }
                    return enrichedProjectionKind;
                }
                case IN_VARIANCE: {
                    EnrichedProjectionKind enrichedProjectionKind = IN;
                    if (enrichedProjectionKind == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/checker/TypeCheckingProcedure$EnrichedProjectionKind", "fromVariance"));
                    }
                    return enrichedProjectionKind;
                }
                case OUT_VARIANCE: {
                    EnrichedProjectionKind enrichedProjectionKind = OUT;
                    if (enrichedProjectionKind == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/checker/TypeCheckingProcedure$EnrichedProjectionKind", "fromVariance"));
                    }
                    return enrichedProjectionKind;
                }
            }
            throw new IllegalStateException("Unknown variance");
        }
    }
}

