/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.config;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetPsiFactory;
import org.jetbrains.k2js.config.ClassPathLibraryDefintionsConfig;

public final class MetaInfServices {
    private MetaInfServices() {
    }

    public static List<JetFile> loadServicesFiles(@NotNull String metaInfServicesFile, @NotNull Project project) {
        if (metaInfServicesFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaInfServicesFile", "org/jetbrains/k2js/config/MetaInfServices", "loadServicesFiles"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/k2js/config/MetaInfServices", "loadServicesFiles"));
        }
        ArrayList<JetFile> libFiles = new ArrayList<JetFile>();
        HashSet<URL> urlsLoaded = new HashSet<URL>();
        try {
            Enumeration<URL> resources = MetaInfServices.class.getClassLoader().getResources(metaInfServicesFile);
            MetaInfServices.loadLibFiles(resources, urlsLoaded, libFiles, project);
            resources = Thread.currentThread().getContextClassLoader().getResources(metaInfServicesFile);
            MetaInfServices.loadLibFiles(resources, urlsLoaded, libFiles, project);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return libFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadLibFiles(@NotNull Enumeration<URL> resources, @NotNull Set<URL> urlsLoaded, @NotNull List<JetFile> libFiles, @NotNull Project project) throws IOException {
        if (resources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resources", "org/jetbrains/k2js/config/MetaInfServices", "loadLibFiles"));
        }
        if (urlsLoaded == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlsLoaded", "org/jetbrains/k2js/config/MetaInfServices", "loadLibFiles"));
        }
        if (libFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libFiles", "org/jetbrains/k2js/config/MetaInfServices", "loadLibFiles"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/k2js/config/MetaInfServices", "loadLibFiles"));
        }
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            if (url == null || !urlsLoaded.add(url)) continue;
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    InputStream stream2;
                    if ((line = line.trim()).length() == 0 || line.startsWith("#") || (stream2 = MetaInfServices.loadClasspathResource(line)) == null) continue;
                    String text = StringUtil.convertLineSeparators(FileUtil.loadTextAndClose(stream2));
                    libFiles.add(JetPsiFactory.createFile(project, line, text));
                }
            }
            finally {
                reader.close();
            }
        }
    }

    public static InputStream loadClasspathResource(String resourceName) {
        InputStream answer = ClassPathLibraryDefintionsConfig.class.getClassLoader().getResourceAsStream(resourceName);
        if (answer == null) {
            answer = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
        }
        return answer;
    }
}

