/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.DelegateLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class MergingLexerAdapterBase
extends DelegateLexer {
    private IElementType myTokenType;
    private int myState;
    private int myTokenStart;
    private final MergeFunction myMergeFunction;

    public MergingLexerAdapterBase(Lexer original, MergeFunction mergeFunction) {
        super(original);
        this.myMergeFunction = mergeFunction;
    }

    @Override
    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lexer/MergingLexerAdapterBase", "start"));
        }
        super.start(buffer, startOffset, endOffset, initialState);
        this.myTokenType = null;
    }

    @Override
    public int getState() {
        if (this.myTokenType == null) {
            this.locateToken();
        }
        return this.myState;
    }

    @Override
    public IElementType getTokenType() {
        if (this.myTokenType == null) {
            this.locateToken();
        }
        return this.myTokenType;
    }

    @Override
    public int getTokenStart() {
        if (this.myTokenType == null) {
            this.locateToken();
        }
        return this.myTokenStart;
    }

    @Override
    public int getTokenEnd() {
        if (this.myTokenType == null) {
            this.locateToken();
        }
        return super.getTokenStart();
    }

    @Override
    public void advance() {
        this.myTokenType = null;
    }

    private void locateToken() {
        if (this.myTokenType == null) {
            Lexer orig = this.getDelegate();
            this.myTokenType = orig.getTokenType();
            this.myTokenStart = orig.getTokenStart();
            this.myState = orig.getState();
            if (this.myTokenType == null) {
                return;
            }
            orig.advance();
            this.myTokenType = this.myMergeFunction.merge(this.myTokenType, orig);
        }
    }

    public Lexer getOriginal() {
        return this.getDelegate();
    }

    @Override
    public void restore(@NotNull LexerPosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lexer/MergingLexerAdapterBase", "restore"));
        }
        MyLexerPosition pos = (MyLexerPosition)position;
        this.getDelegate().restore(pos.getOriginalPosition());
        this.myTokenType = pos.getType();
        this.myTokenStart = pos.getOffset();
        this.myState = pos.getOldState();
    }

    @Override
    @NotNull
    public LexerPosition getCurrentPosition() {
        MyLexerPosition myLexerPosition = new MyLexerPosition(this.myTokenStart, this.myTokenType, this.getDelegate().getCurrentPosition(), this.myState);
        if (myLexerPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lexer/MergingLexerAdapterBase", "getCurrentPosition"));
        }
        return myLexerPosition;
    }

    protected static interface MergeFunction {
        public IElementType merge(IElementType var1, Lexer var2);
    }

    private static class MyLexerPosition
    implements LexerPosition {
        private final int myOffset;
        private final IElementType myTokenType;
        private final LexerPosition myOriginalPosition;
        private final int myOldState;

        public MyLexerPosition(int offset, IElementType tokenType, LexerPosition originalPosition, int oldState) {
            this.myOffset = offset;
            this.myTokenType = tokenType;
            this.myOriginalPosition = originalPosition;
            this.myOldState = oldState;
        }

        @Override
        public int getOffset() {
            return this.myOffset;
        }

        @Override
        public int getState() {
            return this.myOriginalPosition.getState();
        }

        public IElementType getType() {
            return this.myTokenType;
        }

        public LexerPosition getOriginalPosition() {
            return this.myOriginalPosition;
        }

        public int getOldState() {
            return this.myOldState;
        }
    }
}

