/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VfsUtilCore {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.vfs.VfsUtilCore");

    public static boolean isAncestor(@NotNull VirtualFile ancestor, @NotNull VirtualFile file, boolean strict) {
        VirtualFile parent;
        if (ancestor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/VfsUtilCore", "isAncestor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/VfsUtilCore", "isAncestor"));
        }
        if (!file.getFileSystem().equals(ancestor.getFileSystem())) {
            return false;
        }
        VirtualFile virtualFile = parent = strict ? file.getParent() : file;
        while (parent != null) {
            if (parent.equals(ancestor)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    @Nullable
    public static VirtualFile getVirtualFileForJar(@Nullable VirtualFile entryVFile) {
        if (entryVFile == null) {
            return null;
        }
        String path = entryVFile.getPath();
        int separatorIndex = path.indexOf("!/");
        if (separatorIndex < 0) {
            return null;
        }
        String localPath = path.substring(0, separatorIndex);
        return VirtualFileManager.getInstance().findFileByUrl("file://" + localPath);
    }

    public static VirtualFile copyFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile toDir) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/VfsUtilCore", "copyFile"));
        }
        if (toDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vfs/VfsUtilCore", "copyFile"));
        }
        return VfsUtilCore.copyFile(requestor, file, toDir, file.getName());
    }

    public static VirtualFile copyFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile toDir, @NotNull @NonNls String newName) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/VfsUtilCore", "copyFile"));
        }
        if (toDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vfs/VfsUtilCore", "copyFile"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/vfs/VfsUtilCore", "copyFile"));
        }
        VirtualFile newChild = toDir.createChildData(requestor, newName);
        newChild.setBinaryContent(file.contentsToByteArray());
        return newChild;
    }

    @NotNull
    public static InputStream byteStreamSkippingBOM(@NotNull byte[] buf, @NotNull VirtualFile file) throws IOException {
        if (buf == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/VfsUtilCore", "byteStreamSkippingBOM"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/VfsUtilCore", "byteStreamSkippingBOM"));
        }
        BufferExposingByteArrayInputStream stream2 = new BufferExposingByteArrayInputStream(buf);
        InputStream inputStream = VfsUtilCore.inputStreamSkippingBOM(stream2, file);
        if (inputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtilCore", "byteStreamSkippingBOM"));
        }
        return inputStream;
    }

    @NotNull
    public static InputStream inputStreamSkippingBOM(@NotNull InputStream stream2, @NotNull VirtualFile file) throws IOException {
        if (stream2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/VfsUtilCore", "inputStreamSkippingBOM"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/VfsUtilCore", "inputStreamSkippingBOM"));
        }
        InputStream inputStream = CharsetToolkit.inputStreamSkippingBOM(stream2);
        if (inputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtilCore", "inputStreamSkippingBOM"));
        }
        return inputStream;
    }

    @NotNull
    public static OutputStream outputStreamAddingBOM(@NotNull OutputStream stream2, @NotNull VirtualFile file) throws IOException {
        if (stream2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/VfsUtilCore", "outputStreamAddingBOM"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/VfsUtilCore", "outputStreamAddingBOM"));
        }
        byte[] bom = file.getBOM();
        if (bom != null) {
            stream2.write(bom);
        }
        OutputStream outputStream = stream2;
        if (outputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtilCore", "outputStreamAddingBOM"));
        }
        return outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static VirtualFileVisitor.Result visitChildrenRecursively(@NotNull VirtualFile file, @NotNull VirtualFileVisitor<?> visitor) throws VirtualFileVisitor.VisitorException {
        block27: {
            block26: {
                block25: {
                    block24: {
                        if (file == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", new Object[]{"0", "com/intellij/openapi/vfs/VfsUtilCore", "visitChildrenRecursively"}));
                        }
                        if (visitor == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", new Object[]{"1", "com/intellij/openapi/vfs/VfsUtilCore", "visitChildrenRecursively"}));
                        }
                        pushed = false;
                        visited = visitor.allowVisitFile(file);
                        if (visited) {
                            result = visitor.visitFileEx(file);
                            if (result.skipChildren) {
                                var5_5 = result;
                                v0 = var5_5;
                                if (v0 == null) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/openapi/vfs/VfsUtilCore", "visitChildrenRecursively"}));
                                }
                                return v0;
                            }
                        }
                        childrenIterable = null;
                        children = null;
                        try {
                            if (file.isValid() && visitor.allowVisitChildren(file) && !visitor.depthLimitReached() && (childrenIterable = visitor.getChildrenIterable(file)) == null) {
                                children = file.getChildren();
                            }
                        }
                        catch (InvalidVirtualFileAccessException e) {
                            VfsUtilCore.LOG.info("Ignoring: " + e.getMessage());
                            var7_9 = VirtualFileVisitor.CONTINUE;
                            visitor.restoreValue(pushed);
                            v1 = var7_9;
                            if (v1 == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/openapi/vfs/VfsUtilCore", "visitChildrenRecursively"}));
                            }
                            return v1;
                        }
                        if (childrenIterable == null) break block24;
                        visitor.saveValue();
                        pushed = true;
                        i$ = childrenIterable.iterator();
                        break block25;
                    }
                    if (children == null || children.length == 0) break block26;
                    break block27;
                }
                while (i$.hasNext()) {
                    child = (VirtualFile)i$.next();
                    result = VfsUtilCore.visitChildrenRecursively(child, visitor);
                    if (result.skipToParent == null || Comparing.equal(result.skipToParent, child)) continue;
                    var9_14 = result;
                    v2 = var9_14;
                    if (v2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/openapi/vfs/VfsUtilCore", "visitChildrenRecursively"}));
                    }
                    return v2;
                }
            }
            while (true) {
                if (visited) {
                    visitor.afterChildrenVisited(file);
                }
                var6_8 = VirtualFileVisitor.CONTINUE;
                v3 = var6_8;
                if (v3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/openapi/vfs/VfsUtilCore", "visitChildrenRecursively"}));
                }
                return v3;
            }
            finally {
                visitor.restoreValue(pushed);
            }
        }
        visitor.saveValue();
        pushed = true;
        arr$ = children;
        len$ = arr$.length;
        i$ = 0;
        while (true) {
            if (i$ >= len$) ** continue;
            child = arr$[i$];
            result = VfsUtilCore.visitChildrenRecursively(child, visitor);
            if (result.skipToParent != null && !Comparing.equal(result.skipToParent, child)) {
                var11_17 = result;
                v4 = var11_17;
                if (v4 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/openapi/vfs/VfsUtilCore", "visitChildrenRecursively"}));
                }
                return v4;
            }
            ++i$;
        }
    }

    public static boolean isInvalidLink(@NotNull VirtualFile link) {
        if (link == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/VfsUtilCore", "isInvalidLink"));
        }
        VirtualFile target = link.getCanonicalFile();
        return target == null || target.equals(link) || VfsUtilCore.isAncestor(target, link, true);
    }

    @NotNull
    public static File virtualToIoFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/VfsUtilCore", "virtualToIoFile"));
        }
        File file2 = new File(PathUtil.toPresentableUrl(file.getUrl()));
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VfsUtilCore", "virtualToIoFile"));
        }
        return file2;
    }
}

