/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.common;

import com.sampullara.cli.Argument;
import java.io.PrintStream;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.jet.cli.common.arguments.ValueDescription;

class Usage {
    Usage() {
    }

    public static void print(@NotNull PrintStream target, @NotNull CommonCompilerArguments arguments) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/jet/cli/common/Usage", "print"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/jet/cli/common/Usage", "print"));
        }
        target.println("Usage: " + arguments.executableScriptFileName() + " <options> <source files>");
        target.println("where possible options include:");
        for (Class<?> clazz = arguments.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                String usage = Usage.fieldUsage(field);
                if (usage == null) continue;
                target.println(usage);
            }
        }
    }

    @Nullable
    private static String fieldUsage(@NotNull Field field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/jet/cli/common/Usage", "fieldUsage"));
        }
        Argument argument = field.getAnnotation(Argument.class);
        if (argument == null) {
            return null;
        }
        ValueDescription description = field.getAnnotation(ValueDescription.class);
        String prefix = argument.prefix();
        StringBuilder sb = new StringBuilder("  ");
        sb.append(prefix);
        if (argument.value().isEmpty()) {
            sb.append(field.getName());
        } else {
            sb.append(argument.value());
        }
        if (!argument.alias().isEmpty()) {
            sb.append(" (");
            sb.append(prefix);
            sb.append(argument.alias());
            sb.append(")");
        }
        if (description != null) {
            sb.append(" ");
            sb.append(description.value());
        }
        while (sb.length() < 29) {
            sb.append(" ");
        }
        sb.append(argument.description());
        return sb.toString();
    }
}

