/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.binding;

import com.intellij.openapi.util.Pair;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.binding.CalculatedClosure;
import org.jetbrains.jet.codegen.context.EnclosedValueDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.psi.JetDelegatorToSuperCall;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.org.objectweb.asm.Type;

public final class MutableClosure
implements CalculatedClosure {
    private final JetDelegatorToSuperCall superCall;
    private final ClassDescriptor enclosingClass;
    private final CallableDescriptor enclosingReceiverDescriptor;
    private boolean captureThis;
    private boolean captureReceiver;
    private Map<DeclarationDescriptor, EnclosedValueDescriptor> captureVariables;
    private List<Pair<String, Type>> recordedFields;

    MutableClosure(JetDelegatorToSuperCall superCall, ClassDescriptor enclosingClass, CallableDescriptor enclosingReceiverDescriptor) {
        this.superCall = superCall;
        this.enclosingClass = enclosingClass;
        this.enclosingReceiverDescriptor = enclosingReceiverDescriptor;
    }

    @Override
    @Nullable
    public ClassDescriptor getEnclosingClass() {
        return this.enclosingClass;
    }

    @Override
    public JetDelegatorToSuperCall getSuperCall() {
        return this.superCall;
    }

    @Override
    public ClassDescriptor getCaptureThis() {
        return this.captureThis ? this.enclosingClass : null;
    }

    public void setCaptureThis() {
        this.captureThis = true;
    }

    @Override
    public JetType getCaptureReceiverType() {
        if (this.captureReceiver) {
            ReceiverParameterDescriptor parameter = this.enclosingReceiverDescriptor.getReceiverParameter();
            assert (parameter != null) : "Receiver parameter should exist in " + this.enclosingReceiverDescriptor;
            return parameter.getType();
        }
        return null;
    }

    public void setCaptureReceiver() {
        if (this.enclosingReceiverDescriptor == null) {
            throw new IllegalStateException();
        }
        this.captureReceiver = true;
    }

    @Override
    @NotNull
    public Map<DeclarationDescriptor, EnclosedValueDescriptor> getCaptureVariables() {
        Map<DeclarationDescriptor, EnclosedValueDescriptor> map2 = this.captureVariables != null ? this.captureVariables : Collections.emptyMap();
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/binding/MutableClosure", "getCaptureVariables"));
        }
        return map2;
    }

    @Override
    @NotNull
    public List<Pair<String, Type>> getRecordedFields() {
        List<Pair<String, Type>> list = this.recordedFields != null ? this.recordedFields : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/binding/MutableClosure", "getRecordedFields"));
        }
        return list;
    }

    public void recordField(String name, Type type) {
        if (this.recordedFields == null) {
            this.recordedFields = new LinkedList<Pair<String, Type>>();
        }
        this.recordedFields.add(new Pair<String, Type>(name, type));
    }

    public void captureVariable(EnclosedValueDescriptor value) {
        if (this.captureVariables == null) {
            this.captureVariables = new HashMap<DeclarationDescriptor, EnclosedValueDescriptor>();
        }
        this.captureVariables.put(value.getDescriptor(), value);
    }

    public CallableDescriptor getEnclosingReceiverDescriptor() {
        return this.enclosingReceiverDescriptor;
    }
}

