/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.di;

import com.intellij.openapi.project.Project;
import javax.annotation.PreDestroy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.context.ContextPackage;
import org.jetbrains.jet.context.GlobalContextImpl;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptorImpl;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.java.AnalyzerFacadeForJVM;
import org.jetbrains.jet.lang.resolve.java.JavaClassFinderImpl;
import org.jetbrains.jet.lang.resolve.java.JavaDescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.lazy.GlobalJavaResolverContext;
import org.jetbrains.jet.lang.resolve.java.lazy.LazyJavaPackageFragmentProvider;
import org.jetbrains.jet.lang.resolve.java.resolver.PsiBasedExternalAnnotationResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.PsiBasedMethodSignatureChecker;
import org.jetbrains.jet.lang.resolve.java.resolver.TraceBasedErrorReporter;
import org.jetbrains.jet.lang.resolve.java.resolver.TraceBasedExternalSignatureResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.TraceBasedJavaResolverCache;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaPropertyInitializerEvaluatorImpl;
import org.jetbrains.jet.lang.resolve.kotlin.AnnotationDescriptorLoader;
import org.jetbrains.jet.lang.resolve.kotlin.ConstantDescriptorLoader;
import org.jetbrains.jet.lang.resolve.kotlin.DescriptorDeserializersStorage;
import org.jetbrains.jet.lang.resolve.kotlin.DeserializationGlobalContextForJava;
import org.jetbrains.jet.lang.resolve.kotlin.DeserializedDescriptorResolver;
import org.jetbrains.jet.lang.resolve.kotlin.JavaDescriptorFinder;
import org.jetbrains.jet.lang.resolve.kotlin.VirtualFileFinder;
import org.jetbrains.jet.storage.LockBasedStorageManager;
import org.jetbrains.jet.storage.StorageManager;

public class InjectorForJavaDescriptorResolver {
    private final Project project;
    private final BindingTrace bindingTrace;
    private final GlobalContextImpl globalContext;
    private final LockBasedStorageManager lockBasedStorageManager;
    private final ModuleDescriptorImpl module;
    private final JavaDescriptorResolver javaDescriptorResolver;
    private final JavaClassFinderImpl javaClassFinder;
    private final TraceBasedExternalSignatureResolver traceBasedExternalSignatureResolver;
    private final TraceBasedJavaResolverCache traceBasedJavaResolverCache;
    private final TraceBasedErrorReporter traceBasedErrorReporter;
    private final PsiBasedMethodSignatureChecker psiBasedMethodSignatureChecker;
    private final PsiBasedExternalAnnotationResolver psiBasedExternalAnnotationResolver;
    private final JavaPropertyInitializerEvaluatorImpl javaPropertyInitializerEvaluator;
    private final VirtualFileFinder virtualFileFinder;
    private final LazyJavaPackageFragmentProvider lazyJavaPackageFragmentProvider;
    private final GlobalJavaResolverContext globalJavaResolverContext;
    private final DeserializedDescriptorResolver deserializedDescriptorResolver;
    private final DeserializationGlobalContextForJava deserializationGlobalContextForJava;
    private final JavaDescriptorFinder javaDescriptorFinder;
    private final AnnotationDescriptorLoader annotationDescriptorLoader;
    private final DescriptorDeserializersStorage descriptorDeserializersStorage;
    private final ConstantDescriptorLoader constantDescriptorLoader;

    public InjectorForJavaDescriptorResolver(@NotNull Project project, @NotNull BindingTrace bindingTrace) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jet/di/InjectorForJavaDescriptorResolver", "<init>"));
        }
        if (bindingTrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingTrace", "org/jetbrains/jet/di/InjectorForJavaDescriptorResolver", "<init>"));
        }
        this.project = project;
        this.bindingTrace = bindingTrace;
        this.globalContext = ContextPackage.GlobalContext();
        this.lockBasedStorageManager = this.globalContext.getStorageManager();
        this.module = AnalyzerFacadeForJVM.createJavaModule("<fake-jdr-module>");
        this.javaClassFinder = new JavaClassFinderImpl();
        this.virtualFileFinder = VirtualFileFinder.SERVICE.getInstance(project);
        this.deserializedDescriptorResolver = new DeserializedDescriptorResolver();
        this.psiBasedExternalAnnotationResolver = new PsiBasedExternalAnnotationResolver();
        this.traceBasedExternalSignatureResolver = new TraceBasedExternalSignatureResolver();
        this.traceBasedErrorReporter = new TraceBasedErrorReporter();
        this.psiBasedMethodSignatureChecker = new PsiBasedMethodSignatureChecker();
        this.traceBasedJavaResolverCache = new TraceBasedJavaResolverCache();
        this.javaPropertyInitializerEvaluator = new JavaPropertyInitializerEvaluatorImpl();
        this.globalJavaResolverContext = new GlobalJavaResolverContext(this.lockBasedStorageManager, this.getJavaClassFinder(), this.virtualFileFinder, this.deserializedDescriptorResolver, this.psiBasedExternalAnnotationResolver, this.traceBasedExternalSignatureResolver, this.traceBasedErrorReporter, this.psiBasedMethodSignatureChecker, this.traceBasedJavaResolverCache, this.javaPropertyInitializerEvaluator);
        this.lazyJavaPackageFragmentProvider = new LazyJavaPackageFragmentProvider(this.globalJavaResolverContext, this.getModule());
        this.javaDescriptorResolver = new JavaDescriptorResolver(this.lazyJavaPackageFragmentProvider, this.getModule());
        this.javaDescriptorFinder = new JavaDescriptorFinder(this.getJavaDescriptorResolver(), this.lazyJavaPackageFragmentProvider);
        this.annotationDescriptorLoader = new AnnotationDescriptorLoader();
        this.constantDescriptorLoader = new ConstantDescriptorLoader();
        this.deserializationGlobalContextForJava = new DeserializationGlobalContextForJava((StorageManager)this.lockBasedStorageManager, this.javaDescriptorFinder, this.annotationDescriptorLoader, this.constantDescriptorLoader, this.lazyJavaPackageFragmentProvider);
        this.descriptorDeserializersStorage = new DescriptorDeserializersStorage(this.lockBasedStorageManager);
        this.javaClassFinder.setProject(project);
        this.traceBasedExternalSignatureResolver.setExternalAnnotationResolver(this.psiBasedExternalAnnotationResolver);
        this.traceBasedExternalSignatureResolver.setProject(project);
        this.traceBasedExternalSignatureResolver.setTrace(bindingTrace);
        this.traceBasedJavaResolverCache.setTrace(bindingTrace);
        this.traceBasedErrorReporter.setTrace(bindingTrace);
        this.psiBasedMethodSignatureChecker.setExternalAnnotationResolver(this.psiBasedExternalAnnotationResolver);
        this.psiBasedMethodSignatureChecker.setExternalSignatureResolver(this.traceBasedExternalSignatureResolver);
        this.deserializedDescriptorResolver.setContext(this.deserializationGlobalContextForJava);
        this.deserializedDescriptorResolver.setErrorReporter(this.traceBasedErrorReporter);
        this.annotationDescriptorLoader.setClassResolver(this.javaDescriptorResolver);
        this.annotationDescriptorLoader.setErrorReporter(this.traceBasedErrorReporter);
        this.annotationDescriptorLoader.setKotlinClassFinder(this.virtualFileFinder);
        this.annotationDescriptorLoader.setStorage(this.descriptorDeserializersStorage);
        this.descriptorDeserializersStorage.setClassResolver(this.javaDescriptorResolver);
        this.descriptorDeserializersStorage.setErrorReporter(this.traceBasedErrorReporter);
        this.constantDescriptorLoader.setClassResolver(this.javaDescriptorResolver);
        this.constantDescriptorLoader.setErrorReporter(this.traceBasedErrorReporter);
        this.constantDescriptorLoader.setKotlinClassFinder(this.virtualFileFinder);
        this.constantDescriptorLoader.setStorage(this.descriptorDeserializersStorage);
        this.javaClassFinder.initialize();
    }

    @PreDestroy
    public void destroy() {
    }

    public GlobalContextImpl getGlobalContext() {
        return this.globalContext;
    }

    public ModuleDescriptorImpl getModule() {
        return this.module;
    }

    public JavaDescriptorResolver getJavaDescriptorResolver() {
        return this.javaDescriptorResolver;
    }

    public JavaClassFinderImpl getJavaClassFinder() {
        return this.javaClassFinder;
    }
}

