/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.jet.lang.descriptors.Visibilities;

public abstract class Visibility {
    private final boolean isPublicAPI;
    private final String name;

    protected Visibility(@NotNull String name, boolean isPublicAPI) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/descriptors/Visibility", "<init>"));
        }
        this.isPublicAPI = isPublicAPI;
        this.name = name;
    }

    public boolean isPublicAPI() {
        return this.isPublicAPI;
    }

    protected Integer compareTo(@NotNull Visibility visibility) {
        if (visibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibility", "org/jetbrains/jet/lang/descriptors/Visibility", "compareTo"));
        }
        return Visibilities.compareLocal(this, visibility);
    }

    public String toString() {
        return this.name;
    }

    @NotNull
    public Visibility normalize() {
        Visibility visibility = this;
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/Visibility", "normalize"));
        }
        return visibility;
    }

    protected abstract boolean isVisible(@NotNull DeclarationDescriptorWithVisibility var1, @NotNull DeclarationDescriptor var2);
}

