/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.parsing;

import com.google.common.collect.ImmutableMap;
import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.Arrays;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.JetNodeType;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.parsing.AbstractJetParsing;
import org.jetbrains.jet.lang.parsing.FirstBefore;
import org.jetbrains.jet.lang.parsing.JetParsing;
import org.jetbrains.jet.lang.parsing.LastBefore;
import org.jetbrains.jet.lang.parsing.SemanticWhitespaceAwarePsiBuilder;
import org.jetbrains.jet.lexer.JetToken;
import org.jetbrains.jet.lexer.JetTokens;

public class JetExpressionParsing
extends AbstractJetParsing {
    private static final TokenSet WHEN_CONDITION_RECOVERY_SET;
    private static final TokenSet WHEN_CONDITION_RECOVERY_SET_WITH_ARROW;
    private static final ImmutableMap<String, JetToken> KEYWORD_TEXTS;
    private static final TokenSet TYPE_ARGUMENT_LIST_STOPPERS;
    static final TokenSet EXPRESSION_FIRST;
    private static final TokenSet STATEMENT_FIRST;
    private static final TokenSet STATEMENT_NEW_LINE_QUICK_RECOVERY_SET;
    static final TokenSet EXPRESSION_FOLLOW;
    public static final TokenSet ALLOW_NEWLINE_OPERATIONS;
    public static final TokenSet ALL_OPERATIONS;
    private final JetParsing myJetParsing;

    private static ImmutableMap<String, JetToken> tokenSetToMap(TokenSet tokens) {
        ImmutableMap.Builder<String, JetToken> builder = ImmutableMap.builder();
        for (IElementType token : tokens.getTypes()) {
            builder.put(token.toString(), (JetToken)token);
        }
        return builder.build();
    }

    public JetExpressionParsing(SemanticWhitespaceAwarePsiBuilder builder, JetParsing jetParsing) {
        super(builder);
        this.myJetParsing = jetParsing;
    }

    public void parseExpression() {
        if (!this.atSet(EXPRESSION_FIRST)) {
            this.error("Expecting an expression");
            return;
        }
        this.parseBinaryExpression(Precedence.ASSIGNMENT);
    }

    private void parseBinaryExpression(Precedence precedence) {
        PsiBuilder.Marker expression = this.mark();
        precedence.parseHigherPrecedence(this);
        while (!this.interruptedWithNewLine() && this.atSet(precedence.getOperations())) {
            IElementType operation = this.tt();
            this.parseOperationReference();
            JetNodeType resultType = precedence.parseRightHandSide(operation, this);
            expression.done(resultType);
            expression = expression.precede();
        }
        expression.drop();
    }

    private void parseLabeledExpression() {
        assert (this._at(JetTokens.LABEL_IDENTIFIER));
        PsiBuilder.Marker expression = this.mark();
        this.parseLabel();
        this.parsePrefixExpression();
        expression.done(JetNodeTypes.LABELED_EXPRESSION);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parsePrefixExpression() {
        if (this.at(JetTokens.LBRACKET)) {
            if (this.parseLocalDeclaration()) return;
            PsiBuilder.Marker expression = this.mark();
            this.myJetParsing.parseAnnotations(false);
            this.parsePrefixExpression();
            expression.done(JetNodeTypes.ANNOTATED_EXPRESSION);
            return;
        } else {
            this.myBuilder.disableJoiningComplexTokens();
            if (this.at(JetTokens.LABEL_IDENTIFIER)) {
                this.myBuilder.restoreJoiningComplexTokensState();
                this.parseLabeledExpression();
                return;
            } else if (this.atSet(Precedence.PREFIX.getOperations())) {
                PsiBuilder.Marker expression = this.mark();
                this.parseOperationReference();
                this.myBuilder.restoreJoiningComplexTokensState();
                this.parsePrefixExpression();
                expression.done(JetNodeTypes.PREFIX_EXPRESSION);
                return;
            } else {
                this.myBuilder.restoreJoiningComplexTokensState();
                this.parsePostfixExpression();
            }
        }
    }

    private boolean parseCallableReferenceExpression() {
        PsiBuilder.Marker expression = this.mark();
        if (!this.at(JetTokens.COLONCOLON)) {
            PsiBuilder.Marker typeReference = this.mark();
            this.myJetParsing.parseUserType();
            typeReference = this.myJetParsing.parseNullableTypeSuffix(typeReference);
            typeReference.done(JetNodeTypes.TYPE_REFERENCE);
            if (!this.at(JetTokens.COLONCOLON)) {
                expression.rollbackTo();
                return false;
            }
        }
        this.advance();
        this.parseSimpleNameExpression();
        expression.done(JetNodeTypes.CALLABLE_REFERENCE_EXPRESSION);
        return true;
    }

    private void parsePostfixExpression() {
        PsiBuilder.Marker expression = this.mark();
        boolean callableReference = this.parseCallableReferenceExpression();
        if (!callableReference) {
            this.parseAtomicExpression();
        }
        while (!this.interruptedWithNewLine()) {
            if (this.at(JetTokens.LBRACKET)) {
                this.parseArrayAccess();
                expression.done(JetNodeTypes.ARRAY_ACCESS_EXPRESSION);
            } else if (!callableReference && this.parseCallSuffix()) {
                expression.done(JetNodeTypes.CALL_EXPRESSION);
            } else if (this.at(JetTokens.DOT)) {
                this.advance();
                this.parseCallExpression();
                expression.done(JetNodeTypes.DOT_QUALIFIED_EXPRESSION);
            } else if (this.at(JetTokens.SAFE_ACCESS)) {
                this.advance();
                this.parseCallExpression();
                expression.done(JetNodeTypes.SAFE_ACCESS_EXPRESSION);
            } else {
                if (!this.atSet(Precedence.POSTFIX.getOperations())) break;
                this.parseOperationReference();
                expression.done(JetNodeTypes.POSTFIX_EXPRESSION);
            }
            expression = expression.precede();
        }
        expression.drop();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseCallSuffix() {
        if (this.parseCallWithClosure()) {
            this.parseCallWithClosure();
            return true;
        } else if (this.at(JetTokens.LPAR)) {
            this.parseValueArgumentList();
            this.parseCallWithClosure();
            return true;
        } else {
            if (!this.at(JetTokens.LT)) return false;
            PsiBuilder.Marker typeArgumentList = this.mark();
            if (this.myJetParsing.tryParseTypeArgumentList(TYPE_ARGUMENT_LIST_STOPPERS)) {
                typeArgumentList.done(JetNodeTypes.TYPE_ARGUMENT_LIST);
                if (!this.myBuilder.newlineBeforeCurrentToken() && this.at(JetTokens.LPAR)) {
                    this.parseValueArgumentList();
                }
                this.parseCallWithClosure();
                return true;
            } else {
                typeArgumentList.rollbackTo();
                return false;
            }
        }
    }

    private void parseCallExpression() {
        PsiBuilder.Marker mark = this.mark();
        this.parseAtomicExpression();
        if (!this.myBuilder.newlineBeforeCurrentToken() && this.parseCallSuffix()) {
            mark.done(JetNodeTypes.CALL_EXPRESSION);
        } else {
            mark.drop();
        }
    }

    private void parseOperationReference() {
        PsiBuilder.Marker operationReference = this.mark();
        this.advance();
        operationReference.done(JetNodeTypes.OPERATION_REFERENCE);
    }

    protected boolean parseCallWithClosure() {
        boolean success = false;
        while (this.at(JetTokens.LBRACE) || this.at(JetTokens.LABEL_IDENTIFIER) && this.lookahead(1) == JetTokens.LBRACE) {
            if (!this.at(JetTokens.LBRACE)) {
                assert (this._at(JetTokens.LABEL_IDENTIFIER));
                this.parseLabeledExpression();
            } else {
                this.parseFunctionLiteral();
            }
            success = true;
        }
        return success;
    }

    private void parseAtomicExpression() {
        if (this.at(JetTokens.LPAR)) {
            this.parseParenthesizedExpression();
        } else if (this.at(JetTokens.HASH)) {
            this.parseTupleExpression();
        } else if (this.at(JetTokens.PACKAGE_KEYWORD)) {
            this.parseOneTokenExpression(JetNodeTypes.ROOT_PACKAGE);
        } else if (this.at(JetTokens.THIS_KEYWORD)) {
            this.parseThisExpression();
        } else if (this.at(JetTokens.SUPER_KEYWORD)) {
            this.parseSuperExpression();
        } else if (this.at(JetTokens.OBJECT_KEYWORD)) {
            this.parseObjectLiteral();
        } else if (this.at(JetTokens.THROW_KEYWORD)) {
            this.parseThrow();
        } else if (this.at(JetTokens.RETURN_KEYWORD)) {
            this.parseReturn();
        } else if (this.at(JetTokens.CONTINUE_KEYWORD)) {
            this.parseJump(JetNodeTypes.CONTINUE);
        } else if (this.at(JetTokens.BREAK_KEYWORD)) {
            this.parseJump(JetNodeTypes.BREAK);
        } else if (this.at(JetTokens.IF_KEYWORD)) {
            this.parseIf();
        } else if (this.at(JetTokens.WHEN_KEYWORD)) {
            this.parseWhen();
        } else if (this.at(JetTokens.TRY_KEYWORD)) {
            this.parseTry();
        } else if (this.at(JetTokens.FOR_KEYWORD)) {
            this.parseFor();
        } else if (this.at(JetTokens.WHILE_KEYWORD)) {
            this.parseWhile();
        } else if (this.at(JetTokens.DO_KEYWORD)) {
            this.parseDoWhile();
        } else if (this.atSet(JetTokens.CLASS_KEYWORD, JetTokens.FUN_KEYWORD, JetTokens.VAL_KEYWORD, JetTokens.VAR_KEYWORD, JetTokens.TYPE_KEYWORD)) {
            this.parseLocalDeclaration();
        } else if (this.at(JetTokens.FIELD_IDENTIFIER)) {
            this.parseSimpleNameExpression();
        } else if (this.at(JetTokens.IDENTIFIER)) {
            this.parseSimpleNameExpression();
        } else if (this.at(JetTokens.LBRACE)) {
            this.parseFunctionLiteral();
        } else if (this.at(JetTokens.OPEN_QUOTE)) {
            this.parseStringTemplate();
        } else if (!this.parseLiteralConstant()) {
            this.errorWithRecovery("Expecting an element", EXPRESSION_FOLLOW);
        }
    }

    private void parseStringTemplate() {
        assert (this._at(JetTokens.OPEN_QUOTE));
        PsiBuilder.Marker template = this.mark();
        this.advance();
        while (!(this.eof() || this.at(JetTokens.CLOSING_QUOTE) || this.at(JetTokens.DANGLING_NEWLINE))) {
            this.parseStringTemplateElement();
        }
        if (this.at(JetTokens.DANGLING_NEWLINE)) {
            this.errorAndAdvance("Expecting '\"'");
        } else {
            this.expect(JetTokens.CLOSING_QUOTE, "Expecting '\"'");
        }
        template.done(JetNodeTypes.STRING_TEMPLATE);
    }

    private void parseStringTemplateElement() {
        if (this.at(JetTokens.REGULAR_STRING_PART)) {
            PsiBuilder.Marker mark = this.mark();
            this.advance();
            mark.done(JetNodeTypes.LITERAL_STRING_TEMPLATE_ENTRY);
        } else if (this.at(JetTokens.ESCAPE_SEQUENCE)) {
            PsiBuilder.Marker mark = this.mark();
            this.advance();
            mark.done(JetNodeTypes.ESCAPE_STRING_TEMPLATE_ENTRY);
        } else if (this.at(JetTokens.SHORT_TEMPLATE_ENTRY_START)) {
            PsiBuilder.Marker entry = this.mark();
            this.advance();
            if (this.at(JetTokens.THIS_KEYWORD)) {
                PsiBuilder.Marker thisExpression = this.mark();
                PsiBuilder.Marker reference = this.mark();
                this.advance();
                reference.done(JetNodeTypes.REFERENCE_EXPRESSION);
                thisExpression.done(JetNodeTypes.THIS_EXPRESSION);
            } else {
                JetToken keyword = KEYWORD_TEXTS.get(this.myBuilder.getTokenText());
                if (keyword != null) {
                    this.myBuilder.remapCurrentToken(keyword);
                    this.errorAndAdvance("Keyword cannot be used as a reference");
                } else {
                    PsiBuilder.Marker reference = this.mark();
                    this.expect(JetTokens.IDENTIFIER, "Expecting a name");
                    reference.done(JetNodeTypes.REFERENCE_EXPRESSION);
                }
            }
            entry.done(JetNodeTypes.SHORT_STRING_TEMPLATE_ENTRY);
        } else if (this.at(JetTokens.LONG_TEMPLATE_ENTRY_START)) {
            PsiBuilder.Marker longTemplateEntry = this.mark();
            this.advance();
            this.parseExpression();
            this.expect(JetTokens.LONG_TEMPLATE_ENTRY_END, "Expecting '}'", TokenSet.create(JetTokens.CLOSING_QUOTE, JetTokens.DANGLING_NEWLINE, JetTokens.REGULAR_STRING_PART, JetTokens.ESCAPE_SEQUENCE, JetTokens.SHORT_TEMPLATE_ENTRY_START));
            longTemplateEntry.done(JetNodeTypes.LONG_STRING_TEMPLATE_ENTRY);
        } else {
            this.errorAndAdvance("Unexpected token in a string template");
        }
    }

    private boolean parseLiteralConstant() {
        if (this.at(JetTokens.TRUE_KEYWORD) || this.at(JetTokens.FALSE_KEYWORD)) {
            this.parseOneTokenExpression(JetNodeTypes.BOOLEAN_CONSTANT);
        } else if (this.at(JetTokens.INTEGER_LITERAL)) {
            this.parseOneTokenExpression(JetNodeTypes.INTEGER_CONSTANT);
        } else if (this.at(JetTokens.CHARACTER_LITERAL)) {
            this.parseOneTokenExpression(JetNodeTypes.CHARACTER_CONSTANT);
        } else if (this.at(JetTokens.FLOAT_LITERAL)) {
            this.parseOneTokenExpression(JetNodeTypes.FLOAT_CONSTANT);
        } else if (this.at(JetTokens.NULL_KEYWORD)) {
            this.parseOneTokenExpression(JetNodeTypes.NULL);
        } else {
            return false;
        }
        return true;
    }

    private void parseWhen() {
        assert (this._at(JetTokens.WHEN_KEYWORD));
        PsiBuilder.Marker when = this.mark();
        this.advance();
        this.myBuilder.disableNewlines();
        if (this.at(JetTokens.LPAR)) {
            this.advanceAt(JetTokens.LPAR);
            int valPos = this.matchTokenStreamPredicate(new FirstBefore(new AbstractJetParsing.At(JetTokens.VAL_KEYWORD), (AbstractJetParsing)this.new AbstractJetParsing.AtSet(JetTokens.RPAR, JetTokens.LBRACE, JetTokens.RBRACE, JetTokens.SEMICOLON, JetTokens.EQ)));
            if (valPos >= 0) {
                PsiBuilder.Marker property2 = this.mark();
                this.myJetParsing.parseModifierList(JetNodeTypes.MODIFIER_LIST, true);
                this.myJetParsing.parseProperty(true);
                property2.done(JetNodeTypes.PROPERTY);
            } else {
                this.parseExpression();
            }
            this.expect(JetTokens.RPAR, "Expecting ')'");
        }
        this.myBuilder.restoreNewlinesState();
        this.myBuilder.enableNewlines();
        if (this.expect(JetTokens.LBRACE, "Expecting '{'")) {
            while (!this.eof() && !this.at(JetTokens.RBRACE)) {
                this.parseWhenEntry();
            }
            this.expect(JetTokens.RBRACE, "Expecting '}'");
        }
        this.myBuilder.restoreNewlinesState();
        when.done(JetNodeTypes.WHEN);
    }

    private void parseWhenEntry() {
        PsiBuilder.Marker entry = this.mark();
        if (this.at(JetTokens.ELSE_KEYWORD)) {
            this.advance();
            if (!this.at(JetTokens.ARROW)) {
                this.errorUntil("Expecting '->'", TokenSet.create(JetTokens.ARROW, JetTokens.RBRACE, JetTokens.EOL_OR_SEMICOLON));
            }
            if (this.at(JetTokens.ARROW)) {
                this.advance();
                if (this.atSet(WHEN_CONDITION_RECOVERY_SET)) {
                    this.error("Expecting an element");
                } else {
                    this.parseExpressionPreferringBlocks();
                }
            } else if (!this.atSet(WHEN_CONDITION_RECOVERY_SET)) {
                this.errorAndAdvance("Expecting '->'");
            }
        } else {
            this.parseWhenEntryNotElse();
        }
        entry.done(JetNodeTypes.WHEN_ENTRY);
        this.consumeIf(JetTokens.SEMICOLON);
    }

    private void parseWhenEntryNotElse() {
        while (true) {
            if (this.at(JetTokens.COMMA)) {
                this.errorAndAdvance("Expecting a when-condition");
                continue;
            }
            this.parseWhenCondition();
            if (!this.at(JetTokens.COMMA)) break;
            this.advance();
        }
        this.expect(JetTokens.ARROW, "Expecting '->' or 'when'", WHEN_CONDITION_RECOVERY_SET);
        if (this.atSet(WHEN_CONDITION_RECOVERY_SET)) {
            this.error("Expecting an element");
        } else {
            this.parseExpressionPreferringBlocks();
        }
    }

    private void parseWhenCondition() {
        PsiBuilder.Marker condition = this.mark();
        this.myBuilder.disableNewlines();
        if (this.at(JetTokens.IN_KEYWORD) || this.at(JetTokens.NOT_IN)) {
            PsiBuilder.Marker mark = this.mark();
            this.advance();
            mark.done(JetNodeTypes.OPERATION_REFERENCE);
            if (this.atSet(WHEN_CONDITION_RECOVERY_SET_WITH_ARROW)) {
                this.error("Expecting an element");
            } else {
                this.parseExpression();
            }
            condition.done(JetNodeTypes.WHEN_CONDITION_IN_RANGE);
        } else if (this.at(JetTokens.IS_KEYWORD) || this.at(JetTokens.NOT_IS)) {
            this.advance();
            if (this.atSet(WHEN_CONDITION_RECOVERY_SET_WITH_ARROW)) {
                this.error("Expecting a type");
            } else {
                this.myJetParsing.parseTypeRef();
            }
            condition.done(JetNodeTypes.WHEN_CONDITION_IS_PATTERN);
        } else {
            if (this.atSet(WHEN_CONDITION_RECOVERY_SET_WITH_ARROW)) {
                this.error("Expecting an expression, is-condition or in-condition");
            } else {
                this.parseExpression();
            }
            condition.done(JetNodeTypes.WHEN_CONDITION_EXPRESSION);
        }
        this.myBuilder.restoreNewlinesState();
    }

    private void parseArrayAccess() {
        assert (this._at(JetTokens.LBRACKET));
        PsiBuilder.Marker indices = this.mark();
        this.myBuilder.disableNewlines();
        this.advance();
        while (true) {
            if (this.at(JetTokens.COMMA)) {
                this.errorAndAdvance("Expecting an index element");
            }
            if (this.at(JetTokens.RBRACKET)) {
                this.error("Expecting an index element");
                break;
            }
            this.parseExpression();
            if (!this.at(JetTokens.COMMA)) break;
            this.advance();
        }
        this.expect(JetTokens.RBRACKET, "Expecting ']'");
        this.myBuilder.restoreNewlinesState();
        indices.done(JetNodeTypes.INDICES);
    }

    public void parseSimpleNameExpression() {
        PsiBuilder.Marker simpleName = this.mark();
        if (this.at(JetTokens.FIELD_IDENTIFIER)) {
            this.advance();
        } else {
            this.expect(JetTokens.IDENTIFIER, "Expecting an identifier");
        }
        simpleName.done(JetNodeTypes.REFERENCE_EXPRESSION);
    }

    private boolean parseLocalDeclaration() {
        PsiBuilder.Marker decl = this.mark();
        JetParsing.TokenDetector enumDetector = new JetParsing.TokenDetector(JetTokens.ENUM_KEYWORD);
        this.myJetParsing.parseModifierList(JetNodeTypes.MODIFIER_LIST, enumDetector, false);
        IElementType declType = this.parseLocalDeclarationRest(enumDetector.isDetected());
        if (declType != null) {
            decl.done(declType);
            return true;
        }
        decl.rollbackTo();
        return false;
    }

    private void parseFunctionLiteral() {
        this.parseFunctionLiteral(false);
    }

    private void parseFunctionLiteral(boolean preferBlock) {
        assert (this._at(JetTokens.LBRACE));
        PsiBuilder.Marker literalExpression = this.mark();
        PsiBuilder.Marker literal = this.mark();
        this.myBuilder.enableNewlines();
        this.advance();
        boolean paramsFound = false;
        if (this.at(JetTokens.ARROW)) {
            this.mark().done(JetNodeTypes.VALUE_PARAMETER_LIST);
            this.advance();
            paramsFound = true;
        } else if (this.at(JetTokens.LPAR)) {
            boolean preferParamsToExpressions = this.isConfirmedParametersByComma();
            PsiBuilder.Marker rollbackMarker = this.mark();
            this.parseFunctionLiteralParametersAndType();
            boolean bl = paramsFound = preferParamsToExpressions ? this.rollbackOrDrop(rollbackMarker, JetTokens.ARROW, "An -> is expected", JetTokens.RBRACE) : this.rollbackOrDropAt(rollbackMarker, JetTokens.ARROW);
            if (!paramsFound) {
                paramsFound = this.parseFunctionTypeDotParametersAndType();
            }
        } else {
            if (this.at(JetTokens.IDENTIFIER)) {
                PsiBuilder.Marker rollbackMarker = this.mark();
                boolean preferParamsToExpressions = this.lookahead(1) == JetTokens.COMMA;
                this.parseFunctionLiteralShorthandParameterList();
                this.parseOptionalFunctionLiteralType();
                boolean bl = paramsFound = preferParamsToExpressions ? this.rollbackOrDrop(rollbackMarker, JetTokens.ARROW, "An -> is expected", JetTokens.RBRACE) : this.rollbackOrDropAt(rollbackMarker, JetTokens.ARROW);
            }
            if (!paramsFound && this.atSet(JetParsing.TYPE_REF_FIRST)) {
                paramsFound = this.parseFunctionTypeDotParametersAndType();
            }
        }
        if (!paramsFound && preferBlock) {
            literal.drop();
            this.parseStatements();
            this.expect(JetTokens.RBRACE, "Expecting '}'");
            literalExpression.done(JetNodeTypes.BLOCK);
            this.myBuilder.restoreNewlinesState();
            return;
        }
        PsiBuilder.Marker body = this.mark();
        this.parseStatements();
        body.done(JetNodeTypes.BLOCK);
        this.expect(JetTokens.RBRACE, "Expecting '}'");
        this.myBuilder.restoreNewlinesState();
        literal.done(JetNodeTypes.FUNCTION_LITERAL);
        literalExpression.done(JetNodeTypes.FUNCTION_LITERAL_EXPRESSION);
    }

    private boolean rollbackOrDropAt(PsiBuilder.Marker rollbackMarker, IElementType dropAt) {
        if (this.at(dropAt)) {
            this.advance();
            rollbackMarker.drop();
            return true;
        }
        rollbackMarker.rollbackTo();
        return false;
    }

    private boolean rollbackOrDrop(PsiBuilder.Marker rollbackMarker, JetToken expected, String expectMessage, IElementType validForDrop) {
        if (this.at(expected)) {
            this.advance();
            rollbackMarker.drop();
            return true;
        }
        if (this.at(validForDrop)) {
            rollbackMarker.drop();
            this.expect(expected, expectMessage);
            return true;
        }
        rollbackMarker.rollbackTo();
        return false;
    }

    private void parseFunctionLiteralShorthandParameterList() {
        PsiBuilder.Marker parameterList = this.mark();
        while (!this.eof()) {
            PsiBuilder.Marker parameter = this.mark();
            this.expect(JetTokens.IDENTIFIER, "Expecting parameter name", TokenSet.create(JetTokens.ARROW));
            parameter.done(JetNodeTypes.VALUE_PARAMETER);
            if (this.at(JetTokens.COLON)) {
                PsiBuilder.Marker errorMarker = this.mark();
                this.advance();
                this.myJetParsing.parseTypeRef();
                errorMarker.error("To specify a type of a parameter or a return type, use the full notation: {(parameter : Type) : ReturnType -> ...}");
                continue;
            }
            if (this.at(JetTokens.ARROW)) break;
            if (this.at(JetTokens.COMMA)) {
                this.advance();
                continue;
            }
            this.error("Expecting '->' or ','");
            break;
        }
        parameterList.done(JetNodeTypes.VALUE_PARAMETER_LIST);
    }

    private boolean isConfirmedParametersByComma() {
        assert (this._at(JetTokens.LPAR));
        PsiBuilder.Marker lparMarker = this.mark();
        this.advance();
        int comma = this.matchTokenStreamPredicate(new FirstBefore(new AbstractJetParsing.At(JetTokens.COMMA), (AbstractJetParsing)this.new AbstractJetParsing.AtSet(JetTokens.ARROW, JetTokens.RPAR)));
        lparMarker.rollbackTo();
        return comma > 0;
    }

    private boolean parseFunctionTypeDotParametersAndType() {
        PsiBuilder.Marker rollbackMarker = this.mark();
        boolean preferParamsToExpressions = false;
        int lastDot = this.matchTokenStreamPredicate(new LastBefore(new AbstractJetParsing.At(JetTokens.DOT), (AbstractJetParsing)this.new AbstractJetParsing.AtSet(JetTokens.ARROW, JetTokens.RPAR)));
        if (lastDot >= 0) {
            this.createTruncatedBuilder(lastDot).parseTypeRef();
            if (this.at(JetTokens.DOT)) {
                this.advance();
                if (this.at(JetTokens.LPAR)) {
                    preferParamsToExpressions = this.isConfirmedParametersByComma();
                }
                this.parseFunctionLiteralParametersAndType();
            }
        }
        return preferParamsToExpressions ? this.rollbackOrDrop(rollbackMarker, JetTokens.ARROW, "An -> is expected", JetTokens.RBRACE) : this.rollbackOrDropAt(rollbackMarker, JetTokens.ARROW);
    }

    private void parseFunctionLiteralParametersAndType() {
        this.parseFunctionLiteralParameterList();
        this.parseOptionalFunctionLiteralType();
    }

    private void parseOptionalFunctionLiteralType() {
        if (this.at(JetTokens.COLON)) {
            this.advance();
            if (this.at(JetTokens.ARROW)) {
                this.error("Expecting a type");
            } else {
                this.myJetParsing.parseTypeRef();
            }
        }
    }

    private void parseFunctionLiteralParameterList() {
        PsiBuilder.Marker list;
        block4: {
            list = this.mark();
            this.expect(JetTokens.LPAR, "Expecting a parameter list in parentheses (...)", TokenSet.create(JetTokens.ARROW, JetTokens.COLON));
            this.myBuilder.disableNewlines();
            if (!this.at(JetTokens.RPAR)) {
                do {
                    if (this.at(JetTokens.COMMA)) {
                        this.errorAndAdvance("Expecting a parameter declaration");
                    }
                    PsiBuilder.Marker parameter = this.mark();
                    int parameterNamePos = this.matchTokenStreamPredicate(new LastBefore(new AbstractJetParsing.At(JetTokens.IDENTIFIER), (AbstractJetParsing)this.new AbstractJetParsing.AtSet(JetTokens.COMMA, JetTokens.RPAR, JetTokens.COLON, JetTokens.ARROW)));
                    this.createTruncatedBuilder(parameterNamePos).parseModifierList(JetNodeTypes.MODIFIER_LIST, false);
                    this.expect(JetTokens.IDENTIFIER, "Expecting parameter declaration");
                    if (this.at(JetTokens.COLON)) {
                        this.advance();
                        this.myJetParsing.parseTypeRef();
                    }
                    parameter.done(JetNodeTypes.VALUE_PARAMETER);
                    if (!this.at(JetTokens.COMMA)) break block4;
                    this.advance();
                } while (!this.at(JetTokens.RPAR));
                this.error("Expecting a parameter declaration");
            }
        }
        this.myBuilder.restoreNewlinesState();
        this.expect(JetTokens.RPAR, "Expecting ')", TokenSet.create(JetTokens.ARROW, JetTokens.COLON));
        list.done(JetNodeTypes.VALUE_PARAMETER_LIST);
    }

    public void parseStatements() {
        while (this.at(JetTokens.SEMICOLON)) {
            this.advance();
        }
        while (!this.eof() && !this.at(JetTokens.RBRACE)) {
            if (!this.atSet(STATEMENT_FIRST)) {
                this.errorAndAdvance("Expecting an element");
            }
            if (this.atSet(STATEMENT_FIRST)) {
                this.parseStatement();
            }
            if (this.at(JetTokens.SEMICOLON)) {
                while (this.at(JetTokens.SEMICOLON)) {
                    this.advance();
                }
                continue;
            }
            if (this.at(JetTokens.RBRACE)) break;
            if (this.myBuilder.newlineBeforeCurrentToken()) continue;
            String severalStatementsError = "Unexpected tokens (use ';' to separate expressions on the same line)";
            if (this.atSet(STATEMENT_NEW_LINE_QUICK_RECOVERY_SET)) {
                this.error(severalStatementsError);
                continue;
            }
            this.errorUntil(severalStatementsError, TokenSet.create(JetTokens.EOL_OR_SEMICOLON));
        }
    }

    private void parseStatement() {
        if (!this.parseLocalDeclaration()) {
            if (!this.atSet(EXPRESSION_FIRST)) {
                this.errorAndAdvance("Expecting a statement");
            } else {
                this.parseExpression();
            }
        }
    }

    private IElementType parseLocalDeclarationRest(boolean isEnum) {
        IElementType keywordToken = this.tt();
        IElementType declType = null;
        if (keywordToken == JetTokens.CLASS_KEYWORD || keywordToken == JetTokens.TRAIT_KEYWORD) {
            declType = this.myJetParsing.parseClass(isEnum);
        } else if (keywordToken == JetTokens.FUN_KEYWORD) {
            declType = this.myJetParsing.parseFunction();
        } else if (keywordToken == JetTokens.VAL_KEYWORD || keywordToken == JetTokens.VAR_KEYWORD) {
            declType = this.myJetParsing.parseProperty(true);
        } else if (keywordToken == JetTokens.TYPE_KEYWORD) {
            declType = this.myJetParsing.parseTypeDef();
        } else if (keywordToken == JetTokens.OBJECT_KEYWORD) {
            IElementType lookahead = this.lookahead(1);
            if (lookahead == JetTokens.COLON || lookahead == JetTokens.LBRACE) {
                return null;
            }
            this.myJetParsing.parseObject(true, true);
            declType = JetNodeTypes.OBJECT_DECLARATION;
        }
        return declType;
    }

    private void parseDoWhile() {
        assert (this._at(JetTokens.DO_KEYWORD));
        PsiBuilder.Marker loop = this.mark();
        this.advance();
        if (!this.at(JetTokens.WHILE_KEYWORD)) {
            this.parseControlStructureBody();
        }
        if (this.expect(JetTokens.WHILE_KEYWORD, "Expecting 'while' followed by a post-condition")) {
            this.parseCondition();
        }
        loop.done(JetNodeTypes.DO_WHILE);
    }

    private void parseWhile() {
        assert (this._at(JetTokens.WHILE_KEYWORD));
        PsiBuilder.Marker loop = this.mark();
        this.advance();
        this.parseCondition();
        this.parseControlStructureBody();
        loop.done(JetNodeTypes.WHILE);
    }

    private void parseFor() {
        assert (this._at(JetTokens.FOR_KEYWORD));
        PsiBuilder.Marker loop = this.mark();
        this.advance();
        if (this.expect(JetTokens.LPAR, "Expecting '(' to open a loop range", EXPRESSION_FIRST)) {
            this.myBuilder.disableNewlines();
            if (!this.at(JetTokens.RPAR)) {
                PsiBuilder.Marker parameter = this.mark();
                if (this.at(JetTokens.VAL_KEYWORD) || this.at(JetTokens.VAR_KEYWORD)) {
                    this.advance();
                }
                if (this.at(JetTokens.LPAR)) {
                    this.myJetParsing.parseMultiDeclarationName(TokenSet.create(JetTokens.IN_KEYWORD, JetTokens.LBRACE));
                    parameter.done(JetNodeTypes.MULTI_VARIABLE_DECLARATION);
                } else {
                    this.expect(JetTokens.IDENTIFIER, "Expecting a variable name", TokenSet.create(JetTokens.COLON, JetTokens.IN_KEYWORD));
                    if (this.at(JetTokens.COLON)) {
                        this.advance();
                        this.myJetParsing.parseTypeRef(TokenSet.create(JetTokens.IN_KEYWORD));
                    }
                    parameter.done(JetNodeTypes.VALUE_PARAMETER);
                }
                if (this.expect(JetTokens.IN_KEYWORD, "Expecting 'in'", TokenSet.create(JetTokens.LPAR, JetTokens.LBRACE, JetTokens.RPAR))) {
                    PsiBuilder.Marker range = this.mark();
                    this.parseExpression();
                    range.done(JetNodeTypes.LOOP_RANGE);
                }
            } else {
                this.error("Expecting a variable name");
            }
            this.expectNoAdvance(JetTokens.RPAR, "Expecting ')'");
            this.myBuilder.restoreNewlinesState();
        }
        this.parseControlStructureBody();
        loop.done(JetNodeTypes.FOR);
    }

    private void parseExpressionPreferringBlocks() {
        if (this.at(JetTokens.LBRACE)) {
            this.parseFunctionLiteral(true);
        } else if (this.at(JetTokens.LABEL_IDENTIFIER) && this.lookahead(1) == JetTokens.LBRACE) {
            PsiBuilder.Marker mark = this.mark();
            this.parseLabel();
            this.parseFunctionLiteral(true);
            mark.done(JetNodeTypes.LABELED_EXPRESSION);
        } else {
            this.parseExpression();
        }
    }

    private void parseControlStructureBody() {
        PsiBuilder.Marker body = this.mark();
        if (!this.at(JetTokens.SEMICOLON)) {
            this.parseExpressionPreferringBlocks();
        }
        body.done(JetNodeTypes.BODY);
    }

    private void parseTry() {
        assert (this._at(JetTokens.TRY_KEYWORD));
        PsiBuilder.Marker tryExpression = this.mark();
        this.advance();
        this.myJetParsing.parseBlock();
        boolean catchOrFinally = false;
        while (this.at(JetTokens.CATCH_KEYWORD)) {
            catchOrFinally = true;
            PsiBuilder.Marker catchBlock = this.mark();
            this.advance();
            TokenSet recoverySet = TokenSet.create(JetTokens.LBRACE, JetTokens.FINALLY_KEYWORD, JetTokens.CATCH_KEYWORD);
            if (this.atSet(recoverySet)) {
                this.error("Expecting exception variable declaration");
            } else {
                PsiBuilder.Marker parameters = this.mark();
                this.expect(JetTokens.LPAR, "Expecting '('", recoverySet);
                if (!this.atSet(recoverySet)) {
                    this.myJetParsing.parseValueParameter();
                    this.expect(JetTokens.RPAR, "Expecting ')'", recoverySet);
                } else {
                    this.error("Expecting exception variable declaration");
                }
                parameters.done(JetNodeTypes.VALUE_PARAMETER_LIST);
            }
            if (this.at(JetTokens.LBRACE)) {
                this.myJetParsing.parseBlock();
            } else {
                this.error("Expecting a block: { ... }");
            }
            catchBlock.done(JetNodeTypes.CATCH);
        }
        if (this.at(JetTokens.FINALLY_KEYWORD)) {
            catchOrFinally = true;
            PsiBuilder.Marker finallyBlock = this.mark();
            this.advance();
            this.myJetParsing.parseBlock();
            finallyBlock.done(JetNodeTypes.FINALLY);
        }
        if (!catchOrFinally) {
            this.error("Expecting 'catch' or 'finally'");
        }
        tryExpression.done(JetNodeTypes.TRY);
    }

    private void parseIf() {
        assert (this._at(JetTokens.IF_KEYWORD));
        PsiBuilder.Marker marker = this.mark();
        this.advance();
        this.parseCondition();
        PsiBuilder.Marker thenBranch = this.mark();
        if (!this.at(JetTokens.ELSE_KEYWORD) && !this.at(JetTokens.SEMICOLON)) {
            this.parseExpressionPreferringBlocks();
        }
        if (this.at(JetTokens.SEMICOLON) && this.lookahead(1) == JetTokens.ELSE_KEYWORD) {
            this.advance();
        }
        thenBranch.done(JetNodeTypes.THEN);
        if (this.at(JetTokens.ELSE_KEYWORD)) {
            this.advance();
            PsiBuilder.Marker elseBranch = this.mark();
            if (!this.at(JetTokens.SEMICOLON)) {
                this.parseExpressionPreferringBlocks();
            }
            elseBranch.done(JetNodeTypes.ELSE);
        }
        marker.done(JetNodeTypes.IF);
    }

    private void parseCondition() {
        this.myBuilder.disableNewlines();
        if (this.expect(JetTokens.LPAR, "Expecting a condition in parentheses '(...)'", EXPRESSION_FIRST)) {
            PsiBuilder.Marker condition = this.mark();
            this.parseExpression();
            condition.done(JetNodeTypes.CONDITION);
            this.expect(JetTokens.RPAR, "Expecting ')");
        }
        this.myBuilder.restoreNewlinesState();
    }

    private void parseJump(JetNodeType type) {
        assert (this._at(JetTokens.BREAK_KEYWORD) || this._at(JetTokens.CONTINUE_KEYWORD));
        PsiBuilder.Marker marker = this.mark();
        this.advance();
        this.parseLabelOnTheSameLine();
        marker.done(type);
    }

    private void parseReturn() {
        assert (this._at(JetTokens.RETURN_KEYWORD));
        PsiBuilder.Marker returnExpression = this.mark();
        this.advance();
        this.parseLabelOnTheSameLine();
        if (this.atSet(EXPRESSION_FIRST) && !this.at(JetTokens.EOL_OR_SEMICOLON)) {
            this.parseExpression();
        }
        returnExpression.done(JetNodeTypes.RETURN);
    }

    private void parseLabelOnTheSameLine() {
        if (!this.eol() && this.at(JetTokens.LABEL_IDENTIFIER)) {
            this.parseLabel();
        }
    }

    private void parseLabel() {
        assert (this._at(JetTokens.LABEL_IDENTIFIER));
        String labelText = this.myBuilder.getTokenText();
        if ("@".equals(labelText)) {
            this.errorAndAdvance("Label must be named");
            return;
        }
        PsiBuilder.Marker labelWrap = this.mark();
        PsiBuilder.Marker mark = this.mark();
        this.advance();
        mark.done(JetNodeTypes.LABEL);
        labelWrap.done(JetNodeTypes.LABEL_QUALIFIER);
    }

    private void parseThrow() {
        assert (this._at(JetTokens.THROW_KEYWORD));
        PsiBuilder.Marker marker = this.mark();
        this.advance();
        this.parseExpression();
        marker.done(JetNodeTypes.THROW);
    }

    private void parseParenthesizedExpression() {
        assert (this._at(JetTokens.LPAR));
        PsiBuilder.Marker mark = this.mark();
        this.myBuilder.disableNewlines();
        this.advance();
        if (this.at(JetTokens.RPAR)) {
            this.error("Expecting an expression");
        } else {
            this.parseExpression();
        }
        this.expect(JetTokens.RPAR, "Expecting ')'");
        this.myBuilder.restoreNewlinesState();
        mark.done(JetNodeTypes.PARENTHESIZED);
    }

    @Deprecated
    private void parseTupleExpression() {
        assert (this._at(JetTokens.HASH));
        PsiBuilder.Marker mark = this.mark();
        this.advance();
        this.advance();
        this.myBuilder.disableNewlines();
        if (!this.at(JetTokens.RPAR)) {
            while (true) {
                if (this.at(JetTokens.COMMA)) {
                    this.advance();
                    continue;
                }
                if (this.at(JetTokens.IDENTIFIER) && this.lookahead(1) == JetTokens.EQ) {
                    this.advance();
                    this.advance();
                    this.parseExpression();
                } else {
                    this.parseExpression();
                }
                if (!this.at(JetTokens.COMMA)) break;
                this.advance();
                if (this.at(JetTokens.RPAR)) break;
            }
        }
        this.consumeIf(JetTokens.RPAR);
        this.myBuilder.restoreNewlinesState();
        mark.error("Tuples are not supported. Use data classes instead.");
    }

    private void parseThisExpression() {
        assert (this._at(JetTokens.THIS_KEYWORD));
        PsiBuilder.Marker mark = this.mark();
        PsiBuilder.Marker thisReference = this.mark();
        this.advance();
        thisReference.done(JetNodeTypes.REFERENCE_EXPRESSION);
        this.parseLabelOnTheSameLine();
        mark.done(JetNodeTypes.THIS_EXPRESSION);
    }

    private void parseSuperExpression() {
        assert (this._at(JetTokens.SUPER_KEYWORD));
        PsiBuilder.Marker mark = this.mark();
        PsiBuilder.Marker superReference = this.mark();
        this.advance();
        superReference.done(JetNodeTypes.REFERENCE_EXPRESSION);
        if (this.at(JetTokens.LT)) {
            PsiBuilder.Marker supertype = this.mark();
            this.myBuilder.disableNewlines();
            this.advance();
            this.myJetParsing.parseTypeRef();
            if (this.at(JetTokens.GT)) {
                this.advance();
                supertype.drop();
            } else {
                supertype.rollbackTo();
            }
            this.myBuilder.restoreNewlinesState();
        }
        this.parseLabelOnTheSameLine();
        mark.done(JetNodeTypes.SUPER_EXPRESSION);
    }

    public void parseValueArgumentList() {
        PsiBuilder.Marker list = this.mark();
        this.myBuilder.disableNewlines();
        if (this.expect(JetTokens.LPAR, "Expecting an argument list", EXPRESSION_FOLLOW)) {
            block4: {
                if (!this.at(JetTokens.RPAR)) {
                    while (true) {
                        if (this.at(JetTokens.COMMA)) {
                            this.errorAndAdvance("Expecting an argument");
                            continue;
                        }
                        this.parseValueArgument();
                        if (!this.at(JetTokens.COMMA)) break block4;
                        this.advance();
                        if (this.at(JetTokens.RPAR)) break;
                    }
                    this.error("Expecting an argument");
                }
            }
            this.expect(JetTokens.RPAR, "Expecting ')'", EXPRESSION_FOLLOW);
        }
        this.myBuilder.restoreNewlinesState();
        list.done(JetNodeTypes.VALUE_ARGUMENT_LIST);
    }

    private void parseValueArgument() {
        PsiBuilder.Marker argument = this.mark();
        if (this.at(JetTokens.IDENTIFIER) && this.lookahead(1) == JetTokens.EQ) {
            PsiBuilder.Marker argName = this.mark();
            PsiBuilder.Marker reference = this.mark();
            this.advance();
            reference.done(JetNodeTypes.REFERENCE_EXPRESSION);
            argName.done(JetNodeTypes.VALUE_ARGUMENT_NAME);
            this.advance();
        }
        if (this.at(JetTokens.MUL)) {
            this.advance();
        }
        this.parseExpression();
        argument.done(JetNodeTypes.VALUE_ARGUMENT);
    }

    public void parseObjectLiteral() {
        PsiBuilder.Marker literal = this.mark();
        PsiBuilder.Marker declaration = this.mark();
        this.myJetParsing.parseObject(false, false);
        declaration.done(JetNodeTypes.OBJECT_DECLARATION);
        literal.done(JetNodeTypes.OBJECT_LITERAL);
    }

    private void parseOneTokenExpression(JetNodeType type) {
        PsiBuilder.Marker mark = this.mark();
        this.advance();
        mark.done(type);
    }

    @Override
    protected JetParsing create(SemanticWhitespaceAwarePsiBuilder builder) {
        return this.myJetParsing.create(builder);
    }

    private boolean interruptedWithNewLine() {
        return !ALLOW_NEWLINE_OPERATIONS.contains(this.tt()) && this.myBuilder.newlineBeforeCurrentToken();
    }

    static {
        Precedence[] values;
        WHEN_CONDITION_RECOVERY_SET = TokenSet.create(JetTokens.RBRACE, JetTokens.IN_KEYWORD, JetTokens.NOT_IN, JetTokens.IS_KEYWORD, JetTokens.NOT_IS, JetTokens.ELSE_KEYWORD);
        WHEN_CONDITION_RECOVERY_SET_WITH_ARROW = TokenSet.create(JetTokens.RBRACE, JetTokens.IN_KEYWORD, JetTokens.NOT_IN, JetTokens.IS_KEYWORD, JetTokens.NOT_IS, JetTokens.ELSE_KEYWORD, JetTokens.ARROW, JetTokens.DOT);
        KEYWORD_TEXTS = JetExpressionParsing.tokenSetToMap(JetTokens.KEYWORDS);
        TYPE_ARGUMENT_LIST_STOPPERS = TokenSet.create(JetTokens.INTEGER_LITERAL, JetTokens.FLOAT_LITERAL, JetTokens.CHARACTER_LITERAL, JetTokens.OPEN_QUOTE, JetTokens.PACKAGE_KEYWORD, JetTokens.AS_KEYWORD, JetTokens.TYPE_KEYWORD, JetTokens.TRAIT_KEYWORD, JetTokens.CLASS_KEYWORD, JetTokens.THIS_KEYWORD, JetTokens.VAL_KEYWORD, JetTokens.VAR_KEYWORD, JetTokens.FUN_KEYWORD, JetTokens.FOR_KEYWORD, JetTokens.NULL_KEYWORD, JetTokens.TRUE_KEYWORD, JetTokens.FALSE_KEYWORD, JetTokens.IS_KEYWORD, JetTokens.THROW_KEYWORD, JetTokens.RETURN_KEYWORD, JetTokens.BREAK_KEYWORD, JetTokens.CONTINUE_KEYWORD, JetTokens.OBJECT_KEYWORD, JetTokens.IF_KEYWORD, JetTokens.TRY_KEYWORD, JetTokens.ELSE_KEYWORD, JetTokens.WHILE_KEYWORD, JetTokens.DO_KEYWORD, JetTokens.WHEN_KEYWORD, JetTokens.RBRACKET, JetTokens.RBRACE, JetTokens.RPAR, JetTokens.PLUSPLUS, JetTokens.MINUSMINUS, JetTokens.EXCLEXCL, JetTokens.PLUS, JetTokens.MINUS, JetTokens.EXCL, JetTokens.DIV, JetTokens.PERC, JetTokens.LTEQ, JetTokens.EQEQEQ, JetTokens.EXCLEQEQEQ, JetTokens.EQEQ, JetTokens.EXCLEQ, JetTokens.ANDAND, JetTokens.OROR, JetTokens.SAFE_ACCESS, JetTokens.ELVIS, JetTokens.SEMICOLON, JetTokens.RANGE, JetTokens.EQ, JetTokens.MULTEQ, JetTokens.DIVEQ, JetTokens.PERCEQ, JetTokens.PLUSEQ, JetTokens.MINUSEQ, JetTokens.NOT_IN, JetTokens.NOT_IS, JetTokens.COLONCOLON, JetTokens.COLON);
        EXPRESSION_FIRST = TokenSet.create(JetTokens.MINUS, JetTokens.PLUS, JetTokens.MINUSMINUS, JetTokens.PLUSPLUS, JetTokens.EXCL, JetTokens.EXCLEXCL, JetTokens.LBRACKET, JetTokens.LABEL_IDENTIFIER, JetTokens.COLONCOLON, JetTokens.LPAR, JetTokens.HASH, JetTokens.TRUE_KEYWORD, JetTokens.FALSE_KEYWORD, JetTokens.OPEN_QUOTE, JetTokens.INTEGER_LITERAL, JetTokens.CHARACTER_LITERAL, JetTokens.FLOAT_LITERAL, JetTokens.NULL_KEYWORD, JetTokens.LBRACE, JetTokens.LPAR, JetTokens.THIS_KEYWORD, JetTokens.SUPER_KEYWORD, JetTokens.IF_KEYWORD, JetTokens.WHEN_KEYWORD, JetTokens.TRY_KEYWORD, JetTokens.OBJECT_KEYWORD, JetTokens.THROW_KEYWORD, JetTokens.RETURN_KEYWORD, JetTokens.CONTINUE_KEYWORD, JetTokens.BREAK_KEYWORD, JetTokens.FOR_KEYWORD, JetTokens.WHILE_KEYWORD, JetTokens.DO_KEYWORD, JetTokens.IDENTIFIER, JetTokens.FIELD_IDENTIFIER, JetTokens.PACKAGE_KEYWORD);
        STATEMENT_FIRST = TokenSet.orSet(EXPRESSION_FIRST, TokenSet.create(JetTokens.LBRACKET, JetTokens.FUN_KEYWORD, JetTokens.VAL_KEYWORD, JetTokens.VAR_KEYWORD, JetTokens.TRAIT_KEYWORD, JetTokens.CLASS_KEYWORD, JetTokens.TYPE_KEYWORD), JetTokens.MODIFIER_KEYWORDS);
        STATEMENT_NEW_LINE_QUICK_RECOVERY_SET = TokenSet.orSet(TokenSet.andSet(STATEMENT_FIRST, TokenSet.andNot(JetTokens.KEYWORDS, TokenSet.create(JetTokens.IN_KEYWORD))), TokenSet.create(JetTokens.EOL_OR_SEMICOLON));
        EXPRESSION_FOLLOW = TokenSet.create(JetTokens.SEMICOLON, JetTokens.ARROW, JetTokens.COMMA, JetTokens.RBRACE, JetTokens.RPAR, JetTokens.RBRACKET);
        ALLOW_NEWLINE_OPERATIONS = TokenSet.create(JetTokens.DOT, JetTokens.SAFE_ACCESS, JetTokens.COLON, JetTokens.AS_KEYWORD, JetTokens.AS_SAFE, JetTokens.ELVIS, JetTokens.ANDAND, JetTokens.OROR);
        IElementType[] operations = new HashSet();
        for (Precedence precedence : values = Precedence.values()) {
            operations.addAll(Arrays.asList(precedence.getOperations().getTypes()));
        }
        ALL_OPERATIONS = TokenSet.create(operations.toArray(new IElementType[operations.size()]));
        operations = JetTokens.OPERATIONS.getTypes();
        HashSet<IElementType> opSet = new HashSet<IElementType>(Arrays.asList(operations));
        IElementType[] usedOperations = ALL_OPERATIONS.getTypes();
        HashSet<IElementType> usedSet = new HashSet<IElementType>(Arrays.asList(usedOperations));
        if (opSet.size() > usedSet.size()) {
            opSet.removeAll(usedSet);
            assert (false) : opSet;
        }
        assert (usedSet.size() == opSet.size()) : "Either some ops are unused, or something a non-op is used";
        usedSet.removeAll(opSet);
        assert (usedSet.isEmpty()) : ((Object)usedSet).toString();
    }

    public static class Precedence
    extends Enum<Precedence> {
        public static final /* enum */ Precedence POSTFIX;
        public static final /* enum */ Precedence PREFIX;
        public static final /* enum */ Precedence COLON_AS;
        public static final /* enum */ Precedence MULTIPLICATIVE;
        public static final /* enum */ Precedence ADDITIVE;
        public static final /* enum */ Precedence RANGE;
        public static final /* enum */ Precedence SIMPLE_NAME;
        public static final /* enum */ Precedence ELVIS;
        public static final /* enum */ Precedence IN_OR_IS;
        public static final /* enum */ Precedence COMPARISON;
        public static final /* enum */ Precedence EQUALITY;
        public static final /* enum */ Precedence CONJUNCTION;
        public static final /* enum */ Precedence DISJUNCTION;
        public static final /* enum */ Precedence ASSIGNMENT;
        private Precedence higher;
        private final TokenSet operations;
        private static final /* synthetic */ Precedence[] $VALUES;

        public static Precedence[] values() {
            return (Precedence[])$VALUES.clone();
        }

        public static Precedence valueOf(String name) {
            return Enum.valueOf(Precedence.class, name);
        }

        private Precedence(IElementType ... operations) {
            this.operations = TokenSet.create(operations);
        }

        public void parseHigherPrecedence(JetExpressionParsing parser) {
            assert (this.higher != null);
            parser.parseBinaryExpression(this.higher);
        }

        public JetNodeType parseRightHandSide(IElementType operation, JetExpressionParsing parser) {
            this.parseHigherPrecedence(parser);
            return JetNodeTypes.BINARY_EXPRESSION;
        }

        @NotNull
        public final TokenSet getOperations() {
            TokenSet tokenSet = this.operations;
            if (tokenSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/parsing/JetExpressionParsing$Precedence", "getOperations"));
            }
            return tokenSet;
        }

        static {
            Precedence[] values;
            POSTFIX = new Precedence(JetTokens.PLUSPLUS, JetTokens.MINUSMINUS, JetTokens.EXCLEXCL, JetTokens.DOT, JetTokens.SAFE_ACCESS);
            PREFIX = new Precedence(new IElementType[]{JetTokens.MINUS, JetTokens.PLUS, JetTokens.MINUSMINUS, JetTokens.PLUSPLUS, JetTokens.EXCL, JetTokens.LABEL_IDENTIFIER}){

                @Override
                public void parseHigherPrecedence(JetExpressionParsing parser) {
                    throw new IllegalStateException("Don't call this method");
                }
            };
            COLON_AS = new Precedence(new IElementType[]{JetTokens.COLON, JetTokens.AS_KEYWORD, JetTokens.AS_SAFE}){

                @Override
                public JetNodeType parseRightHandSide(IElementType operation, JetExpressionParsing parser) {
                    parser.myJetParsing.parseTypeRef();
                    return JetNodeTypes.BINARY_WITH_TYPE;
                }

                @Override
                public void parseHigherPrecedence(JetExpressionParsing parser) {
                    parser.parsePrefixExpression();
                }
            };
            MULTIPLICATIVE = new Precedence(JetTokens.MUL, JetTokens.DIV, JetTokens.PERC);
            ADDITIVE = new Precedence(JetTokens.PLUS, JetTokens.MINUS);
            RANGE = new Precedence(JetTokens.RANGE);
            SIMPLE_NAME = new Precedence(JetTokens.IDENTIFIER);
            ELVIS = new Precedence(JetTokens.ELVIS);
            IN_OR_IS = new Precedence(new IElementType[]{JetTokens.IN_KEYWORD, JetTokens.NOT_IN, JetTokens.IS_KEYWORD, JetTokens.NOT_IS}){

                @Override
                public JetNodeType parseRightHandSide(IElementType operation, JetExpressionParsing parser) {
                    if (operation == JetTokens.IS_KEYWORD || operation == JetTokens.NOT_IS) {
                        parser.myJetParsing.parseTypeRef();
                        return JetNodeTypes.IS_EXPRESSION;
                    }
                    return super.parseRightHandSide(operation, parser);
                }
            };
            COMPARISON = new Precedence(JetTokens.LT, JetTokens.GT, JetTokens.LTEQ, JetTokens.GTEQ);
            EQUALITY = new Precedence(JetTokens.EQEQ, JetTokens.EXCLEQ, JetTokens.EQEQEQ, JetTokens.EXCLEQEQEQ);
            CONJUNCTION = new Precedence(JetTokens.ANDAND);
            DISJUNCTION = new Precedence(JetTokens.OROR);
            ASSIGNMENT = new Precedence(JetTokens.EQ, JetTokens.PLUSEQ, JetTokens.MINUSEQ, JetTokens.MULTEQ, JetTokens.DIVEQ, JetTokens.PERCEQ);
            $VALUES = new Precedence[]{POSTFIX, PREFIX, COLON_AS, MULTIPLICATIVE, ADDITIVE, RANGE, SIMPLE_NAME, ELVIS, IN_OR_IS, COMPARISON, EQUALITY, CONJUNCTION, DISJUNCTION, ASSIGNMENT};
            for (Precedence precedence : values = Precedence.values()) {
                int ordinal = precedence.ordinal();
                precedence.higher = ordinal > 0 ? values[ordinal - 1] : null;
            }
        }
    }
}

