/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.inference;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintType;
import org.jetbrains.jet.lang.types.JetType;

public class SubtypingConstraint {
    private final ConstraintType type;
    private final JetType subtype;
    private final JetType supertype;

    public SubtypingConstraint(@NotNull ConstraintType type, @NotNull JetType subtype, @NotNull JetType supertype) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/calls/inference/SubtypingConstraint", "<init>"));
        }
        if (subtype == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subtype", "org/jetbrains/jet/lang/resolve/calls/inference/SubtypingConstraint", "<init>"));
        }
        if (supertype == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertype", "org/jetbrains/jet/lang/resolve/calls/inference/SubtypingConstraint", "<init>"));
        }
        this.type = type;
        this.subtype = subtype;
        this.supertype = supertype;
    }

    @NotNull
    public JetType getSubtype() {
        JetType jetType = this.subtype;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/SubtypingConstraint", "getSubtype"));
        }
        return jetType;
    }

    @NotNull
    public JetType getSupertype() {
        JetType jetType = this.supertype;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/SubtypingConstraint", "getSupertype"));
        }
        return jetType;
    }

    @NotNull
    public ConstraintType getType() {
        ConstraintType constraintType = this.type;
        if (constraintType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/SubtypingConstraint", "getType"));
        }
        return constraintType;
    }

    @NotNull
    public String getErrorMessage() {
        String string = this.type.makeErrorMessage(this);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/SubtypingConstraint", "getErrorMessage"));
        }
        return string;
    }

    public String toString() {
        return this.getSubtype() + " :< " + this.getSupertype();
    }
}

