/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.kotlin;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.descriptors.serialization.ClassData;
import org.jetbrains.jet.descriptors.serialization.JavaProtoBufUtil;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedClassDescriptor;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedPackageMemberScope;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.resolve.java.resolver.ErrorReporter;
import org.jetbrains.jet.lang.resolve.kotlin.DeserializationGlobalContextForJava;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.jet.lang.resolve.kotlin.header.KotlinClassHeader;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;

public final class DeserializedDescriptorResolver {
    private DeserializationGlobalContextForJava context;
    private ErrorReporter errorReporter;

    public void setContext(DeserializationGlobalContextForJava context) {
        this.context = context;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Nullable
    public ClassDescriptor resolveClass(@NotNull KotlinJvmBinaryClass kotlinClass) {
        if (kotlinClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinClass", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedDescriptorResolver", "resolveClass"));
        }
        String[] data2 = this.readData(kotlinClass, KotlinClassHeader.Kind.CLASS);
        if (data2 != null) {
            ClassData classData = JavaProtoBufUtil.readClassDataFrom(data2);
            return new DeserializedClassDescriptor(this.context, classData);
        }
        return null;
    }

    @Nullable
    public JetScope createKotlinPackageScope(@NotNull PackageFragmentDescriptor descriptor, @NotNull KotlinJvmBinaryClass kotlinClass) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedDescriptorResolver", "createKotlinPackageScope"));
        }
        if (kotlinClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinClass", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedDescriptorResolver", "createKotlinPackageScope"));
        }
        String[] data2 = this.readData(kotlinClass, KotlinClassHeader.Kind.PACKAGE_FACADE);
        if (data2 != null) {
            return new DeserializedPackageMemberScope(descriptor, JavaProtoBufUtil.readPackageDataFrom(data2), this.context);
        }
        return null;
    }

    @Nullable
    private String[] readData(@NotNull KotlinJvmBinaryClass kotlinClass, @NotNull KotlinClassHeader.Kind expectedKind) {
        if (kotlinClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinClass", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedDescriptorResolver", "readData"));
        }
        if (expectedKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedKind", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedDescriptorResolver", "readData"));
        }
        KotlinClassHeader header = kotlinClass.getClassHeader();
        if (header.getKind() == KotlinClassHeader.Kind.INCOMPATIBLE_ABI_VERSION) {
            this.errorReporter.reportIncompatibleAbiVersion(kotlinClass, header.getVersion());
        } else if (header.getKind() == expectedKind) {
            return header.getAnnotationData();
        }
        return null;
    }
}

