/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.util.containers.ConcurrentHashSet;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class ProgressManager
extends ProgressIndicatorProvider {
    protected static final ThreadLocal<ProgressIndicator> myThreadIndicator = new ThreadLocal();
    private static final Map<ProgressIndicator, Set<Thread>> threadsUnderIndicator = new THashMap<ProgressIndicator, Set<Thread>>();
    private static final Set<Thread> threadsUnderCanceledIndicator = new ConcurrentHashSet<Thread>();
    private static final Collection<ProgressIndicator> nonStandardIndicators = new ConcurrentHashSet<ProgressIndicator>();

    @NotNull
    public static ProgressManager getInstance() {
        ProgressManager progressManager = ProgressManagerHolder.ourInstance;
        if (progressManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/ProgressManager", "getInstance"));
        }
        return progressManager;
    }

    @Override
    public ProgressIndicator getProgressIndicator() {
        return myThreadIndicator.get();
    }

    public abstract void executeNonCancelableSection(@NotNull Runnable var1);

    public static void checkCanceled() throws ProcessCanceledException {
        boolean thereIsCanceledIndicator;
        boolean bl = thereIsCanceledIndicator = !threadsUnderCanceledIndicator.isEmpty();
        if (thereIsCanceledIndicator) {
            ProgressManager.getInstance().doCheckCanceled();
        }
    }

    private static class ProgressManagerHolder {
        private static final ProgressManager ourInstance = ServiceManager.getService(ProgressManager.class);
    }
}

