/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZipFileCache {
    private static final Object ourLock = new Object();
    private static final Map<String, CacheRecord> ourPathCache = ContainerUtil.newTroveMap(FileUtil.PATH_HASHING_STRATEGY);
    private static final Map<ZipFile, CacheRecord> ourFileCache = ContainerUtil.newHashMap();
    private static final Map<ZipFile, Integer> ourQueue = ContainerUtil.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static ZipFile acquire(@NotNull String path) throws IOException {
        CacheRecord record;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/util/io/ZipFileCache", "acquire"));
        }
        path = FileUtil.toCanonicalPath(path);
        Object object2 = ourLock;
        synchronized (object2) {
            CacheRecord record2 = ourPathCache.get(path);
            if (record2 != null) {
                record2.count++;
                ZipFile zipFile = record2.file;
                // MONITOREXIT @DISABLED, blocks:[4, 10] lbl11 : MonitorExitStatement: MONITOREXIT : var1_1
                if (zipFile == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/ZipFileCache", "acquire"));
                }
                return zipFile;
            }
        }
        ZipFile file = ZipFileCache.tryOpen(path);
        Object object3 = ourLock;
        synchronized (object3) {
            record = ourPathCache.get(path);
            if (record == null) {
                record = new CacheRecord(path, file);
                ourPathCache.put(path, record);
                ourFileCache.put(file, record);
                ZipFile zipFile = file;
                // MONITOREXIT @DISABLED, blocks:[5, 8] lbl27 : MonitorExitStatement: MONITOREXIT : var3_3
                if (zipFile == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/ZipFileCache", "acquire"));
                }
                return zipFile;
            }
            record.count++;
        }
        ZipFileCache.close(file);
        ZipFile zipFile = record.file;
        if (zipFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/ZipFileCache", "acquire"));
        }
        return zipFile;
    }

    private static ZipFile tryOpen(String path) throws IOException {
        path = FileUtil.toSystemDependentName(path);
        ZipFileCache.debug("opening %s", path);
        try {
            return new ZipFile(path);
        }
        catch (IOException e) {
            String reason = e.getMessage();
            if ("too many open files".equalsIgnoreCase(reason) && ZipFileCache.tryCloseFiles() > 0) {
                return new ZipFile(path);
            }
            throw e;
        }
    }

    private static int tryCloseFiles() {
        List<ZipFile> toClose = ZipFileCache.getFilesToClose(5, 0L);
        if (toClose == null) {
            return 0;
        }
        ZipFileCache.close(toClose);
        ZipFileCache.logger().warn("too many open files, closed: " + toClose.size());
        return toClose.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static List<ZipFile> getFilesToClose(int limit, long timeout) {
        ArrayList toClose = null;
        Object object2 = ourLock;
        synchronized (object2) {
            Iterator<CacheRecord> i = ourPathCache.values().iterator();
            while (i.hasNext() && (limit == 0 || toClose == null || toClose.size() < limit)) {
                CacheRecord record = i.next();
                if (record.count > 0 || timeout != 0L && record.released > timeout) continue;
                i.remove();
                ourFileCache.remove(record.file);
                if (toClose == null) {
                    toClose = ContainerUtil.newArrayList();
                }
                toClose.add(record.file);
            }
        }
        return toClose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release(@NotNull ZipFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/ZipFileCache", "release"));
        }
        Object object2 = ourLock;
        synchronized (object2) {
            CacheRecord record = ourFileCache.get(file);
            if (record != null) {
                record.count--;
                record.released = System.currentTimeMillis();
                ZipFileCache.logger().assertTrue(record.count >= 0, record.path);
                return;
            }
            Integer count = ourQueue.get(file);
            if (count != null) {
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count - 1);
                if (count == 0) {
                    ourQueue.remove(file);
                    ZipFileCache.close(file);
                } else {
                    ourQueue.put(file, count);
                }
                return;
            }
        }
        ZipFileCache.logger().warn(new IllegalArgumentException("stray file: " + file.getName()));
        ZipFileCache.close(file);
    }

    private static void close(@NotNull List<ZipFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/util/io/ZipFileCache", "close"));
        }
        for (ZipFile file : files) {
            ZipFileCache.close(file);
        }
    }

    private static void close(@NotNull ZipFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/ZipFileCache", "close"));
        }
        ZipFileCache.debug("closing %s", file.getName());
        try {
            file.close();
        }
        catch (IOException e) {
            ZipFileCache.logger().info(file.getName(), e);
        }
    }

    private static Logger logger() {
        return Logger.getInstance(ZipFileCache.class);
    }

    private static void debug(@NotNull String format, Object ... args) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/openapi/util/io/ZipFileCache", "debug"));
        }
        LogUtil.debug(ZipFileCache.logger(), format, args);
    }

    static {
        ConcurrencyUtil.newSingleScheduledThreadExecutor("ZipFileCache Dispose", 1).scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                List toClose = ZipFileCache.getFilesToClose(0, System.currentTimeMillis() - 30000L);
                if (toClose != null) {
                    ZipFileCache.close(toClose);
                }
            }
        }, 10000L, 10000L, TimeUnit.MILLISECONDS);
    }

    private static class CacheRecord {
        private final String path;
        private final ZipFile file;
        private int count;
        private long released;

        private CacheRecord(@NotNull String path, @NotNull ZipFile file) throws IOException {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/util/io/ZipFileCache$CacheRecord", "<init>"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/ZipFileCache$CacheRecord", "<init>"));
            }
            this.count = 1;
            this.released = 0L;
            this.path = path;
            this.file = file;
        }
    }
}

