/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceIncorporationPhase;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariablesOrder;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.CheckedExceptionCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ExpressionCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.InputOutputConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeEqualityConstraint;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InferenceSession {
    private static final Logger LOG = Logger.getInstance("#" + InferenceSession.class.getName());
    public static final Key<PsiType> LOWER_BOUND = Key.create("LowBound");
    private static final Key<Boolean> ERASED = Key.create("UNCHECKED_CONVERSION");
    private static final Function<Pair<PsiType, PsiType>, PsiType> UPPER_BOUND_FUNCTION = new Function<Pair<PsiType, PsiType>, PsiType>(){

        @Override
        public PsiType fun(Pair<PsiType, PsiType> pair) {
            return GenericsUtil.getGreatestLowerBound((PsiType)pair.first, (PsiType)pair.second);
        }
    };
    private final Set<InferenceVariable> myInferenceVariables = new LinkedHashSet<InferenceVariable>();
    private final List<ConstraintFormula> myConstraints = new ArrayList<ConstraintFormula>();
    private final Set<ConstraintFormula> myConstraintsCopy = new HashSet<ConstraintFormula>();
    private PsiSubstitutor mySiteSubstitutor;
    private PsiManager myManager;
    private int myConstraintIdx = 0;
    private boolean myErased = false;
    private final InferenceIncorporationPhase myIncorporationPhase = new InferenceIncorporationPhase(this);
    private final PsiElement myContext;
    private PsiSubstitutor myInferenceSubstitution = PsiSubstitutor.EMPTY;
    private Map<PsiElement, InferenceSession> myNestedSessions = new HashMap<PsiElement, InferenceSession>();

    public void registerNestedSession(InferenceSession session) {
        this.propagateVariables(session.getInferenceVariables());
        this.myNestedSessions.put(session.getContext(), session);
        this.myNestedSessions.putAll(session.myNestedSessions);
    }

    public InferenceSession(PsiTypeParameter[] typeParams, PsiType[] leftTypes, PsiType[] rightTypes, PsiSubstitutor siteSubstitutor, PsiManager manager, PsiElement context2) {
        this.myManager = manager;
        this.mySiteSubstitutor = siteSubstitutor;
        this.myContext = context2;
        this.initBounds(typeParams);
        LOG.assertTrue(leftTypes.length == rightTypes.length);
        for (int i = 0; i < leftTypes.length; ++i) {
            PsiType rightType = this.mySiteSubstitutor.substitute(rightTypes[i]);
            if (rightType == null) continue;
            this.addConstraint(new TypeCompatibilityConstraint(this.substituteWithInferenceVariables(leftTypes[i]), this.substituteWithInferenceVariables(rightType)));
        }
    }

    public InferenceSession(PsiTypeParameter[] typeParams, PsiSubstitutor siteSubstitutor, PsiManager manager, PsiElement context2) {
        this.myManager = manager;
        this.mySiteSubstitutor = siteSubstitutor;
        this.myContext = context2;
        this.initBounds(typeParams);
    }

    public void initExpressionConstraints(PsiParameter[] parameters, PsiExpression[] args, PsiElement parent, PsiMethod method) {
        MethodCandidateInfo.CurrentCandidateProperties currentProperties = InferenceSession.getCurrentProperties(parent);
        this.initExpressionConstraints(parameters, args, parent, method, currentProperties != null && currentProperties.isVarargs());
    }

    public void initExpressionConstraints(PsiParameter[] parameters, PsiExpression[] args, PsiElement parent, PsiMethod method, boolean varargs) {
        MethodCandidateInfo.CurrentCandidateProperties currentProperties = InferenceSession.getCurrentProperties(parent);
        if (method == null && currentProperties != null) {
            method = currentProperties.getMethod();
        }
        if (method != null) {
            this.initThrowsConstraints(method);
        }
        if (parameters.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null || !InferenceSession.isPertinentToApplicability(args[i], method)) continue;
                PsiType parameterType = InferenceSession.getParameterType(parameters, i, this.mySiteSubstitutor, varargs);
                this.addConstraint(new ExpressionCompatibilityConstraint(args[i], this.substituteWithInferenceVariables(parameterType)));
            }
        }
    }

    public void initThrowsConstraints(PsiMethod method) {
        for (PsiClassType thrownType : method.getThrowsList().getReferencedTypes()) {
            InferenceVariable variable = this.getInferenceVariable(this.substituteWithInferenceVariables(thrownType));
            if (variable == null) continue;
            variable.setThrownBound();
        }
    }

    private static MethodCandidateInfo.CurrentCandidateProperties getCurrentProperties(PsiElement parent) {
        if (parent instanceof PsiCallExpression) {
            return MethodCandidateInfo.getCurrentMethod(((PsiCallExpression)parent).getArgumentList());
        }
        return null;
    }

    public static boolean isPertinentToApplicability(PsiExpression expr, PsiMethod method) {
        PsiElement gParent;
        PsiElement parent;
        if ((expr instanceof PsiLambdaExpression && ((PsiLambdaExpression)expr).hasFormalParameterTypes() || expr instanceof PsiMethodReferenceExpression && ((PsiMethodReferenceExpression)expr).isExact()) && method != null && method.getTypeParameters().length > 0 && (parent = PsiUtil.skipParenthesizedExprUp(expr.getParent())) instanceof PsiExpressionList && (gParent = parent.getParent()) instanceof PsiCallExpression && ((PsiCallExpression)gParent).getTypeArgumentList().getTypeParameterElements().length == 0) {
            PsiType paramType;
            PsiParameter[] parameters;
            int idx = LambdaUtil.getLambdaIdx((PsiExpressionList)parent, expr);
            if (idx > (parameters = method.getParameterList().getParameters()).length - 1) {
                PsiType lastParamType = parameters[parameters.length - 1].getType();
                paramType = parameters[parameters.length - 1].isVarArgs() ? ((PsiEllipsisType)lastParamType).getComponentType() : lastParamType;
            } else {
                paramType = parameters[idx].getType();
            }
            PsiClass psiClass = PsiUtil.resolveClassInType(paramType);
            if (psiClass instanceof PsiTypeParameter && ((PsiTypeParameter)psiClass).getOwner() == method) {
                return false;
            }
        }
        if (expr instanceof PsiLambdaExpression) {
            if (!((PsiLambdaExpression)expr).hasFormalParameterTypes()) {
                return false;
            }
            for (PsiExpression expression : LambdaUtil.getReturnExpressions((PsiLambdaExpression)expr)) {
                if (InferenceSession.isPertinentToApplicability(expression, method)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof PsiMethodReferenceExpression) {
            return ((PsiMethodReferenceExpression)expr).isExact();
        }
        if (expr instanceof PsiParenthesizedExpression) {
            return InferenceSession.isPertinentToApplicability(((PsiParenthesizedExpression)expr).getExpression(), method);
        }
        if (expr instanceof PsiConditionalExpression) {
            PsiExpression thenExpression = ((PsiConditionalExpression)expr).getThenExpression();
            if (!InferenceSession.isPertinentToApplicability(thenExpression, method)) {
                return false;
            }
            PsiExpression elseExpression = ((PsiConditionalExpression)expr).getElseExpression();
            if (!InferenceSession.isPertinentToApplicability(elseExpression, method)) {
                return false;
            }
        }
        return true;
    }

    private static PsiType getParameterType(PsiParameter[] parameters, int i, @Nullable PsiSubstitutor substitutor, boolean varargs) {
        if (substitutor == null) {
            return null;
        }
        PsiType parameterType = substitutor.substitute(parameters[i < parameters.length ? i : parameters.length - 1].getType());
        if (parameterType instanceof PsiEllipsisType && varargs) {
            parameterType = ((PsiEllipsisType)parameterType).getComponentType();
        }
        return parameterType;
    }

    @NotNull
    public PsiSubstitutor infer() {
        PsiSubstitutor psiSubstitutor = this.infer(null, null, null);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
        }
        return psiSubstitutor;
    }

    @NotNull
    public PsiSubstitutor infer(@Nullable PsiParameter[] parameters, @Nullable PsiExpression[] args, @Nullable PsiElement parent) {
        PsiSubstitutor substitutor;
        MethodCandidateInfo.CurrentCandidateProperties properties2 = InferenceSession.getCurrentProperties(parent);
        if (!this.repeatInferencePhases(true)) {
            PsiSubstitutor psiSubstitutor = this.resolveSubset(this.myInferenceVariables, this.mySiteSubstitutor);
            if (psiSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
            }
            return psiSubstitutor;
        }
        if (properties2 != null && !properties2.isApplicabilityCheck()) {
            this.initReturnTypeConstraint(properties2.getMethod(), (PsiCallExpression)parent);
            if (!this.repeatInferencePhases(true)) {
                PsiSubstitutor psiSubstitutor = this.prepareSubstitution();
                if (psiSubstitutor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
                }
                return psiSubstitutor;
            }
            if (parameters != null && args != null && !MethodCandidateInfo.ourOverloadGuard.currentStack().contains(PsiUtil.skipParenthesizedExprUp(parent.getParent()))) {
                LinkedHashSet<ConstraintFormula> additionalConstraints = new LinkedHashSet<ConstraintFormula>();
                if (parameters.length > 0) {
                    this.collectAdditionalConstraints(parameters, args, properties2.getMethod(), PsiSubstitutor.EMPTY, additionalConstraints, properties2.isVarargs());
                }
                if (!additionalConstraints.isEmpty() && !this.proceedWithAdditionalConstraints(additionalConstraints)) {
                    PsiSubstitutor psiSubstitutor = this.prepareSubstitution();
                    if (psiSubstitutor == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
                    }
                    return psiSubstitutor;
                }
            }
        }
        if ((substitutor = this.resolveBounds(this.myInferenceVariables, this.mySiteSubstitutor)) != null) {
            if (this.myContext != null) {
                this.myContext.putUserData(ERASED, this.myErased);
            }
            this.mySiteSubstitutor = substitutor;
            for (InferenceVariable variable : this.myInferenceVariables) {
                variable.setInstantiation(substitutor.substitute(variable.getParameter()));
            }
        } else {
            PsiSubstitutor psiSubstitutor = this.resolveSubset(this.myInferenceVariables, this.mySiteSubstitutor);
            if (psiSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
            }
            return psiSubstitutor;
        }
        PsiSubstitutor psiSubstitutor = this.prepareSubstitution();
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
        }
        return psiSubstitutor;
    }

    private void collectAdditionalConstraints(PsiParameter[] parameters, PsiExpression[] args, PsiMethod parentMethod, PsiSubstitutor siteSubstitutor, Set<ConstraintFormula> additionalConstraints, boolean varargs) {
        for (int i = 0; i < args.length; ++i) {
            PsiExpression arg = PsiUtil.skipParenthesizedExprDown(args[i]);
            if (arg == null) continue;
            InferenceSession nestedCallSession = this.findNestedCallSession(arg);
            PsiType parameterType = nestedCallSession.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters, i, siteSubstitutor, varargs));
            if (!InferenceSession.isPertinentToApplicability(arg, parentMethod)) {
                additionalConstraints.add(new ExpressionCompatibilityConstraint(arg, parameterType));
            }
            additionalConstraints.add(new CheckedExceptionCompatibilityConstraint(arg, parameterType));
            if (arg instanceof PsiCallExpression) {
                PsiMethod calledMethod = InferenceSession.getCalledMethod((PsiCallExpression)arg);
                if (calledMethod == null || !PsiPolyExpressionUtil.isMethodCallPolyExpression(arg, calledMethod)) continue;
                this.collectAdditionalConstraints(additionalConstraints, (PsiCallExpression)arg);
                continue;
            }
            if (!(arg instanceof PsiLambdaExpression)) continue;
            this.collectLambdaReturnExpression(additionalConstraints, (PsiLambdaExpression)arg, parameterType);
        }
    }

    private static PsiMethod getCalledMethod(PsiCallExpression arg) {
        PsiExpressionList argumentList = arg.getArgumentList();
        if (argumentList == null || argumentList.getExpressions().length == 0) {
            return null;
        }
        boolean found = false;
        for (PsiExpression expression : argumentList.getExpressions()) {
            if (!((expression = PsiUtil.skipParenthesizedExprDown(expression)) instanceof PsiConditionalExpression) && !(expression instanceof PsiCallExpression) && !(expression instanceof PsiLambdaExpression) && !(expression instanceof PsiMethodReferenceExpression)) continue;
            found = true;
            break;
        }
        if (!found) {
            return null;
        }
        MethodCandidateInfo.CurrentCandidateProperties properties2 = MethodCandidateInfo.getCurrentMethod(argumentList);
        if (properties2 != null) {
            return properties2.getMethod();
        }
        JavaResolveResult resolveResult = InferenceSession.getMethodResult(arg);
        if (resolveResult instanceof MethodCandidateInfo) {
            return (PsiMethod)resolveResult.getElement();
        }
        return null;
    }

    private void collectLambdaReturnExpression(Set<ConstraintFormula> additionalConstraints, PsiLambdaExpression lambdaExpression, PsiType parameterType) {
        PsiType interfaceReturnType = LambdaUtil.getFunctionalInterfaceReturnType(parameterType);
        if (interfaceReturnType != null) {
            List<PsiExpression> returnExpressions = LambdaUtil.getReturnExpressions(lambdaExpression);
            for (PsiExpression returnExpression : returnExpressions) {
                this.processReturnExpression(additionalConstraints, returnExpression, interfaceReturnType);
            }
        }
    }

    private void processReturnExpression(Set<ConstraintFormula> additionalConstraints, PsiExpression returnExpression, PsiType functionalType) {
        if (returnExpression instanceof PsiCallExpression) {
            PsiMethod calledMethod = InferenceSession.getCalledMethod((PsiCallExpression)returnExpression);
            if (calledMethod != null && PsiPolyExpressionUtil.isMethodCallPolyExpression(returnExpression, calledMethod)) {
                this.collectAdditionalConstraints(additionalConstraints, (PsiCallExpression)returnExpression);
            }
        } else if (returnExpression instanceof PsiParenthesizedExpression) {
            this.processReturnExpression(additionalConstraints, ((PsiParenthesizedExpression)returnExpression).getExpression(), functionalType);
        } else if (returnExpression instanceof PsiConditionalExpression) {
            this.processReturnExpression(additionalConstraints, ((PsiConditionalExpression)returnExpression).getThenExpression(), functionalType);
            this.processReturnExpression(additionalConstraints, ((PsiConditionalExpression)returnExpression).getElseExpression(), functionalType);
        } else if (returnExpression instanceof PsiLambdaExpression) {
            this.collectLambdaReturnExpression(additionalConstraints, (PsiLambdaExpression)returnExpression, functionalType);
        }
    }

    private void collectAdditionalConstraints(Set<ConstraintFormula> additionalConstraints, PsiCallExpression callExpression) {
        PsiExpressionList argumentList = callExpression.getArgumentList();
        if (argumentList != null) {
            PsiMethod method;
            JavaResolveResult result2 = InferenceSession.getMethodResult(callExpression);
            MethodCandidateInfo.CurrentCandidateProperties properties2 = MethodCandidateInfo.getCurrentMethod(argumentList);
            PsiMethod psiMethod = result2 instanceof MethodCandidateInfo ? ((MethodCandidateInfo)result2).getElement() : (method = properties2 != null ? properties2.getMethod() : null);
            if (method != null) {
                PsiExpression[] newArgs = argumentList.getExpressions();
                PsiParameter[] newParams = method.getParameterList().getParameters();
                if (newParams.length > 0) {
                    this.collectAdditionalConstraints(newParams, newArgs, method, result2 != null ? ((MethodCandidateInfo)result2).getSiteSubstitutor() : properties2.getSubstitutor(), additionalConstraints, result2 != null ? ((MethodCandidateInfo)result2).isVarargs() : properties2.isVarargs());
                }
            }
        }
    }

    private static JavaResolveResult getMethodResult(final PsiCallExpression callExpression) {
        PsiExpressionList argumentList = callExpression.getArgumentList();
        PsiLambdaExpression expression = PsiTreeUtil.getParentOfType((PsiElement)argumentList, PsiLambdaExpression.class);
        Computable<JavaResolveResult> computableResolve = new Computable<JavaResolveResult>(){

            @Override
            public JavaResolveResult compute() {
                return callExpression.resolveMethodGenerics();
            }
        };
        MethodCandidateInfo.CurrentCandidateProperties properties2 = MethodCandidateInfo.getCurrentMethod(argumentList);
        return properties2 != null ? null : (expression == null || !PsiResolveHelper.ourGraphGuard.currentStack().contains(expression) ? (JavaResolveResult)computableResolve.compute() : PsiResolveHelper.ourGraphGuard.doPreventingRecursion(expression, false, computableResolve));
    }

    public PsiSubstitutor retrieveNonPrimitiveEqualsBounds(Collection<InferenceVariable> variables) {
        PsiSubstitutor substitutor = this.mySiteSubstitutor;
        for (InferenceVariable variable : variables) {
            PsiType equalsBound = this.getEqualsBound(variable, substitutor);
            if (equalsBound instanceof PsiPrimitiveType) continue;
            substitutor = substitutor.put(variable, equalsBound);
        }
        return substitutor;
    }

    private PsiSubstitutor prepareSubstitution() {
        for (InferenceVariable inferenceVariable : this.myInferenceVariables) {
            PsiTypeParameter typeParameter = inferenceVariable.getParameter();
            PsiType instantiation = inferenceVariable.getInstantiation();
            if (instantiation != PsiType.NULL) continue;
            this.mySiteSubstitutor = this.mySiteSubstitutor.put(typeParameter, JavaPsiFacade.getInstance(typeParameter.getProject()).getElementFactory().createType(typeParameter));
        }
        return this.mySiteSubstitutor;
    }

    public void initBounds(PsiTypeParameter ... typeParameters) {
        this.initBounds(this.myContext, typeParameters);
    }

    public InferenceVariable[] initBounds(PsiElement context2, PsiTypeParameter ... typeParameters) {
        ArrayList<InferenceVariable> result2 = new ArrayList<InferenceVariable>(typeParameters.length);
        for (PsiTypeParameter parameter : typeParameters) {
            InferenceVariable variable = new InferenceVariable(context2, parameter);
            result2.add(variable);
            this.myInferenceSubstitution = this.myInferenceSubstitution.put(parameter, JavaPsiFacade.getElementFactory(variable.getProject()).createType(variable));
        }
        for (InferenceVariable variable : result2) {
            PsiClassType[] extendsListTypes;
            PsiTypeParameter parameter = variable.getParameter();
            boolean added = false;
            for (PsiType classType : extendsListTypes = parameter.getExtendsListTypes()) {
                if (this.isProperType(classType = this.substituteWithInferenceVariables(this.mySiteSubstitutor.substitute(classType)))) {
                    added = true;
                }
                variable.addBound(classType, InferenceBound.UPPER);
            }
            if (added) continue;
            variable.addBound(PsiType.getJavaLangObject(parameter.getManager(), parameter.getResolveScope()), InferenceBound.UPPER);
        }
        this.myInferenceVariables.addAll(result2);
        return result2.toArray(new InferenceVariable[result2.size()]);
    }

    private void initReturnTypeConstraint(PsiMethod method, PsiCallExpression context2) {
        PsiType targetType;
        PsiType returnType;
        if (PsiPolyExpressionUtil.isMethodCallPolyExpression(context2, method) && !PsiType.VOID.equals(returnType = method.getReturnType()) && returnType != null && (targetType = InferenceSession.getTargetType(context2)) != null && !PsiType.VOID.equals(targetType)) {
            this.registerReturnTypeConstraints(PsiUtil.isRawSubstitutor(method, this.mySiteSubstitutor) ? returnType : this.mySiteSubstitutor.substitute(returnType), targetType);
        }
    }

    public void registerReturnTypeConstraints(PsiType returnType, PsiType targetType) {
        InferenceVariable inferenceVariable = this.shouldResolveAndInstantiate(returnType = this.substituteWithInferenceVariables(returnType), targetType);
        if (inferenceVariable != null) {
            PsiSubstitutor substitutor = this.resolveSubset(Collections.singletonList(inferenceVariable), this.mySiteSubstitutor);
            PsiType substitutedReturnType = substitutor.substitute(inferenceVariable.getParameter());
            if (substitutedReturnType != null) {
                this.addConstraint(new TypeCompatibilityConstraint(targetType, PsiUtil.captureToplevelWildcards(substitutedReturnType, this.myContext)));
            }
        } else if (FunctionalInterfaceParameterizationUtil.isWildcardParameterized(returnType)) {
            PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(returnType);
            PsiClass psiClass = resolveResult.getElement();
            if (psiClass != null) {
                LOG.assertTrue(returnType instanceof PsiClassType);
                PsiTypeParameter[] typeParameters = psiClass.getTypeParameters();
                PsiTypeParameter[] copy = this.initBounds(this.myContext, typeParameters);
                PsiType substitutedCapture = PsiUtil.captureToplevelWildcards(returnType, this.myContext);
                this.myIncorporationPhase.addCapture(copy, (PsiClassType)this.substituteWithInferenceVariables(returnType));
                this.addConstraint(new TypeCompatibilityConstraint(targetType, substitutedCapture));
            }
        } else {
            this.addConstraint(new TypeCompatibilityConstraint(targetType, this.myErased ? TypeConversionUtil.erasure(returnType) : returnType));
        }
    }

    private InferenceVariable shouldResolveAndInstantiate(PsiType returnType, PsiType targetType) {
        InferenceVariable inferenceVariable = this.getInferenceVariable(returnType);
        if (inferenceVariable != null) {
            if (targetType instanceof PsiPrimitiveType && InferenceSession.hasPrimitiveWrapperBound(inferenceVariable)) {
                return inferenceVariable;
            }
            if (targetType instanceof PsiClassType && (this.myErased || InferenceSession.hasUncheckedBounds(inferenceVariable, (PsiClassType)targetType) || InferenceSession.hasWildcardParameterization(inferenceVariable, (PsiClassType)targetType))) {
                return inferenceVariable;
            }
        }
        return null;
    }

    private static boolean hasPrimitiveWrapperBound(InferenceVariable inferenceVariable) {
        InferenceBound[] boundTypes;
        for (InferenceBound inferenceBound : boundTypes = new InferenceBound[]{InferenceBound.UPPER, InferenceBound.LOWER, InferenceBound.EQ}) {
            List<PsiType> bounds = inferenceVariable.getBounds(inferenceBound);
            for (PsiType bound : bounds) {
                if (PsiPrimitiveType.getUnboxedType(bound) == null) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasUncheckedBounds(InferenceVariable inferenceVariable, PsiClassType targetType) {
        if (!targetType.isRaw()) {
            InferenceBound[] boundTypes;
            for (InferenceBound inferenceBound : boundTypes = new InferenceBound[]{InferenceBound.EQ, InferenceBound.LOWER}) {
                List<PsiType> bounds = inferenceVariable.getBounds(inferenceBound);
                for (PsiType bound : bounds) {
                    if (!TypeCompatibilityConstraint.isUncheckedConversion(targetType, bound)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean hasWildcardParameterization(InferenceVariable inferenceVariable, PsiClassType targetType) {
        if (!FunctionalInterfaceParameterizationUtil.isWildcardParameterized(targetType)) {
            Processor<Pair<PsiType, PsiType>> differentParameterizationProcessor;
            List<PsiType> bounds = inferenceVariable.getBounds(InferenceBound.LOWER);
            if (InferenceIncorporationPhase.findParameterizationOfTheSameGenericClass(bounds, differentParameterizationProcessor = new Processor<Pair<PsiType, PsiType>>(){

                @Override
                public boolean process(Pair<PsiType, PsiType> pair) {
                    return pair.first == null || pair.second == null || ((PsiType)pair.first).equals(pair.second);
                }
            })) {
                return true;
            }
            List<PsiType> eqBounds = inferenceVariable.getBounds(InferenceBound.EQ);
            for (PsiType lowBound : bounds) {
                if (!FunctionalInterfaceParameterizationUtil.isWildcardParameterized(lowBound)) continue;
                for (PsiType bound : eqBounds) {
                    if (!lowBound.equals(bound)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static PsiType getTargetType(PsiExpression context2) {
        PsiType targetType = PsiTypesUtil.getExpectedTypeByParent(context2);
        if (targetType != null) {
            return targetType;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp(context2.getParent());
        if (parent instanceof PsiExpressionList) {
            PsiExpressionList argumentList;
            PsiElement gParent = parent.getParent();
            if (gParent instanceof PsiAnonymousClass) {
                gParent = gParent.getParent();
            }
            if (gParent instanceof PsiCallExpression && (argumentList = ((PsiCallExpression)gParent).getArgumentList()) != null) {
                MethodCandidateInfo.CurrentCandidateProperties properties2 = MethodCandidateInfo.getCurrentMethod(argumentList);
                if (properties2 != null && properties2.isApplicabilityCheck()) {
                    return InferenceSession.getTypeByMethod(context2, argumentList, properties2.getMethod(), properties2.isVarargs(), properties2.getSubstitutor());
                }
                final JavaResolveResult result2 = ((PsiCallExpression)gParent).resolveMethodGenerics();
                boolean varargs = properties2 != null && properties2.isVarargs() || result2 instanceof MethodCandidateInfo && ((MethodCandidateInfo)result2).isVarargs();
                return InferenceSession.getTypeByMethod(context2, argumentList, result2.getElement(), varargs, PsiResolveHelper.ourGraphGuard.doPreventingRecursion(argumentList.getParent(), false, new Computable<PsiSubstitutor>(){

                    @Override
                    public PsiSubstitutor compute() {
                        return result2.getSubstitutor();
                    }
                }));
            }
        } else {
            if (parent instanceof PsiConditionalExpression) {
                return InferenceSession.getTargetType((PsiExpression)parent);
            }
            if (parent instanceof PsiLambdaExpression) {
                return InferenceSession.getTargetTypeByContainingLambda((PsiLambdaExpression)parent);
            }
            if (parent instanceof PsiReturnStatement) {
                return InferenceSession.getTargetTypeByContainingLambda(PsiTreeUtil.getParentOfType(parent, PsiLambdaExpression.class));
            }
        }
        return null;
    }

    private static PsiType getTargetTypeByContainingLambda(PsiLambdaExpression lambdaExpression) {
        if (lambdaExpression != null) {
            if (PsiUtil.skipParenthesizedExprUp(lambdaExpression.getParent()) instanceof PsiExpressionList) {
                PsiType typeTypeByParentCall = InferenceSession.getTargetType(lambdaExpression);
                return LambdaUtil.getFunctionalInterfaceReturnType(FunctionalInterfaceParameterizationUtil.getGroundTargetType(typeTypeByParentCall, lambdaExpression));
            }
            return LambdaUtil.getFunctionalInterfaceReturnType(lambdaExpression.getFunctionalInterfaceType());
        }
        return null;
    }

    private static PsiType getTypeByMethod(PsiExpression context2, PsiExpressionList argumentList, PsiElement parentMethod, boolean varargs, PsiSubstitutor substitutor) {
        if (parentMethod instanceof PsiMethod) {
            PsiParameter[] parameters = ((PsiMethod)parentMethod).getParameterList().getParameters();
            if (parameters.length == 0) {
                return null;
            }
            PsiExpression[] args = argumentList.getExpressions();
            if (!((PsiMethod)parentMethod).isVarArgs() && parameters.length != args.length) {
                return null;
            }
            PsiElement arg = context2;
            while (arg.getParent() instanceof PsiParenthesizedExpression) {
                arg = arg.getParent();
            }
            int i = ArrayUtilRt.find(args, arg);
            if (i < 0) {
                return null;
            }
            return InferenceSession.getParameterType(parameters, i, substitutor, varargs);
        }
        return null;
    }

    public InferenceVariable getInferenceVariable(PsiType psiType) {
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly(psiType);
        if (psiClass instanceof InferenceVariable) {
            return (InferenceVariable)psiClass;
        }
        return null;
    }

    public boolean isProperType(@Nullable PsiType type) {
        return this.collectDependencies(type, null);
    }

    public boolean collectDependencies(@Nullable PsiType type, final @Nullable Set<InferenceVariable> dependencies) {
        if (type == null) {
            return true;
        }
        Boolean isProper = type.accept(new PsiTypeVisitor<Boolean>(){

            @Override
            @Nullable
            public Boolean visitType(PsiType type) {
                return true;
            }

            @Override
            @Nullable
            public Boolean visitArrayType(PsiArrayType arrayType) {
                return arrayType.getComponentType().accept(this);
            }

            @Override
            @Nullable
            public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                PsiType bound = wildcardType.getBound();
                if (bound == null) {
                    return true;
                }
                return bound.accept(this);
            }

            @Override
            @Nullable
            public Boolean visitClassType(PsiClassType classType) {
                InferenceVariable inferenceVariable = InferenceSession.this.getInferenceVariable(classType);
                if (inferenceVariable != null) {
                    if (dependencies != null) {
                        dependencies.add(inferenceVariable);
                        return true;
                    }
                    return false;
                }
                for (PsiType psiType : classType.getParameters()) {
                    if (psiType.accept(this).booleanValue()) continue;
                    return false;
                }
                return true;
            }
        });
        return dependencies != null ? !dependencies.isEmpty() : isProper;
    }

    public boolean repeatInferencePhases(boolean incorporate) {
        do {
            if (!this.reduceConstraints()) {
                return false;
            }
            if (!incorporate || this.myIncorporationPhase.incorporate()) continue;
            return false;
        } while (incorporate && !this.myIncorporationPhase.isFullyIncorporated() || this.myConstraintIdx < this.myConstraints.size());
        return true;
    }

    private boolean reduceConstraints() {
        ArrayList<ConstraintFormula> newConstraints = new ArrayList<ConstraintFormula>();
        for (int i = this.myConstraintIdx; i < this.myConstraints.size(); ++i) {
            ConstraintFormula constraint = this.myConstraints.get(i);
            if (constraint.reduce(this, newConstraints)) continue;
            return false;
        }
        this.myConstraintIdx = this.myConstraints.size();
        for (ConstraintFormula constraint : newConstraints) {
            this.addConstraint(constraint);
        }
        return true;
    }

    private boolean isThrowable(List<PsiType> upperBounds) {
        boolean commonThrowable = false;
        for (PsiType upperBound : upperBounds) {
            if (upperBound.equalsToText("java.lang.Object") || !this.isProperType(upperBound)) continue;
            if (upperBound.equalsToText("java.lang.Exception") || upperBound.equalsToText("java.lang.Throwable")) {
                commonThrowable = true;
                continue;
            }
            return false;
        }
        return commonThrowable;
    }

    private PsiType substituteNonProperBound(PsiType bound, PsiSubstitutor substitutor) {
        return this.isProperType(bound) ? bound : substitutor.substitute(bound);
    }

    private PsiSubstitutor resolveBounds(Collection<InferenceVariable> inferenceVariables, PsiSubstitutor substitutor) {
        ArrayList<InferenceVariable> allVars = new ArrayList<InferenceVariable>(inferenceVariables);
        while (!allVars.isEmpty()) {
            List<InferenceVariable> vars = InferenceVariablesOrder.resolveOrder(allVars, this);
            if (!this.myIncorporationPhase.hasCaptureConstraints(vars)) {
                Set<PsiTypeParameter> parameters;
                PsiSubstitutor firstSubstitutor = this.resolveSubset(vars, substitutor);
                if (firstSubstitutor != null && GenericsUtil.findTypeParameterWithBoundError((parameters = firstSubstitutor.getSubstitutionMap().keySet()).toArray(new PsiTypeParameter[parameters.size()]), firstSubstitutor, this.myContext, true) != null) {
                    firstSubstitutor = null;
                }
                if (firstSubstitutor != null) {
                    substitutor = firstSubstitutor;
                    allVars.removeAll(vars);
                    continue;
                }
            }
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(this.getManager().getProject());
            PsiTypeParameter[] freshParameters = this.createFreshVariables(vars, substitutor);
            for (int i = 0; i < freshParameters.length; ++i) {
                PsiTypeParameter parameter = freshParameters[i];
                InferenceVariable var = vars.get(i);
                PsiType lub = this.getLowerBound(var, PsiSubstitutor.EMPTY);
                if (lub != PsiType.NULL) {
                    for (PsiClassType upperBoundType : parameter.getExtendsListTypes()) {
                        if (TypeConversionUtil.isAssignable(upperBoundType, lub)) continue;
                        return null;
                    }
                    parameter.putUserData(LOWER_BOUND, lub);
                }
                var.addBound(elementFactory.createType(parameter), InferenceBound.EQ);
            }
            this.myIncorporationPhase.forgetCaptures(vars);
            if (this.repeatInferencePhases(true)) continue;
            return null;
        }
        return substitutor;
    }

    private PsiTypeParameter[] createFreshVariables(List<InferenceVariable> vars, final PsiSubstitutor siteSubstitutor) {
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(this.getManager().getProject());
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        PsiTypeParameter[] yVars = new PsiTypeParameter[vars.size()];
        for (int i = 0; i < vars.size(); ++i) {
            InferenceVariable var = vars.get(i);
            PsiTypeParameter parameter = var.getParameter();
            yVars[i] = elementFactory.createTypeParameterFromText(InferenceSession.getFreshVariableName(var), parameter);
            substitutor = substitutor.put(var, elementFactory.createType(yVars[i]));
        }
        final PsiSubstitutor ySubstitutor = substitutor;
        String classText = "class I<" + StringUtil.join(vars, new Function<InferenceVariable, String>(){

            @Override
            public String fun(InferenceVariable variable) {
                PsiType glb = InferenceSession.this.composeBound(variable, InferenceBound.UPPER, UPPER_BOUND_FUNCTION, ySubstitutor.putAll(siteSubstitutor), true);
                return InferenceSession.getFreshVariableName(variable) + " extends " + glb.getInternalCanonicalText();
            }
        }, ", ") + ">{}";
        PsiFile file = PsiFileFactory.getInstance(this.getManager().getProject()).createFileFromText("inference_dummy.java", JavaFileType.INSTANCE, (CharSequence)classText);
        LOG.assertTrue(file instanceof PsiJavaFile, classText);
        PsiClass[] classes2 = ((PsiJavaFile)file).getClasses();
        LOG.assertTrue(classes2.length == 1, classText);
        return classes2[0].getTypeParameters();
    }

    private static String getFreshVariableName(InferenceVariable var) {
        return var.getName();
    }

    private PsiSubstitutor resolveSubset(Collection<InferenceVariable> vars, PsiSubstitutor substitutor) {
        for (InferenceVariable var : vars) {
            PsiType type;
            PsiType eqBound;
            LOG.assertTrue(var.getInstantiation() == PsiType.NULL);
            PsiTypeParameter typeParameter = var.getParameter();
            if (substitutor.getSubstitutionMap().containsKey(typeParameter) && var.getCallContext() != this.myContext || (eqBound = this.getEqualsBound(var, substitutor)) != PsiType.NULL && eqBound instanceof PsiPrimitiveType) continue;
            PsiType psiType = type = eqBound != PsiType.NULL && (this.myErased || eqBound != null) ? eqBound : this.getLowerBound(var, substitutor);
            if (type == PsiType.NULL) {
                if (var.isThrownBound() && this.isThrowable(var.getBounds(InferenceBound.UPPER))) {
                    type = PsiType.getJavaLangRuntimeException(this.myManager, GlobalSearchScope.allScope(this.myManager.getProject()));
                } else {
                    if (substitutor.getSubstitutionMap().get(typeParameter) != null) continue;
                    type = this.myErased ? null : this.getUpperBound(var, substitutor);
                }
            }
            substitutor = substitutor.put(typeParameter, type);
        }
        return substitutor;
    }

    private PsiType getLowerBound(InferenceVariable var, PsiSubstitutor substitutor) {
        return this.composeBound(var, InferenceBound.LOWER, new Function<Pair<PsiType, PsiType>, PsiType>(){

            @Override
            public PsiType fun(Pair<PsiType, PsiType> pair) {
                return GenericsUtil.getLeastUpperBound((PsiType)pair.first, (PsiType)pair.second, InferenceSession.this.myManager);
            }
        }, substitutor);
    }

    private PsiType getUpperBound(InferenceVariable var, PsiSubstitutor substitutor) {
        return this.composeBound(var, InferenceBound.UPPER, UPPER_BOUND_FUNCTION, substitutor);
    }

    public PsiType getEqualsBound(InferenceVariable var, PsiSubstitutor substitutor) {
        return this.composeBound(var, InferenceBound.EQ, new Function<Pair<PsiType, PsiType>, PsiType>(){

            @Override
            public PsiType fun(Pair<PsiType, PsiType> pair) {
                return (PsiType)pair.first;
            }
        }, substitutor);
    }

    private PsiType composeBound(InferenceVariable variable, InferenceBound boundType, Function<Pair<PsiType, PsiType>, PsiType> fun, PsiSubstitutor substitutor) {
        return this.composeBound(variable, boundType, fun, substitutor, false);
    }

    private PsiType composeBound(InferenceVariable variable, InferenceBound boundType, Function<Pair<PsiType, PsiType>, PsiType> fun, PsiSubstitutor substitutor, boolean includeNonProperBounds) {
        List<PsiType> lowerBounds = variable.getBounds(boundType);
        PsiType lub = PsiType.NULL;
        for (PsiType lowerBound : lowerBounds) {
            lowerBound = this.substituteNonProperBound(lowerBound, substitutor);
            if (!includeNonProperBounds && !this.isProperType(lowerBound)) continue;
            if (lub == PsiType.NULL) {
                lub = lowerBound;
                continue;
            }
            lub = fun.fun(Pair.create(lub, lowerBound));
        }
        return lub;
    }

    public PsiManager getManager() {
        return this.myManager;
    }

    public GlobalSearchScope getScope() {
        return GlobalSearchScope.allScope(this.myManager.getProject());
    }

    public Collection<InferenceVariable> getInferenceVariables() {
        return this.myInferenceVariables;
    }

    public void addConstraint(ConstraintFormula constraint) {
        if (this.myConstraintsCopy.add(constraint)) {
            this.myConstraints.add(constraint);
        }
    }

    private boolean proceedWithAdditionalConstraints(Set<ConstraintFormula> additionalConstraints) {
        PsiSubstitutor siteSubstitutor = this.mySiteSubstitutor;
        while (!additionalConstraints.isEmpty()) {
            Set<ConstraintFormula> subset = this.buildSubset(additionalConstraints);
            LinkedHashSet<InferenceVariable> varsToResolve = new LinkedHashSet<InferenceVariable>();
            for (ConstraintFormula formula : subset) {
                if (!(formula instanceof InputOutputConstraintFormula)) continue;
                this.collectVarsToResolve(varsToResolve, (InputOutputConstraintFormula)formula);
            }
            for (ConstraintFormula formula : subset) {
                if (this.processOneConstraint(formula, siteSubstitutor, varsToResolve)) continue;
                return false;
            }
        }
        return true;
    }

    private void collectVarsToResolve(Set<InferenceVariable> varsToResolve, InputOutputConstraintFormula formula) {
        Set<InferenceVariable> inputVariables = formula.getInputVariables(this);
        if (inputVariables != null) {
            for (InferenceVariable inputVariable : inputVariables) {
                varsToResolve.addAll(inputVariable.getDependencies(this));
            }
            varsToResolve.addAll(inputVariables);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processOneConstraint(ConstraintFormula formula, PsiSubstitutor siteSubstitutor, Set<InferenceVariable> varsToResolve) {
        PsiSubstitutor substitutor;
        InferenceSession session;
        PsiExpression expression;
        PsiCallExpression callExpression;
        if (formula instanceof ExpressionCompatibilityConstraint && (callExpression = PsiTreeUtil.getParentOfType((PsiElement)(expression = ((ExpressionCompatibilityConstraint)formula).getExpression()), PsiCallExpression.class, false)) != null && (session = this.myNestedSessions.get(callExpression)) != null) {
            formula.apply(session.myInferenceSubstitution, true);
            this.collectVarsToResolve(varsToResolve, (InputOutputConstraintFormula)formula);
        }
        if ((substitutor = this.resolveSubset(varsToResolve, siteSubstitutor)) == null) {
            return false;
        }
        if (this.myContext instanceof PsiCallExpression) {
            PsiExpressionList argumentList = ((PsiCallExpression)this.myContext).getArgumentList();
            LOG.assertTrue(argumentList != null);
            MethodCandidateInfo.updateSubstitutor(argumentList, substitutor);
        }
        try {
            formula.apply(substitutor, true);
            this.myConstraints.add(formula);
            if (!this.repeatInferencePhases(true)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            LambdaUtil.ourFunctionTypes.set(null);
        }
        return true;
    }

    private Set<ConstraintFormula> buildSubset(Set<ConstraintFormula> additionalConstraints) {
        Set<InferenceVariable> inputVariables;
        LinkedHashSet<ConstraintFormula> subset = new LinkedHashSet<ConstraintFormula>();
        HashSet<InferenceVariable> outputVariables = new HashSet<InferenceVariable>();
        for (ConstraintFormula constraint : additionalConstraints) {
            Set<InferenceVariable> outputVars;
            if (!(constraint instanceof InputOutputConstraintFormula) || (outputVars = ((InputOutputConstraintFormula)constraint).getOutputVariables(inputVariables = ((InputOutputConstraintFormula)constraint).getInputVariables(this), this)) == null) continue;
            outputVariables.addAll(outputVars);
        }
        for (ConstraintFormula constraint : additionalConstraints) {
            if (constraint instanceof InputOutputConstraintFormula) {
                inputVariables = ((InputOutputConstraintFormula)constraint).getInputVariables(this);
                if (inputVariables != null) {
                    boolean dependsOnOutput = false;
                    for (InferenceVariable inputVariable : inputVariables) {
                        if (dependsOnOutput) break;
                        if (inputVariable.hasInstantiation(this)) continue;
                        Set<InferenceVariable> dependencies = inputVariable.getDependencies(this);
                        dependencies.add(inputVariable);
                        if (!this.hasCapture(inputVariable)) {
                            for (InferenceVariable outputVariable : outputVariables) {
                                if (!ContainerUtil.intersects(outputVariable.getDependencies(this), dependencies)) continue;
                                dependsOnOutput = true;
                                break;
                            }
                        }
                        dependencies.retainAll(outputVariables);
                        if (dependencies.isEmpty()) continue;
                        dependsOnOutput = true;
                        break;
                    }
                    if (dependsOnOutput) continue;
                    subset.add(constraint);
                    continue;
                }
                subset.add(constraint);
                continue;
            }
            subset.add(constraint);
        }
        if (subset.isEmpty()) {
            subset.add(additionalConstraints.iterator().next());
        }
        additionalConstraints.removeAll(subset);
        return subset;
    }

    public PsiSubstitutor collectApplicabilityConstraints(PsiMethodReferenceExpression reference, MethodCandidateInfo candidateInfo, PsiType functionalInterfaceType) {
        block7: {
            boolean isStatic;
            PsiParameter[] parameters;
            PsiParameter[] functionalMethodParameters;
            PsiClass containingClass;
            PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult;
            PsiMethod method;
            boolean varargs;
            MethodSignature signature;
            block6: {
                PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
                PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
                LOG.assertTrue(interfaceMethod != null, this.myContext);
                PsiSubstitutor functionalInterfaceSubstitutor = LambdaUtil.getSubstitutor(interfaceMethod, resolveResult);
                signature = interfaceMethod.getSignature(functionalInterfaceSubstitutor);
                varargs = candidateInfo.isVarargs();
                method = candidateInfo.getElement();
                qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult(reference);
                containingClass = qualifierResolveResult.getContainingClass();
                LOG.assertTrue(containingClass != null, this.myContext);
                functionalMethodParameters = interfaceMethod.getParameterList().getParameters();
                parameters = method.getParameterList().getParameters();
                isStatic = method.hasModifierProperty("static");
                if ((parameters.length != functionalMethodParameters.length || varargs) && (!isStatic || !varargs)) break block6;
                if (method.isConstructor() && PsiUtil.isRawSubstitutor(containingClass, qualifierResolveResult.getSubstitutor())) {
                    this.initBounds(containingClass.getTypeParameters());
                }
                for (int i = 0; i < functionalMethodParameters.length; ++i) {
                    PsiType pType = signature.getParameterTypes()[i];
                    this.addConstraint(new TypeCompatibilityConstraint(this.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters, i, PsiSubstitutor.EMPTY, varargs)), PsiImplUtil.normalizeWildcardTypeByPosition(pType, reference)));
                }
                break block7;
            }
            if ((parameters.length + 1 != functionalMethodParameters.length || varargs) && (isStatic || !varargs || functionalMethodParameters.length <= 0 || !PsiMethodReferenceUtil.hasReceiver(reference, method))) break block7;
            this.initBounds(containingClass.getTypeParameters());
            PsiType pType = signature.getParameterTypes()[0];
            PsiSubstitutor psiSubstitutor = qualifierResolveResult.getSubstitutor();
            if (PsiUtil.isRawSubstitutor(containingClass, qualifierResolveResult.getSubstitutor())) {
                PsiSubstitutor receiverSubstitutor;
                PsiClassType.ClassResolveResult pResult = PsiUtil.resolveGenericsClassInType(pType);
                PsiClass pClass = pResult.getElement();
                PsiSubstitutor psiSubstitutor2 = receiverSubstitutor = pClass != null ? TypeConversionUtil.getClassSubstitutor(containingClass, pClass, pResult.getSubstitutor()) : null;
                if (receiverSubstitutor != null) {
                    if (!method.hasTypeParameters() && (signature.getParameterTypes().length == 1 || PsiUtil.isRawSubstitutor(containingClass, receiverSubstitutor))) {
                        return receiverSubstitutor;
                    }
                    psiSubstitutor = receiverSubstitutor;
                }
            }
            PsiClassType qType = JavaPsiFacade.getElementFactory(method.getProject()).createType(containingClass, psiSubstitutor);
            this.addConstraint(new TypeCompatibilityConstraint(this.substituteWithInferenceVariables(qType), pType));
            for (int i = 0; i < signature.getParameterTypes().length - 1; ++i) {
                PsiType interfaceParamType = signature.getParameterTypes()[i + 1];
                this.addConstraint(new TypeCompatibilityConstraint(this.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters, i, PsiSubstitutor.EMPTY, varargs)), PsiImplUtil.normalizeWildcardTypeByPosition(interfaceParamType, reference)));
            }
        }
        return null;
    }

    public void setErased() {
        this.myErased = true;
    }

    public InferenceVariable getInferenceVariable(PsiTypeParameter parameter) {
        return parameter instanceof InferenceVariable && this.myInferenceVariables.contains(parameter) ? (InferenceVariable)parameter : null;
    }

    public static boolean isMoreSpecific(PsiMethod m1, PsiMethod m2, PsiExpression[] args, PsiElement context2, boolean varargs) {
        ArrayList<PsiTypeParameter> params = new ArrayList<PsiTypeParameter>();
        for (PsiTypeParameter param : PsiUtil.typeParametersIterable(m2)) {
            params.add(param);
        }
        InferenceSession session = new InferenceSession(params.toArray(new PsiTypeParameter[params.size()]), PsiSubstitutor.EMPTY, m2.getManager(), context2);
        PsiParameter[] parameters1 = m1.getParameterList().getParameters();
        PsiParameter[] parameters2 = m2.getParameterList().getParameters();
        if (!varargs) {
            LOG.assertTrue(parameters1.length == parameters2.length);
        }
        int paramsLength = !varargs ? parameters1.length : parameters1.length - 1;
        for (int i = 0; i < paramsLength; ++i) {
            PsiType sType = InferenceSession.getParameterType(parameters1, i, PsiSubstitutor.EMPTY, false);
            PsiType tType = session.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters2, i, PsiSubstitutor.EMPTY, varargs));
            if (session.isProperType(sType) && session.isProperType(tType)) {
                if (TypeConversionUtil.isAssignable(tType, sType)) continue;
                return false;
            }
            if (LambdaUtil.isFunctionalType(sType) && LambdaUtil.isFunctionalType(tType) && !InferenceSession.relates(sType, tType)) {
                if (InferenceSession.isFunctionalTypeMoreSpecific(sType, tType, session, args)) continue;
                return false;
            }
            session.addConstraint(new StrictSubtypingConstraint(tType, sType));
        }
        if (varargs) {
            PsiType sType = InferenceSession.getParameterType(parameters1, paramsLength, PsiSubstitutor.EMPTY, true);
            PsiType tType = session.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters2, paramsLength, PsiSubstitutor.EMPTY, true));
            session.addConstraint(new StrictSubtypingConstraint(tType, sType));
        }
        return session.repeatInferencePhases(true);
    }

    public static boolean isFunctionalTypeMoreSpecificOnExpression(PsiType sType, PsiType tType, PsiExpression arg) {
        return InferenceSession.isFunctionalTypeMoreSpecific(sType, tType, null, arg);
    }

    private static boolean isFunctionalTypeMoreSpecific(PsiType sType, PsiType tType, @Nullable InferenceSession session, PsiExpression ... args) {
        PsiType capturedSType = sType;
        PsiClassType.ClassResolveResult sResult = PsiUtil.resolveGenericsClassInType(capturedSType);
        PsiMethod sInterfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(sResult);
        LOG.assertTrue(sInterfaceMethod != null);
        PsiSubstitutor sSubstitutor = LambdaUtil.getSubstitutor(sInterfaceMethod, sResult);
        PsiClassType.ClassResolveResult tResult = PsiUtil.resolveGenericsClassInType(tType);
        PsiMethod tInterfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(tResult);
        LOG.assertTrue(tInterfaceMethod != null);
        PsiSubstitutor tSubstitutor = LambdaUtil.getSubstitutor(tInterfaceMethod, tResult);
        for (PsiExpression arg : args) {
            if (InferenceSession.argConstraints(arg, session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor)) continue;
            return false;
        }
        return true;
    }

    protected static boolean argConstraints(PsiExpression arg, @Nullable InferenceSession session, PsiMethod sInterfaceMethod, PsiSubstitutor sSubstitutor, PsiMethod tInterfaceMethod, PsiSubstitutor tSubstitutor) {
        if (arg instanceof PsiLambdaExpression && ((PsiLambdaExpression)arg).hasFormalParameterTypes()) {
            PsiType sReturnType = sSubstitutor.substitute(sInterfaceMethod.getReturnType());
            PsiType tReturnType = tSubstitutor.substitute(tInterfaceMethod.getReturnType());
            if (tReturnType == PsiType.VOID) {
                return true;
            }
            List<PsiExpression> returnExpressions = LambdaUtil.getReturnExpressions((PsiLambdaExpression)arg);
            if (LambdaUtil.isFunctionalType(sReturnType) && LambdaUtil.isFunctionalType(tReturnType) && !TypeConversionUtil.isAssignable(TypeConversionUtil.erasure(sReturnType), TypeConversionUtil.erasure(tReturnType)) && !TypeConversionUtil.isAssignable(TypeConversionUtil.erasure(tReturnType), TypeConversionUtil.erasure(sReturnType))) {
                if (!InferenceSession.isFunctionalTypeMoreSpecific(sReturnType, tReturnType, session, returnExpressions.toArray(new PsiExpression[returnExpressions.size()]))) {
                    return false;
                }
            } else {
                boolean tPrimitive;
                boolean sPrimitive = sReturnType instanceof PsiPrimitiveType && sReturnType != PsiType.VOID;
                boolean bl = tPrimitive = tReturnType instanceof PsiPrimitiveType && tReturnType != PsiType.VOID;
                if (sPrimitive ^ tPrimitive) {
                    for (PsiExpression returnExpression : returnExpressions) {
                        if (PsiPolyExpressionUtil.isPolyExpression(returnExpression)) continue;
                        PsiType returnExpressionType = returnExpression.getType();
                        if (!(sPrimitive ? !(returnExpressionType instanceof PsiPrimitiveType) : !(returnExpressionType instanceof PsiClassType))) continue;
                        return false;
                    }
                    return true;
                }
                if (session != null) {
                    session.addConstraint(new StrictSubtypingConstraint(tReturnType, sReturnType));
                    return true;
                }
                return sReturnType != null && tReturnType != null && TypeConversionUtil.isAssignable(tReturnType, sReturnType);
            }
        }
        if (arg instanceof PsiMethodReferenceExpression && ((PsiMethodReferenceExpression)arg).isExact()) {
            boolean tPrimitive;
            PsiParameter[] sParameters = sInterfaceMethod.getParameterList().getParameters();
            PsiParameter[] tParameters = tInterfaceMethod.getParameterList().getParameters();
            if (session != null) {
                LOG.assertTrue(sParameters.length == tParameters.length);
                for (int i = 0; i < tParameters.length; ++i) {
                    session.addConstraint(new TypeEqualityConstraint(tSubstitutor.substitute(tParameters[i].getType()), sSubstitutor.substitute(sParameters[i].getType())));
                }
            }
            PsiType sReturnType = sSubstitutor.substitute(sInterfaceMethod.getReturnType());
            PsiType tReturnType = tSubstitutor.substitute(tInterfaceMethod.getReturnType());
            if (tReturnType == PsiType.VOID) {
                return true;
            }
            boolean sPrimitive = sReturnType instanceof PsiPrimitiveType && sReturnType != PsiType.VOID;
            boolean bl = tPrimitive = tReturnType instanceof PsiPrimitiveType && tReturnType != PsiType.VOID;
            if (sPrimitive ^ tPrimitive) {
                PsiMember member = ((PsiMethodReferenceExpression)arg).getPotentiallyApplicableMember();
                LOG.assertTrue(member != null);
                if (member instanceof PsiMethod) {
                    PsiType methodReturnType = ((PsiMethod)member).getReturnType();
                    if (sPrimitive && methodReturnType instanceof PsiPrimitiveType && methodReturnType != PsiType.VOID || tPrimitive && methodReturnType instanceof PsiClassType) {
                        return true;
                    }
                }
                return false;
            }
            if (session != null) {
                session.addConstraint(new StrictSubtypingConstraint(tReturnType, sReturnType));
                return true;
            }
            return sReturnType != null && tReturnType != null && TypeConversionUtil.isAssignable(tReturnType, sReturnType);
        }
        if (arg instanceof PsiParenthesizedExpression) {
            return InferenceSession.argConstraints(((PsiParenthesizedExpression)arg).getExpression(), session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor);
        }
        if (arg instanceof PsiConditionalExpression) {
            PsiExpression thenExpression = ((PsiConditionalExpression)arg).getThenExpression();
            PsiExpression elseExpression = ((PsiConditionalExpression)arg).getElseExpression();
            return InferenceSession.argConstraints(thenExpression, session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor) && InferenceSession.argConstraints(elseExpression, session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor);
        }
        return false;
    }

    private static boolean relates(PsiType sType, PsiType tType) {
        PsiType sTypeErasure;
        PsiType erasedType = TypeConversionUtil.erasure(tType);
        LOG.assertTrue(erasedType != null);
        if (sType instanceof PsiIntersectionType) {
            boolean superRelation = true;
            boolean subRelation = false;
            for (PsiType sConjunct : ((PsiIntersectionType)sType).getConjuncts()) {
                PsiType sConjunctErasure = TypeConversionUtil.erasure(sConjunct);
                if (sConjunctErasure == null) continue;
                superRelation &= TypeConversionUtil.isAssignable(sConjunctErasure, erasedType);
                subRelation |= TypeConversionUtil.isAssignable(erasedType, sConjunctErasure);
            }
            return superRelation || subRelation;
        }
        if (sType instanceof PsiClassType && (sTypeErasure = TypeConversionUtil.erasure(sType)) != null) {
            return TypeConversionUtil.isAssignable(sTypeErasure, erasedType) || TypeConversionUtil.isAssignable(erasedType, sTypeErasure);
        }
        return false;
    }

    public void collectCaptureDependencies(InferenceVariable inferenceVariable, Set<InferenceVariable> dependencies) {
        this.myIncorporationPhase.collectCaptureDependencies(inferenceVariable, dependencies);
    }

    public boolean hasCapture(InferenceVariable inferenceVariable) {
        return this.myIncorporationPhase.hasCaptureConstraints(Arrays.asList(inferenceVariable));
    }

    public static boolean wasUncheckedConversionPerformed(PsiElement call) {
        Boolean erased = call.getUserData(ERASED);
        return erased != null && erased != false;
    }

    public PsiElement getContext() {
        return this.myContext;
    }

    public void propagateVariables(Collection<InferenceVariable> variables) {
        this.myInferenceVariables.addAll(variables);
    }

    public PsiType substituteWithInferenceVariables(PsiType type) {
        return this.myInferenceSubstitution.substitute(type);
    }

    public InferenceSession findNestedCallSession(PsiExpression arg) {
        InferenceSession session = this.myNestedSessions.get(PsiTreeUtil.getParentOfType((PsiElement)arg, PsiCallExpression.class));
        if (session == null) {
            session = this;
        }
        return session;
    }

    public PsiType startWithFreshVars(PsiType type) {
        PsiSubstitutor s = PsiSubstitutor.EMPTY;
        for (InferenceVariable variable : this.myInferenceVariables) {
            s = s.put(variable, JavaPsiFacade.getElementFactory(variable.getProject()).createType(variable.getParameter()));
        }
        return s.substitute(type);
    }
}

