/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.diff;

import com.intellij.util.diff.FilesTooBigForDiffException;
import com.intellij.util.diff.LCSBuilder;
import java.util.BitSet;

final class LinkedDiffPaths {
    private int[] mySteps = new int[10];
    private int[] myPrevSteps = new int[10];
    private int myPosition = 0;
    private final int myMaxX;
    private final int myMaxY;
    private int myCornerIndex = -1;

    public LinkedDiffPaths(int maxX, int maxY) {
        this.myMaxX = maxX;
        this.myMaxY = maxY;
    }

    public void applyChanges(final int start1, final int start2, final BitSet changes1, final BitSet changes2) {
        this.decodePath(new LCSBuilder(){
            int x;
            int y;
            {
                this.x = LinkedDiffPaths.this.myMaxX;
                this.y = LinkedDiffPaths.this.myMaxY;
            }

            @Override
            public void addEqual(int length) {
                this.x -= length;
                this.y -= length;
            }

            @Override
            public void addChange(int first, int second) {
                if (first > 0) {
                    changes1.set(start1 + this.x - first, start1 + this.x);
                    this.x -= first;
                }
                if (second > 0) {
                    changes2.set(start2 + this.y - second, start2 + this.y);
                    this.y -= second;
                }
            }
        });
    }

    public <Builder extends LCSBuilder> Builder decodePath(Builder builder) {
        Decoder decoder = new Decoder(this.getXSize(), this.getYSize(), builder);
        int index = this.myCornerIndex;
        while (index != -1) {
            int encodedStep = this.mySteps[index];
            decoder.decode(encodedStep);
            index = this.myPrevSteps[index];
        }
        decoder.beforeFinish();
        return builder;
    }

    public int getXSize() {
        return this.myMaxX;
    }

    public int getYSize() {
        return this.myMaxY;
    }

    public int encodeStep(int x, int y, int diagLength, boolean afterVertical, int prevIndex) throws FilesTooBigForDiffException {
        int encodedPath = diagLength;
        if (afterVertical) {
            encodedPath |= Integer.MIN_VALUE;
        }
        int position = this.incPosition();
        this.myPrevSteps[position] = prevIndex;
        this.mySteps[position] = encodedPath;
        if (x == this.myMaxX - 1 && y == this.myMaxY - 1) {
            this.myCornerIndex = position;
        }
        return position;
    }

    private int incPosition() throws FilesTooBigForDiffException {
        int length = this.myPrevSteps.length;
        if (this.myPosition == length - 1) {
            this.myPrevSteps = this.copy(length, this.myPrevSteps);
            this.mySteps = this.copy(length, this.mySteps);
        }
        ++this.myPosition;
        return this.myPosition;
    }

    private int[] copy(int length, int[] prevArray) throws FilesTooBigForDiffException {
        if (length * 2 >= FilesTooBigForDiffException.MAX_BUFFER_LEN) {
            throw new FilesTooBigForDiffException(FilesTooBigForDiffException.MAX_BUFFER_LEN);
        }
        int[] array = new int[length * 2];
        System.arraycopy(prevArray, 0, array, 0, length);
        return array;
    }

    class Decoder {
        private final LCSBuilder builder;
        private int x;
        private int y;
        private int dx = 0;
        private int dy = 0;

        public Decoder(int x, int y, LCSBuilder builder) {
            this.x = x;
            this.y = y;
            this.builder = builder;
        }

        public void decode(int encodedStep) {
            boolean verticalStep;
            int diagDist = encodedStep & Integer.MAX_VALUE;
            if (diagDist != 0) {
                if (this.dx != 0 || this.dy != 0) {
                    this.builder.addChange(this.dx, this.dy);
                    this.dx = 0;
                    this.dy = 0;
                }
                this.builder.addEqual(diagDist);
            }
            this.x -= diagDist;
            this.y -= diagDist;
            boolean bl = verticalStep = (encodedStep & Integer.MIN_VALUE) != 0;
            if (verticalStep) {
                --this.y;
                ++this.dy;
            } else {
                --this.x;
                ++this.dx;
            }
        }

        public void beforeFinish() {
            this.dx += this.x;
            this.dy += this.y;
            if (this.dx != 0 || this.dy != 0) {
                this.builder.addChange(this.dx, this.dy);
            }
        }
    }
}

