/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.diff;

import gnu.trove.TIntIntHashMap;

public class UniqueLCS {
    private final int[] myFirst;
    private final int[] mySecond;
    private final int myStart1;
    private final int myStart2;
    private final int myCount1;
    private final int myCount2;

    public UniqueLCS(int[] first, int[] second, int start1, int count1, int start2, int count2) {
        this.myFirst = first;
        this.mySecond = second;
        this.myStart1 = start1;
        this.myStart2 = start2;
        this.myCount1 = count1;
        this.myCount2 = count2;
    }

    public int[][] execute() {
        TIntIntHashMap map = new TIntIntHashMap(this.myCount1 + this.myCount2);
        int[] match = new int[this.myCount1];
        for (int i = 0; i < this.myCount1; ++i) {
            int index = this.myStart1 + i;
            int val = map.get(this.myFirst[index]);
            if (val == -1) continue;
            if (val == 0) {
                map.put(this.myFirst[index], i + 1);
                continue;
            }
            map.put(this.myFirst[index], -1);
        }
        int count = 0;
        for (int i = 0; i < this.myCount2; ++i) {
            int index = this.myStart2 + i;
            int val = map.get(this.mySecond[index]);
            if (val == 0 || val == -1) continue;
            if (match[val - 1] == 0) {
                match[val - 1] = i + 1;
                ++count;
                continue;
            }
            match[val - 1] = 0;
            map.put(this.mySecond[index], -1);
            --count;
        }
        if (count == 0) {
            return null;
        }
        int[] sequence = new int[count];
        int[] lastElement = new int[count];
        int[] predecessor = new int[this.myCount1];
        int length = 0;
        for (int i = 0; i < this.myCount1; ++i) {
            int j;
            if (match[i] == 0 || (j = UniqueLCS.binarySearch(sequence, match[i], length)) != length && match[i] >= sequence[j]) continue;
            sequence[j] = match[i];
            lastElement[j] = i;
            int n = predecessor[i] = j > 0 ? lastElement[j - 1] : -1;
            if (j != length) continue;
            ++length;
        }
        int[][] ret = new int[][]{new int[length], new int[length]};
        int i = length - 1;
        int curr = lastElement[length - 1];
        while (curr != -1) {
            ret[0][i] = curr;
            ret[1][i] = match[curr] - 1;
            --i;
            curr = predecessor[curr];
        }
        return ret;
    }

    private static int binarySearch(int[] sequence, int val, int length) {
        int left = -1;
        int right = length;
        while (right - left > 1) {
            int middle = (left + right) / 2;
            if (sequence[middle] > val) {
                right = middle;
                continue;
            }
            left = middle;
        }
        return left + 1;
    }
}

