/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.TObjectHash;
import gnu.trove.TObjectHashIterator;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectProcedure;
import gnu.trove.ToObjectArrayProcedure;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class THashSet<E>
extends TObjectHash<E>
implements Set<E> {
    public THashSet() {
    }

    public THashSet(TObjectHashingStrategy<E> strategy) {
        super(strategy);
    }

    public THashSet(int initialCapacity) {
        super(initialCapacity);
    }

    public THashSet(Collection<? extends E> collection) {
        this(collection.size());
        this.addAll(collection);
    }

    @Override
    public boolean add(E obj) {
        int index = this.insertionIndex(obj);
        if (index < 0) {
            return false;
        }
        Object old = this._set[index];
        this._set[index] = obj;
        this.postInsertHook(old == null);
        return true;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Set)) {
            return false;
        }
        Set that = (Set)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.containsAll(that);
    }

    @Override
    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEach(p);
        return p.getHashCode();
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        Object[] oldSet = this._set;
        this._set = new Object[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldSet[i] == null || oldSet[i] == REMOVED) continue;
            Object o = oldSet[i];
            int index = this.insertionIndex(o);
            if (index < 0) {
                this.throwObjectContractViolation(this._set[-index - 1], o);
            }
            this._set[index] = o;
        }
    }

    @Override
    public Object[] toArray() {
        Object[] result2 = new Object[this.size()];
        this.forEach(new ToObjectArrayProcedure<Object>(result2));
        return result2;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        T[] result2 = a;
        Iterator<E> it = this.iterator();
        for (int i = 0; i < size; ++i) {
            result2[i] = it.next();
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public void clear() {
        super.clear();
        Object[] set = this._set;
        int i = set.length;
        while (i-- > 0) {
            set[i] = null;
        }
    }

    @Override
    public boolean remove(Object obj) {
        int index = this.index(obj);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new TObjectHashIterator(this);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object element : collection) {
            if (this.contains(element)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        int size = collection.size();
        this.ensureCapacity(size);
        Iterator<E> it = collection.iterator();
        boolean changed = false;
        while (size-- > 0) {
            if (!this.add(it.next())) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        int size = collection.size();
        Iterator<?> it = collection.iterator();
        boolean changed = false;
        while (size-- > 0) {
            if (!this.remove(it.next())) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        int size = this.size();
        Iterator<E> it = this.iterator();
        boolean changed = false;
        while (size-- > 0) {
            if (collection.contains(it.next())) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    private final class HashProcedure
    implements TObjectProcedure<E> {
        private int h;

        HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        @Override
        public final boolean execute(E key) {
            this.h += THashSet.this._hashingStrategy.computeHashCode(key);
            return true;
        }
    }
}

