/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.inline;

import com.google.common.base.Objects;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.inline.InlineCodegenUtil;
import org.jetbrains.jet.codegen.inline.InlinePackage;
import org.jetbrains.jet.codegen.inline.MaxLocalsCalculator;
import org.jetbrains.jet.codegen.inline.TryBlockCluster;
import org.jetbrains.jet.codegen.inline.TryCatchBlockNodeInfo;
import org.jetbrains.jet.codegen.inline.TryCatchBlockNodePosition;
import org.jetbrains.jet.codegen.inline.TryCatchPosition;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;

public class InternalFinallyBlockInliner {
    @NotNull
    private final MethodNode inlineFun;
    private final List<TryCatchBlockNodeInfo> inlineFunTryBlockInfo;
    private final ListMultimap<LabelNode, TryCatchBlockNodeInfo> tryBlockStarts;
    private final ListMultimap<LabelNode, TryCatchBlockNodeInfo> tryBlockEnds;

    public static void processInlineFunFinallyBlocks(@NotNull MethodNode inlineFun, int lambdaTryCatchBlockNodes) {
        if (inlineFun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inlineFun", "org/jetbrains/jet/codegen/inline/InternalFinallyBlockInliner", "processInlineFunFinallyBlocks"));
        }
        int index = 0;
        ArrayList<TryCatchBlockNodeInfo> inlineFunTryBlockInfo = new ArrayList<TryCatchBlockNodeInfo>();
        for (TryCatchBlockNode block : inlineFun.tryCatchBlocks) {
            inlineFunTryBlockInfo.add(new TryCatchBlockNodeInfo(block, index++ < lambdaTryCatchBlockNodes));
        }
        if (InternalFinallyBlockInliner.hasFinallyBlocks(inlineFunTryBlockInfo)) {
            new InternalFinallyBlockInliner(inlineFun, inlineFunTryBlockInfo).processInlineFunFinallyBlocks();
        }
    }

    private InternalFinallyBlockInliner(@NotNull MethodNode inlineFun, List<TryCatchBlockNodeInfo> inlineFunTryBlockInfo) {
        if (inlineFun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inlineFun", "org/jetbrains/jet/codegen/inline/InternalFinallyBlockInliner", "<init>"));
        }
        this.tryBlockStarts = LinkedListMultimap.create();
        this.tryBlockEnds = LinkedListMultimap.create();
        this.inlineFun = inlineFun;
        this.inlineFunTryBlockInfo = inlineFunTryBlockInfo;
    }

    private int initAndGetVarIndexForNonLocalReturnValue() {
        this.mapLabelsToTryCatchBlocks();
        MaxLocalsCalculator tempCalcNode = new MaxLocalsCalculator(327680, this.inlineFun.access, this.inlineFun.desc, null);
        this.inlineFun.accept(tempCalcNode);
        return tempCalcNode.getMaxLocals();
    }

    private void processInlineFunFinallyBlocks() {
        int nextTempNonLocalVarIndex = this.initAndGetVarIndexForNonLocalReturnValue();
        Stack<TryCatchBlockNodeInfo> coveringTryCatchBlocks = new Stack<TryCatchBlockNodeInfo>();
        InsnList instructions = this.inlineFun.instructions;
        AbstractInsnNode curIns = instructions.getLast();
        while (curIns != null) {
            this.updateCoveringTryBlocks(coveringTryCatchBlocks, curIns);
            if (!InlineCodegenUtil.isReturnOpcode(curIns.getOpcode()) || !InlineCodegenUtil.isMarkedReturn(curIns)) {
                curIns = curIns.getPrevious();
                continue;
            }
            AbstractInsnNode instrInsertFinallyBefore = curIns.getPrevious();
            AbstractInsnNode nextPrev = instrInsertFinallyBefore.getPrevious();
            Type nonLocalReturnType = InlineCodegenUtil.getReturnType(curIns.getOpcode());
            List<TryBlockCluster<TryCatchBlockNodeInfo>> clusters = InlinePackage.doClustering(coveringTryCatchBlocks);
            ListIterator<TryBlockCluster<TryCatchBlockNodeInfo>> tryCatchBlockIterator = clusters.listIterator(clusters.size());
            while (tryCatchBlockIterator.hasPrevious()) {
                TryBlockCluster<TryCatchBlockNodeInfo> originalFinallyCluster = tryCatchBlockIterator.previous();
                List<TryCatchBlockNodeInfo> clusterBlocks = originalFinallyCluster.getBlocks();
                TryCatchBlockNodeInfo originalFinallyBlock = clusterBlocks.get(0);
                FinallyBlockInfo finallyInfo = this.findFinallyBlockBody(originalFinallyBlock, this.inlineFunTryBlockInfo);
                if (finallyInfo == null) continue;
                instructions.resetLabels();
                List<TryCatchBlockNodePosition> tryCatchBlockInlinedInFinally = this.findTryCatchBlocksInlinedInFinally(finallyInfo);
                Set<LabelNode> labelsInsideFinally = InternalFinallyBlockInliner.rememberOriginalLabelNodes(finallyInfo);
                MethodNode finallyBlockCopy = InlineCodegenUtil.createEmptyMethodNode();
                Label newFinallyStart = new Label();
                Label newFinallyEnd = new Label();
                Label insertedBlockEnd = new Label();
                if (nonLocalReturnType != Type.VOID_TYPE) {
                    finallyBlockCopy.visitVarInsn(nonLocalReturnType.getOpcode(54), nextTempNonLocalVarIndex);
                }
                finallyBlockCopy.visitLabel(newFinallyStart);
                for (AbstractInsnNode currentIns = finallyInfo.startIns; currentIns != finallyInfo.endInsExclusive; currentIns = currentIns.getNext()) {
                    boolean isInsOrJumpInsideFinally;
                    boolean bl = isInsOrJumpInsideFinally = !(currentIns instanceof JumpInsnNode) || labelsInsideFinally.contains(((JumpInsnNode)currentIns).label);
                    if (isInsOrJumpInsideFinally) {
                        currentIns.accept(finallyBlockCopy);
                        continue;
                    }
                    finallyBlockCopy.instructions.add(new JumpInsnNode(currentIns.getOpcode(), ((JumpInsnNode)currentIns).label));
                }
                finallyBlockCopy.visitLabel(newFinallyEnd);
                if (nonLocalReturnType != Type.VOID_TYPE) {
                    finallyBlockCopy.visitVarInsn(nonLocalReturnType.getOpcode(21), nextTempNonLocalVarIndex);
                    nextTempNonLocalVarIndex += nonLocalReturnType.getSize();
                }
                finallyBlockCopy.visitLabel(insertedBlockEnd);
                InlineCodegenUtil.insertNodeBefore(finallyBlockCopy, this.inlineFun, instrInsertFinallyBefore);
                nextPrev = this.updateExceptionTable(coveringTryCatchBlocks, nextPrev, clusterBlocks, newFinallyStart, newFinallyEnd, tryCatchBlockInlinedInFinally, labelsInsideFinally, (LabelNode)insertedBlockEnd.info);
            }
            curIns = nextPrev;
        }
        this.inlineFun.tryCatchBlocks.clear();
        for (TryCatchBlockNodeInfo info : this.inlineFunTryBlockInfo) {
            this.inlineFun.tryCatchBlocks.add(info.getNode());
        }
    }

    @NotNull
    private static Set<LabelNode> rememberOriginalLabelNodes(@NotNull FinallyBlockInfo finallyInfo) {
        if (finallyInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finallyInfo", "org/jetbrains/jet/codegen/inline/InternalFinallyBlockInliner", "rememberOriginalLabelNodes"));
        }
        HashSet<LabelNode> labelsInsideFinally = new HashSet<LabelNode>();
        for (AbstractInsnNode currentIns = finallyInfo.startIns; currentIns != finallyInfo.endInsExclusive; currentIns = currentIns.getNext()) {
            if (!(currentIns instanceof LabelNode)) continue;
            labelsInsideFinally.add((LabelNode)currentIns);
        }
        HashSet<LabelNode> hashSet = labelsInsideFinally;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/inline/InternalFinallyBlockInliner", "rememberOriginalLabelNodes"));
        }
        return hashSet;
    }

    @Nullable
    private AbstractInsnNode updateExceptionTable(@NotNull Stack<TryCatchBlockNodeInfo> coveringTryBlocks, @Nullable AbstractInsnNode nextPrev, @NotNull List<TryCatchBlockNodeInfo> updatingClusterBlocks, @NotNull Label newFinallyStart, @NotNull Label newFinallyEnd, @NotNull List<TryCatchBlockNodePosition> tryCatchBlockPresentInFinally, @NotNull Set<LabelNode> labelsInsideFinally, @NotNull LabelNode insertedBlockEnd) {
        TryBlockCluster singleCluster;
        if (coveringTryBlocks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coveringTryBlocks", "org/jetbrains/jet/codegen/inline/InternalFinallyBlockInliner", "updateExceptionTable"));
        }
        if (updatingClusterBlocks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updatingClusterBlocks", "org/jetbrains/jet/codegen/inline/InternalFinallyBlockInliner", "updateExceptionTable"));
        }
        if (newFinallyStart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newFinallyStart", "org/jetbrains/jet/codegen/inline/InternalFinallyBlockInliner", "updateExceptionTable"));
        }
        if (newFinallyEnd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newFinallyEnd", "org/jetbrains/jet/codegen/inline/InternalFinallyBlockInliner", "updateExceptionTable"));
        }
        if (tryCatchBlockPresentInFinally == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tryCatchBlockPresentInFinally", "org/jetbrains/jet/codegen/inline/InternalFinallyBlockInliner", "updateExceptionTable"));
        }
        if (labelsInsideFinally == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelsInsideFinally", "org/jetbrains/jet/codegen/inline/InternalFinallyBlockInliner", "updateExceptionTable"));
        }
        if (insertedBlockEnd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insertedBlockEnd", "org/jetbrains/jet/codegen/inline/InternalFinallyBlockInliner", "updateExceptionTable"));
        }
        List<TryBlockCluster<TryCatchBlockNodePosition>> clusters = InlinePackage.doClustering(tryCatchBlockPresentInFinally);
        HashMap<LabelNode, TryBlockCluster<TryCatchBlockNodePosition>> handler2Cluster = new HashMap<LabelNode, TryBlockCluster<TryCatchBlockNodePosition>>();
        for (TryBlockCluster<TryCatchBlockNodePosition> cluster : clusters) {
            TryCatchBlockNodePosition defaultHandler;
            List<TryCatchBlockNodePosition> clusterBlocks = cluster.getBlocks();
            TryCatchBlockNodePosition block0 = clusterBlocks.get(0);
            TryCatchPosition clusterPosition = block0.getPosition();
            if (clusterPosition == TryCatchPosition.INNER) {
                for (TryCatchBlockNodePosition position : clusterBlocks) {
                    assert (clusterPosition == position.getPosition()) : "Wrong inner tryCatchBlock structure";
                    TryCatchBlockNode tryCatchBlockNode = position.getNodeInfo().getNode();
                    assert (this.inlineFun.instructions.indexOf(tryCatchBlockNode.start) <= this.inlineFun.instructions.indexOf(tryCatchBlockNode.end));
                    TryCatchBlockNode additionalTryCatchBlock = new TryCatchBlockNode((LabelNode)tryCatchBlockNode.start.getLabel().info, (LabelNode)tryCatchBlockNode.end.getLabel().info, InternalFinallyBlockInliner.getNewOrOldLabel(tryCatchBlockNode.handler, labelsInsideFinally), tryCatchBlockNode.type);
                    assert (this.inlineFun.instructions.indexOf(additionalTryCatchBlock.start) <= this.inlineFun.instructions.indexOf(additionalTryCatchBlock.end));
                    TryCatchBlockNodeInfo newInfo = new TryCatchBlockNodeInfo(additionalTryCatchBlock, true);
                    this.tryBlockStarts.put(newInfo.getStartLabel(), newInfo);
                    this.tryBlockEnds.put(newInfo.getEndLabel(), newInfo);
                    this.inlineFunTryBlockInfo.add(newInfo);
                }
                continue;
            }
            if (clusterPosition == TryCatchPosition.END) {
                defaultHandler = cluster.getDefaultHandler();
                assert (defaultHandler != null) : "Default handler should be present";
                handler2Cluster.put(defaultHandler.getHandler(), cluster);
                continue;
            }
            assert (clusterPosition == TryCatchPosition.START);
            defaultHandler = cluster.getDefaultHandler();
            assert (defaultHandler != null) : "Default handler should be present";
            TryBlockCluster endCluster = (TryBlockCluster)handler2Cluster.remove(defaultHandler.getHandler());
            assert (endCluster != null) : "Could find start cluster for  " + clusterPosition;
            Iterator<TryCatchBlockNodePosition> startBlockPositions = clusterBlocks.iterator();
            for (TryCatchBlockNodePosition endBlockPosition : endCluster.getBlocks()) {
                TryCatchBlockNodeInfo startNode = startBlockPositions.next().getNodeInfo();
                TryCatchBlockNodeInfo endNode = endBlockPosition.getNodeInfo();
                assert (Objects.equal(startNode.getType(), endNode.getType())) : "Different handler types : " + startNode.getType() + " " + endNode.getType();
                this.patchTryBlocks((LabelNode)startNode.getStartLabel().getLabel().info, endNode, false);
            }
        }
        if (handler2Cluster.size() == 1 && ((TryCatchBlockNodePosition)(singleCluster = (TryBlockCluster)handler2Cluster.values().iterator().next()).getBlocks().get(0)).getPosition() == TryCatchPosition.END) {
            for (TryCatchBlockNodePosition endBlockPosition : singleCluster.getBlocks()) {
                TryCatchBlockNodeInfo endNode = endBlockPosition.getNodeInfo();
                this.patchTryBlocks((LabelNode)insertedBlockEnd.getLabel().info, endNode, true);
            }
            handler2Cluster.clear();
        }
        assert (handler2Cluster.isEmpty()) : "Unmatched clusters " + handler2Cluster.size();
        for (TryCatchBlockNodeInfo block : updatingClusterBlocks) {
            LabelNode oldStartNode = block.getNode().start;
            this.tryBlockStarts.remove(oldStartNode, block);
            block.getNode().start = (LabelNode)newFinallyEnd.info;
            TryCatchBlockNode additionalTryCatchBlock = new TryCatchBlockNode(oldStartNode, (LabelNode)newFinallyStart.info, block.getNode().handler, block.getNode().type);
            TryCatchBlockNodeInfo newInfo = new TryCatchBlockNodeInfo(additionalTryCatchBlock, false);
            this.tryBlockStarts.put(additionalTryCatchBlock.start, newInfo);
            this.tryBlockEnds.put(additionalTryCatchBlock.end, newInfo);
            this.inlineFunTryBlockInfo.add(newInfo);
            nextPrev = additionalTryCatchBlock.end;
            coveringTryBlocks.pop();
        }
        this.sortTryCatchBlocks(this.inlineFunTryBlockInfo);
        return nextPrev;
    }

    private void patchTryBlocks(@NotNull LabelNode newStartLabelNode, @NotNull TryCatchBlockNodeInfo endNode, boolean sort) {
        if (newStartLabelNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newStartLabelNode", "org/jetbrains/jet/codegen/inline/InternalFinallyBlockInliner", "patchTryBlocks"));
        }
        if (endNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endNode", "org/jetbrains/jet/codegen/inline/InternalFinallyBlockInliner", "patchTryBlocks"));
        }
        LabelNode oldStart = endNode.getStartLabel();
        endNode.getNode().start = newStartLabelNode;
        this.tryBlockStarts.remove(oldStart, endNode);
        this.tryBlockStarts.put(endNode.getNode().start, endNode);
        TryCatchBlockNode endTryBlock = endNode.getNode();
        TryCatchBlockNode additionalTryCatchBlock = new TryCatchBlockNode(oldStart, (LabelNode)endTryBlock.end.getLabel().info, endTryBlock.handler, endTryBlock.type);
        TryCatchBlockNodeInfo newInfo = new TryCatchBlockNodeInfo(additionalTryCatchBlock, endNode.getOnlyCopyNotProcess());
        this.tryBlockStarts.put(newInfo.getStartLabel(), newInfo);
        this.tryBlockEnds.put(newInfo.getEndLabel(), newInfo);
        this.inlineFunTryBlockInfo.add(newInfo);
    }

    private static LabelNode getNewOrOldLabel(LabelNode oldHandler, @NotNull Set<LabelNode> labelsInsideFinally) {
        if (labelsInsideFinally == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelsInsideFinally", "org/jetbrains/jet/codegen/inline/InternalFinallyBlockInliner", "getNewOrOldLabel"));
        }
        if (labelsInsideFinally.contains(oldHandler)) {
            return (LabelNode)oldHandler.getLabel().info;
        }
        return oldHandler;
    }

    private void updateCoveringTryBlocks(Stack<TryCatchBlockNodeInfo> coveringTryBlocks, AbstractInsnNode curIns) {
        if (!(curIns instanceof LabelNode)) {
            return;
        }
        List<TryCatchBlockNodeInfo> infos = this.tryBlockStarts.get((LabelNode)curIns);
        for (TryCatchBlockNodeInfo startNode : infos) {
            if (startNode.getOnlyCopyNotProcess()) continue;
            TryCatchBlockNodeInfo tryCatchBlockNodeInfo = coveringTryBlocks.pop();
        }
        for (TryCatchBlockNodeInfo info : Lists.reverse(this.tryBlockEnds.get((LabelNode)curIns))) {
            if (info.getOnlyCopyNotProcess()) continue;
            coveringTryBlocks.add(info);
        }
    }

    private static boolean hasFinallyBlocks(List<TryCatchBlockNodeInfo> inlineFunTryBlockInfo) {
        for (TryCatchBlockNodeInfo block : inlineFunTryBlockInfo) {
            if (block.getOnlyCopyNotProcess() || block.getNode().type != null) continue;
            return true;
        }
        return false;
    }

    private void mapLabelsToTryCatchBlocks() {
        for (TryCatchBlockNodeInfo block : this.inlineFunTryBlockInfo) {
            this.tryBlockStarts.put(block.getNode().start, block);
            this.tryBlockEnds.put(block.getNode().end, block);
        }
    }

    @Nullable
    private FinallyBlockInfo findFinallyBlockBody(@NotNull TryCatchBlockNodeInfo tryCatchBlock, @NotNull List<TryCatchBlockNodeInfo> tryCatchBlocks) {
        if (tryCatchBlock == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tryCatchBlock", "org/jetbrains/jet/codegen/inline/InternalFinallyBlockInliner", "findFinallyBlockBody"));
        }
        if (tryCatchBlocks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tryCatchBlocks", "org/jetbrains/jet/codegen/inline/InternalFinallyBlockInliner", "findFinallyBlockBody"));
        }
        ArrayList<TryCatchBlockNodeInfo> sameDefaultHandler = new ArrayList<TryCatchBlockNodeInfo>();
        LabelNode defaultHandler = null;
        boolean afterStartBlock = false;
        for (TryCatchBlockNodeInfo block : tryCatchBlocks) {
            if (tryCatchBlock == block) {
                afterStartBlock = true;
            }
            if (!afterStartBlock || block.getNode().type != null || (InlineCodegenUtil.firstLabelInChain(tryCatchBlock.getNode().start) != InlineCodegenUtil.firstLabelInChain(block.getNode().start) || InlineCodegenUtil.firstLabelInChain(tryCatchBlock.getNode().end) != InlineCodegenUtil.firstLabelInChain(block.getNode().end)) && defaultHandler != InlineCodegenUtil.firstLabelInChain(block.getNode().handler)) continue;
            sameDefaultHandler.add(block);
            if (defaultHandler != null) continue;
            defaultHandler = InlineCodegenUtil.firstLabelInChain(block.getNode().handler);
        }
        if (sameDefaultHandler.isEmpty()) {
            return null;
        }
        TryCatchBlockNodeInfo nextIntervalWithSameDefaultHandler = (TryCatchBlockNodeInfo)sameDefaultHandler.get(1);
        LabelNode startFinallyChain = tryCatchBlock.getNode().end;
        AbstractInsnNode endFinallyChainExclusive = this.skipLastGotoIfNeeded(nextIntervalWithSameDefaultHandler.getNode().handler, nextIntervalWithSameDefaultHandler.getNode().start);
        return new FinallyBlockInfo(startFinallyChain.getNext(), endFinallyChainExclusive);
    }

    @NotNull
    private AbstractInsnNode skipLastGotoIfNeeded(@NotNull LabelNode defaultHandlerStartLabel, @NotNull AbstractInsnNode lastFinallyInsExclusive) {
        if (defaultHandlerStartLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultHandlerStartLabel", "org/jetbrains/jet/codegen/inline/InternalFinallyBlockInliner", "skipLastGotoIfNeeded"));
        }
        if (lastFinallyInsExclusive == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lastFinallyInsExclusive", "org/jetbrains/jet/codegen/inline/InternalFinallyBlockInliner", "skipLastGotoIfNeeded"));
        }
        AbstractInsnNode prevLast = InternalFinallyBlockInliner.getPrevNoLineNumberOrLabel(lastFinallyInsExclusive, true);
        assert (prevLast != null) : "Empty finally block: " + lastFinallyInsExclusive;
        if (prevLast.getOpcode() == 167) {
            LabelNode targetJump = ((JumpInsnNode)prevLast).label;
            InsnList instructions = this.inlineFun.instructions;
            if (instructions.indexOf(defaultHandlerStartLabel) < instructions.indexOf(targetJump)) {
                for (AbstractInsnNode cur = defaultHandlerStartLabel; cur != targetJump; cur = cur.getNext()) {
                    if (cur.getOpcode() != 167 || ((JumpInsnNode)cur).label != targetJump) continue;
                    AbstractInsnNode abstractInsnNode = lastFinallyInsExclusive;
                    if (abstractInsnNode == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/inline/InternalFinallyBlockInliner", "skipLastGotoIfNeeded"));
                    }
                    return abstractInsnNode;
                }
                AbstractInsnNode abstractInsnNode = prevLast;
                if (abstractInsnNode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/inline/InternalFinallyBlockInliner", "skipLastGotoIfNeeded"));
                }
                return abstractInsnNode;
            }
        }
        AbstractInsnNode abstractInsnNode = lastFinallyInsExclusive;
        if (abstractInsnNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/inline/InternalFinallyBlockInliner", "skipLastGotoIfNeeded"));
        }
        return abstractInsnNode;
    }

    @NotNull
    private List<TryCatchBlockNodePosition> findTryCatchBlocksInlinedInFinally(@NotNull FinallyBlockInfo finallyInfo) {
        if (finallyInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finallyInfo", "org/jetbrains/jet/codegen/inline/InternalFinallyBlockInliner", "findTryCatchBlocksInlinedInFinally"));
        }
        ArrayList<TryCatchBlockNodePosition> result2 = new ArrayList<TryCatchBlockNodePosition>();
        HashMap<TryCatchBlockNodeInfo, TryCatchBlockNodePosition> processedBlocks = new HashMap<TryCatchBlockNodeInfo, TryCatchBlockNodePosition>();
        for (AbstractInsnNode curInstr = finallyInfo.startIns; curInstr != finallyInfo.endInsExclusive; curInstr = curInstr.getNext()) {
            List<TryCatchBlockNodeInfo> endedTryBlocks;
            if (!(curInstr instanceof LabelNode)) continue;
            LabelNode curLabel = (LabelNode)curInstr;
            List<TryCatchBlockNodeInfo> startedTryBlocks = this.tryBlockStarts.get(curLabel);
            if (startedTryBlocks != null) {
                for (TryCatchBlockNodeInfo block : startedTryBlocks) {
                    assert (!processedBlocks.containsKey(block)) : "Try catch block already processed before start label!!! " + block;
                    TryCatchBlockNodePosition info = new TryCatchBlockNodePosition(block, TryCatchPosition.START);
                    processedBlocks.put(block, info);
                    result2.add(info);
                }
            }
            if ((endedTryBlocks = this.tryBlockEnds.get(curLabel)) == null) continue;
            for (TryCatchBlockNodeInfo block : endedTryBlocks) {
                TryCatchBlockNodePosition info = (TryCatchBlockNodePosition)processedBlocks.get(block);
                if (info != null) {
                    assert (info.getPosition() == TryCatchPosition.START);
                    info.setPosition(TryCatchPosition.INNER);
                    continue;
                }
                info = new TryCatchBlockNodePosition(block, TryCatchPosition.END);
                processedBlocks.put(block, info);
                result2.add(info);
            }
        }
        ArrayList<TryCatchBlockNodePosition> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/inline/InternalFinallyBlockInliner", "findTryCatchBlocksInlinedInFinally"));
        }
        return arrayList;
    }

    @Nullable
    private static AbstractInsnNode getPrevNoLineNumberOrLabel(@NotNull AbstractInsnNode node, boolean strict) {
        AbstractInsnNode result2;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/codegen/inline/InternalFinallyBlockInliner", "getPrevNoLineNumberOrLabel"));
        }
        AbstractInsnNode abstractInsnNode = result2 = strict ? node.getPrevious() : node;
        while (InlineCodegenUtil.isLineNumberOrLabel(result2)) {
            result2 = result2.getPrevious();
        }
        return result2;
    }

    private void sortTryCatchBlocks(@NotNull List<TryCatchBlockNodeInfo> inlineFunTryBlockInfo) {
        if (inlineFunTryBlockInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inlineFunTryBlockInfo", "org/jetbrains/jet/codegen/inline/InternalFinallyBlockInliner", "sortTryCatchBlocks"));
        }
        Comparator<TryCatchBlockNodeInfo> comp = new Comparator<TryCatchBlockNodeInfo>(){

            @Override
            public int compare(@NotNull TryCatchBlockNodeInfo t1, @NotNull TryCatchBlockNodeInfo t2) {
                if (t1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t1", "org/jetbrains/jet/codegen/inline/InternalFinallyBlockInliner$1", "compare"));
                }
                if (t2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t2", "org/jetbrains/jet/codegen/inline/InternalFinallyBlockInliner$1", "compare"));
                }
                int result2 = ((InternalFinallyBlockInliner)InternalFinallyBlockInliner.this).inlineFun.instructions.indexOf(t1.getNode().handler) - ((InternalFinallyBlockInliner)InternalFinallyBlockInliner.this).inlineFun.instructions.indexOf(t2.getNode().handler);
                if (result2 == 0 && (result2 = ((InternalFinallyBlockInliner)InternalFinallyBlockInliner.this).inlineFun.instructions.indexOf(t1.getNode().start) - ((InternalFinallyBlockInliner)InternalFinallyBlockInliner.this).inlineFun.instructions.indexOf(t2.getNode().start)) == 0) {
                    assert (false) : "Error: support multicatch finallies!";
                    result2 = ((InternalFinallyBlockInliner)InternalFinallyBlockInliner.this).inlineFun.instructions.indexOf(t1.getNode().end) - ((InternalFinallyBlockInliner)InternalFinallyBlockInliner.this).inlineFun.instructions.indexOf(t2.getNode().end);
                }
                return result2;
            }
        };
        Collections.sort(inlineFunTryBlockInfo, comp);
    }

    private static class FinallyBlockInfo {
        final AbstractInsnNode startIns;
        final AbstractInsnNode endInsExclusive;

        private FinallyBlockInfo(@NotNull AbstractInsnNode inclusiveStart, @NotNull AbstractInsnNode exclusiveEnd) {
            if (inclusiveStart == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inclusiveStart", "org/jetbrains/jet/codegen/inline/InternalFinallyBlockInliner$FinallyBlockInfo", "<init>"));
            }
            if (exclusiveEnd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exclusiveEnd", "org/jetbrains/jet/codegen/inline/InternalFinallyBlockInliner$FinallyBlockInfo", "<init>"));
            }
            this.startIns = inclusiveStart;
            this.endInsExclusive = exclusiveEnd;
        }
    }
}

