/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetWhenCondition;
import org.jetbrains.jet.lang.psi.JetWhenConditionWithExpression;
import org.jetbrains.jet.lang.psi.JetWhenEntry;
import org.jetbrains.jet.lang.psi.JetWhenExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.bindingContextUtil.BindingContextUtilPackage;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public final class WhenChecker {
    private WhenChecker() {
    }

    public static boolean mustHaveElse(@NotNull JetWhenExpression expression, @NotNull BindingTrace trace) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/WhenChecker", "mustHaveElse"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/cfg/WhenChecker", "mustHaveElse"));
        }
        JetType expectedType = trace.get(BindingContext.EXPECTED_EXPRESSION_TYPE, expression);
        boolean isUnit = expectedType != null && KotlinBuiltIns.getInstance().isUnit(expectedType);
        boolean isStatement = BindingContextUtilPackage.isUsedAsStatement(expression, trace.getBindingContext()) && expectedType == null;
        return !isUnit && !isStatement && !WhenChecker.isWhenExhaustive(expression, trace);
    }

    public static boolean isWhenByEnum(@NotNull JetWhenExpression expression, @NotNull BindingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/WhenChecker", "isWhenByEnum"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/cfg/WhenChecker", "isWhenByEnum"));
        }
        return WhenChecker.getSubjectClassDescriptorIfEnum(expression, context2) != null;
    }

    private static ClassDescriptor getSubjectClassDescriptorIfEnum(@NotNull JetWhenExpression expression, @NotNull BindingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/WhenChecker", "getSubjectClassDescriptorIfEnum"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/cfg/WhenChecker", "getSubjectClassDescriptorIfEnum"));
        }
        JetExpression subjectExpression = expression.getSubjectExpression();
        if (subjectExpression == null) {
            return null;
        }
        JetType type = context2.get(BindingContext.EXPRESSION_TYPE, subjectExpression);
        if (type == null) {
            return null;
        }
        ClassifierDescriptor declarationDescriptor = type.getConstructor().getDeclarationDescriptor();
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            return null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        if (classDescriptor.getKind() != ClassKind.ENUM_CLASS || classDescriptor.getModality().isOverridable()) {
            return null;
        }
        return classDescriptor;
    }

    private static boolean isWhenExhaustive(@NotNull JetWhenExpression expression, @NotNull BindingTrace trace) {
        boolean exhaustive;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/WhenChecker", "isWhenExhaustive"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/cfg/WhenChecker", "isWhenExhaustive"));
        }
        ClassDescriptor classDescriptor = WhenChecker.getSubjectClassDescriptorIfEnum(expression, trace.getBindingContext());
        if (classDescriptor == null) {
            return false;
        }
        boolean isExhaust = true;
        boolean notEmpty = false;
        for (DeclarationDescriptor descriptor : classDescriptor.getUnsubstitutedInnerClassesScope().getAllDescriptors()) {
            if (!DescriptorUtils.isEnumEntry(descriptor)) continue;
            notEmpty = true;
            if (WhenChecker.containsEnumEntryCase(expression, (ClassDescriptor)descriptor, trace)) continue;
            isExhaust = false;
        }
        boolean bl = exhaustive = isExhaust && notEmpty;
        if (exhaustive) {
            trace.record(BindingContext.EXHAUSTIVE_WHEN, expression);
        }
        return exhaustive;
    }

    private static boolean containsEnumEntryCase(@NotNull JetWhenExpression whenExpression, @NotNull ClassDescriptor enumEntry, @NotNull BindingTrace trace) {
        if (whenExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whenExpression", "org/jetbrains/jet/lang/cfg/WhenChecker", "containsEnumEntryCase"));
        }
        if (enumEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntry", "org/jetbrains/jet/lang/cfg/WhenChecker", "containsEnumEntryCase"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/cfg/WhenChecker", "containsEnumEntryCase"));
        }
        assert (enumEntry.getKind() == ClassKind.ENUM_ENTRY);
        for (JetWhenEntry whenEntry : whenExpression.getEntries()) {
            for (JetWhenCondition condition : whenEntry.getConditions()) {
                if (!(condition instanceof JetWhenConditionWithExpression) || !WhenChecker.isCheckForEnumEntry((JetWhenConditionWithExpression)condition, enumEntry, trace)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isCheckForEnumEntry(@NotNull JetWhenConditionWithExpression whenExpression, @NotNull ClassDescriptor enumEntry, @NotNull BindingTrace trace) {
        if (whenExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whenExpression", "org/jetbrains/jet/lang/cfg/WhenChecker", "isCheckForEnumEntry"));
        }
        if (enumEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntry", "org/jetbrains/jet/lang/cfg/WhenChecker", "isCheckForEnumEntry"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/cfg/WhenChecker", "isCheckForEnumEntry"));
        }
        JetSimpleNameExpression reference = WhenChecker.getReference(whenExpression.getExpression());
        if (reference == null) {
            return false;
        }
        DeclarationDescriptor target = trace.get(BindingContext.REFERENCE_TARGET, reference);
        return target == enumEntry;
    }

    @Nullable
    private static JetSimpleNameExpression getReference(@Nullable JetExpression expression) {
        if (expression == null) {
            return null;
        }
        if (expression instanceof JetSimpleNameExpression) {
            return (JetSimpleNameExpression)expression;
        }
        if (expression instanceof JetQualifiedExpression) {
            return WhenChecker.getReference(((JetQualifiedExpression)expression).getSelectorExpression());
        }
        return null;
    }
}

