/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentProvider;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class CompositePackageFragmentProvider
implements PackageFragmentProvider {
    private final List<PackageFragmentProvider> providers;

    public CompositePackageFragmentProvider(@NotNull List<PackageFragmentProvider> providers) {
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "org/jetbrains/jet/lang/descriptors/impl/CompositePackageFragmentProvider", "<init>"));
        }
        this.providers = providers;
    }

    @Override
    @NotNull
    public List<PackageFragmentDescriptor> getPackageFragments(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/descriptors/impl/CompositePackageFragmentProvider", "getPackageFragments"));
        }
        ArrayList<PackageFragmentDescriptor> result2 = new ArrayList<PackageFragmentDescriptor>();
        for (PackageFragmentProvider provider : this.providers) {
            result2.addAll(provider.getPackageFragments(fqName2));
        }
        result2.trimToSize();
        ArrayList<PackageFragmentDescriptor> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/CompositePackageFragmentProvider", "getPackageFragments"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Collection<FqName> getSubPackagesOf(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/descriptors/impl/CompositePackageFragmentProvider", "getSubPackagesOf"));
        }
        HashSet<FqName> result2 = new HashSet<FqName>();
        for (PackageFragmentProvider provider : this.providers) {
            result2.addAll(provider.getSubPackagesOf(fqName2));
        }
        HashSet<FqName> hashSet = result2;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/CompositePackageFragmentProvider", "getSubPackagesOf"));
        }
        return hashSet;
    }
}

