/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors.impl;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.SourceElement;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationsImpl;
import org.jetbrains.jet.lang.descriptors.impl.ClassDescriptorBase;
import org.jetbrains.jet.lang.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.DeclarationDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.PackageLikeBuilder;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.ClassObjectMixinScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.RedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.StaticScopeForKotlinClass;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.types.DelegatingType;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeConstructorImpl;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.storage.LockBasedStorageManager;

public class MutableClassDescriptor
extends ClassDescriptorBase
implements ClassDescriptorWithResolutionScopes {
    private final ClassKind kind;
    private final boolean isInner;
    private Annotations annotations;
    private Modality modality;
    private Visibility visibility;
    private TypeConstructor typeConstructor;
    private List<TypeParameterDescriptor> typeParameters;
    private Collection<JetType> supertypes;
    private MutableClassDescriptor classObjectDescriptor;
    private final Set<ConstructorDescriptor> constructors;
    private ConstructorDescriptor primaryConstructor;
    private final Set<CallableMemberDescriptor> declaredCallableMembers;
    private final Set<CallableMemberDescriptor> allCallableMembers;
    private final Set<PropertyDescriptor> properties;
    private final Set<SimpleFunctionDescriptor> functions;
    private final WritableScope scopeForMemberResolution;
    private final WritableScope scopeForSupertypeResolution;
    private WritableScope scopeForInitializers;
    private JetScope scopeForMemberLookup;
    private final JetScope staticScope;
    private PackageLikeBuilder builder;

    public MutableClassDescriptor(@NotNull DeclarationDescriptor containingDeclaration, @NotNull JetScope outerScope, @NotNull ClassKind kind, boolean isInner, @NotNull Name name, @NotNull SourceElement source) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "<init>"));
        }
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "<init>"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "<init>"));
        }
        super(LockBasedStorageManager.NO_LOCKS, containingDeclaration, name, source);
        this.supertypes = new ArrayList<JetType>();
        this.constructors = Sets.newLinkedHashSet();
        this.declaredCallableMembers = Sets.newLinkedHashSet();
        this.allCallableMembers = Sets.newLinkedHashSet();
        this.properties = Sets.newLinkedHashSet();
        this.functions = Sets.newLinkedHashSet();
        this.staticScope = new StaticScopeForKotlinClass(this);
        this.builder = null;
        this.kind = kind;
        this.isInner = isInner;
        RedeclarationHandler redeclarationHandler = RedeclarationHandler.DO_NOTHING;
        this.setScopeForMemberLookup(new WritableScopeImpl(JetScope.EMPTY, this, redeclarationHandler, "MemberLookup").changeLockLevel(WritableScope.LockLevel.BOTH));
        this.scopeForSupertypeResolution = new WritableScopeImpl(outerScope, this, redeclarationHandler, "SupertypeResolution").changeLockLevel(WritableScope.LockLevel.BOTH);
        this.scopeForMemberResolution = new WritableScopeImpl(this.scopeForSupertypeResolution, this, redeclarationHandler, "MemberResolution").changeLockLevel(WritableScope.LockLevel.BOTH);
        if (kind == ClassKind.TRAIT) {
            this.setUpScopeForInitializers(this);
        }
        this.scopeForMemberResolution.importScope(this.staticScope);
        this.scopeForMemberResolution.addLabeledDeclaration(this);
    }

    @Override
    @Nullable
    public MutableClassDescriptor getClassObjectDescriptor() {
        return this.classObjectDescriptor;
    }

    @Override
    @NotNull
    public Annotations getAnnotations() {
        if (this.annotations == null) {
            this.annotations = new AnnotationsImpl(new ArrayList<AnnotationDescriptor>(0));
        }
        Annotations annotations = this.annotations;
        if (annotations == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "getAnnotations"));
        }
        return annotations;
    }

    public void addAnnotations(@NotNull Iterable<AnnotationDescriptor> annotationsToAdd) {
        if (annotationsToAdd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationsToAdd", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "addAnnotations"));
        }
        List<AnnotationDescriptor> annotations = ((AnnotationsImpl)this.getAnnotations()).getAnnotationDescriptors();
        for (AnnotationDescriptor annotationDescriptor : annotationsToAdd) {
            annotations.add(annotationDescriptor);
        }
    }

    public void setModality(@NotNull Modality modality) {
        if (modality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modality", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "setModality"));
        }
        this.modality = modality;
    }

    @Override
    @NotNull
    public Modality getModality() {
        Modality modality = this.modality;
        if (modality == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "getModality"));
        }
        return modality;
    }

    @Override
    @NotNull
    public ClassKind getKind() {
        ClassKind classKind = this.kind;
        if (classKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "getKind"));
        }
        return classKind;
    }

    public void setVisibility(@NotNull Visibility visibility) {
        if (visibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibility", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "setVisibility"));
        }
        this.visibility = visibility;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        Visibility visibility = this.visibility;
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "getVisibility"));
        }
        return visibility;
    }

    @Override
    public boolean isInner() {
        return this.isInner;
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        TypeConstructor typeConstructor = this.typeConstructor;
        if (typeConstructor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "getTypeConstructor"));
        }
        return typeConstructor;
    }

    @NotNull
    public Collection<JetType> getSupertypes() {
        Collection<JetType> collection = this.supertypes;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "getSupertypes"));
        }
        return collection;
    }

    public void setSupertypes(@NotNull Collection<JetType> supertypes) {
        if (supertypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertypes", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "setSupertypes"));
        }
        this.supertypes = supertypes;
    }

    public void addSupertype(@NotNull JetType supertype) {
        if (supertype == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertype", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "addSupertype"));
        }
        assert (!supertype.isError()) : "Error types must be filtered out in DescriptorResolver";
        if (TypeUtils.getClassDescriptor(supertype) != null) {
            this.supertypes.add(supertype);
        }
    }

    public void setPrimaryConstructor(@NotNull ConstructorDescriptor constructorDescriptor) {
        if (constructorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorDescriptor", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "setPrimaryConstructor"));
        }
        assert (this.primaryConstructor == null) : "Primary constructor assigned twice " + this;
        this.primaryConstructor = constructorDescriptor;
        this.constructors.add(constructorDescriptor);
        ((ConstructorDescriptorImpl)constructorDescriptor).setReturnType(new DelegatingType(){

            @Override
            protected JetType getDelegate() {
                return MutableClassDescriptor.this.getDefaultType();
            }
        });
        if (constructorDescriptor.isPrimary()) {
            this.setUpScopeForInitializers(constructorDescriptor);
        }
    }

    public void addConstructorParametersToInitializersScope(@NotNull Collection<? extends VariableDescriptor> variables) {
        if (variables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variables", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "addConstructorParametersToInitializersScope"));
        }
        WritableScope scope = this.getWritableScopeForInitializers();
        for (VariableDescriptor variableDescriptor : variables) {
            scope.addVariableDescriptor(variableDescriptor);
        }
    }

    @NotNull
    public Set<ConstructorDescriptor> getConstructors() {
        Set<ConstructorDescriptor> set = this.constructors;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "getConstructors"));
        }
        return set;
    }

    @Override
    @Nullable
    public ConstructorDescriptor getUnsubstitutedPrimaryConstructor() {
        return this.primaryConstructor;
    }

    @NotNull
    public Set<SimpleFunctionDescriptor> getFunctions() {
        Set<SimpleFunctionDescriptor> set = this.functions;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "getFunctions"));
        }
        return set;
    }

    @NotNull
    public Set<PropertyDescriptor> getProperties() {
        Set<PropertyDescriptor> set = this.properties;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "getProperties"));
        }
        return set;
    }

    @NotNull
    public Set<CallableMemberDescriptor> getDeclaredCallableMembers() {
        Set<CallableMemberDescriptor> set = this.declaredCallableMembers;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "getDeclaredCallableMembers"));
        }
        return set;
    }

    @NotNull
    public Set<CallableMemberDescriptor> getAllCallableMembers() {
        Set<CallableMemberDescriptor> set = this.allCallableMembers;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "getAllCallableMembers"));
        }
        return set;
    }

    public void setTypeParameterDescriptors(@NotNull List<TypeParameterDescriptor> typeParameters) {
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "setTypeParameterDescriptors"));
        }
        if (this.typeParameters != null) {
            throw new IllegalStateException("Type parameters are already set for " + this.getName());
        }
        this.typeParameters = new ArrayList<TypeParameterDescriptor>(typeParameters);
        for (TypeParameterDescriptor typeParameterDescriptor : typeParameters) {
            this.scopeForSupertypeResolution.addTypeParameterDescriptor(typeParameterDescriptor);
        }
        this.scopeForSupertypeResolution.changeLockLevel(WritableScope.LockLevel.READING);
    }

    public void createTypeConstructor() {
        assert (this.typeConstructor == null) : this.typeConstructor;
        this.typeConstructor = TypeConstructorImpl.createForClass(this, Annotations.EMPTY, !this.getModality().isOverridable(), this.getName().asString(), this.typeParameters, this.supertypes);
        for (ConstructorDescriptor functionDescriptor : this.getConstructors()) {
            ((ConstructorDescriptorImpl)functionDescriptor).setReturnType(this.getDefaultType());
        }
        this.scopeForMemberResolution.setImplicitReceiver(this.getThisAsReceiverParameter());
    }

    @Override
    @NotNull
    public JetScope getScopeForClassHeaderResolution() {
        WritableScope writableScope = this.scopeForSupertypeResolution;
        if (writableScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "getScopeForClassHeaderResolution"));
        }
        return writableScope;
    }

    @Override
    @NotNull
    public JetScope getScopeForMemberDeclarationResolution() {
        WritableScope writableScope = this.scopeForMemberResolution;
        if (writableScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "getScopeForMemberDeclarationResolution"));
        }
        return writableScope;
    }

    private WritableScope getWritableScopeForInitializers() {
        if (this.scopeForInitializers == null) {
            throw new IllegalStateException("Scope for initializers queried before the primary constructor is set");
        }
        return this.scopeForInitializers;
    }

    @Override
    @NotNull
    public JetScope getScopeForInitializerResolution() {
        WritableScope writableScope = this.getWritableScopeForInitializers();
        if (writableScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "getScopeForInitializerResolution"));
        }
        return writableScope;
    }

    private void setUpScopeForInitializers(@NotNull DeclarationDescriptor containingDeclaration) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "setUpScopeForInitializers"));
        }
        this.scopeForInitializers = new WritableScopeImpl(this.scopeForMemberResolution, containingDeclaration, RedeclarationHandler.DO_NOTHING, "Initializers").changeLockLevel(WritableScope.LockLevel.BOTH);
    }

    public void setScopeForMemberLookup(@NotNull JetScope scopeForMemberLookup) {
        if (scopeForMemberLookup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeForMemberLookup", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "setScopeForMemberLookup"));
        }
        this.scopeForMemberLookup = scopeForMemberLookup;
    }

    @Override
    @NotNull
    public JetScope getScopeForMemberLookup() {
        JetScope jetScope = this.scopeForMemberLookup;
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "getScopeForMemberLookup"));
        }
        return jetScope;
    }

    @NotNull
    private WritableScope getScopeForMemberLookupAsWritableScope() {
        WritableScope writableScope = (WritableScope)this.scopeForMemberLookup;
        if (writableScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "getScopeForMemberLookupAsWritableScope"));
        }
        return writableScope;
    }

    @Override
    @NotNull
    public JetScope getStaticScope() {
        JetScope jetScope = this.staticScope;
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "getStaticScope"));
        }
        return jetScope;
    }

    public void lockScopes() {
        this.getScopeForMemberLookupAsWritableScope().changeLockLevel(WritableScope.LockLevel.READING);
        if (this.classObjectDescriptor != null) {
            this.classObjectDescriptor.lockScopes();
        }
        this.scopeForSupertypeResolution.changeLockLevel(WritableScope.LockLevel.READING);
        this.scopeForMemberResolution.changeLockLevel(WritableScope.LockLevel.READING);
        this.getWritableScopeForInitializers().changeLockLevel(WritableScope.LockLevel.READING);
    }

    @NotNull
    public PackageLikeBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = new PackageLikeBuilder(){

                @Override
                @NotNull
                public DeclarationDescriptor getOwnerForChildren() {
                    MutableClassDescriptor mutableClassDescriptor = MutableClassDescriptor.this;
                    if (mutableClassDescriptor == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor$2", "getOwnerForChildren"));
                    }
                    return mutableClassDescriptor;
                }

                @Override
                public void addClassifierDescriptor(@NotNull MutableClassDescriptor classDescriptor) {
                    if (classDescriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor$2", "addClassifierDescriptor"));
                    }
                    MutableClassDescriptor.this.getScopeForMemberLookupAsWritableScope().addClassifierDescriptor(classDescriptor);
                    MutableClassDescriptor.this.scopeForMemberResolution.addClassifierDescriptor(classDescriptor);
                }

                @Override
                public void addFunctionDescriptor(@NotNull SimpleFunctionDescriptor functionDescriptor) {
                    if (functionDescriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor$2", "addFunctionDescriptor"));
                    }
                    MutableClassDescriptor.this.getScopeForMemberLookupAsWritableScope().addFunctionDescriptor(functionDescriptor);
                    MutableClassDescriptor.this.functions.add(functionDescriptor);
                    if (functionDescriptor.getKind().isReal()) {
                        MutableClassDescriptor.this.declaredCallableMembers.add(functionDescriptor);
                    }
                    MutableClassDescriptor.this.allCallableMembers.add(functionDescriptor);
                    MutableClassDescriptor.this.scopeForMemberResolution.addFunctionDescriptor(functionDescriptor);
                }

                @Override
                public PackageLikeBuilder.ClassObjectStatus setClassObjectDescriptor(@NotNull MutableClassDescriptor classObjectDescriptor) {
                    if (classObjectDescriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classObjectDescriptor", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor$2", "setClassObjectDescriptor"));
                    }
                    if (MutableClassDescriptor.this.getKind() == ClassKind.CLASS_OBJECT || MutableClassDescriptor.this.isInner()) {
                        return PackageLikeBuilder.ClassObjectStatus.NOT_ALLOWED;
                    }
                    if (MutableClassDescriptor.this.classObjectDescriptor != null) {
                        return PackageLikeBuilder.ClassObjectStatus.DUPLICATE;
                    }
                    assert (classObjectDescriptor.getKind() == ClassKind.CLASS_OBJECT);
                    MutableClassDescriptor.this.classObjectDescriptor = classObjectDescriptor;
                    MutableClassDescriptor.this.scopeForMemberResolution.importScope(new ClassObjectMixinScope(classObjectDescriptor));
                    return PackageLikeBuilder.ClassObjectStatus.OK;
                }

                @Override
                public void addPropertyDescriptor(@NotNull PropertyDescriptor propertyDescriptor) {
                    if (propertyDescriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor$2", "addPropertyDescriptor"));
                    }
                    MutableClassDescriptor.this.getScopeForMemberLookupAsWritableScope().addPropertyDescriptor(propertyDescriptor);
                    MutableClassDescriptor.this.properties.add(propertyDescriptor);
                    if (propertyDescriptor.getKind().isReal()) {
                        MutableClassDescriptor.this.declaredCallableMembers.add(propertyDescriptor);
                    }
                    MutableClassDescriptor.this.allCallableMembers.add(propertyDescriptor);
                    MutableClassDescriptor.this.scopeForMemberResolution.addPropertyDescriptor(propertyDescriptor);
                }
            };
        }
        PackageLikeBuilder packageLikeBuilder = this.builder;
        if (packageLikeBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptor", "getBuilder"));
        }
        return packageLikeBuilder;
    }

    public String toString() {
        return DeclarationDescriptorImpl.toString(this);
    }
}

