/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.diagnostics.rendering;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.diagnostics.Diagnostic;
import org.jetbrains.jet.lang.diagnostics.rendering.DiagnosticFactoryToRendererMap;
import org.jetbrains.jet.lang.diagnostics.rendering.DiagnosticRenderer;

public class DispatchingDiagnosticRenderer
implements DiagnosticRenderer<Diagnostic> {
    private final List<DiagnosticFactoryToRendererMap> maps;

    public DispatchingDiagnosticRenderer(List<DiagnosticFactoryToRendererMap> maps) {
        this.maps = maps;
    }

    @Override
    @NotNull
    public String render(@NotNull Diagnostic diagnostic) {
        if (diagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/jet/lang/diagnostics/rendering/DispatchingDiagnosticRenderer", "render"));
        }
        for (DiagnosticFactoryToRendererMap map : this.maps) {
            DiagnosticRenderer<?> renderer = map.get(diagnostic.getFactory());
            if (renderer == null) continue;
            String string = renderer.render(diagnostic);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/DispatchingDiagnosticRenderer", "render"));
            }
            return string;
        }
        throw new IllegalArgumentException("Don't know how to render diagnostic of type " + diagnostic.getFactory().getName());
    }
}

