/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.evaluate;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.Function1;
import kotlin.Function2;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KObject;
import kotlin.jvm.internal.KotlinClass;
import kotlin.reflect.jvm.internal.InternalPackage;
import kotlin.reflect.jvm.internal.KClassImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptorImpl;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.evaluate.BinaryOperationKey;
import org.jetbrains.jet.lang.evaluate.CompileTimeType;
import org.jetbrains.jet.lang.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.jet.lang.evaluate.ConstantExpressionEvaluator$evaluateBinaryAndCheck$2;
import org.jetbrains.jet.lang.evaluate.ConstantExpressionEvaluator$visitConstantExpression$1;
import org.jetbrains.jet.lang.evaluate.EvaluatePackage$ConstantExpressionEvaluator$a64b065f;
import org.jetbrains.jet.lang.evaluate.EvaluatePackage$OperationsMapGenerated$ae0dd7dd;
import org.jetbrains.jet.lang.evaluate.EvaluatorContext;
import org.jetbrains.jet.lang.evaluate.UnaryOperationKey;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetConstantExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetEscapeStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetLabeledExpression;
import org.jetbrains.jet.lang.psi.JetLiteralStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetParenthesizedExpression;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetStringTemplateEntryWithExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateExpression;
import org.jetbrains.jet.lang.psi.JetUnaryExpression;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.AnnotationResolver;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.CompileTimeConstantUtils;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.callUtil.CallUtilPackage$callUtil$bbaa9fe2;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.jet.lang.resolve.constants.AnnotationValue;
import org.jetbrains.jet.lang.resolve.constants.ArrayValue;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstantChecker;
import org.jetbrains.jet.lang.resolve.constants.EnumValue;
import org.jetbrains.jet.lang.resolve.constants.ErrorValue;
import org.jetbrains.jet.lang.resolve.constants.IntegerValueConstant;
import org.jetbrains.jet.lang.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.jet.lang.resolve.constants.JavaClassValue;
import org.jetbrains.jet.lang.resolve.constants.NullValue;
import org.jetbrains.jet.lang.resolve.constants.StringValue;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetTokens;

@KotlinClass(abiVersion=18, data={"P\u0018)Y2i\u001c8ti\u0006tG/\u0012=qe\u0016\u001c8/[8o\u000bZ\fG.^1u_JT1a\u001c:h\u0015%QW\r\u001e2sC&t7OC\u0002kKRTA\u0001\\1oO*AQM^1mk\u0006$XM\u0003\u0006KKR4\u0016n]5u_JT1\u0001]:j\u0015M\u0019u.\u001c9jY\u0016$\u0016.\\3D_:\u001cH/\u00198u\u0015\u001d\u0011Xm]8mm\u0016T\u0011bY8ogR\fg\u000e^:\u000b\u0007\u0005s\u0017P\u0003\u0004l_Rd\u0017N\u001c\u0006\b\u0015\u0016$H+\u001f9f\u0015\u0015!\u0018\u0010]3t\u0015\u0019a\u0014N\\5u}))AO]1dK*a!)\u001b8eS:<GK]1dK*)2-\u00198CKV\u001bX\rZ%o\u0003:tw\u000e^1uS>t'BC3yaJ,7o]5p]*i!*\u001a;FqB\u0014Xm]:j_:TqAQ8pY\u0016\fgNC\rde\u0016\fG/Z\"p[BLG.\u001a+j[\u0016\u001cuN\\:uC:$(\"\u0002<bYV,'\u0002D3ya\u0016\u001cG/\u001a3UsB,'BB5t!V\u0014XM\u0003\fvg\u0016\u001ch+\u0019:jC\ndW-Q:D_:\u001cH/\u00198u\u0015\u0011Q\u0017M^1\u000b\r=\u0013'.Z2u\u0015]\u0019'/Z1uK>\u0003XM]1uS>t\u0017I]4v[\u0016tGO\u0003\bfqB\u0014Xm]:j_:$\u0016\u0010]3\u000b\u001f\r|W\u000e]5mKRKW.\u001a+za\u0016TqbQ8na&dW\rV5nKRK\b/\u001a\u0006\u0012\u001fB,'/\u0019;j_:\f%oZ;nK:$(\"L\"p]N$\u0018M\u001c;FqB\u0014Xm]:j_:,e/\u00197vCR|'\u000fJ(qKJ\fG/[8o\u0003J<W/\\3oi*A3M]3bi\u0016|\u0005/\u001a:bi&|g.\u0011:hk6,g\u000e\u001e$pe\u001aK'o\u001d;QCJ\fW.\u001a;fe*A\u0011M]4v[\u0016tGOC\u000bSKN|GN^3e-\u0006dW/Z!sOVlWM\u001c;\u000b\u000b\r\fG\u000e\\:\u000b\u000b5|G-\u001a7\u000b\u0013A\f'/Y7fi\u0016\u0014(\u0002\u0007,bYV,\u0007+\u0019:b[\u0016$XM\u001d#fg\u000e\u0014\u0018\u000e\u001d;pe*YA-Z:de&\u0004Ho\u001c:t\u0015\t\u001a'/Z1uK>\u0003XM]1uS>t\u0017I]4v[\u0016tGOR8s%\u0016\u001cW-\u001b<fe*a!/Z:pYZ,GmQ1mY*a!+Z:pYZ,GmQ1mY*\u00112)\u00197mC\ndW\rR3tGJL\u0007\u000f^8s\u0015Y)g/\u00197vCR,')\u001b8bef\fe\u000eZ\"iK\u000e\\'\u0002\u0003:fG\u0016Lg/\u001a:\u000b\t9\fW.\u001a\u0006\u0007'R\u0014\u0018N\\4\u000b\u001d\r\fG\u000e\\#yaJ,7o]5p]*aQM^1mk\u0006$XmQ1mY*\u0011\"/Z2fSZ,'/\u0012=qe\u0016\u001c8/[8o\u0015U)g/\u00197vCR,WK\\1ss\u0006sGm\u00115fG.T\u0001#[:ESZL7/[8o\u0005fTVM]8\u000b\u001d%\u001c\b+\u001e:f\u0007>t7\u000f^1oi*\u0001\"/Z:pYZ,\u0017I]4v[\u0016tGo\u001d\u0006\u000fm\u0006dW/Z!sOVlWM\u001c;t\u0015\u0011a\u0015n\u001d;\u000b\u001bY\u000bG.^3Be\u001e,X.\u001a8u\u0015\u0011)H/\u001b7\u000b3M$(/\u001b8h\u000bb\u0004(/Z:tS>tWI^1mk\u0006$xN\u001d\u00068\u0007>t7\u000f^1oi\u0016C\bO]3tg&|g.\u0012<bYV\fGo\u001c:%gR\u0014\u0018N\\4FqB\u0014Xm]:j_:,e/\u00197vCR|'\u000fJ\u0019\u000b\u0011\u001d,G\u000f\u0016:bG\u0016TQC^5tSR\u0014\u0015N\\1ss\u0016C\bO]3tg&|gNC\nKKR\u0014\u0015N\\1ss\u0016C\bO]3tg&|gNC\nwSNLGoQ1mY\u0016C\bO]3tg&|gNC\tKKR\u001c\u0015\r\u001c7FqB\u0014Xm]:j_:TqC^5tSR\u001cuN\\:uC:$X\t\u001f9sKN\u001c\u0018n\u001c8\u000b+)+GoQ8ogR\fg\u000e^#yaJ,7o]5p]*ya/[:ji*+G/\u00127f[\u0016tGOC\u0004fY\u0016lWM\u001c;\u000b\u0015)+G/\u00127f[\u0016tGO\u0003\fwSNLG\u000fT1cK2,G-\u0012=qe\u0016\u001c8/[8o\u0015QQU\r\u001e'bE\u0016dW\rZ#yaJ,7o]5p]*ab/[:jiB\u000b'/\u001a8uQ\u0016\u001c\u0018N_3e\u000bb\u0004(/Z:tS>t'B\u0007&fiB\u000b'/\u001a8uQ\u0016\u001c\u0018N_3e\u000bb\u0004(/Z:tS>t'\u0002\u0007<jg&$\u0018+^1mS\u001aLW\rZ#yaJ,7o]5p]*1\"*\u001a;Rk\u0006d\u0017NZ5fI\u0016C\bO]3tg&|gNC\rwSNLGoU5na2,g*Y7f\u000bb\u0004(/Z:tS>t'b\u0006&fiNKW\u000e\u001d7f\u001d\u0006lW-\u0012=qe\u0016\u001c8/[8o\u0015u1\u0018n]5u'R\u0014\u0018N\\4UK6\u0004H.\u0019;f\u000bb\u0004(/Z:tS>t'b\u0007&fiN#(/\u001b8h)\u0016l\u0007\u000f\\1uK\u0016C\bO]3tg&|gN\u0003\u000bwSNLG/\u00168bef,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u0013\u0015\u0016$XK\\1ss\u0016C\bO]3tg&|g\u000ep\u0002\u000b\u0005A\t!\u0002\u0002\u0005\u0001!\tQA\u0001C\u0001\u0011\u0007)!\u0001B\u0001\t\u0005\u0015\u0011A1\u0001E\u0003\u000b\r!!\u0001\u0003\u0001\r\u0001\u0015\u0011A1\u0001E\u0004\u000b\r!1\u0001C\u0002\r\u0001\u0015\u0011A1\u0001E\u0005\u000b\t!A\u0001C\u0003\u0006\u0007\u0011%\u0001\u0002\u0002\u0007\u0001\u000b\u0005Aa!B\u0002\u0005\f!-A\u0002A\u0003\u0003\t\u0007Aq!B\u0002\u0005\u000e!5A\u0002A\u0003\u0004\t\u0011A\t\u0002\u0004\u0001\u0006\u0005\u0011!\u0001\u0012C\u0003\u0004\t\rA!\u0002\u0004\u0001\u0006\u0007\u0011-\u0001R\u0003\u0007\u0001\u000b\t!1\u0001\u0003\u0006\u0006\u0005\u0011%\u0001\u0002B\u0003\u0002\u00117)!\u0001\"\u0006\t\u0005\u0015\u0011Aa\u0003\u0005\u000f\u000b\t!i\u0001#\u0004\u0006\u0007\u0011\u0011\u0001\u0002\u0005\u0007\u0001\u000b\r!)\u0001#\t\r\u0001\u0015\u0011AA\u0001\u0005\u0012\u000b\t!!\u0001\u0003\t\u0006\u0005\u0011!\u0001bE\u0003\u0003\t;A9#B\u0002\u0005\u001f!\u0015B\u0002A\u0003\u0003\t\u0007AQ#B\u0002\u0005!!%B\u0002A\u0003\u0003\t=A)#\u0002\u0002\u0005!!%Ra\u0001\u0003\u0010\u0011[a\u0001!B\u0002\u0005!!9B\u0002A\u0003\u0003\t=Ai#B\u0002\u0005\f!IB\u0002A\u0003\u0003\t-A\u0011$B\u0002\u0005\f!mB\u0002A\u0003\u0004\t\rAa\u0004\u0004\u0001\u0006\u0005\u0011U\u0001RH\u0003\u0003\tWAY$\u0002\u0002\u0005\u0005!}Ra\u0001\u0003\u0004\u0011\u0005b\u0001!\u0002\u0002\u0005\u0007!\tSa\u0001\u0003\u0004\u0011\tb\u0001!\u0002\u0002\u0005\u0007!\u0011Sa\u0001\u0003\u0004\u0011\rb\u0001!\u0002\u0002\u0005\u0007!\u0019Sa\u0001\u0003\u0004\u0011\u0013b\u0001!\u0002\u0002\u0005\u0007!%Sa\u0001\u0003\u0004\u0011\u0017b\u0001!\u0002\u0002\u0005\u0007!-Sa\u0001\u0003\u0004\u0011\u001bb\u0001!\u0002\u0002\u0005\u0007!5Sa\u0001\u0003\u0004\u0011\u001fb\u0001!\u0002\u0002\u0005\u0007!=Sa\u0001\u0003\u0004\u0011#b\u0001!\u0002\u0002\u0005\u0007!ESa\u0001\u0003\u0004\u0011'b\u0001!\u0002\u0002\u0005\u0007!MSa\u0001\u0003\u0004\u0011+b\u0001!\u0002\u0002\u0005\u0007!UCa\u0001G\u0003#\u0001I\u0002#B\u0001\t\b%I\u0011\u0002C\u0003\u0002\u0011\u0015IQ\u0001\"\u0001\n\u0007\u0015\t\u0001B\u0002G\u0001\u0013\rI!!B\u0001\t\u000fq\u0005Rf\u0005\u0003\u00021%ij\u0001\u0002\u0001\t\u00145\u0011Q!\u0001E\t!\u000e\u0001\u0011EA\u0003\u0002\u0011%\t6!\u0002\u0003\n\u0013\u0005!\t!D\u0001\t\u00145\u0012\r\u0001\u0002\u0001\u0019\u0017u=A\u0001\u0001E\f\u001b\r)\u0011\u0001\u0003\u0004\r\u0002A\u001b\u0001!h\u0004\u0005\u0001!aQbA\u0003\u0002\u0011\u001da\t\u0001UB\u0001;\u001b!\u0011\u0001#\u0007\u000e\u0005\u0015\t\u0001\"\u0003)\u0004\u0003u5A!\u0001\u0005\n\u001b\t)\u0011\u0001C\u0005Q\u0007\u0007ij\u0001B\u0001\t\u001b5\u0011Q!\u0001\u0005\n!\u000e\u0011\u0011%C\u0003\u0002\u0011\u0015IQ\u0001\"\u0001\n\u0007\u0015\t\u0001B\u0002G\u0001\u0019\u0003\t6!\u0004\u0003\f\u0013\u0005A!\"D\u0001\t\u00185\t\u0001\u0002D\u0007\u0002\t\u0003i\u0011\u0001\"\u0001\u000e\u0003\u0011\u0005Q&\f\u0003\u00021;ij\u0001\u0002\u0001\t\u00145\u0011Q!\u0001E\t!\u000e\u0001QT\u0002\u0003\u0001\u0011=i!!B\u0001\t\u000fA\u001b\t!(\u0007\u0005\u0001!}Q\u0002C\u0003\u0002\u00113IQ\u0001\"\u0001\n\u0007\u0015\t\u0001B\u0002G\u0001!\u000e\t\u0011eA\u0003\u0002\u00115a\t!U\u0002\n\t;I\u0011\u0001c\u0007\u000e\u0003!MQ\"\u0001\u0005\r\u001b\u0005Aa\"l\u000f\u0005\u0003a\rRT\u0002\u0003\u0001\u0011Ii!!B\u0001\t A\u001b\u0001!(\u0004\u0005\u0001!!RBA\u0003\u0002\u0011C\u00016\u0011A\u0011\u0004\u000b\u0005AQ\u0002$\u0001R\u0007\u001d!\u0019#C\u0001\t\u001c5\t\u0001\"E\u0007\u0002\u0011Gi+\u0005B\u0001\u0019,u]A\u0001\u0001\u0005\u0017\u001b\u001d)\u0011\u0001\u0003\n\n\t\u0011\u0005\u0011BA\u0003\u0002\u0011K\u00016\u0001AO\u0007\t\u0001A\u0019\"\u0004\u0002\u0006\u0003!E\u0001k!\u0001\"\u0007\u0015\t\u0001\"\u0004G\u0001#\u000e9A1F\u0005\u0002\u00117i\u0011\u0001C\n\u000e\u0003!MQ\u0016\n\u0003\u00021\u000bij\u0001\u0002\u0001\t\u00145\u0011Q!\u0001E\t!\u000e\u0001Qt\u0002\u0003\u0001\u00111i1!B\u0001\t\u000f1\u0005\u0001k!\u0001\"\u0013\u0015\t\u0001\"B\u0005\u0006\t\u0003I1!B\u0001\t\r1\u0005A\u0012A)\u0004\u000f\u0011\u0015\u0011\"\u0001\u0005\u000b\u001b\u0005A\u0019\"D\u0001\t\u00195\u0006D!\u0001M\u0018;\u001b!\u0001\u0001\u0003\r\u000e\u0005\u0015\t\u0001\"\u0004)\u0004\u0001u5A\u0001\u0001\u0005\u0015\u001b\t)\u0011\u0001C\u0007Q\u0007\u0003ij\u0001\u0002\u0001\t25\u0011Q!\u0001E\u0014!\u000e\tQT\u0002\u0003\u0001\u0011gi!!B\u0001\t\u0012A\u001b\u0019!I\u0002\u0006\u0003!1A\u0012A)\u0004\u0017\u0011=\u0012\"\u0001E\f\u001b\u0005AY\"D\u0001\t\u001c5\t\u0001\u0002F\u0007\u0002\u0011'ic\u0006B\u0001\u00195u5A\u0001\u0001E\u001a\u001b\t)\u0011\u0001#\u0005Q\u0007\u0001ij\u0001\u0002\u0001\t65\u0011Q!\u0001E\t!\u000e\u0005Qt\u0002\u0003\u0001\u00111i1!B\u0001\t\u000f1\u0005\u0001kA\u0001\"\u0013\u0015\t\u0001\"B\u0005\u0006\t\u0003I1!B\u0001\t\r1\u0005A\u0012A)\u0004\u0013\u0011Q\u0012\"\u0001\u0005\u000b\u001b\u0005A\u0019\"D\u0001\t\u00145\t\u0001\u0002D\u0017(\t\u0005A2$(\u0004\u0005\u0001!ARBA\u0003\u0002\u00115\u00016\u0001AO\u0007\t\u0001A\t$\u0004\u0002\u0006\u0003!\u001d\u0002k!\u0001\u001e\u000e\u0011\u0001\u00012G\u0007\u0003\u000b\u0005A\t\u0002U\u0002\u0002C\r)\u0011\u0001\u0003\u0004\r\u0002E\u001b\u0011\u0002B\u000e\n\u0003!]Q\"\u0001E\u000e\u001b\u0005AA#D\u0001\t\u00145nB!\u0001M\u001c;\u001b!\u0001\u0001#\r\u000e\u0005\u0015\t\u0001r\u0005)\u0004\u0001u=A\u0001\u0001\u0005\u0015\u001b\r)\u0011\u0001\u0003\u0004\r\u0002A\u001b\t!\t\u0002\u0006\u0003!I\u0011kA\u0004\u00058%\tA\u0011A\u0007\u0002\u0011Qi\u0011\u0001c\u0006.'\u0011\t\u0001\u0004HO\u0007\t\u0001A\u0019\"\u0004\u0002\u0006\u0003!E\u0001k\u0001\u0001\"\u0005\u0015\t\u0001\"C)\u0004\u000b\u0011a\u0012\"\u0001C\u0001\u001b\u0005A\u0019\",\u0016\u0005\u0003aeRT\u0003\u0003\u0001\u0011uia!B\u0001\t*%\u0019\u0011BA\u0003\u0002\u0011U\u00016\u0001AO\u0007\t\u0001AA\"\u0004\u0002\u0006\u0003!9\u0001k!\u0001\"\u0019\u0015\t\u0001\u0012F\u0005\n\u0013!)\u0011\u0001C\u0003\n\u000b\u0011\u0005\u0011bA\u0003\u0002\u0011\u0019a\t!U\u0002\b\tsI\u0011\u0001\u0003\f\u000e\u0003!1R\"\u0001\u0005\r[-!\u0011\r\u0002\r C\t)\u0011\u0001\u0003\u0004V\u0007\u0011)1\u0001B\u0010\n\u0003!5Rf\u0004\u0003a\taA\u0011EA\u0003\u0002\u0011\u001f)6\u0001C\u0003\u0004\t!I\u0011\u0001\u0003\u0005\u000e\u0007\u0011\u0001\u0013\"\u0001\u0005\t[M!\u0011\u0001G\u0007\u001e\u000e\u0011\u0001\u00012C\u0007\u0003\u000b\u0005A\t\u0002U\u0002\u0001C\t)\u0011\u0001C\u0005R\u0007\u0015!Q\"C\u0001\u0005\u00025\t\u00012CW%\t-A\n%(\u0004\u0005\u0001!MQBA\u0003\u0002\u0011]\u00016\u0001AO\b\t\u0001AA\"D\u0002\u0006\u0003!9A\u0012\u0001)\u0004\u0002\u0005JQ!\u0001\u0005\u0006\u0013\u0015!\t!C\u0002\u0006\u0003!1A\u0012\u0001G\u0001#\u000e9A\u0011I\u0005\u0002\u0011)i\u0011\u0001c\f\u000e\u0003!aQ\u0016\n\u0003\f1\u0007jj\u0001\u0002\u0001\t\u00145\u0011Q!\u0001\u0005\u0019!\u000e\u0001Qt\u0002\u0003\u0001\u00111i1!B\u0001\t\u000f1\u0005\u0001k!\u0001\"\u0013\u0015\t\u0001\"B\u0005\u0006\t\u0003I1!B\u0001\t\r1\u0005A\u0012A)\u0004\u000f\u0011\r\u0013\"\u0001\u0005\u000b\u001b\u0005A\t$D\u0001\t\u00195&Ca\u0003M#;\u001b!\u0001\u0001c\u0005\u000e\u0005\u0015\t\u0001\"\u0007)\u0004\u0001u=A\u0001\u0001\u0005\r\u001b\r)\u0011\u0001C\u0004\r\u0002A\u001b\t!I\u0005\u0006\u0003!)\u0011\"\u0002C\u0001\u0013\r)\u0011\u0001\u0003\u0004\r\u00021\u0005\u0011kA\u0004\u0005F%\t\u0001BC\u0007\u0002\u0011gi\u0011\u0001\u0003\u0007.J\u0011Y\u0001tIO\u0007\t\u0001AA%\u0004\u0002\u0006\u0003!Q\u0002k\u0001\u0001\u001e\u0010\u0011\u0001\u0001\u0002D\u0007\u0004\u000b\u0005Aq\u0001$\u0001Q\u0007\u0003\t\u0013\"B\u0001\t\u000b%)A\u0011A\u0005\u0004\u000b\u0005Aa\u0001$\u0001\r\u0002E\u001bq\u0001b\u0012\n\u0003!QQ\"\u0001E\u001b\u001b\u0005AA\",\u0013\u0005\u0017a)ST\u0002\u0003\u0001\u0011'i!!B\u0001\t7A\u001b\u0001!h\u0004\u0005\u0001!aQbA\u0003\u0002\u0011\u001da\t\u0001UB\u0001C%)\u0011\u0001C\u0003\n\u000b\u0011\u0005\u0011bA\u0003\u0002\u0011\u0019a\t\u0001$\u0001R\u0007\u001d!Q%C\u0001\t\u00155\t\u0001rG\u0007\u0002\u00111iK\u0005B\u0006\u0019Mu5A\u0001\u0001E\n\u001b\t)\u0011\u0001\u0003\u000fQ\u0007\u0001iz\u0001\u0002\u0001\t\u00195\u0019Q!\u0001\u0005\b\u0019\u0003\u00016\u0011A\u0011\n\u000b\u0005AQ!C\u0003\u0005\u0002%\u0019Q!\u0001\u0005\u0007\u0019\u0003a\t!U\u0002\b\t\u0019J\u0011\u0001\u0003\u0006\u000e\u0003!eR\"\u0001\u0005\r[\u0013\"1\u0002G\u0014\u001e\u000e\u0011\u0001\u00012C\u0007\u0003\u000b\u0005AQ\u0004U\u0002\u0001;\u001f!\u0001\u0001\u0003\u0007\u000e\u0007\u0015\t\u0001b\u0002G\u0001!\u000e\u0005\u0011%C\u0003\u0002\u0011\u0015IQ\u0001\"\u0001\n\u0007\u0015\t\u0001B\u0002G\u0001\u0019\u0003\t6a\u0002\u0003(\u0013\u0005A!\"D\u0001\t<5\t\u0001\u0002DW%\t-A\u0002&(\u0004\u0005\u0001!MQBA\u0003\u0002\u0011y\u00016\u0001AO\b\t\u0001AA\"D\u0002\u0006\u0003!9A\u0012\u0001)\u0004\u0002\u0005JQ!\u0001\u0005\u0006\u0013\u0015!\t!C\u0002\u0006\u0003!1A\u0012\u0001G\u0001#\u000e9A\u0001K\u0005\u0002\u0011)i\u0011\u0001#\u0010\u000e\u0003!aQ\u0016\n\u0003\f1%jj\u0001\u0002\u0001\t\u00145\u0011Q!\u0001\u0005 !\u000e\u0001Qt\u0002\u0003\u0001\u00111i1!B\u0001\t\u000f1\u0005\u0001k!\u0001\"\u0013\u0015\t\u0001\"B\u0005\u0006\t\u0003I1!B\u0001\t\r1\u0005A\u0012A)\u0004\u000f\u0011I\u0013\"\u0001\u0005\u000b\u001b\u0005Ay$D\u0001\t\u00195&Ca\u0003\r+;\u001b!\u0001\u0001c\u0005\u000e\u0005\u0015\t\u0001\u0002\t)\u0004\u0001u=A\u0001\u0001\u0005\r\u001b\r)\u0011\u0001C\u0004\r\u0002A\u001b\t!I\u0005\u0006\u0003!)\u0011\"\u0002C\u0001\u0013\r)\u0011\u0001\u0003\u0004\r\u00021\u0005\u0011kA\u0004\u0005U%\t\u0001BC\u0007\u0002\u0011\u0003j\u0011\u0001\u0003\u00076*\u0015\u001dB!9\u0001\u0019\u0010u5A\u0001\u0001\u0005\t\u001b\t)\u0011\u0001c\u0004Q\u0007\u0001\t#!B\u0001\t\u0006E\u001bQ\u0001b\u0004\n\u0003\u0011\u0001Q\"\u0001\u0005\t"})
public final class ConstantExpressionEvaluator
extends JetVisitor<CompileTimeConstant<? extends Object>, JetType>
implements KObject {
    public static final /* synthetic */ KClassImpl $kotlinClass;
    private final stringExpressionEvaluator.1 stringExpressionEvaluator;
    @NotNull
    private final BindingTrace trace;
    public static final object OBJECT$;

    static {
        $kotlinClass = InternalPackage.kClassFromKotlin(ConstantExpressionEvaluator.class);
        OBJECT$ = object.$init$b$0();
    }

    private final CompileTimeConstant<? extends Object> evaluate(@JetValueParameter(name="expression") JetExpression expression, @JetValueParameter(name="expectedType", type="?") JetType expectedType) {
        CompileTimeConstant recordedCompileTimeConstant = (CompileTimeConstant)this.trace.get(BindingContext.COMPILE_TIME_VALUE, expression);
        if (recordedCompileTimeConstant != null) {
            return recordedCompileTimeConstant;
        }
        JetVisitor jetVisitor = this;
        JetType jetType = expectedType;
        if (jetType == null) {
            jetType = TypeUtils.NO_EXPECTED_TYPE;
        }
        CompileTimeConstant compileTimeConstant = (CompileTimeConstant)expression.accept(jetVisitor, jetType);
        if (compileTimeConstant != null) {
            this.trace.record(BindingContext.COMPILE_TIME_VALUE, expression, compileTimeConstant);
            return compileTimeConstant;
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<? extends Object> visitConstantExpression(@JetValueParameter(name="expression") @NotNull JetConstantExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        Object object2;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "visitConstantExpression"));
        }
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        String text = expression.getText();
        if (text == null) {
            return null;
        }
        IElementType nodeElementType = expression.getNode().getElementType();
        if (Intrinsics.areEqual(nodeElementType, JetNodeTypes.NULL)) {
            return NullValue.NULL;
        }
        Object object3 = nodeElementType;
        if (Intrinsics.areEqual(object3, JetNodeTypes.INTEGER_CONSTANT)) {
            object2 = EvaluatePackage$ConstantExpressionEvaluator$a64b065f.parseLong(text);
        } else if (Intrinsics.areEqual(object3, JetNodeTypes.FLOAT_CONSTANT)) {
            object2 = EvaluatePackage$ConstantExpressionEvaluator$a64b065f.parseFloatingLiteral(text);
        } else if (Intrinsics.areEqual(object3, JetNodeTypes.BOOLEAN_CONSTANT)) {
            object2 = EvaluatePackage$ConstantExpressionEvaluator$a64b065f.parseBoolean(text);
        } else if (Intrinsics.areEqual(object3, JetNodeTypes.CHARACTER_CONSTANT)) {
            object2 = CompileTimeConstantChecker.parseChar(expression);
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported constant: " + expression);
        }
        Long result2 = object2;
        if (result2 == null) {
            return null;
        }
        object3 = new ConstantExpressionEvaluator$visitConstantExpression$1(nodeElementType, text);
        return this.createCompileTimeConstant(result2, expectedType, !((ConstantExpressionEvaluator$visitConstantExpression$1)object3).invoke(), true, false);
    }

    @Override
    @Nullable
    public CompileTimeConstant<? extends Object> visitParenthesizedExpression(@JetValueParameter(name="expression") @NotNull JetParenthesizedExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "visitParenthesizedExpression"));
        }
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        JetExpression deparenthesizedExpression = JetPsiUtil.deparenthesize(expression);
        if (deparenthesizedExpression != null ? Intrinsics.areEqual(deparenthesizedExpression, expression) ^ true : false) {
            return this.evaluate(deparenthesizedExpression, expectedType);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<? extends Object> visitLabeledExpression(@JetValueParameter(name="expression") @NotNull JetLabeledExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "visitLabeledExpression"));
        }
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        JetExpression baseExpression = expression.getBaseExpression();
        if (baseExpression != null) {
            return this.evaluate(baseExpression, expectedType);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<? extends Object> visitStringTemplateExpression(@JetValueParameter(name="expression") @NotNull JetStringTemplateExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "visitStringTemplateExpression"));
        }
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        StringBuilder sb = new StringBuilder();
        int interupted = 0;
        int canBeUsedInAnnotation = 1;
        int usesVariableAsConstant = 0;
        JetStringTemplateEntry[] jetStringTemplateEntryArray = expression.getEntries();
        for (int i = 0; i < jetStringTemplateEntryArray.length; ++i) {
            JetStringTemplateEntry entry = jetStringTemplateEntryArray[i];
            StringValue constant = this.stringExpressionEvaluator.evaluate(entry);
            if (constant == null) {
                interupted = 1;
                break;
            }
            if (!constant.canBeUsedInAnnotations()) {
                canBeUsedInAnnotation = 0;
            }
            if (constant.usesVariableAsConstant()) {
                usesVariableAsConstant = 1;
            }
            sb.append((String)constant.getValue());
        }
        return interupted == 0 ? this.createCompileTimeConstant(sb.toString(), expectedType, true, canBeUsedInAnnotation != 0, usesVariableAsConstant != 0) : (CompileTimeConstant<? extends Object>)null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<? extends Object> visitBinaryExpression(@JetValueParameter(name="expression") @NotNull JetBinaryExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "visitBinaryExpression"));
        }
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        JetExpression leftExpression = expression.getLeft();
        if (leftExpression == null) {
            return null;
        }
        IElementType operationToken = expression.getOperationToken();
        if (OperatorConventions.BOOLEAN_OPERATIONS.containsKey(operationToken)) {
            boolean bl;
            JetType booleanType = KotlinBuiltIns.getInstance().getBooleanType();
            CompileTimeConstant<? extends Object> leftConstant = this.evaluate(leftExpression, booleanType);
            if (leftConstant == null) {
                return null;
            }
            JetExpression rightExpression = expression.getRight();
            if (rightExpression == null) {
                return null;
            }
            CompileTimeConstant<? extends Object> rightConstant = this.evaluate(rightExpression, booleanType);
            if (rightConstant == null) {
                return null;
            }
            Object leftValue = leftConstant.getValue();
            Object rightValue = rightConstant.getValue();
            boolean bl2 = !(!(leftValue instanceof Boolean)) ? !(rightValue instanceof Boolean) : true;
            if (bl2) {
                return null;
            }
            IElementType iElementType = operationToken;
            if (Intrinsics.areEqual(iElementType, JetTokens.ANDAND)) {
                Object object2 = leftValue;
                if (object2 == null) {
                    throw new TypeCastException("kotlin.Any! cannot be cast to kotlin.Boolean");
                }
                if (((Boolean)object2).booleanValue()) {
                    Object object3 = rightValue;
                    if (object3 == null) {
                        throw new TypeCastException("kotlin.Any! cannot be cast to kotlin.Boolean");
                    }
                    bl = (Boolean)object3;
                } else {
                    bl = false;
                }
            } else if (Intrinsics.areEqual(iElementType, JetTokens.OROR)) {
                Object object4 = leftValue;
                if (object4 == null) {
                    throw new TypeCastException("kotlin.Any! cannot be cast to kotlin.Boolean");
                }
                if (!((Boolean)object4).booleanValue()) {
                    Object object5 = rightValue;
                    if (object5 == null) {
                        throw new TypeCastException("kotlin.Any! cannot be cast to kotlin.Boolean");
                    }
                    bl = (Boolean)object5;
                } else {
                    bl = true;
                }
            } else {
                throw (Throwable)new IllegalArgumentException("Unknown boolean operation token " + operationToken);
            }
            boolean result2 = bl;
            boolean usesVariableAsConstant = !leftConstant.usesVariableAsConstant() ? rightConstant.usesVariableAsConstant() : true;
            return this.createCompileTimeConstant(result2, expectedType, true, true, usesVariableAsConstant);
        }
        return this.evaluateCall(expression.getOperationReference(), leftExpression, expectedType);
    }

    private final CompileTimeConstant<? extends Object> evaluateCall(@JetValueParameter(name="callExpression") JetExpression callExpression, @JetValueParameter(name="receiverExpression") JetExpression receiverExpression, @JetValueParameter(name="expectedType", type="?") JetType expectedType) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage$callUtil$bbaa9fe2.getResolvedCall(callExpression, this.trace.getBindingContext());
        if (resolvedCall == null) {
            return null;
        }
        Name resultingDescriptorName = resolvedCall.getResultingDescriptor().getName();
        OperationArgument argumentForReceiver = this.createOperationArgumentForReceiver(resolvedCall, receiverExpression);
        if (argumentForReceiver == null) {
            return null;
        }
        Set<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> argumentsEntrySet = resolvedCall.getValueArguments().entrySet();
        if (argumentsEntrySet.isEmpty()) {
            Object result2 = this.evaluateUnaryAndCheck(argumentForReceiver, resultingDescriptorName.asString(), callExpression);
            if (result2 == null) {
                return null;
            }
            boolean isArgumentPure = this.isPureConstant(argumentForReceiver.getExpression());
            boolean canBeUsedInAnnotation = this.canBeUsedInAnnotation(argumentForReceiver.getExpression());
            boolean usesVariableAsConstant = this.usesVariableAsConstant(argumentForReceiver.getExpression());
            boolean isNumberConversionMethod = OperatorConventions.NUMBER_CONVERSIONS.contains(resultingDescriptorName);
            return this.createCompileTimeConstant(result2, expectedType, !isNumberConversionMethod ? isArgumentPure : false, canBeUsedInAnnotation, usesVariableAsConstant);
        }
        if (argumentsEntrySet.size() == 1) {
            Map.Entry canBeUsedInAnnotation = (Map.Entry)KotlinPackage.first((Iterable)argumentsEntrySet);
            ValueParameterDescriptor parameter = (ValueParameterDescriptor)KotlinPackage.component1(canBeUsedInAnnotation);
            ResolvedValueArgument argument = (ResolvedValueArgument)KotlinPackage.component2(canBeUsedInAnnotation);
            OperationArgument argumentForParameter = null;
            argumentForParameter = this.createOperationArgumentForFirstParameter(argument, parameter);
            if (argumentForParameter == null) {
                return null;
            }
            if (this.isDivisionByZero(resultingDescriptorName.asString(), argumentForParameter.getValue())) {
                return ErrorValue.create("Division by zero");
            }
            Object result3 = this.evaluateBinaryAndCheck(argumentForReceiver, argumentForParameter, resultingDescriptorName.asString(), callExpression);
            if (result3 == null) {
                return null;
            }
            boolean areArgumentsPure = this.isPureConstant(argumentForReceiver.getExpression()) ? this.isPureConstant(argumentForParameter.getExpression()) : false;
            boolean canBeUsedInAnnotation2 = this.canBeUsedInAnnotation(argumentForReceiver.getExpression()) ? this.canBeUsedInAnnotation(argumentForParameter.getExpression()) : false;
            boolean usesVariableAsConstant = !this.usesVariableAsConstant(argumentForReceiver.getExpression()) ? this.usesVariableAsConstant(argumentForParameter.getExpression()) : true;
            EvaluatorContext c = new EvaluatorContext(canBeUsedInAnnotation2, areArgumentsPure, usesVariableAsConstant);
            Name name = resultingDescriptorName;
            return Intrinsics.areEqual(name, OperatorConventions.COMPARE_TO) ? EvaluatePackage$ConstantExpressionEvaluator$a64b065f.createCompileTimeConstantForCompareTo(result3, callExpression, c) : (Intrinsics.areEqual(name, OperatorConventions.EQUALS) ? EvaluatePackage$ConstantExpressionEvaluator$a64b065f.createCompileTimeConstantForEquals(result3, callExpression, c) : this.createCompileTimeConstant(result3, expectedType, areArgumentsPure, canBeUsedInAnnotation2, usesVariableAsConstant));
        }
        return null;
    }

    private final boolean usesVariableAsConstant(@JetValueParameter(name="expression") JetExpression expression) {
        CompileTimeConstant compileTimeConstant = (CompileTimeConstant)this.trace.get(BindingContext.COMPILE_TIME_VALUE, expression);
        return compileTimeConstant != null ? compileTimeConstant.usesVariableAsConstant() : false;
    }

    private final boolean canBeUsedInAnnotation(@JetValueParameter(name="expression") JetExpression expression) {
        CompileTimeConstant compileTimeConstant = (CompileTimeConstant)this.trace.get(BindingContext.COMPILE_TIME_VALUE, expression);
        return compileTimeConstant != null ? compileTimeConstant.canBeUsedInAnnotations() : false;
    }

    private final boolean isPureConstant(@JetValueParameter(name="expression") JetExpression expression) {
        CompileTimeConstant compileTimeConstant = (CompileTimeConstant)this.trace.get(BindingContext.COMPILE_TIME_VALUE, expression);
        if (compileTimeConstant instanceof IntegerValueConstant) {
            return ((IntegerValueConstant)compileTimeConstant).isPure();
        }
        return false;
    }

    private final Object evaluateUnaryAndCheck(@JetValueParameter(name="receiver") OperationArgument receiver, @JetValueParameter(name="name") String name, @JetValueParameter(name="callExpression") JetExpression callExpression) {
        Pair<? extends Function1<? super Object, ? extends Object>, ? extends Function1<? super Long, ? extends Long>> functions2 = EvaluatePackage$OperationsMapGenerated$ae0dd7dd.getUnaryOperations().get(new UnaryOperationKey<Object>(receiver.getCtcType(), name));
        if (functions2 == null) {
            return null;
        }
        Pair<? extends Function1<? super Object, ? extends Object>, ? extends Function1<? super Long, ? extends Long>> pair = functions2;
        Function1<? super Object, ? extends Object> function = pair.component1();
        Function1<? super Long, ? extends Long> check = pair.component2();
        Object result2 = null;
        result2 = function.invoke(receiver.getValue());
        if (Intrinsics.areEqual(check, EvaluatePackage$OperationsMapGenerated$ae0dd7dd.getEmptyUnaryFun())) {
            return result2;
        }
        KotlinPackage.assert(EvaluatePackage$ConstantExpressionEvaluator$a64b065f.isIntegerType(receiver.getValue()), "Only integer constants should be checked for overflow");
        KotlinPackage.assert(Intrinsics.areEqual(name, "minus"), "Only negation should be checked for overflow");
        if (Intrinsics.areEqual(receiver.getValue(), result2)) {
            JetExpression jetExpression = PsiTreeUtil.getParentOfType((PsiElement)callExpression, JetExpression.class);
            if (jetExpression == null) {
                jetExpression = callExpression;
            }
            this.trace.report(Errors.INTEGER_OVERFLOW.on((JetExpression)((PsiElement)jetExpression)));
        }
        return result2;
    }

    private final Object evaluateBinaryAndCheck(@JetValueParameter(name="receiver") OperationArgument receiver, @JetValueParameter(name="parameter") OperationArgument parameter, @JetValueParameter(name="name") String name, @JetValueParameter(name="callExpression") JetExpression callExpression) {
        boolean bl;
        Object object2;
        Pair<? extends Function2<? super Object, ? super Object, ? extends Object>, ? extends Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger>> functions2 = EvaluatePackage$OperationsMapGenerated$ae0dd7dd.getBinaryOperations().get(new BinaryOperationKey<Object, Object>(receiver.getCtcType(), parameter.getCtcType(), name));
        if (functions2 == null) {
            return null;
        }
        Pair<? extends Function2<? super Object, ? super Object, ? extends Object>, ? extends Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger>> pair = functions2;
        Function2<? super Object, ? super Object, ? extends Object> function = pair.component1();
        Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger> checker = pair.component2();
        Object actualResult = null;
        try {
            object2 = function.invoke(receiver.getValue(), parameter.getValue());
        }
        catch (Exception e) {
            object2 = null;
        }
        actualResult = object2;
        if (Intrinsics.areEqual(checker, EvaluatePackage$OperationsMapGenerated$ae0dd7dd.getEmptyBinaryFun())) {
            return actualResult;
        }
        boolean bl2 = bl = EvaluatePackage$ConstantExpressionEvaluator$a64b065f.isIntegerType(receiver.getValue()) ? EvaluatePackage$ConstantExpressionEvaluator$a64b065f.isIntegerType(parameter.getValue()) : false;
        if (KotlinPackage.getASSERTIONS_ENABLED() && !bl) {
            String e = "Only integer constants should be checked for overflow";
            throw (Throwable)((Object)new AssertionError((Object)e));
        }
        ConstantExpressionEvaluator$evaluateBinaryAndCheck$2 constantExpressionEvaluator$evaluateBinaryAndCheck$2 = ConstantExpressionEvaluator$evaluateBinaryAndCheck$2.INSTANCE$;
        BigInteger resultInBigIntegers = checker.invoke((BigInteger)constantExpressionEvaluator$evaluateBinaryAndCheck$2.invoke(receiver.getValue()), (BigInteger)constantExpressionEvaluator$evaluateBinaryAndCheck$2.invoke(parameter.getValue()));
        if (Intrinsics.areEqual(constantExpressionEvaluator$evaluateBinaryAndCheck$2.invoke(actualResult), resultInBigIntegers) ^ true) {
            JetExpression jetExpression = PsiTreeUtil.getParentOfType((PsiElement)callExpression, JetExpression.class);
            if (jetExpression == null) {
                jetExpression = callExpression;
            }
            this.trace.report(Errors.INTEGER_OVERFLOW.on((JetExpression)((PsiElement)jetExpression)));
        }
        return actualResult;
    }

    private final boolean isDivisionByZero(@JetValueParameter(name="name") String name, @JetValueParameter(name="parameter", type="?") Object parameter) {
        Object v = OperatorConventions.BINARY_OPERATION_NAMES.get(JetTokens.DIV);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        if (Intrinsics.areEqual(name, ((Name)v).asString())) {
            if (EvaluatePackage$ConstantExpressionEvaluator$a64b065f.isIntegerType(parameter)) {
                Object object2 = parameter;
                if (object2 == null) {
                    throw new TypeCastException("kotlin.Any? cannot be cast to kotlin.Number");
                }
                return ((Number)object2).longValue() == (long)0;
            }
            if (!(parameter instanceof Float) ? parameter instanceof Double : true) {
                Object object3 = parameter;
                if (object3 == null) {
                    throw new TypeCastException("kotlin.Any? cannot be cast to kotlin.Number");
                }
                return ((Number)object3).doubleValue() == 0.0;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public CompileTimeConstant<? extends Object> visitUnaryExpression(@JetValueParameter(name="expression") @NotNull JetUnaryExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "visitUnaryExpression"));
        }
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        JetExpression leftExpression = expression.getBaseExpression();
        if (leftExpression == null) {
            return null;
        }
        return this.evaluateCall(expression.getOperationReference(), leftExpression, expectedType);
    }

    @Override
    @Nullable
    public CompileTimeConstant<? extends Object> visitSimpleNameExpression(@JetValueParameter(name="expression") @NotNull JetSimpleNameExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        CallableDescriptor callableDescriptor;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "visitSimpleNameExpression"));
        }
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        DeclarationDescriptor enumDescriptor = (DeclarationDescriptor)this.trace.getBindingContext().get(BindingContext.REFERENCE_TARGET, expression);
        if (enumDescriptor != null ? DescriptorUtils.isEnumEntry(enumDescriptor) : false) {
            DeclarationDescriptor declarationDescriptor = enumDescriptor;
            if (declarationDescriptor == null) {
                throw new TypeCastException("org.jetbrains.jet.lang.descriptors.DeclarationDescriptor! cannot be cast to org.jetbrains.jet.lang.descriptors.ClassDescriptor");
            }
            return new EnumValue((ClassDescriptor)declarationDescriptor, false);
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage$callUtil$bbaa9fe2.getResolvedCall(expression, this.trace.getBindingContext());
        if (resolvedCall != null && (callableDescriptor = resolvedCall.getResultingDescriptor()) instanceof VariableDescriptor) {
            Object object2;
            CompileTimeConstant<?> compileTimeConstant = ((VariableDescriptor)callableDescriptor).getCompileTimeInitializer();
            if (compileTimeConstant == null) {
                return null;
            }
            if (compileTimeConstant instanceof IntegerValueTypeConstant) {
                IntegerValueTypeConstant integerValueTypeConstant = (IntegerValueTypeConstant)compileTimeConstant;
                JetType jetType = expectedType;
                if (jetType == null) {
                    jetType = TypeUtils.NO_EXPECTED_TYPE;
                }
                object2 = integerValueTypeConstant.getValue(jetType);
            } else {
                object2 = compileTimeConstant.getValue();
            }
            Object value = object2;
            return this.createCompileTimeConstant(value, expectedType, false, OBJECT$.isPropertyCompileTimeConstant((VariableDescriptor)callableDescriptor), true);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<? extends Object> visitQualifiedExpression(@JetValueParameter(name="expression") @NotNull JetQualifiedExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "visitQualifiedExpression"));
        }
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        JetExpression selectorExpression = expression.getSelectorExpression();
        if (selectorExpression instanceof JetCallExpression) {
            JetExpression calleeExpression = ((JetCallExpression)selectorExpression).getCalleeExpression();
            if (!(calleeExpression instanceof JetSimpleNameExpression)) {
                return null;
            }
            JetExpression receiverExpression = expression.getReceiverExpression();
            return this.evaluateCall(calleeExpression, receiverExpression, expectedType);
        }
        if (selectorExpression != null) {
            return this.evaluate(selectorExpression, expectedType);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<? extends Object> visitCallExpression(@JetValueParameter(name="expression") @NotNull JetCallExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        ClassDescriptor classDescriptor;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "visitCallExpression"));
        }
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        ResolvedCall<? extends CallableDescriptor> call = CallUtilPackage$callUtil$bbaa9fe2.getResolvedCall(expression, this.trace.getBindingContext());
        if (call == null) {
            return null;
        }
        CallableDescriptor resultingDescriptor = call.getResultingDescriptor();
        if (CompileTimeConstantUtils.isArrayMethodCall(call)) {
            boolean bl;
            ArrayValue arrayValue;
            ArrayValue arrayValue2;
            List list;
            JetType jetType;
            boolean bl2;
            block10: {
                ArrayValue arrayValue3;
                ValueParameterDescriptor valueParameterDescriptor = KotlinPackage.getFirst(resultingDescriptor.getValueParameters());
                JetType jetType2 = valueParameterDescriptor != null ? valueParameterDescriptor.getVarargElementType() : null;
                if (jetType2 == null) {
                    Intrinsics.throwNpe();
                }
                JetType varargType = jetType2;
                Iterable iterable = call.getValueArguments().values();
                Iterable iterable2 = iterable;
                Collection collection2 = new ArrayList();
                Iterator iterator2 = iterable2.iterator();
                while (iterator2.hasNext()) {
                    Object t = iterator2.next();
                    ResolvedValueArgument it = (ResolvedValueArgument)t;
                    Iterable iterable3 = ConstantExpressionEvaluator.resolveArguments$b$2(this, it.getArguments(), varargType);
                    KotlinPackage.addAll(collection2, iterable3);
                }
                List arguments = (ArrayList)collection2;
                JetType jetType3 = resultingDescriptor.getReturnType();
                if (jetType3 == null) {
                    Intrinsics.throwNpe();
                }
                iterable = arguments;
                bl2 = true;
                jetType = jetType3;
                list = arguments;
                arrayValue2 = arrayValue3;
                arrayValue = arrayValue3;
                for (Collection collection2 : iterable) {
                    CompileTimeConstant it = (CompileTimeConstant)((Object)collection2);
                    if (!it.usesVariableAsConstant()) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
            boolean bl3 = bl;
            arrayValue2(list, jetType, bl2, bl3);
            return arrayValue;
        }
        if (resultingDescriptor instanceof ConstructorDescriptor && DescriptorUtils.isAnnotationClass(classDescriptor = ((ConstructorDescriptor)resultingDescriptor).getContainingDeclaration())) {
            AnnotationDescriptorImpl descriptor = new AnnotationDescriptorImpl(classDescriptor.getDefaultType(), AnnotationResolver.resolveAnnotationArguments(call, this.trace));
            return new AnnotationValue(descriptor);
        }
        if (CompileTimeConstantUtils.isJavaClassMethodCall(call)) {
            JetType jetType = resultingDescriptor.getReturnType();
            if (jetType == null) {
                Intrinsics.throwNpe();
            }
            return new JavaClassValue(jetType);
        }
        return null;
    }

    private final List<CompileTimeConstant<? extends Object>> resolveArguments(@JetValueParameter(name="valueArguments") List<? extends ValueArgument> valueArguments2, @JetValueParameter(name="expectedType") JetType expectedType) {
        ArrayList<CompileTimeConstant> constants = KotlinPackage.arrayListOf(new CompileTimeConstant[0]);
        for (ValueArgument valueArgument : valueArguments2) {
            CompileTimeConstant<? extends Object> compileTimeConstant;
            JetExpression argumentExpression = valueArgument.getArgumentExpression();
            if (!(argumentExpression != null) || !((compileTimeConstant = this.evaluate(argumentExpression, expectedType)) != null)) continue;
            constants.add(compileTimeConstant);
        }
        return constants;
    }

    @Override
    @Nullable
    public CompileTimeConstant<? extends Object> visitJetElement(@JetValueParameter(name="element") @NotNull JetElement element, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "visitJetElement"));
        }
        Intrinsics.checkParameterIsNotNull(element, "element");
        return null;
    }

    private final OperationArgument createOperationArgumentForReceiver(@JetValueParameter(name="resolvedCall") ResolvedCall<? extends CallableDescriptor> resolvedCall, @JetValueParameter(name="expression") JetExpression expression) {
        JetType receiverExpressionType = EvaluatePackage$ConstantExpressionEvaluator$a64b065f.getReceiverExpressionType(resolvedCall);
        if (receiverExpressionType == null) {
            return null;
        }
        CompileTimeType<? extends Object> receiverCompileTimeType = EvaluatePackage$ConstantExpressionEvaluator$a64b065f.getCompileTimeType(receiverExpressionType);
        if (receiverCompileTimeType == null) {
            return null;
        }
        return this.createOperationArgument(expression, receiverExpressionType, receiverCompileTimeType);
    }

    private final OperationArgument createOperationArgumentForFirstParameter(@JetValueParameter(name="argument") ResolvedValueArgument argument, @JetValueParameter(name="parameter") ValueParameterDescriptor parameter) {
        CompileTimeType<? extends Object> argumentCompileTimeType = EvaluatePackage$ConstantExpressionEvaluator$a64b065f.getCompileTimeType(parameter.getType());
        if (argumentCompileTimeType == null) {
            return null;
        }
        List<ValueArgument> arguments = argument.getArguments();
        if (KotlinPackage.getSize((Collection<? extends Object>)arguments) != 1) {
            return null;
        }
        JetExpression argumentExpression = KotlinPackage.first(arguments).getArgumentExpression();
        if (argumentExpression == null) {
            return null;
        }
        return this.createOperationArgument(argumentExpression, parameter.getType(), argumentCompileTimeType);
    }

    private final OperationArgument createOperationArgument(@JetValueParameter(name="expression") JetExpression expression, @JetValueParameter(name="expressionType") JetType expressionType, @JetValueParameter(name="compileTimeType") CompileTimeType<? extends Object> compileTimeType) {
        CompileTimeConstant<? extends Object> evaluatedConstant = this.evaluate(expression, expressionType);
        if (evaluatedConstant == null) {
            return null;
        }
        if (evaluatedConstant instanceof IntegerValueTypeConstant) {
            Number evaluationResultWithNewType = ((IntegerValueTypeConstant)evaluatedConstant).getValue(expressionType);
            return new OperationArgument(evaluationResultWithNewType, compileTimeType, expression);
        }
        Object evaluationResult = evaluatedConstant.getValue();
        if (evaluationResult == null) {
            return null;
        }
        return new OperationArgument(evaluationResult, compileTimeType, expression);
    }

    @Nullable
    public final CompileTimeConstant<? extends Object> createCompileTimeConstant(@JetValueParameter(name="value", type="?") @Nullable Object value, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType, @JetValueParameter(name="isPure") boolean isPure, @JetValueParameter(name="canBeUsedInAnnotation") boolean canBeUsedInAnnotation, @JetValueParameter(name="usesVariableAsConstant") boolean usesVariableAsConstant) {
        JetType jetType;
        EvaluatorContext c = new EvaluatorContext(canBeUsedInAnnotation, isPure, usesVariableAsConstant);
        if (isPure) {
            jetType = expectedType;
            if (jetType == null) {
                jetType = TypeUtils.NO_EXPECTED_TYPE;
            }
        } else {
            jetType = null;
        }
        return EvaluatePackage$ConstantExpressionEvaluator$a64b065f.createCompileTimeConstant(value, c, jetType);
    }

    /*
     * WARNING - void declaration
     */
    public static CompileTimeConstant createCompileTimeConstant$default(ConstantExpressionEvaluator constantExpressionEvaluator, Object object2, JetType jetType, boolean bl, boolean bl2, boolean bl3, int n) {
        int n2;
        int n3;
        int n4;
        void var6_9;
        if ((var6_9 & 4) != 0) {
            n4 = 1;
        }
        if ((var6_9 & 8) != 0) {
            n3 = 1;
        }
        if ((var6_9 & 0x10) != 0) {
            n2 = 0;
        }
        return constantExpressionEvaluator.createCompileTimeConstant(object2, jetType, n4 != 0, n3 != 0, n2 != 0);
    }

    @NotNull
    public final BindingTrace getTrace() {
        BindingTrace bindingTrace = this.trace;
        if (bindingTrace == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "getTrace"));
        }
        return bindingTrace;
    }

    private ConstantExpressionEvaluator(@JetValueParameter(name="trace") BindingTrace trace) {
        this.trace = trace;
        this.stringExpressionEvaluator = new KObject(this){
            public static final /* synthetic */ KClassImpl $kotlinClass;
            final /* synthetic */ ConstantExpressionEvaluator this$0;

            static {
                $kotlinClass = InternalPackage.kClassFromKotlin(stringExpressionEvaluator.1.class);
            }

            @Nullable
            public final StringValue evaluate(@JetValueParameter(name="entry") @NotNull JetStringTemplateEntry entry) {
                if (entry == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$stringExpressionEvaluator$1", "evaluate"));
                }
                Intrinsics.checkParameterIsNotNull(entry, "entry");
                return (StringValue)entry.accept(this, null);
            }

            @Nullable
            public StringValue visitStringTemplateEntryWithExpression(@JetValueParameter(name="entry") @NotNull JetStringTemplateEntryWithExpression entry, @JetValueParameter(name="data", type="?") @Nullable Void data2) {
                if (entry == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$stringExpressionEvaluator$1", "visitStringTemplateEntryWithExpression"));
                }
                Intrinsics.checkParameterIsNotNull(entry, "entry");
                JetExpression expression = entry.getExpression();
                if (expression == null) {
                    return null;
                }
                return EvaluatePackage$ConstantExpressionEvaluator$a64b065f.createStringConstant(ConstantExpressionEvaluator.evaluate$b$1(this.this$0, expression, KotlinBuiltIns.getInstance().getStringType()));
            }

            @NotNull
            public StringValue visitLiteralStringTemplateEntry(@JetValueParameter(name="entry") @NotNull JetLiteralStringTemplateEntry entry, @JetValueParameter(name="data", type="?") @Nullable Void data2) {
                if (entry == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$stringExpressionEvaluator$1", "visitLiteralStringTemplateEntry"));
                }
                Intrinsics.checkParameterIsNotNull(entry, "entry");
                StringValue stringValue = new StringValue(entry.getText(), true, false);
                if (stringValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$stringExpressionEvaluator$1", "visitLiteralStringTemplateEntry"));
                }
                return stringValue;
            }

            @NotNull
            public StringValue visitEscapeStringTemplateEntry(@JetValueParameter(name="entry") @NotNull JetEscapeStringTemplateEntry entry, @JetValueParameter(name="data", type="?") @Nullable Void data2) {
                if (entry == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$stringExpressionEvaluator$1", "visitEscapeStringTemplateEntry"));
                }
                Intrinsics.checkParameterIsNotNull(entry, "entry");
                StringValue stringValue = new StringValue(entry.getUnescapedValue(), true, false);
                if (stringValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$stringExpressionEvaluator$1", "visitEscapeStringTemplateEntry"));
                }
                return stringValue;
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    @Nullable
    public static final /* synthetic */ CompileTimeConstant<? extends Object> evaluate$b$1(@JetValueParameter(name="$this", type="?") ConstantExpressionEvaluator $this, @JetValueParameter(name="expression") @NotNull JetExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "evaluate$b$1"));
        }
        return $this.evaluate(expression, expectedType);
    }

    @NotNull
    public static final /* synthetic */ List<CompileTimeConstant<? extends Object>> resolveArguments$b$2(@JetValueParameter(name="$this", type="?") ConstantExpressionEvaluator $this, @JetValueParameter(name="valueArguments") @NotNull List<? extends ValueArgument> valueArguments2, @JetValueParameter(name="expectedType") @NotNull JetType expectedType) {
        if (valueArguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueArguments", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "resolveArguments$b$2"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "resolveArguments$b$2"));
        }
        List<CompileTimeConstant<? extends Object>> list = $this.resolveArguments(valueArguments2, expectedType);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "resolveArguments$b$2"));
        }
        return list;
    }

    @NotNull
    public static final /* synthetic */ ConstantExpressionEvaluator $init$b$0(@JetValueParameter(name="trace") @NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "$init$b$0"));
        }
        ConstantExpressionEvaluator constantExpressionEvaluator = new ConstantExpressionEvaluator(trace);
        if (constantExpressionEvaluator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "$init$b$0"));
        }
        return constantExpressionEvaluator;
    }

    @KotlinClass(abiVersion=18, data={"Q\u0006)qCh\u00197bgNlsN\u00196fGRlcm\u001c:.\u0007>t7\u000f^1oi\u0016C\bO]3tg&|g.\u0012<bYV\fGo\u001c:?\u0015m\u0019uN\\:uC:$X\t\u001f9sKN\u001c\u0018n\u001c8Fm\u0006dW/\u0019;pe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(b\u00016fi*!A.\u00198h\u0015!)g/\u00197vCR,'bA!os*11n\u001c;mS:T!\"\u001a=qe\u0016\u001c8/[8o\u00155QU\r^#yaJ,7o]5p]*\u0019\u0001o]5\u000b\u000bQ\u0014\u0018mY3\u000b\u0019\tKg\u000eZ5oOR\u0013\u0018mY3\u000b\u000fI,7o\u001c7wK*aQ\r\u001f9fGR,G\rV=qK*9!*\u001a;UsB,'\"\u0002;za\u0016\u001c(bE\"p[BLG.\u001a+j[\u0016\u001cuN\\:uC:$(\"C2p]N$\u0018M\u001c;t\u0015uI7\u000f\u0015:pa\u0016\u0014H/_\"p[BLG.\u001a+j[\u0016\u001cuN\\:uC:$(B\u00033fg\u000e\u0014\u0018\u000e\u001d;pe*\u0011b+\u0019:jC\ndW\rR3tGJL\u0007\u000f^8s\u0015-!Wm]2sSB$xN]:\u000b\u000f\t{w\u000e\\3b]\u0012\u000e!B\u0001\t\u0003\u0015\u0011A\u0001\u0001E\u0002\u000b\t!\t\u0001\u0003\u0002\u0006\u0005\u0011\t\u0001RA\u0003\u0003\t\u0007A1!B\u0002\u0005\u0005!\u0005A\u0002A\u0003\u0004\t\u000bA\u0001\u0001\u0004\u0001\u0006\u0003!!Qa\u0001C\u0004\u0011\u000fa\u0001!\u0002\u0002\u0005\u0004!-Qa\u0001C\u0005\u0011\u0015a\u0001!\u0002\u0002\u0005\u0004!9Qa\u0001C\u0006\u0011\u001ba\u0001!\u0002\u0002\u0005\u0004!EQa\u0001C\u0007\u0011!a\u0001!\u0002\u0002\u0005\f!MQa\u0001C\b\u0011%a\u0001!\u0002\u0002\u0005\u0010!IQA\u0001C\u0005\u0011\u0015)!\u0001b\u0003\t\u000e\u0015\u0011AQ\u0002\u0005\t\u000b\t!\u0019\u0001c\u0006\u0006\u0007\u0011U\u0001b\u0003\u0007\u0001\u000b\r!9\u0001\u0003\u0007\r\u0001\u0015\u0011AQ\u0003\u0005\f\t\r\u000fAbA\r\u0003\u000b\u0005AA!\f\u0018\u0005\u0007a\u0019QT\u0002\u0003\u0001\u0011\u0013i!!B\u0001\t\u000bA\u001b\u0001!(\u0004\u0005\u0001!1QBA\u0003\u0002\u0011\u0019\u00016\u0011AO\b\t\u0005Ay!D\u0002\u0006\u0003!9A\u0012\u0001)\u0004\u0003\u0005JQ!\u0001\u0005\t\u0013\u0015!\t!C\u0002\u0006\u0003!!A\u0012\u0001G\u0001#\u000eIAaA\u0005\u0002\u0011#i\u0011\u0001C\u0005\u000e\u0003!MQ\"\u0001\u0005\u000b[M!1\u0001\u0007\u0006\u001e\u000e\u0011\u0001\u0001RC\u0007\u0003\u000b\u0005A1\u0002U\u0002\u0001C\t)\u0011\u0001c\u0006R\u0007\u0015!!\"C\u0001\u0005\u00025\t\u0001\u0002D\u001b\u0001"})
    public static final class object
    implements KObject {
        public static final /* synthetic */ KClassImpl $kotlinClass;

        static {
            $kotlinClass = InternalPackage.kClassFromKotlin(object.class);
        }

        @Nullable
        public final CompileTimeConstant<? extends Object> evaluate(@JetValueParameter(name="expression") @NotNull JetExpression expression, @JetValueParameter(name="trace") @NotNull BindingTrace trace, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$object", "evaluate"));
            }
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$object", "evaluate"));
            }
            Intrinsics.checkParameterIsNotNull(expression, "expression");
            Intrinsics.checkParameterIsNotNull(trace, "trace");
            ConstantExpressionEvaluator evaluator = ConstantExpressionEvaluator.$init$b$0(trace);
            return ConstantExpressionEvaluator.evaluate$b$1(evaluator, expression, expectedType);
        }

        public static CompileTimeConstant evaluate$default(object object2, JetExpression jetExpression, BindingTrace bindingTrace, JetType jetType, int n) {
            if ((n & 4) != 0) {
                jetType = TypeUtils.NO_EXPECTED_TYPE;
            }
            return object2.evaluate(jetExpression, bindingTrace, jetType);
        }

        public final boolean isPropertyCompileTimeConstant(@JetValueParameter(name="descriptor") @NotNull VariableDescriptor descriptor) {
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$object", "isPropertyCompileTimeConstant"));
            }
            Intrinsics.checkParameterIsNotNull(descriptor, "descriptor");
            if (descriptor.isVar()) {
                return false;
            }
            if (!DescriptorUtils.isClassObject(descriptor.getContainingDeclaration()) ? DescriptorUtils.isStaticDeclaration(descriptor) : true) {
                JetType returnType = descriptor.getType();
                return !KotlinBuiltIns.getInstance().isPrimitiveType(returnType) ? Intrinsics.areEqual(KotlinBuiltIns.getInstance().getStringType(), returnType) : true;
            }
            return false;
        }

        private object() {
        }

        @NotNull
        public static final /* synthetic */ object $init$b$0() {
            object object2 = new object();
            if (object2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$object", "$init$b$0"));
            }
            return object2;
        }
    }

    @KotlinClass(abiVersion=18, data={"_\u0004)\tr\n]3sCRLwN\\!sOVlWM\u001c;\u000b7\r{gn\u001d;b]R,\u0005\u0010\u001d:fgNLwN\\#wC2,\u0018\r^8s\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NT1A[3u\u0015\u0011a\u0017M\\4\u000b\u0011\u00154\u0018\r\\;bi\u0016T1!\u00118z\u0015\u0019Yw\u000e\u001e7j]*1A(\u001b8jizRQA^1mk\u0016Tqa\u0019;d)f\u0004XMC\bD_6\u0004\u0018\u000e\\3US6,G+\u001f9f\u0015))\u0007\u0010\u001d:fgNLwN\u001c\u0006\u000e\u0015\u0016$X\t\u001f9sKN\u001c\u0018n\u001c8\u000b\u0007A\u001c\u0018N\u0003\u0003kCZ\f'BB(cU\u0016\u001cGO\u0003\u0006hKR\u001cEo\u0019+za\u0016TQbZ3u\u000bb\u0004(/Z:tS>t'\u0002C4fiZ\u000bG.^3k\u0015\t\u0001\"A\u0003\u0003\t\u0001A\u0019!\u0002\u0002\u0005\u0002!\u0011QA\u0001\u0003\u0002\u0011\u000b)!\u0001b\u0001\t\u0007\u0015\u0019AA\u0001E\u0001\u0019\u0001)1\u0001\"\u0002\t\u00011\u0001Q!\u0001\u0005\u0005\u000b\r!9\u0001c\u0002\r\u0001\u0015\u0019AA\u0001\u0005\u0007\u0019\u0001)!\u0001b\u0001\t\u0010\u0015\u0019A!\u0002\u0005\b\u0019\u0001)\u0011\u0001\u0003\u0005\u0006\u0005\u00111\u0001RA\u0003\u0003\t\u001bA\t\"\u0002\u0002\u0005\u0005!1QA\u0001\u0003\u0006\u0011\u001d!\u0011\u0001D\u0002\u001a\u0005\u0015\t\u0001\u0002B\u0017\u0016\t\u0001$\u00014B\u0011\t\u000b\u0005AI!C\u0003\u0005\u0002%\u0019Q!\u0001\u0005\u0005\u0019\u0003)6\u0001C\u0003\u0004\t\u0017I\u0011\u0001c\u0004\u000e\u0007\u0011I\u0011\"\u0001E\b[=!\u0001\r\u0002M\u0007C\t)\u0011\u0001c\u0003V\u0007!)1\u0001\"\u0004\n\u0003!AQb\u0001C\n\u0013\u0005A\u0001\"L\b\u0005A\u0012AR!\t\u0002\u0006\u0003!!Qk\u0001\u0005\u0006\u0007\u0011)\u0011\"\u0001\u0005\b\u001b\r!!\"C\u0001\t\u000fUnS\u0011\f\u0003d\u0002a%QT\u0002\u0003\u0001\u0011\u0015i!!B\u0001\t\tA\u001b\u0001!(\u0007\u0005\u0001!-Q\u0002C\u0003\u0002\u0011\u0013IQ\u0001\"\u0001\n\u0007\u0015\t\u0001\u0002\u0002G\u0001!\u000e\u0005QT\u0002\u0003\u0001\u0011\u001bi!!B\u0001\t\fA\u001b\u0011!\t\u0002\u0006\u0003!\u0019\u0011kA\u0005\u0005\n%\tA\u0001A\u0007\u0002\u0011\u001di\u0011\u0001c\u0004\u000e\u0003!A\u0001"})
    private static final class OperationArgument
    implements KObject {
        public static final /* synthetic */ KClassImpl $kotlinClass;
        @NotNull
        private final Object value;
        @NotNull
        private final CompileTimeType<? extends Object> ctcType;
        @NotNull
        private final JetExpression expression;

        static {
            $kotlinClass = InternalPackage.kClassFromKotlin(OperationArgument.class);
        }

        @NotNull
        public final Object getValue() {
            Object object2 = this.value;
            if (object2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$OperationArgument", "getValue"));
            }
            return object2;
        }

        @NotNull
        public final CompileTimeType<? extends Object> getCtcType() {
            CompileTimeType<? extends Object> compileTimeType = this.ctcType;
            if (compileTimeType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$OperationArgument", "getCtcType"));
            }
            return compileTimeType;
        }

        @NotNull
        public final JetExpression getExpression() {
            JetExpression jetExpression = this.expression;
            if (jetExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$OperationArgument", "getExpression"));
            }
            return jetExpression;
        }

        public OperationArgument(@JetValueParameter(name="value") @NotNull Object value, @JetValueParameter(name="ctcType") @NotNull CompileTimeType<? extends Object> ctcType, @JetValueParameter(name="expression") @NotNull JetExpression expression) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$OperationArgument", "<init>"));
            }
            if (ctcType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ctcType", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$OperationArgument", "<init>"));
            }
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$OperationArgument", "<init>"));
            }
            Intrinsics.checkParameterIsNotNull(value, "value");
            Intrinsics.checkParameterIsNotNull(ctcType, "ctcType");
            Intrinsics.checkParameterIsNotNull(expression, "expression");
            this.value = value;
            this.ctcType = ctcType;
            this.expression = expression;
        }
    }
}

