/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ConcurrentWeakValueHashMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.diagnostics.Diagnostic;
import org.jetbrains.jet.lang.diagnostics.DiagnosticFactory;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.diagnostics.Severity;
import org.jetbrains.jet.lang.psi.JetAnnotated;
import org.jetbrains.jet.lang.psi.JetAnnotationEntry;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetStubbedPsiUtil;
import org.jetbrains.jet.lang.psi.codeFragmentUtil.CodeFragmentUtilPackage;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.Diagnostics;
import org.jetbrains.jet.lang.resolve.DiagnosticsElementsCache;
import org.jetbrains.jet.lang.resolve.SimpleDiagnostics;
import org.jetbrains.jet.lang.resolve.constants.ArrayValue;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.StringValue;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class DiagnosticsWithSuppression
implements Diagnostics {
    private static final Logger LOG = Logger.getInstance(DiagnosticsWithSuppression.class);
    private final BindingContext context;
    private final Collection<Diagnostic> diagnostics;
    private final Map<JetAnnotated, Suppressor> suppressors;
    private final Condition<Diagnostic> filter;
    private final DiagnosticsElementsCache elementsCache;

    public DiagnosticsWithSuppression(@NotNull BindingContext context2, @NotNull Collection<Diagnostic> diagnostics) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression", "<init>"));
        }
        if (diagnostics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostics", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression", "<init>"));
        }
        this.suppressors = new ConcurrentWeakValueHashMap<JetAnnotated, Suppressor>();
        this.filter = new Condition<Diagnostic>(){

            @Override
            public boolean value(Diagnostic diagnostic) {
                return !DiagnosticsWithSuppression.this.isSuppressed(diagnostic);
            }
        };
        this.elementsCache = new DiagnosticsElementsCache(this);
        this.context = context2;
        this.diagnostics = diagnostics;
    }

    @Override
    @NotNull
    public Diagnostics noSuppression() {
        SimpleDiagnostics simpleDiagnostics = new SimpleDiagnostics(this.diagnostics);
        if (simpleDiagnostics == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression", "noSuppression"));
        }
        return simpleDiagnostics;
    }

    @Override
    @NotNull
    public Iterator<Diagnostic> iterator() {
        FilteringIterator filteringIterator = new FilteringIterator(this.diagnostics.iterator(), this.filter);
        if (filteringIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression", "iterator"));
        }
        return filteringIterator;
    }

    @Override
    @NotNull
    public Collection<Diagnostic> all() {
        List<Diagnostic> list = ContainerUtil.filter(this.diagnostics, this.filter);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression", "all"));
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<Diagnostic> forElement(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression", "forElement"));
        }
        Collection<Diagnostic> collection = this.elementsCache.getDiagnostics(psiElement);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression", "forElement"));
        }
        return collection;
    }

    @Override
    public boolean isEmpty() {
        return this.all().isEmpty();
    }

    private boolean isSuppressed(@NotNull Diagnostic diagnostic) {
        if (diagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression", "isSuppressed"));
        }
        PsiElement element = diagnostic.getPsiElement();
        if (DiagnosticsWithSuppression.isSuppressedForDebugger(diagnostic, element)) {
            return true;
        }
        JetAnnotated annotated = JetStubbedPsiUtil.getPsiOrStubParent(element, JetAnnotated.class, false);
        if (annotated == null) {
            return false;
        }
        return this.isSuppressedByAnnotated(diagnostic, annotated, 0);
    }

    private static boolean isSuppressedForDebugger(@NotNull Diagnostic diagnostic, @NotNull PsiElement element) {
        if (diagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression", "isSuppressedForDebugger"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression", "isSuppressedForDebugger"));
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile instanceof JetFile && CodeFragmentUtilPackage.getSkipVisibilityCheck((JetFile)containingFile)) {
            DiagnosticFactory<?> diagnosticFactory = diagnostic.getFactory();
            return diagnosticFactory == Errors.INVISIBLE_MEMBER || diagnosticFactory == Errors.INVISIBLE_REFERENCE || diagnosticFactory == Errors.INVISIBLE_SETTER;
        }
        return false;
    }

    private boolean isSuppressedByAnnotated(@NotNull Diagnostic diagnostic, @NotNull JetAnnotated annotated, int debugDepth) {
        Suppressor suppressor;
        if (diagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression", "isSuppressedByAnnotated"));
        }
        if (annotated == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotated", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression", "isSuppressedByAnnotated"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Annotated: ", annotated.getName());
            LOG.debug("Depth: ", debugDepth);
            LOG.debug("Cache size: ", this.suppressors.size(), "\n");
        }
        if ((suppressor = this.getOrCreateSuppressor(annotated)).isSuppressed(diagnostic)) {
            return true;
        }
        JetAnnotated annotatedAbove = JetStubbedPsiUtil.getPsiOrStubParent(suppressor.getAnnotatedElement(), JetAnnotated.class, true);
        if (annotatedAbove == null) {
            return false;
        }
        boolean suppressed = this.isSuppressedByAnnotated(diagnostic, annotatedAbove, debugDepth + 1);
        Suppressor suppressorAbove = this.suppressors.get(annotatedAbove);
        if (suppressorAbove != null && suppressorAbove.dominates(suppressor)) {
            this.suppressors.put(annotated, suppressorAbove);
        }
        return suppressed;
    }

    @NotNull
    private Suppressor getOrCreateSuppressor(@NotNull JetAnnotated annotated) {
        if (annotated == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotated", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression", "getOrCreateSuppressor"));
        }
        Suppressor suppressor = this.suppressors.get(annotated);
        if (suppressor == null) {
            Set<String> strings2 = this.getSuppressingStrings(annotated);
            suppressor = strings2.isEmpty() ? new EmptySuppressor(annotated) : (strings2.size() == 1 ? new SingularSuppressor(annotated, strings2.iterator().next()) : new MultiSuppressor(annotated, strings2));
            this.suppressors.put(annotated, suppressor);
        }
        Suppressor suppressor2 = suppressor;
        if (suppressor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression", "getOrCreateSuppressor"));
        }
        return suppressor2;
    }

    private Set<String> getSuppressingStrings(@NotNull JetAnnotated annotated) {
        if (annotated == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotated", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression", "getSuppressingStrings"));
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (JetAnnotationEntry annotationEntry : annotated.getAnnotationEntries()) {
            AnnotationDescriptor annotationDescriptor = this.context.get(BindingContext.ANNOTATION, annotationEntry);
            if (annotationDescriptor == null || !KotlinBuiltIns.getInstance().isSuppressAnnotation(annotationDescriptor)) continue;
            for (CompileTimeConstant<?> arrayValue : annotationDescriptor.getAllValueArguments().values()) {
                if (!(arrayValue instanceof ArrayValue)) continue;
                Iterator i$ = ((ArrayValue)arrayValue).getValue().iterator();
                while (i$.hasNext()) {
                    CompileTimeConstant value = (CompileTimeConstant)i$.next();
                    if (!(value instanceof StringValue)) continue;
                    builder.add(String.valueOf(((StringValue)value).getValue()).toLowerCase());
                }
            }
        }
        return builder.build();
    }

    public static boolean isSuppressedByStrings(@NotNull Diagnostic diagnostic, @NotNull Set<String> strings2) {
        if (diagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression", "isSuppressedByStrings"));
        }
        if (strings2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression", "isSuppressedByStrings"));
        }
        if (strings2.contains("warnings") && diagnostic.getSeverity() == Severity.WARNING) {
            return true;
        }
        return strings2.contains(diagnostic.getFactory().getName().toLowerCase());
    }

    private static class MultiSuppressor
    extends Suppressor {
        private final Set<String> strings;

        private MultiSuppressor(@NotNull JetAnnotated annotated, @NotNull Set<String> strings2) {
            if (annotated == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotated", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression$MultiSuppressor", "<init>"));
            }
            if (strings2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression$MultiSuppressor", "<init>"));
            }
            super(annotated);
            this.strings = strings2;
        }

        @Override
        public boolean isSuppressed(@NotNull Diagnostic diagnostic) {
            if (diagnostic == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression$MultiSuppressor", "isSuppressed"));
            }
            return DiagnosticsWithSuppression.isSuppressedByStrings(diagnostic, this.strings);
        }

        @Override
        public boolean dominates(@NotNull Suppressor other) {
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression$MultiSuppressor", "dominates"));
            }
            return other instanceof EmptySuppressor;
        }
    }

    private static class SingularSuppressor
    extends Suppressor {
        private final String string;

        private SingularSuppressor(@NotNull JetAnnotated annotated, @NotNull String string) {
            if (annotated == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotated", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression$SingularSuppressor", "<init>"));
            }
            if (string == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression$SingularSuppressor", "<init>"));
            }
            super(annotated);
            this.string = string;
        }

        @Override
        public boolean isSuppressed(@NotNull Diagnostic diagnostic) {
            if (diagnostic == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression$SingularSuppressor", "isSuppressed"));
            }
            return DiagnosticsWithSuppression.isSuppressedByStrings(diagnostic, ImmutableSet.of(this.string));
        }

        @Override
        public boolean dominates(@NotNull Suppressor other) {
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression$SingularSuppressor", "dominates"));
            }
            return other instanceof EmptySuppressor || other instanceof SingularSuppressor && ((SingularSuppressor)other).string.equals(this.string);
        }
    }

    private static class EmptySuppressor
    extends Suppressor {
        private EmptySuppressor(@NotNull JetAnnotated annotated) {
            if (annotated == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotated", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression$EmptySuppressor", "<init>"));
            }
            super(annotated);
        }

        @Override
        public boolean isSuppressed(@NotNull Diagnostic diagnostic) {
            if (diagnostic == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression$EmptySuppressor", "isSuppressed"));
            }
            return false;
        }

        @Override
        public boolean dominates(@NotNull Suppressor other) {
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression$EmptySuppressor", "dominates"));
            }
            return other instanceof EmptySuppressor;
        }
    }

    private static abstract class Suppressor {
        private final JetAnnotated annotated;

        protected Suppressor(@NotNull JetAnnotated annotated) {
            if (annotated == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotated", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression$Suppressor", "<init>"));
            }
            this.annotated = annotated;
        }

        @NotNull
        public JetAnnotated getAnnotatedElement() {
            JetAnnotated jetAnnotated = this.annotated;
            if (jetAnnotated == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DiagnosticsWithSuppression$Suppressor", "getAnnotatedElement"));
            }
            return jetAnnotated;
        }

        public abstract boolean isSuppressed(@NotNull Diagnostic var1);

        public abstract boolean dominates(@NotNull Suppressor var1);
    }
}

