/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.LinkedMultiMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.hash.EqualityPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Function1;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.ReadOnly;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.MemberDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetAnnotationEntry;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetModifierListOwner;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DelegationResolver;
import org.jetbrains.jet.lang.resolve.DescriptorEquivalenceForOverrides;
import org.jetbrains.jet.lang.resolve.DescriptorToSourceUtils;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.OverridingUtil;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisContext;
import org.jetbrains.jet.lang.resolve.calls.CallResolverUtil;
import org.jetbrains.jet.lang.resolve.dataClassUtils.DataClassUtilsPackage;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeProjectionImpl;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.jet.utils.HashSetUtil;

public class OverrideResolver {
    private BindingTrace trace;

    @Inject
    public void setTrace(BindingTrace trace) {
        this.trace = trace;
    }

    public void process(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/OverrideResolver", "process"));
        }
        this.generateOverridesAndDelegation(c);
        this.check(c);
    }

    public void check(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/OverrideResolver", "check"));
        }
        this.checkVisibility(c);
        this.checkOverrides(c);
        this.checkParameterOverridesForAllClasses(c);
    }

    private void generateOverridesAndDelegation(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/OverrideResolver", "generateOverridesAndDelegation"));
        }
        HashSet<ClassDescriptorWithResolutionScopes> ourClasses = new HashSet<ClassDescriptorWithResolutionScopes>(c.getAllClasses());
        HashSet<ClassifierDescriptor> processed = new HashSet<ClassifierDescriptor>();
        for (MutableClassDescriptor klass : ContainerUtil.reverse(c.getClassesTopologicalOrder())) {
            if (!ourClasses.contains(klass)) continue;
            this.generateOverridesAndDelegationInAClass(klass, processed, ourClasses);
            MutableClassDescriptor classObject = klass.getClassObjectDescriptor();
            if (classObject == null) continue;
            this.generateOverridesAndDelegationInAClass(classObject, processed, ourClasses);
        }
    }

    private void generateOverridesAndDelegationInAClass(@NotNull MutableClassDescriptor classDescriptor, @NotNull Set<ClassifierDescriptor> processed, @NotNull Set<ClassDescriptorWithResolutionScopes> classesBeingAnalyzed) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/OverrideResolver", "generateOverridesAndDelegationInAClass"));
        }
        if (processed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processed", "org/jetbrains/jet/lang/resolve/OverrideResolver", "generateOverridesAndDelegationInAClass"));
        }
        if (classesBeingAnalyzed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classesBeingAnalyzed", "org/jetbrains/jet/lang/resolve/OverrideResolver", "generateOverridesAndDelegationInAClass"));
        }
        if (!processed.add(classDescriptor)) {
            return;
        }
        for (JetType supertype : classDescriptor.getTypeConstructor().getSupertypes()) {
            ClassDescriptor superclass = (ClassDescriptor)supertype.getConstructor().getDeclarationDescriptor();
            if (!(superclass instanceof MutableClassDescriptor) || !classesBeingAnalyzed.contains(superclass)) continue;
            this.generateOverridesAndDelegationInAClass((MutableClassDescriptor)superclass, processed, classesBeingAnalyzed);
        }
        JetClassOrObject classOrObject = (JetClassOrObject)DescriptorToSourceUtils.classDescriptorToDeclaration(classDescriptor);
        if (classOrObject != null) {
            DelegationResolver.generateDelegatesInAClass(classDescriptor, this.trace, classOrObject);
        }
        this.generateOverridesInAClass(classDescriptor);
    }

    private void generateOverridesInAClass(final @NotNull MutableClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/OverrideResolver", "generateOverridesInAClass"));
        }
        List<CallableMemberDescriptor> membersFromSupertypes = OverrideResolver.getCallableMembersFromSupertypes(classDescriptor);
        MultiMap<Name, CallableMemberDescriptor> membersFromSupertypesByName = OverrideResolver.groupDescriptorsByName(membersFromSupertypes);
        MultiMap membersFromCurrentByName = OverrideResolver.groupDescriptorsByName(classDescriptor.getDeclaredCallableMembers());
        LinkedHashSet<Name> memberNames = new LinkedHashSet<Name>();
        memberNames.addAll(membersFromSupertypesByName.keySet());
        memberNames.addAll(membersFromCurrentByName.keySet());
        for (Name memberName : memberNames) {
            Collection<CallableMemberDescriptor> fromSupertypes = membersFromSupertypesByName.get(memberName);
            Collection fromCurrent = membersFromCurrentByName.get(memberName);
            OverridingUtil.generateOverridesInFunctionGroup(memberName, fromSupertypes, fromCurrent, classDescriptor, new OverridingUtil.DescriptorSink(){

                @Override
                public void addToScope(@NotNull CallableMemberDescriptor fakeOverride) {
                    if (fakeOverride == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fakeOverride", "org/jetbrains/jet/lang/resolve/OverrideResolver$1", "addToScope"));
                    }
                    if (fakeOverride instanceof PropertyDescriptor) {
                        classDescriptor.getBuilder().addPropertyDescriptor((PropertyDescriptor)fakeOverride);
                    } else if (fakeOverride instanceof SimpleFunctionDescriptor) {
                        classDescriptor.getBuilder().addFunctionDescriptor((SimpleFunctionDescriptor)fakeOverride);
                    } else {
                        throw new IllegalStateException(fakeOverride.getClass().getName());
                    }
                }

                @Override
                public void conflict(@NotNull CallableMemberDescriptor fromSuper, @NotNull CallableMemberDescriptor fromCurrent) {
                    if (fromSuper == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromSuper", "org/jetbrains/jet/lang/resolve/OverrideResolver$1", "conflict"));
                    }
                    if (fromCurrent == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromCurrent", "org/jetbrains/jet/lang/resolve/OverrideResolver$1", "conflict"));
                    }
                    JetDeclaration declaration = (JetDeclaration)DescriptorToSourceUtils.descriptorToDeclaration(fromCurrent);
                    OverrideResolver.this.trace.report(Errors.CONFLICTING_OVERLOADS.on(declaration, fromCurrent, fromCurrent.getContainingDeclaration().getName().asString()));
                }
            });
        }
        OverrideResolver.resolveUnknownVisibilities(classDescriptor.getAllCallableMembers(), this.trace);
    }

    public static void resolveUnknownVisibilities(@NotNull Collection<? extends CallableMemberDescriptor> descriptors, @NotNull BindingTrace trace) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/jet/lang/resolve/OverrideResolver", "resolveUnknownVisibilities"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/OverrideResolver", "resolveUnknownVisibilities"));
        }
        for (CallableMemberDescriptor callableMemberDescriptor : descriptors) {
            OverridingUtil.resolveUnknownVisibilityForMember(callableMemberDescriptor, OverrideResolver.createCannotInferVisibilityReporter(trace));
        }
    }

    @NotNull
    public static Function1<CallableMemberDescriptor, Unit> createCannotInferVisibilityReporter(final @NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/OverrideResolver", "createCannotInferVisibilityReporter"));
        }
        Function1<CallableMemberDescriptor, Unit> function1 = new Function1<CallableMemberDescriptor, Unit>(){

            @Override
            public Unit invoke(@NotNull CallableMemberDescriptor descriptor) {
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/OverrideResolver$2", "invoke"));
                }
                MemberDescriptor reportOn = descriptor.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE || descriptor.getKind() == CallableMemberDescriptor.Kind.DELEGATION ? DescriptorUtils.getParentOfType(descriptor, ClassDescriptor.class) : (descriptor instanceof PropertyAccessorDescriptor && ((PropertyAccessorDescriptor)descriptor).isDefault() ? ((PropertyAccessorDescriptor)descriptor).getCorrespondingProperty() : descriptor);
                PsiElement element = DescriptorToSourceUtils.descriptorToDeclaration(reportOn);
                if (element instanceof JetDeclaration) {
                    trace.report(Errors.CANNOT_INFER_VISIBILITY.on((JetDeclaration)element, descriptor));
                }
                return Unit.INSTANCE$;
            }
        };
        if (function1 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverrideResolver", "createCannotInferVisibilityReporter"));
        }
        return function1;
    }

    @NotNull
    public static <D extends CallableDescriptor> Set<D> filterOutOverridden(@NotNull Set<D> candidateSet) {
        if (candidateSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateSet", "org/jetbrains/jet/lang/resolve/OverrideResolver", "filterOutOverridden"));
        }
        Set<D> set = OverrideResolver.filterOverrides(candidateSet, Function.ID, Filtering.RETAIN_OVERRIDING);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverrideResolver", "filterOutOverridden"));
        }
        return set;
    }

    @NotNull
    public static <D> Set<D> filterOutOverriding(@NotNull Set<D> candidateSet) {
        if (candidateSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateSet", "org/jetbrains/jet/lang/resolve/OverrideResolver", "filterOutOverriding"));
        }
        Set<D> set = OverrideResolver.filterOverrides(candidateSet, Function.ID, Filtering.RETAIN_OVERRIDDEN);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverrideResolver", "filterOutOverriding"));
        }
        return set;
    }

    @NotNull
    public static <D> Set<D> filterOutOverridden(@NotNull Set<D> candidateSet, @NotNull Function<? super D, ? extends CallableDescriptor> transform) {
        if (candidateSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateSet", "org/jetbrains/jet/lang/resolve/OverrideResolver", "filterOutOverridden"));
        }
        if (transform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transform", "org/jetbrains/jet/lang/resolve/OverrideResolver", "filterOutOverridden"));
        }
        Set<? super D> set = OverrideResolver.filterOverrides(candidateSet, transform, Filtering.RETAIN_OVERRIDING);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverrideResolver", "filterOutOverridden"));
        }
        return set;
    }

    @NotNull
    private static <D> Set<D> filterOverrides(@NotNull Set<D> candidateSet, final @NotNull Function<? super D, ? extends CallableDescriptor> transform, @NotNull Filtering filtering) {
        if (candidateSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateSet", "org/jetbrains/jet/lang/resolve/OverrideResolver", "filterOverrides"));
        }
        if (transform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transform", "org/jetbrains/jet/lang/resolve/OverrideResolver", "filterOverrides"));
        }
        if (filtering == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filtering", "org/jetbrains/jet/lang/resolve/OverrideResolver", "filterOverrides"));
        }
        if (candidateSet.size() <= 1) {
            Set<D> set = candidateSet;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverrideResolver", "filterOverrides"));
            }
            return set;
        }
        Set<D> noDuplicates = HashSetUtil.linkedHashSet(candidateSet, new EqualityPolicy<D>(){

            @Override
            public int getHashCode(D d) {
                return DescriptorUtils.getFqName(((CallableDescriptor)transform.fun(d)).getContainingDeclaration()).hashCode();
            }

            @Override
            public boolean isEqual(D d1, D d2) {
                CallableDescriptor f = (CallableDescriptor)transform.fun(d1);
                CallableDescriptor g = (CallableDescriptor)transform.fun(d2);
                return DescriptorEquivalenceForOverrides.INSTANCE$.areEquivalent(f.getOriginal(), g.getOriginal());
            }
        });
        LinkedHashSet<D> candidates = Sets.newLinkedHashSet();
        block0: for (D meD : noDuplicates) {
            CallableDescriptor other;
            CallableDescriptor me = transform.fun(meD);
            for (Object otherD : noDuplicates) {
                other = transform.fun(otherD);
                if (me == other) continue;
                if (filtering == Filtering.RETAIN_OVERRIDING) {
                    if (!OverrideResolver.overrides(other, me)) continue;
                    continue block0;
                }
                if (filtering == Filtering.RETAIN_OVERRIDDEN) {
                    if (!OverrideResolver.overrides(me, other)) continue;
                    continue block0;
                }
                throw new AssertionError((Object)("Unexpected Filtering object: " + (Object)((Object)filtering)));
            }
            for (Object otherD : candidates) {
                other = transform.fun(otherD);
                if (me.getOriginal() != other.getOriginal() || OverridingUtil.DEFAULT.isOverridableBy(other, me).getResult() != OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE || OverridingUtil.DEFAULT.isOverridableBy(me, other).getResult() != OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE) continue;
                continue block0;
            }
            candidates.add(meD);
        }
        assert (!candidates.isEmpty()) : "All candidates filtered out from " + candidateSet;
        LinkedHashSet<D> linkedHashSet = candidates;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverrideResolver", "filterOverrides"));
        }
        return linkedHashSet;
    }

    public static <D extends CallableDescriptor> boolean overrides(@NotNull D f, @NotNull D g) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "org/jetbrains/jet/lang/resolve/OverrideResolver", "overrides"));
        }
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "org/jetbrains/jet/lang/resolve/OverrideResolver", "overrides"));
        }
        if (!f.equals(g) && DescriptorEquivalenceForOverrides.INSTANCE$.areEquivalent(f.getOriginal(), g.getOriginal())) {
            return true;
        }
        CallableDescriptor originalG = g.getOriginal();
        for (D overriddenFunction : OverrideResolver.getAllOverriddenDescriptors(f)) {
            if (!DescriptorEquivalenceForOverrides.INSTANCE$.areEquivalent(originalG, overriddenFunction.getOriginal())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static <D extends CallableDescriptor> Set<D> getAllOverriddenDescriptors(@NotNull D f) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "org/jetbrains/jet/lang/resolve/OverrideResolver", "getAllOverriddenDescriptors"));
        }
        LinkedHashSet result2 = new LinkedHashSet();
        OverrideResolver.collectAllOverriddenDescriptors(f.getOriginal(), result2);
        LinkedHashSet linkedHashSet = result2;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverrideResolver", "getAllOverriddenDescriptors"));
        }
        return linkedHashSet;
    }

    private static <D extends CallableDescriptor> void collectAllOverriddenDescriptors(@NotNull D current, @NotNull Set<D> result2) {
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "org/jetbrains/jet/lang/resolve/OverrideResolver", "collectAllOverriddenDescriptors"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/lang/resolve/OverrideResolver", "collectAllOverriddenDescriptors"));
        }
        if (result2.contains(current)) {
            return;
        }
        Iterator<? extends CallableDescriptor> i$ = current.getOriginal().getOverriddenDescriptors().iterator();
        while (i$.hasNext()) {
            CallableDescriptor callableDescriptor;
            CallableDescriptor descriptor = callableDescriptor = i$.next();
            OverrideResolver.collectAllOverriddenDescriptors(descriptor, result2);
            result2.add(descriptor);
        }
    }

    private static <T extends DeclarationDescriptor> MultiMap<Name, T> groupDescriptorsByName(Collection<T> properties2) {
        LinkedMultiMap<Name, DeclarationDescriptor> r = new LinkedMultiMap<Name, DeclarationDescriptor>();
        for (DeclarationDescriptor property2 : properties2) {
            r.putValue(property2.getName(), property2);
        }
        return r;
    }

    private static List<CallableMemberDescriptor> getCallableMembersFromSupertypes(ClassDescriptor classDescriptor) {
        LinkedHashSet<CallableMemberDescriptor> r = Sets.newLinkedHashSet();
        for (JetType supertype : classDescriptor.getTypeConstructor().getSupertypes()) {
            r.addAll(OverrideResolver.getCallableMembersFromType(supertype.getMemberScope()));
        }
        return new ArrayList<CallableMemberDescriptor>(r);
    }

    private static List<CallableMemberDescriptor> getCallableMembersFromType(JetScope scope) {
        ArrayList<CallableMemberDescriptor> r = Lists.newArrayList();
        for (DeclarationDescriptor decl : scope.getAllDescriptors()) {
            if (!(decl instanceof PropertyDescriptor) && !(decl instanceof SimpleFunctionDescriptor)) continue;
            r.add((CallableMemberDescriptor)decl);
        }
        return r;
    }

    private void checkOverrides(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/OverrideResolver", "checkOverrides"));
        }
        for (Map.Entry<JetClassOrObject, ClassDescriptorWithResolutionScopes> entry : c.getDeclaredClasses().entrySet()) {
            this.checkOverridesInAClass(c, entry.getValue(), entry.getKey());
        }
    }

    private void checkOverridesInAClass(@NotNull TopDownAnalysisContext c, @NotNull ClassDescriptorWithResolutionScopes classDescriptor, @NotNull JetClassOrObject klass) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/OverrideResolver", "checkOverridesInAClass"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/OverrideResolver", "checkOverridesInAClass"));
        }
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/jet/lang/resolve/OverrideResolver", "checkOverridesInAClass"));
        }
        if (c.getTopDownAnalysisParameters().isAnalyzingBootstrapLibrary()) {
            return;
        }
        for (CallableMemberDescriptor member : classDescriptor.getDeclaredCallableMembers()) {
            this.checkOverrideForMember(member);
        }
        LinkedHashSet<CallableMemberDescriptor> abstractNoImpl = Sets.newLinkedHashSet();
        LinkedHashSet<CallableMemberDescriptor> manyImpl = Sets.newLinkedHashSet();
        OverrideResolver.collectMissingImplementations(classDescriptor, abstractNoImpl, manyImpl);
        if (!manyImpl.isEmpty()) {
            this.trace.report(Errors.MANY_IMPL_MEMBER_NOT_IMPLEMENTED.on(klass, klass, (CallableMemberDescriptor)manyImpl.iterator().next()));
        }
        if (classDescriptor.getModality() != Modality.ABSTRACT && !abstractNoImpl.isEmpty()) {
            this.trace.report(Errors.ABSTRACT_MEMBER_NOT_IMPLEMENTED.on(klass, klass, (CallableMemberDescriptor)abstractNoImpl.iterator().next()));
        }
    }

    @NotNull
    public static Set<CallableMemberDescriptor> getMissingImplementations(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/OverrideResolver", "getMissingImplementations"));
        }
        LinkedHashSet<CallableMemberDescriptor> result2 = new LinkedHashSet<CallableMemberDescriptor>();
        OverrideResolver.collectMissingImplementations(classDescriptor, result2, result2);
        LinkedHashSet<CallableMemberDescriptor> linkedHashSet = result2;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverrideResolver", "getMissingImplementations"));
        }
        return linkedHashSet;
    }

    private static void collectMissingImplementations(@NotNull ClassDescriptor classDescriptor, @NotNull Set<CallableMemberDescriptor> abstractNoImpl, @NotNull Set<CallableMemberDescriptor> manyImpl) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/OverrideResolver", "collectMissingImplementations"));
        }
        if (abstractNoImpl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abstractNoImpl", "org/jetbrains/jet/lang/resolve/OverrideResolver", "collectMissingImplementations"));
        }
        if (manyImpl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manyImpl", "org/jetbrains/jet/lang/resolve/OverrideResolver", "collectMissingImplementations"));
        }
        for (DeclarationDescriptor member : classDescriptor.getDefaultType().getMemberScope().getAllDescriptors()) {
            if (!(member instanceof CallableMemberDescriptor)) continue;
            OverrideResolver.collectMissingImplementations((CallableMemberDescriptor)member, abstractNoImpl, manyImpl);
        }
    }

    private static void collectMissingImplementations(@NotNull CallableMemberDescriptor descriptor, @NotNull Set<CallableMemberDescriptor> abstractNoImpl, @NotNull Set<CallableMemberDescriptor> manyImpl) {
        List<CallableMemberDescriptor> allOverriddenDeclarations;
        Set<CallableMemberDescriptor> allFilteredOverriddenDeclarations;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/OverrideResolver", "collectMissingImplementations"));
        }
        if (abstractNoImpl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abstractNoImpl", "org/jetbrains/jet/lang/resolve/OverrideResolver", "collectMissingImplementations"));
        }
        if (manyImpl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manyImpl", "org/jetbrains/jet/lang/resolve/OverrideResolver", "collectMissingImplementations"));
        }
        if (descriptor.getKind().isReal()) {
            return;
        }
        if (descriptor.getVisibility() == Visibilities.INVISIBLE_FAKE) {
            return;
        }
        Set<? extends CallableMemberDescriptor> directOverridden = descriptor.getOverriddenDescriptors();
        if (directOverridden.size() == 0) {
            throw new IllegalStateException("A 'fake override' must override something");
        }
        Map<CallableMemberDescriptor, Set<CallableMemberDescriptor>> overriddenDeclarationsByDirectParent = OverrideResolver.collectOverriddenDeclarations(directOverridden);
        Set<CallableMemberDescriptor> relevantDirectlyOverridden = OverrideResolver.getRelevantDirectlyOverridden(overriddenDeclarationsByDirectParent, allFilteredOverriddenDeclarations = OverrideResolver.filterOutOverridden(Sets.newLinkedHashSet(allOverriddenDeclarations = ContainerUtil.flatten(overriddenDeclarationsByDirectParent.values()))));
        List<CallableMemberDescriptor> implementations = OverrideResolver.collectImplementations(relevantDirectlyOverridden);
        if (implementations.size() == 1 && OverrideResolver.isReturnTypeOkForOverride(descriptor, implementations.get(0))) {
            return;
        }
        ArrayList<CallableMemberDescriptor> abstractOverridden = new ArrayList<CallableMemberDescriptor>(allFilteredOverriddenDeclarations.size());
        ArrayList<CallableMemberDescriptor> concreteOverridden = new ArrayList<CallableMemberDescriptor>(allFilteredOverriddenDeclarations.size());
        OverrideResolver.filterNotSynthesizedDescriptorsByModality(allFilteredOverriddenDeclarations, abstractOverridden, concreteOverridden);
        if (implementations.isEmpty()) {
            abstractNoImpl.addAll(abstractOverridden);
        } else if (implementations.size() > 1) {
            manyImpl.addAll(concreteOverridden);
        } else {
            abstractNoImpl.addAll(OverrideResolver.collectAbstractMethodsWithMoreSpecificReturnType(abstractOverridden, implementations.get(0)));
        }
    }

    @NotNull
    private static List<CallableMemberDescriptor> collectImplementations(@NotNull Set<CallableMemberDescriptor> relevantDirectlyOverridden) {
        if (relevantDirectlyOverridden == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relevantDirectlyOverridden", "org/jetbrains/jet/lang/resolve/OverrideResolver", "collectImplementations"));
        }
        ArrayList<CallableMemberDescriptor> result2 = new ArrayList<CallableMemberDescriptor>(relevantDirectlyOverridden.size());
        for (CallableMemberDescriptor overriddenDescriptor : relevantDirectlyOverridden) {
            if (overriddenDescriptor.getModality() == Modality.ABSTRACT) continue;
            result2.add(overriddenDescriptor);
        }
        ArrayList<CallableMemberDescriptor> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverrideResolver", "collectImplementations"));
        }
        return arrayList;
    }

    private static void filterNotSynthesizedDescriptorsByModality(@NotNull Set<CallableMemberDescriptor> allOverriddenDeclarations, @NotNull List<CallableMemberDescriptor> abstractOverridden, @NotNull List<CallableMemberDescriptor> concreteOverridden) {
        if (allOverriddenDeclarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allOverriddenDeclarations", "org/jetbrains/jet/lang/resolve/OverrideResolver", "filterNotSynthesizedDescriptorsByModality"));
        }
        if (abstractOverridden == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abstractOverridden", "org/jetbrains/jet/lang/resolve/OverrideResolver", "filterNotSynthesizedDescriptorsByModality"));
        }
        if (concreteOverridden == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "concreteOverridden", "org/jetbrains/jet/lang/resolve/OverrideResolver", "filterNotSynthesizedDescriptorsByModality"));
        }
        for (CallableMemberDescriptor overridden : allOverriddenDeclarations) {
            if (CallResolverUtil.isOrOverridesSynthesized(overridden)) continue;
            if (overridden.getModality() == Modality.ABSTRACT) {
                abstractOverridden.add(overridden);
                continue;
            }
            concreteOverridden.add(overridden);
        }
    }

    @NotNull
    private static List<CallableMemberDescriptor> collectAbstractMethodsWithMoreSpecificReturnType(@NotNull List<CallableMemberDescriptor> abstractOverridden, @NotNull CallableMemberDescriptor implementation) {
        if (abstractOverridden == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abstractOverridden", "org/jetbrains/jet/lang/resolve/OverrideResolver", "collectAbstractMethodsWithMoreSpecificReturnType"));
        }
        if (implementation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "implementation", "org/jetbrains/jet/lang/resolve/OverrideResolver", "collectAbstractMethodsWithMoreSpecificReturnType"));
        }
        ArrayList<CallableMemberDescriptor> result2 = new ArrayList<CallableMemberDescriptor>(abstractOverridden.size());
        for (CallableMemberDescriptor abstractMember : abstractOverridden) {
            if (OverrideResolver.isReturnTypeOkForOverride(abstractMember, implementation)) continue;
            result2.add(abstractMember);
        }
        assert (!result2.isEmpty()) : "Implementation (" + implementation + ") doesn't have the most specific type, " + "but none of the other overridden methods does either: " + abstractOverridden;
        ArrayList<CallableMemberDescriptor> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverrideResolver", "collectAbstractMethodsWithMoreSpecificReturnType"));
        }
        return arrayList;
    }

    @NotNull
    private static Set<CallableMemberDescriptor> getRelevantDirectlyOverridden(@NotNull Map<CallableMemberDescriptor, Set<CallableMemberDescriptor>> overriddenByParent, @NotNull Set<CallableMemberDescriptor> allFilteredOverriddenDeclarations) {
        if (overriddenByParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overriddenByParent", "org/jetbrains/jet/lang/resolve/OverrideResolver", "getRelevantDirectlyOverridden"));
        }
        if (allFilteredOverriddenDeclarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allFilteredOverriddenDeclarations", "org/jetbrains/jet/lang/resolve/OverrideResolver", "getRelevantDirectlyOverridden"));
        }
        Iterator<Map.Entry<CallableMemberDescriptor, Set<CallableMemberDescriptor>>> iterator2 = overriddenByParent.entrySet().iterator();
        while (iterator2.hasNext()) {
            if (OverrideResolver.isRelevant(iterator2.next().getValue(), overriddenByParent.values(), allFilteredOverriddenDeclarations)) continue;
            iterator2.remove();
        }
        Set<CallableMemberDescriptor> set = overriddenByParent.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverrideResolver", "getRelevantDirectlyOverridden"));
        }
        return set;
    }

    private static boolean isRelevant(@NotNull Set<CallableMemberDescriptor> declarationSet, @NotNull Collection<Set<CallableMemberDescriptor>> allDeclarationSets, @NotNull Set<CallableMemberDescriptor> allFilteredOverriddenDeclarations) {
        if (declarationSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationSet", "org/jetbrains/jet/lang/resolve/OverrideResolver", "isRelevant"));
        }
        if (allDeclarationSets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allDeclarationSets", "org/jetbrains/jet/lang/resolve/OverrideResolver", "isRelevant"));
        }
        if (allFilteredOverriddenDeclarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allFilteredOverriddenDeclarations", "org/jetbrains/jet/lang/resolve/OverrideResolver", "isRelevant"));
        }
        for (Set<CallableMemberDescriptor> otherSet : allDeclarationSets) {
            if (otherSet == declarationSet) continue;
            if (otherSet.containsAll(declarationSet)) {
                return false;
            }
            if (!Collections.disjoint(allFilteredOverriddenDeclarations, declarationSet)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static Map<CallableMemberDescriptor, Set<CallableMemberDescriptor>> collectOverriddenDeclarations(@NotNull Collection<? extends CallableMemberDescriptor> directOverriddenDescriptors) {
        if (directOverriddenDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directOverriddenDescriptors", "org/jetbrains/jet/lang/resolve/OverrideResolver", "collectOverriddenDeclarations"));
        }
        LinkedHashMap<CallableMemberDescriptor, Set<CallableMemberDescriptor>> overriddenDeclarationsByDirectParent = Maps.newLinkedHashMap();
        for (CallableMemberDescriptor callableMemberDescriptor : directOverriddenDescriptors) {
            Set<CallableMemberDescriptor> overriddenDeclarations = OverrideResolver.getOverriddenDeclarations(callableMemberDescriptor);
            Set<CallableMemberDescriptor> filteredOverrides = OverrideResolver.filterOutOverridden(overriddenDeclarations);
            overriddenDeclarationsByDirectParent.put(callableMemberDescriptor, new LinkedHashSet<CallableMemberDescriptor>(filteredOverrides));
        }
        LinkedHashMap<CallableMemberDescriptor, Set<CallableMemberDescriptor>> linkedHashMap = overriddenDeclarationsByDirectParent;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverrideResolver", "collectOverriddenDeclarations"));
        }
        return linkedHashMap;
    }

    @NotNull
    public static Set<CallableMemberDescriptor> getOverriddenDeclarations(@NotNull CallableMemberDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/OverrideResolver", "getOverriddenDeclarations"));
        }
        LinkedHashSet<CallableMemberDescriptor> result2 = new LinkedHashSet<CallableMemberDescriptor>();
        OverrideResolver.getOverriddenDeclarations(descriptor, result2);
        LinkedHashSet<CallableMemberDescriptor> linkedHashSet = result2;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverrideResolver", "getOverriddenDeclarations"));
        }
        return linkedHashSet;
    }

    private static void getOverriddenDeclarations(@NotNull CallableMemberDescriptor descriptor, @NotNull Set<CallableMemberDescriptor> result2) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/OverrideResolver", "getOverriddenDeclarations"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/lang/resolve/OverrideResolver", "getOverriddenDeclarations"));
        }
        if (descriptor.getKind().isReal()) {
            result2.add(descriptor);
        } else {
            if (descriptor.getOverriddenDescriptors().isEmpty()) {
                throw new IllegalStateException("No overridden descriptors found for (fake override) " + descriptor);
            }
            for (CallableMemberDescriptor callableMemberDescriptor : descriptor.getOverriddenDescriptors()) {
                OverrideResolver.getOverriddenDeclarations(callableMemberDescriptor, result2);
            }
        }
    }

    private void checkOverrideForMember(final @NotNull CallableMemberDescriptor declared) {
        if (declared == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declared", "org/jetbrains/jet/lang/resolve/OverrideResolver", "checkOverrideForMember"));
        }
        if (declared.getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED) {
            if (DataClassUtilsPackage.isComponentLike(declared.getName())) {
                this.checkOverrideForComponentFunction(declared);
            }
            return;
        }
        if (declared.getKind() != CallableMemberDescriptor.Kind.DECLARATION) {
            return;
        }
        final JetNamedDeclaration member = (JetNamedDeclaration)DescriptorToSourceUtils.descriptorToDeclaration(declared);
        if (member == null) {
            throw new IllegalStateException("declared descriptor is not resolved to declaration: " + declared);
        }
        JetModifierList modifierList = member.getModifierList();
        boolean hasOverrideNode = modifierList != null && modifierList.hasModifier(JetTokens.OVERRIDE_KEYWORD);
        Set<? extends CallableMemberDescriptor> overriddenDescriptors = declared.getOverriddenDescriptors();
        if (hasOverrideNode) {
            OverrideResolver.checkOverridesForMemberMarkedOverride(declared, true, new CheckOverrideReportStrategy(){
                private boolean finalOverriddenError = false;
                private boolean typeMismatchError = false;
                private boolean kindMismatchError = false;

                @Override
                public void overridingFinalMember(@NotNull CallableMemberDescriptor overridden) {
                    if (overridden == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overridden", "org/jetbrains/jet/lang/resolve/OverrideResolver$4", "overridingFinalMember"));
                    }
                    if (!this.finalOverriddenError) {
                        this.finalOverriddenError = true;
                        OverrideResolver.this.trace.report(Errors.OVERRIDING_FINAL_MEMBER.on(member, overridden, overridden.getContainingDeclaration()));
                    }
                }

                @Override
                public void returnTypeMismatchOnOverride(@NotNull CallableMemberDescriptor overridden) {
                    if (overridden == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overridden", "org/jetbrains/jet/lang/resolve/OverrideResolver$4", "returnTypeMismatchOnOverride"));
                    }
                    if (!this.typeMismatchError) {
                        this.typeMismatchError = true;
                        OverrideResolver.this.trace.report(Errors.RETURN_TYPE_MISMATCH_ON_OVERRIDE.on(member, declared, overridden));
                    }
                }

                @Override
                public void propertyTypeMismatchOnOverride(@NotNull CallableMemberDescriptor overridden) {
                    if (overridden == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overridden", "org/jetbrains/jet/lang/resolve/OverrideResolver$4", "propertyTypeMismatchOnOverride"));
                    }
                    if (!this.typeMismatchError) {
                        this.typeMismatchError = true;
                        OverrideResolver.this.trace.report(Errors.PROPERTY_TYPE_MISMATCH_ON_OVERRIDE.on(member, declared, overridden));
                    }
                }

                @Override
                public void varOverriddenByVal(@NotNull CallableMemberDescriptor overridden) {
                    if (overridden == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overridden", "org/jetbrains/jet/lang/resolve/OverrideResolver$4", "varOverriddenByVal"));
                    }
                    if (!this.kindMismatchError) {
                        this.kindMismatchError = true;
                        OverrideResolver.this.trace.report(Errors.VAR_OVERRIDDEN_BY_VAL.on((JetProperty)member, (PropertyDescriptor)declared, (PropertyDescriptor)overridden));
                    }
                }

                @Override
                public void cannotOverrideInvisibleMember(@NotNull CallableMemberDescriptor invisibleOverridden) {
                    if (invisibleOverridden == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invisibleOverridden", "org/jetbrains/jet/lang/resolve/OverrideResolver$4", "cannotOverrideInvisibleMember"));
                    }
                    OverrideResolver.this.trace.report(Errors.CANNOT_OVERRIDE_INVISIBLE_MEMBER.on(member, declared, invisibleOverridden));
                }

                @Override
                public void nothingToOverride() {
                    OverrideResolver.this.trace.report(Errors.NOTHING_TO_OVERRIDE.on(member, declared));
                }
            });
        } else if (!overriddenDescriptors.isEmpty()) {
            CallableMemberDescriptor overridden = overriddenDescriptors.iterator().next();
            this.trace.report(Errors.VIRTUAL_MEMBER_HIDDEN.on(member, declared, overridden, overridden.getContainingDeclaration()));
        }
    }

    private static void checkOverridesForMemberMarkedOverride(@NotNull CallableMemberDescriptor declared, boolean checkIfOverridesNothing, @NotNull CheckOverrideReportStrategy reportError) {
        if (declared == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declared", "org/jetbrains/jet/lang/resolve/OverrideResolver", "checkOverridesForMemberMarkedOverride"));
        }
        if (reportError == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reportError", "org/jetbrains/jet/lang/resolve/OverrideResolver", "checkOverridesForMemberMarkedOverride"));
        }
        Set<? extends CallableMemberDescriptor> overriddenDescriptors = declared.getOverriddenDescriptors();
        for (CallableMemberDescriptor callableMemberDescriptor : overriddenDescriptors) {
            if (callableMemberDescriptor == null) continue;
            if (!callableMemberDescriptor.getModality().isOverridable()) {
                reportError.overridingFinalMember(callableMemberDescriptor);
            }
            if (declared instanceof PropertyDescriptor && !OverrideResolver.isPropertyTypeOkForOverride((PropertyDescriptor)callableMemberDescriptor, (PropertyDescriptor)declared)) {
                reportError.propertyTypeMismatchOnOverride(callableMemberDescriptor);
            } else if (!OverrideResolver.isReturnTypeOkForOverride(callableMemberDescriptor, declared)) {
                reportError.returnTypeMismatchOnOverride(callableMemberDescriptor);
            }
            if (!OverrideResolver.checkPropertyKind(callableMemberDescriptor, true) || !OverrideResolver.checkPropertyKind(declared, false)) continue;
            reportError.varOverriddenByVal(callableMemberDescriptor);
        }
        if (checkIfOverridesNothing && overriddenDescriptors.isEmpty()) {
            DeclarationDescriptor containingDeclaration = declared.getContainingDeclaration();
            assert (containingDeclaration instanceof ClassDescriptor) : "Overrides may only be resolved in a class, but " + declared + " comes from " + containingDeclaration;
            ClassDescriptor classDescriptor = (ClassDescriptor)containingDeclaration;
            CallableMemberDescriptor invisibleOverriddenDescriptor = OverrideResolver.findInvisibleOverriddenDescriptor(declared, classDescriptor);
            if (invisibleOverriddenDescriptor != null) {
                reportError.cannotOverrideInvisibleMember(invisibleOverriddenDescriptor);
            } else {
                reportError.nothingToOverride();
            }
        }
    }

    public static boolean isReturnTypeOkForOverride(@NotNull CallableDescriptor superDescriptor, @NotNull CallableDescriptor subDescriptor) {
        if (superDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superDescriptor", "org/jetbrains/jet/lang/resolve/OverrideResolver", "isReturnTypeOkForOverride"));
        }
        if (subDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subDescriptor", "org/jetbrains/jet/lang/resolve/OverrideResolver", "isReturnTypeOkForOverride"));
        }
        TypeSubstitutor typeSubstitutor = OverrideResolver.prepareTypeSubstitutor(superDescriptor, subDescriptor);
        if (typeSubstitutor == null) {
            return false;
        }
        JetType superReturnType = superDescriptor.getReturnType();
        assert (superReturnType != null);
        JetType subReturnType = subDescriptor.getReturnType();
        assert (subReturnType != null);
        JetType substitutedSuperReturnType = typeSubstitutor.substitute(superReturnType, Variance.OUT_VARIANCE);
        assert (substitutedSuperReturnType != null);
        return JetTypeChecker.DEFAULT.isSubtypeOf(subReturnType, substitutedSuperReturnType);
    }

    @Nullable
    private static TypeSubstitutor prepareTypeSubstitutor(@NotNull CallableDescriptor superDescriptor, @NotNull CallableDescriptor subDescriptor) {
        if (superDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superDescriptor", "org/jetbrains/jet/lang/resolve/OverrideResolver", "prepareTypeSubstitutor"));
        }
        if (subDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subDescriptor", "org/jetbrains/jet/lang/resolve/OverrideResolver", "prepareTypeSubstitutor"));
        }
        List<TypeParameterDescriptor> superTypeParameters = superDescriptor.getTypeParameters();
        List<TypeParameterDescriptor> subTypeParameters = subDescriptor.getTypeParameters();
        if (subTypeParameters.size() != superTypeParameters.size()) {
            return null;
        }
        HashMap<TypeConstructor, TypeProjection> substitutionContext = Maps.newHashMapWithExpectedSize(superTypeParameters.size());
        for (int i = 0; i < superTypeParameters.size(); ++i) {
            TypeParameterDescriptor superTypeParameter = superTypeParameters.get(i);
            TypeParameterDescriptor subTypeParameter = subTypeParameters.get(i);
            substitutionContext.put(superTypeParameter.getTypeConstructor(), new TypeProjectionImpl(subTypeParameter.getDefaultType()));
        }
        return TypeSubstitutor.create(substitutionContext);
    }

    public static boolean isPropertyTypeOkForOverride(@NotNull PropertyDescriptor superDescriptor, @NotNull PropertyDescriptor subDescriptor) {
        if (superDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superDescriptor", "org/jetbrains/jet/lang/resolve/OverrideResolver", "isPropertyTypeOkForOverride"));
        }
        if (subDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subDescriptor", "org/jetbrains/jet/lang/resolve/OverrideResolver", "isPropertyTypeOkForOverride"));
        }
        TypeSubstitutor typeSubstitutor = OverrideResolver.prepareTypeSubstitutor(superDescriptor, subDescriptor);
        if (typeSubstitutor == null) {
            return false;
        }
        if (!superDescriptor.isVar()) {
            return true;
        }
        JetType substitutedSuperReturnType = typeSubstitutor.substitute(superDescriptor.getType(), Variance.OUT_VARIANCE);
        assert (substitutedSuperReturnType != null);
        return JetTypeChecker.DEFAULT.equalTypes(subDescriptor.getType(), substitutedSuperReturnType);
    }

    private void checkOverrideForComponentFunction(final @NotNull CallableMemberDescriptor componentFunction) {
        if (componentFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentFunction", "org/jetbrains/jet/lang/resolve/OverrideResolver", "checkOverrideForComponentFunction"));
        }
        final JetAnnotationEntry dataAnnotation = this.findDataAnnotationForDataClass(componentFunction.getContainingDeclaration());
        OverrideResolver.checkOverridesForMemberMarkedOverride(componentFunction, false, new CheckOverrideReportStrategy(){
            private boolean overrideConflict = false;

            @Override
            public void overridingFinalMember(@NotNull CallableMemberDescriptor overridden) {
                if (overridden == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overridden", "org/jetbrains/jet/lang/resolve/OverrideResolver$5", "overridingFinalMember"));
                }
                if (!this.overrideConflict) {
                    this.overrideConflict = true;
                    OverrideResolver.this.trace.report(Errors.DATA_CLASS_OVERRIDE_CONFLICT.on(dataAnnotation, componentFunction, overridden.getContainingDeclaration()));
                }
            }

            @Override
            public void returnTypeMismatchOnOverride(@NotNull CallableMemberDescriptor overridden) {
                if (overridden == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overridden", "org/jetbrains/jet/lang/resolve/OverrideResolver$5", "returnTypeMismatchOnOverride"));
                }
                if (!this.overrideConflict) {
                    this.overrideConflict = true;
                    OverrideResolver.this.trace.report(Errors.DATA_CLASS_OVERRIDE_CONFLICT.on(dataAnnotation, componentFunction, overridden.getContainingDeclaration()));
                }
            }

            @Override
            public void propertyTypeMismatchOnOverride(@NotNull CallableMemberDescriptor overridden) {
                if (overridden == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overridden", "org/jetbrains/jet/lang/resolve/OverrideResolver$5", "propertyTypeMismatchOnOverride"));
                }
                throw new IllegalStateException("Component functions are not properties");
            }

            @Override
            public void varOverriddenByVal(@NotNull CallableMemberDescriptor overridden) {
                if (overridden == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overridden", "org/jetbrains/jet/lang/resolve/OverrideResolver$5", "varOverriddenByVal"));
                }
                throw new IllegalStateException("Component functions are not properties");
            }

            @Override
            public void cannotOverrideInvisibleMember(@NotNull CallableMemberDescriptor invisibleOverridden) {
                if (invisibleOverridden == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invisibleOverridden", "org/jetbrains/jet/lang/resolve/OverrideResolver$5", "cannotOverrideInvisibleMember"));
                }
                throw new IllegalStateException("CANNOT_OVERRIDE_INVISIBLE_MEMBER should be reported on the corresponding property");
            }

            @Override
            public void nothingToOverride() {
                throw new IllegalStateException("Component functions are OK to override nothing");
            }
        });
    }

    @NotNull
    private JetAnnotationEntry findDataAnnotationForDataClass(@NotNull DeclarationDescriptor dataClass) {
        if (dataClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataClass", "org/jetbrains/jet/lang/resolve/OverrideResolver", "findDataAnnotationForDataClass"));
        }
        ClassDescriptor stdDataClassAnnotation = KotlinBuiltIns.getInstance().getDataClassAnnotation();
        AnnotationDescriptor annotation = dataClass.getAnnotations().findAnnotation(DescriptorUtils.getFqNameSafe(stdDataClassAnnotation));
        if (annotation == null) {
            throw new IllegalStateException("No data annotation is found for data class " + dataClass);
        }
        JetAnnotationEntry jetAnnotationEntry = BindingContextUtils.getNotNull(this.trace.getBindingContext(), BindingContext.ANNOTATION_DESCRIPTOR_TO_PSI_ELEMENT, annotation);
        if (jetAnnotationEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverrideResolver", "findDataAnnotationForDataClass"));
        }
        return jetAnnotationEntry;
    }

    @Nullable
    private static CallableMemberDescriptor findInvisibleOverriddenDescriptor(@NotNull CallableMemberDescriptor declared, @NotNull ClassDescriptor declaringClass) {
        if (declared == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declared", "org/jetbrains/jet/lang/resolve/OverrideResolver", "findInvisibleOverriddenDescriptor"));
        }
        if (declaringClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaringClass", "org/jetbrains/jet/lang/resolve/OverrideResolver", "findInvisibleOverriddenDescriptor"));
        }
        for (JetType supertype : declaringClass.getTypeConstructor().getSupertypes()) {
            LinkedHashSet<CallableDescriptor> all = Sets.newLinkedHashSet();
            all.addAll(supertype.getMemberScope().getFunctions(declared.getName()));
            all.addAll(supertype.getMemberScope().getProperties(declared.getName()));
            for (CallableMemberDescriptor callableMemberDescriptor : all) {
                if (OverridingUtil.DEFAULT.isOverridableBy(callableMemberDescriptor, declared).getResult() != OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE) continue;
                if (Visibilities.isVisible(callableMemberDescriptor, declared)) {
                    throw new IllegalStateException("Descriptor " + callableMemberDescriptor + " is overridable by " + declared + " and visible but does not appear in its getOverriddenDescriptors()");
                }
                return callableMemberDescriptor;
            }
        }
        return null;
    }

    private void checkParameterOverridesForAllClasses(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/OverrideResolver", "checkParameterOverridesForAllClasses"));
        }
        for (ClassDescriptorWithResolutionScopes classDescriptor : c.getDeclaredClasses().values()) {
            for (DeclarationDescriptor member : classDescriptor.getDefaultType().getMemberScope().getAllDescriptors()) {
                if (!(member instanceof CallableMemberDescriptor)) continue;
                this.checkOverridesForParameters((CallableMemberDescriptor)member);
            }
        }
    }

    private void checkOverridesForParameters(@NotNull CallableMemberDescriptor declared) {
        JetModifierListOwner declaration;
        boolean isDeclaration;
        if (declared == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declared", "org/jetbrains/jet/lang/resolve/OverrideResolver", "checkOverridesForParameters"));
        }
        boolean bl = isDeclaration = declared.getKind() == CallableMemberDescriptor.Kind.DECLARATION;
        if (isDeclaration && (declaration = (JetModifierListOwner)DescriptorToSourceUtils.descriptorToDeclaration(declared)) != null && !declaration.hasModifier(JetTokens.OVERRIDE_KEYWORD)) {
            return;
        }
        for (ValueParameterDescriptor parameterFromSubclass : declared.getValueParameters()) {
            boolean multipleDefaultsInSuper;
            int defaultsInSuper = 0;
            for (ValueParameterDescriptor valueParameterDescriptor : parameterFromSubclass.getOverriddenDescriptors()) {
                if (!valueParameterDescriptor.declaresDefaultValue()) continue;
                ++defaultsInSuper;
            }
            boolean bl2 = multipleDefaultsInSuper = defaultsInSuper > 1;
            if (isDeclaration) {
                this.checkNameAndDefaultForDeclaredParameter(parameterFromSubclass, multipleDefaultsInSuper);
                continue;
            }
            this.checkNameAndDefaultForFakeOverrideParameter(declared, parameterFromSubclass, multipleDefaultsInSuper);
        }
    }

    private void checkNameAndDefaultForDeclaredParameter(@NotNull ValueParameterDescriptor descriptor, boolean multipleDefaultsInSuper) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/OverrideResolver", "checkNameAndDefaultForDeclaredParameter"));
        }
        JetParameter parameter = (JetParameter)DescriptorToSourceUtils.descriptorToDeclaration(descriptor);
        assert (parameter != null) : "Declaration not found for parameter: " + descriptor;
        if (descriptor.declaresDefaultValue()) {
            this.trace.report(Errors.DEFAULT_VALUE_NOT_ALLOWED_IN_OVERRIDE.on(parameter));
        }
        if (multipleDefaultsInSuper) {
            this.trace.report(Errors.MULTIPLE_DEFAULTS_INHERITED_FROM_SUPERTYPES.on(parameter, descriptor));
        }
        for (ValueParameterDescriptor valueParameterDescriptor : descriptor.getOverriddenDescriptors()) {
            if (!OverrideResolver.shouldReportParameterNameOverrideWarning(descriptor, valueParameterDescriptor)) continue;
            this.trace.report(Errors.PARAMETER_NAME_CHANGED_ON_OVERRIDE.on(parameter, (ClassDescriptor)valueParameterDescriptor.getContainingDeclaration().getContainingDeclaration(), valueParameterDescriptor));
        }
    }

    private void checkNameAndDefaultForFakeOverrideParameter(@NotNull CallableMemberDescriptor containingFunction, @NotNull ValueParameterDescriptor descriptor, boolean multipleDefaultsInSuper) {
        if (containingFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFunction", "org/jetbrains/jet/lang/resolve/OverrideResolver", "checkNameAndDefaultForFakeOverrideParameter"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/OverrideResolver", "checkNameAndDefaultForFakeOverrideParameter"));
        }
        DeclarationDescriptor containingClass = containingFunction.getContainingDeclaration();
        JetClassOrObject classElement = (JetClassOrObject)DescriptorToSourceUtils.descriptorToDeclaration(containingClass);
        assert (classElement != null) : "Declaration not found for class: " + containingClass;
        if (multipleDefaultsInSuper) {
            this.trace.report(Errors.MULTIPLE_DEFAULTS_INHERITED_FROM_SUPERTYPES_WHEN_NO_EXPLICIT_OVERRIDE.on(classElement, descriptor));
        }
        for (ValueParameterDescriptor valueParameterDescriptor : descriptor.getOverriddenDescriptors()) {
            if (!OverrideResolver.shouldReportParameterNameOverrideWarning(descriptor, valueParameterDescriptor)) continue;
            this.trace.report(Errors.DIFFERENT_NAMES_FOR_THE_SAME_PARAMETER_IN_SUPERTYPES.on(classElement, containingFunction.getOverriddenDescriptors(), valueParameterDescriptor.getIndex() + 1));
        }
    }

    private static boolean shouldReportParameterNameOverrideWarning(@NotNull ValueParameterDescriptor parameterFromSubclass, @NotNull ValueParameterDescriptor parameterFromSuperclass) {
        if (parameterFromSubclass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterFromSubclass", "org/jetbrains/jet/lang/resolve/OverrideResolver", "shouldReportParameterNameOverrideWarning"));
        }
        if (parameterFromSuperclass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterFromSuperclass", "org/jetbrains/jet/lang/resolve/OverrideResolver", "shouldReportParameterNameOverrideWarning"));
        }
        DeclarationDescriptor subFunction = parameterFromSubclass.getContainingDeclaration();
        DeclarationDescriptor superFunction = parameterFromSuperclass.getContainingDeclaration();
        return subFunction instanceof CallableDescriptor && ((CallableDescriptor)subFunction).hasStableParameterNames() && superFunction instanceof CallableDescriptor && ((CallableDescriptor)superFunction).hasStableParameterNames() && !parameterFromSuperclass.getName().equals(parameterFromSubclass.getName());
    }

    private static boolean checkPropertyKind(@NotNull CallableMemberDescriptor descriptor, boolean isVar) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/OverrideResolver", "checkPropertyKind"));
        }
        return descriptor instanceof PropertyDescriptor && ((PropertyDescriptor)descriptor).isVar() == isVar;
    }

    private void checkVisibility(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/OverrideResolver", "checkVisibility"));
        }
        for (Map.Entry<JetDeclaration, CallableMemberDescriptor> entry : c.getMembers().entrySet()) {
            this.checkVisibilityForMember(entry.getKey(), entry.getValue());
        }
    }

    private void checkVisibilityForMember(@NotNull JetDeclaration declaration, @NotNull CallableMemberDescriptor memberDescriptor) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/resolve/OverrideResolver", "checkVisibilityForMember"));
        }
        if (memberDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberDescriptor", "org/jetbrains/jet/lang/resolve/OverrideResolver", "checkVisibilityForMember"));
        }
        Visibility visibility = memberDescriptor.getVisibility();
        for (CallableMemberDescriptor callableMemberDescriptor : memberDescriptor.getOverriddenDescriptors()) {
            Integer compare = Visibilities.compare(visibility, callableMemberDescriptor.getVisibility());
            if (compare == null) {
                this.trace.report(Errors.CANNOT_CHANGE_ACCESS_PRIVILEGE.on(declaration, callableMemberDescriptor.getVisibility(), callableMemberDescriptor, callableMemberDescriptor.getContainingDeclaration()));
                return;
            }
            if (compare >= 0) continue;
            this.trace.report(Errors.CANNOT_WEAKEN_ACCESS_PRIVILEGE.on(declaration, callableMemberDescriptor.getVisibility(), callableMemberDescriptor, callableMemberDescriptor.getContainingDeclaration()));
            return;
        }
    }

    @NotNull
    public static <D extends CallableMemberDescriptor> Set<D> getDirectlyOverriddenDeclarations(@NotNull D descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/OverrideResolver", "getDirectlyOverriddenDeclarations"));
        }
        HashSet<CallableMemberDescriptor> result2 = Sets.newHashSet();
        Set<? extends CallableMemberDescriptor> overriddenDescriptors = descriptor.getOverriddenDescriptors();
        for (CallableMemberDescriptor callableMemberDescriptor : overriddenDescriptors) {
            CallableMemberDescriptor.Kind kind = callableMemberDescriptor.getKind();
            if (kind == CallableMemberDescriptor.Kind.DECLARATION) {
                result2.add(callableMemberDescriptor);
                continue;
            }
            if (kind == CallableMemberDescriptor.Kind.FAKE_OVERRIDE || kind == CallableMemberDescriptor.Kind.DELEGATION) {
                result2.addAll(OverrideResolver.getDirectlyOverriddenDeclarations(callableMemberDescriptor));
                continue;
            }
            if (kind != CallableMemberDescriptor.Kind.SYNTHESIZED) {
                throw new AssertionError((Object)("Unexpected callable kind " + (Object)((Object)kind)));
            }
        }
        Set set = OverrideResolver.filterOutOverridden(result2);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverrideResolver", "getDirectlyOverriddenDeclarations"));
        }
        return set;
    }

    @NotNull
    public static <D extends CallableMemberDescriptor> Set<D> getAllOverriddenDeclarations(@NotNull D memberDescriptor) {
        if (memberDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberDescriptor", "org/jetbrains/jet/lang/resolve/OverrideResolver", "getAllOverriddenDeclarations"));
        }
        HashSet<CallableMemberDescriptor> result2 = Sets.newHashSet();
        for (CallableMemberDescriptor callableMemberDescriptor : memberDescriptor.getOverriddenDescriptors()) {
            CallableMemberDescriptor.Kind kind = callableMemberDescriptor.getKind();
            if (kind == CallableMemberDescriptor.Kind.DECLARATION) {
                result2.add(callableMemberDescriptor);
            } else if (kind != CallableMemberDescriptor.Kind.DELEGATION && kind != CallableMemberDescriptor.Kind.FAKE_OVERRIDE && kind != CallableMemberDescriptor.Kind.SYNTHESIZED) {
                throw new AssertionError((Object)("Unexpected callable kind " + (Object)((Object)kind)));
            }
            result2.addAll(OverrideResolver.getAllOverriddenDeclarations(callableMemberDescriptor));
        }
        HashSet<CallableMemberDescriptor> hashSet = result2;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverrideResolver", "getAllOverriddenDeclarations"));
        }
        return hashSet;
    }

    @NotNull
    @ReadOnly
    public static <D extends CallableMemberDescriptor> Set<D> getDeepestSuperDeclarations(@NotNull D functionDescriptor) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/lang/resolve/OverrideResolver", "getDeepestSuperDeclarations"));
        }
        Set<D> overriddenDeclarations = OverrideResolver.getAllOverriddenDeclarations(functionDescriptor);
        if (overriddenDeclarations.isEmpty()) {
            Set<D> set = Collections.singleton(functionDescriptor);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverrideResolver", "getDeepestSuperDeclarations"));
            }
            return set;
        }
        Set<D> set = OverrideResolver.filterOutOverriding(overriddenDeclarations);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverrideResolver", "getDeepestSuperDeclarations"));
        }
        return set;
    }

    private static interface CheckOverrideReportStrategy {
        public void overridingFinalMember(@NotNull CallableMemberDescriptor var1);

        public void returnTypeMismatchOnOverride(@NotNull CallableMemberDescriptor var1);

        public void propertyTypeMismatchOnOverride(@NotNull CallableMemberDescriptor var1);

        public void varOverriddenByVal(@NotNull CallableMemberDescriptor var1);

        public void cannotOverrideInvisibleMember(@NotNull CallableMemberDescriptor var1);

        public void nothingToOverride();
    }

    private static enum Filtering {
        RETAIN_OVERRIDING,
        RETAIN_OVERRIDDEN;

    }
}

