/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.ServiceLoader;
import java.util.Set;
import kotlin.Function1;
import kotlin.KotlinPackage;
import kotlin.Unit;
import kotlin.jvm.KotlinSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.impl.FunctionDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.PropertyAccessorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.jet.lang.resolve.ExternalOverridabilityCondition;
import org.jetbrains.jet.lang.resolve.VisibilityUtil;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.utils.DFS;

public class OverridingUtil {
    private static final List<ExternalOverridabilityCondition> EXTERNAL_CONDITIONS = KotlinPackage.toList(ServiceLoader.load(ExternalOverridabilityCondition.class, ExternalOverridabilityCondition.class.getClassLoader()));
    public static final OverridingUtil DEFAULT = new OverridingUtil(new JetTypeChecker.TypeConstructorEquality(){

        @Override
        public boolean equals(@NotNull TypeConstructor a, @NotNull TypeConstructor b) {
            if (a == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "org/jetbrains/jet/lang/resolve/OverridingUtil$1", "equals"));
            }
            if (b == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "org/jetbrains/jet/lang/resolve/OverridingUtil$1", "equals"));
            }
            return a.equals(b);
        }
    });
    private final JetTypeChecker.TypeConstructorEquality equalityAxioms;

    @NotNull
    public static OverridingUtil createWithEqualityAxioms(@NotNull JetTypeChecker.TypeConstructorEquality equalityAxioms) {
        if (equalityAxioms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "equalityAxioms", "org/jetbrains/jet/lang/resolve/OverridingUtil", "createWithEqualityAxioms"));
        }
        OverridingUtil overridingUtil2 = new OverridingUtil(equalityAxioms);
        if (overridingUtil2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil", "createWithEqualityAxioms"));
        }
        return overridingUtil2;
    }

    private OverridingUtil(JetTypeChecker.TypeConstructorEquality axioms) {
        this.equalityAxioms = axioms;
    }

    @NotNull
    public OverrideCompatibilityInfo isOverridableBy(@NotNull CallableDescriptor superDescriptor, @NotNull CallableDescriptor subDescriptor) {
        if (superDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superDescriptor", "org/jetbrains/jet/lang/resolve/OverridingUtil", "isOverridableBy"));
        }
        if (subDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subDescriptor", "org/jetbrains/jet/lang/resolve/OverridingUtil", "isOverridableBy"));
        }
        OverrideCompatibilityInfo overrideCompatibilityInfo = this.isOverridableBy(superDescriptor, subDescriptor, false);
        if (overrideCompatibilityInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil", "isOverridableBy"));
        }
        return overrideCompatibilityInfo;
    }

    @NotNull
    public OverrideCompatibilityInfo isOverridableByIncludingReturnType(@NotNull CallableDescriptor superDescriptor, @NotNull CallableDescriptor subDescriptor) {
        if (superDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superDescriptor", "org/jetbrains/jet/lang/resolve/OverridingUtil", "isOverridableByIncludingReturnType"));
        }
        if (subDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subDescriptor", "org/jetbrains/jet/lang/resolve/OverridingUtil", "isOverridableByIncludingReturnType"));
        }
        OverrideCompatibilityInfo overrideCompatibilityInfo = this.isOverridableBy(superDescriptor, subDescriptor, true);
        if (overrideCompatibilityInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil", "isOverridableByIncludingReturnType"));
        }
        return overrideCompatibilityInfo;
    }

    @NotNull
    private OverrideCompatibilityInfo isOverridableBy(@NotNull CallableDescriptor superDescriptor, @NotNull CallableDescriptor subDescriptor, boolean checkReturnType) {
        int i;
        if (superDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superDescriptor", "org/jetbrains/jet/lang/resolve/OverridingUtil", "isOverridableBy"));
        }
        if (subDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subDescriptor", "org/jetbrains/jet/lang/resolve/OverridingUtil", "isOverridableBy"));
        }
        if (superDescriptor instanceof FunctionDescriptor) {
            if (!(subDescriptor instanceof FunctionDescriptor)) {
                OverrideCompatibilityInfo overrideCompatibilityInfo = OverrideCompatibilityInfo.memberKindMismatch();
                if (overrideCompatibilityInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil", "isOverridableBy"));
                }
                return overrideCompatibilityInfo;
            }
        } else if (superDescriptor instanceof PropertyDescriptor) {
            if (!(subDescriptor instanceof PropertyDescriptor)) {
                OverrideCompatibilityInfo overrideCompatibilityInfo = OverrideCompatibilityInfo.memberKindMismatch();
                if (overrideCompatibilityInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil", "isOverridableBy"));
                }
                return overrideCompatibilityInfo;
            }
        } else {
            throw new IllegalArgumentException("This type of CallableDescriptor cannot be checked for overridability: " + superDescriptor);
        }
        if (!superDescriptor.getName().equals(subDescriptor.getName())) {
            OverrideCompatibilityInfo overrideCompatibilityInfo = OverrideCompatibilityInfo.nameMismatch();
            if (overrideCompatibilityInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil", "isOverridableBy"));
            }
            return overrideCompatibilityInfo;
        }
        OverrideCompatibilityInfo receiverAndParameterResult = OverridingUtil.checkReceiverAndParameterCount(superDescriptor, subDescriptor);
        if (receiverAndParameterResult != null) {
            OverrideCompatibilityInfo overrideCompatibilityInfo = receiverAndParameterResult;
            if (overrideCompatibilityInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil", "isOverridableBy"));
            }
            return overrideCompatibilityInfo;
        }
        List<JetType> superValueParameters = OverridingUtil.compiledValueParameters(superDescriptor);
        List<JetType> subValueParameters = OverridingUtil.compiledValueParameters(subDescriptor);
        List<TypeParameterDescriptor> superTypeParameters = superDescriptor.getTypeParameters();
        List<TypeParameterDescriptor> subTypeParameters = subDescriptor.getTypeParameters();
        if (superTypeParameters.size() != subTypeParameters.size()) {
            for (int i2 = 0; i2 < superValueParameters.size(); ++i2) {
                JetType subValueParameterType;
                JetType superValueParameterType = OverridingUtil.getUpperBound(superValueParameters.get(i2));
                if (JetTypeChecker.DEFAULT.equalTypes(superValueParameterType, subValueParameterType = OverridingUtil.getUpperBound(subValueParameters.get(i2)))) continue;
                OverrideCompatibilityInfo overrideCompatibilityInfo = OverrideCompatibilityInfo.typeParameterNumberMismatch();
                if (overrideCompatibilityInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil", "isOverridableBy"));
                }
                return overrideCompatibilityInfo;
            }
            OverrideCompatibilityInfo overrideCompatibilityInfo = OverrideCompatibilityInfo.valueParameterTypeMismatch(null, null, OverrideCompatibilityInfo.Result.CONFLICT);
            if (overrideCompatibilityInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil", "isOverridableBy"));
            }
            return overrideCompatibilityInfo;
        }
        final HashMap<TypeConstructor, TypeConstructor> matchingTypeConstructors = new HashMap<TypeConstructor, TypeConstructor>();
        int typeParametersSize = superTypeParameters.size();
        for (int i3 = 0; i3 < typeParametersSize; ++i3) {
            TypeParameterDescriptor superTypeParameter = superTypeParameters.get(i3);
            TypeParameterDescriptor subTypeParameter = subTypeParameters.get(i3);
            matchingTypeConstructors.put(superTypeParameter.getTypeConstructor(), subTypeParameter.getTypeConstructor());
        }
        JetTypeChecker.TypeConstructorEquality localEqualityAxioms = new JetTypeChecker.TypeConstructorEquality(){

            @Override
            public boolean equals(@NotNull TypeConstructor a, @NotNull TypeConstructor b) {
                if (a == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "org/jetbrains/jet/lang/resolve/OverridingUtil$2", "equals"));
                }
                if (b == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "org/jetbrains/jet/lang/resolve/OverridingUtil$2", "equals"));
                }
                if (OverridingUtil.this.equalityAxioms.equals(a, b)) {
                    return true;
                }
                TypeConstructor img1 = (TypeConstructor)matchingTypeConstructors.get(a);
                TypeConstructor img2 = (TypeConstructor)matchingTypeConstructors.get(b);
                return img1 != null && img1.equals(b) || img2 != null && img2.equals(a);
            }
        };
        int typeParametersSize2 = superTypeParameters.size();
        for (i = 0; i < typeParametersSize2; ++i) {
            TypeParameterDescriptor superTypeParameter = superTypeParameters.get(i);
            TypeParameterDescriptor subTypeParameter = subTypeParameters.get(i);
            if (OverridingUtil.areTypesEquivalent(superTypeParameter.getUpperBoundsAsType(), subTypeParameter.getUpperBoundsAsType(), localEqualityAxioms)) continue;
            OverrideCompatibilityInfo overrideCompatibilityInfo = OverrideCompatibilityInfo.boundsMismatch(superTypeParameter, subTypeParameter);
            if (overrideCompatibilityInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil", "isOverridableBy"));
            }
            return overrideCompatibilityInfo;
        }
        int unsubstitutedValueParametersSize = superValueParameters.size();
        for (i = 0; i < unsubstitutedValueParametersSize; ++i) {
            JetType subValueParameter;
            JetType superValueParameter = superValueParameters.get(i);
            if (OverridingUtil.areTypesEquivalent(superValueParameter, subValueParameter = subValueParameters.get(i), localEqualityAxioms)) continue;
            OverrideCompatibilityInfo overrideCompatibilityInfo = OverrideCompatibilityInfo.valueParameterTypeMismatch(superValueParameter, subValueParameter, OverrideCompatibilityInfo.Result.INCOMPATIBLE);
            if (overrideCompatibilityInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil", "isOverridableBy"));
            }
            return overrideCompatibilityInfo;
        }
        if (checkReturnType) {
            JetType superReturnType = superDescriptor.getReturnType();
            JetType subReturnType = subDescriptor.getReturnType();
            if (superReturnType != null && subReturnType != null) {
                boolean bothErrors;
                boolean bl = bothErrors = subReturnType.isError() && superReturnType.isError();
                if (!bothErrors && !JetTypeChecker.withAxioms(localEqualityAxioms).isSubtypeOf(subReturnType, superReturnType)) {
                    OverrideCompatibilityInfo overrideCompatibilityInfo = OverrideCompatibilityInfo.returnTypeMismatch(superReturnType, subReturnType);
                    if (overrideCompatibilityInfo == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil", "isOverridableBy"));
                    }
                    return overrideCompatibilityInfo;
                }
            }
        }
        for (ExternalOverridabilityCondition externalCondition : EXTERNAL_CONDITIONS) {
            if (externalCondition.isOverridable(superDescriptor, subDescriptor)) continue;
            OverrideCompatibilityInfo overrideCompatibilityInfo = OverrideCompatibilityInfo.externalConditionFailed(externalCondition.getClass());
            if (overrideCompatibilityInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil", "isOverridableBy"));
            }
            return overrideCompatibilityInfo;
        }
        OverrideCompatibilityInfo overrideCompatibilityInfo = OverrideCompatibilityInfo.success();
        if (overrideCompatibilityInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil", "isOverridableBy"));
        }
        return overrideCompatibilityInfo;
    }

    @Nullable
    static OverrideCompatibilityInfo checkReceiverAndParameterCount(CallableDescriptor superDescriptor, CallableDescriptor subDescriptor) {
        if (superDescriptor.getReceiverParameter() == null != (subDescriptor.getReceiverParameter() == null)) {
            return OverrideCompatibilityInfo.receiverPresenceMismatch();
        }
        if (superDescriptor.getValueParameters().size() != subDescriptor.getValueParameters().size()) {
            return OverrideCompatibilityInfo.valueParameterNumberMismatch();
        }
        return null;
    }

    private static boolean areTypesEquivalent(@NotNull JetType typeInSuper, @NotNull JetType typeInSub, @NotNull JetTypeChecker.TypeConstructorEquality axioms) {
        boolean bothErrors;
        if (typeInSuper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeInSuper", "org/jetbrains/jet/lang/resolve/OverridingUtil", "areTypesEquivalent"));
        }
        if (typeInSub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeInSub", "org/jetbrains/jet/lang/resolve/OverridingUtil", "areTypesEquivalent"));
        }
        if (axioms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "axioms", "org/jetbrains/jet/lang/resolve/OverridingUtil", "areTypesEquivalent"));
        }
        boolean bl = bothErrors = typeInSuper.isError() && typeInSub.isError();
        return bothErrors || JetTypeChecker.withAxioms(axioms).equalTypes(typeInSuper, typeInSub);
    }

    static List<JetType> compiledValueParameters(CallableDescriptor callableDescriptor) {
        ReceiverParameterDescriptor receiverParameter = callableDescriptor.getReceiverParameter();
        ArrayList<JetType> parameters = new ArrayList<JetType>();
        if (receiverParameter != null) {
            parameters.add(receiverParameter.getType());
        }
        for (ValueParameterDescriptor valueParameterDescriptor : callableDescriptor.getValueParameters()) {
            parameters.add(valueParameterDescriptor.getType());
        }
        return parameters;
    }

    static JetType getUpperBound(JetType type) {
        if (type.getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor) {
            return type;
        }
        if (type.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
            return ((TypeParameterDescriptor)type.getConstructor().getDeclarationDescriptor()).getUpperBoundsAsType();
        }
        throw new IllegalStateException("unknown type constructor: " + type.getConstructor().getClass().getName());
    }

    public static void bindOverride(CallableMemberDescriptor fromCurrent, CallableMemberDescriptor fromSupertype) {
        fromCurrent.addOverriddenDescriptor(fromSupertype);
        for (ValueParameterDescriptor parameterFromCurrent : fromCurrent.getValueParameters()) {
            assert (parameterFromCurrent.getIndex() < fromSupertype.getValueParameters().size()) : "An override relation between functions implies that they have the same number of value parameters";
            ValueParameterDescriptor parameterFromSupertype = fromSupertype.getValueParameters().get(parameterFromCurrent.getIndex());
            parameterFromCurrent.addOverriddenDescriptor(parameterFromSupertype);
        }
    }

    public static void generateOverridesInFunctionGroup(@NotNull Name name, @NotNull Collection<? extends CallableMemberDescriptor> membersFromSupertypes, @NotNull Collection<? extends CallableMemberDescriptor> membersFromCurrent, @NotNull ClassDescriptor current, @NotNull DescriptorSink sink) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/OverridingUtil", "generateOverridesInFunctionGroup"));
        }
        if (membersFromSupertypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "membersFromSupertypes", "org/jetbrains/jet/lang/resolve/OverridingUtil", "generateOverridesInFunctionGroup"));
        }
        if (membersFromCurrent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "membersFromCurrent", "org/jetbrains/jet/lang/resolve/OverridingUtil", "generateOverridesInFunctionGroup"));
        }
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "org/jetbrains/jet/lang/resolve/OverridingUtil", "generateOverridesInFunctionGroup"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "org/jetbrains/jet/lang/resolve/OverridingUtil", "generateOverridesInFunctionGroup"));
        }
        LinkedHashSet<CallableMemberDescriptor> notOverridden = new LinkedHashSet<CallableMemberDescriptor>(membersFromSupertypes);
        for (CallableMemberDescriptor callableMemberDescriptor : membersFromCurrent) {
            Collection<CallableMemberDescriptor> bound = OverridingUtil.extractAndBindOverridesForMember(callableMemberDescriptor, membersFromSupertypes, current, sink);
            notOverridden.removeAll(bound);
        }
        OverridingUtil.createAndBindFakeOverrides(current, notOverridden, sink);
    }

    private static Collection<CallableMemberDescriptor> extractAndBindOverridesForMember(@NotNull CallableMemberDescriptor fromCurrent, @NotNull Collection<? extends CallableMemberDescriptor> descriptorsFromSuper, @NotNull ClassDescriptor current, @NotNull DescriptorSink sink) {
        if (fromCurrent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromCurrent", "org/jetbrains/jet/lang/resolve/OverridingUtil", "extractAndBindOverridesForMember"));
        }
        if (descriptorsFromSuper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorsFromSuper", "org/jetbrains/jet/lang/resolve/OverridingUtil", "extractAndBindOverridesForMember"));
        }
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "org/jetbrains/jet/lang/resolve/OverridingUtil", "extractAndBindOverridesForMember"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "org/jetbrains/jet/lang/resolve/OverridingUtil", "extractAndBindOverridesForMember"));
        }
        ArrayList<CallableMemberDescriptor> bound = new ArrayList<CallableMemberDescriptor>(descriptorsFromSuper.size());
        for (CallableMemberDescriptor callableMemberDescriptor : descriptorsFromSuper) {
            OverrideCompatibilityInfo.Result result2 = DEFAULT.isOverridableBy(callableMemberDescriptor, fromCurrent).getResult();
            boolean isVisible = Visibilities.isVisible(callableMemberDescriptor, current);
            switch (result2) {
                case OVERRIDABLE: {
                    if (isVisible) {
                        OverridingUtil.bindOverride(fromCurrent, callableMemberDescriptor);
                    }
                    bound.add(callableMemberDescriptor);
                    break;
                }
                case CONFLICT: {
                    if (isVisible) {
                        sink.conflict(callableMemberDescriptor, fromCurrent);
                    }
                    bound.add(callableMemberDescriptor);
                    break;
                }
            }
        }
        return bound;
    }

    private static void createAndBindFakeOverrides(@NotNull ClassDescriptor current, @NotNull Collection<CallableMemberDescriptor> notOverridden, @NotNull DescriptorSink sink) {
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "org/jetbrains/jet/lang/resolve/OverridingUtil", "createAndBindFakeOverrides"));
        }
        if (notOverridden == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notOverridden", "org/jetbrains/jet/lang/resolve/OverridingUtil", "createAndBindFakeOverrides"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "org/jetbrains/jet/lang/resolve/OverridingUtil", "createAndBindFakeOverrides"));
        }
        LinkedList<CallableMemberDescriptor> fromSuperQueue = new LinkedList<CallableMemberDescriptor>(notOverridden);
        while (!fromSuperQueue.isEmpty()) {
            CallableMemberDescriptor notOverriddenFromSuper = VisibilityUtil.findMemberWithMaxVisibility(fromSuperQueue);
            Collection<CallableMemberDescriptor> overridables = OverridingUtil.extractMembersOverridableInBothWays(notOverriddenFromSuper, fromSuperQueue, sink);
            OverridingUtil.createAndBindFakeOverride(overridables, current, sink);
        }
    }

    private static boolean isMoreSpecific(@NotNull CallableMemberDescriptor a, @NotNull CallableMemberDescriptor b) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "org/jetbrains/jet/lang/resolve/OverridingUtil", "isMoreSpecific"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "org/jetbrains/jet/lang/resolve/OverridingUtil", "isMoreSpecific"));
        }
        if (a instanceof SimpleFunctionDescriptor) {
            assert (b instanceof SimpleFunctionDescriptor) : "b is " + b.getClass();
            JetType aReturnType = a.getReturnType();
            assert (aReturnType != null);
            JetType bReturnType = b.getReturnType();
            assert (bReturnType != null);
            return JetTypeChecker.DEFAULT.isSubtypeOf(aReturnType, bReturnType);
        }
        if (a instanceof PropertyDescriptor) {
            assert (b instanceof PropertyDescriptor) : "b is " + b.getClass();
            if (((PropertyDescriptor)a).isVar() || ((PropertyDescriptor)b).isVar()) {
                return ((PropertyDescriptor)a).isVar();
            }
            return JetTypeChecker.DEFAULT.isSubtypeOf(((PropertyDescriptor)a).getType(), ((PropertyDescriptor)b).getType());
        }
        throw new IllegalArgumentException("Unexpected callable: " + a.getClass());
    }

    private static CallableMemberDescriptor selectMostSpecificMemberFromSuper(@NotNull Collection<CallableMemberDescriptor> overridables) {
        if (overridables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overridables", "org/jetbrains/jet/lang/resolve/OverridingUtil", "selectMostSpecificMemberFromSuper"));
        }
        CallableMemberDescriptor result2 = null;
        for (CallableMemberDescriptor overridable : overridables) {
            if (result2 != null && !OverridingUtil.isMoreSpecific(overridable, result2)) continue;
            result2 = overridable;
        }
        return result2;
    }

    private static void createAndBindFakeOverride(@NotNull Collection<CallableMemberDescriptor> overridables, @NotNull ClassDescriptor current, @NotNull DescriptorSink sink) {
        if (overridables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overridables", "org/jetbrains/jet/lang/resolve/OverridingUtil", "createAndBindFakeOverride"));
        }
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "org/jetbrains/jet/lang/resolve/OverridingUtil", "createAndBindFakeOverride"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "org/jetbrains/jet/lang/resolve/OverridingUtil", "createAndBindFakeOverride"));
        }
        Collection<CallableMemberDescriptor> visibleOverridables = OverridingUtil.filterVisibleFakeOverrides(current, overridables);
        boolean allInvisible = visibleOverridables.isEmpty();
        Collection<CallableMemberDescriptor> effectiveOverridden = allInvisible ? overridables : visibleOverridables;
        Modality modality = OverridingUtil.getMinimalModality(effectiveOverridden);
        Visibility visibility = allInvisible ? Visibilities.INVISIBLE_FAKE : Visibilities.INHERITED;
        CallableMemberDescriptor mostSpecific = OverridingUtil.selectMostSpecificMemberFromSuper(effectiveOverridden);
        CallableMemberDescriptor fakeOverride = mostSpecific.copy(current, modality, visibility, CallableMemberDescriptor.Kind.FAKE_OVERRIDE, false);
        for (CallableMemberDescriptor descriptor : effectiveOverridden) {
            OverridingUtil.bindOverride(fakeOverride, descriptor);
        }
        sink.addToScope(fakeOverride);
    }

    @NotNull
    private static Modality getMinimalModality(@NotNull Collection<CallableMemberDescriptor> descriptors) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/jet/lang/resolve/OverridingUtil", "getMinimalModality"));
        }
        Modality modality = Modality.ABSTRACT;
        for (CallableMemberDescriptor descriptor : descriptors) {
            if (descriptor.getModality().compareTo(modality) >= 0) continue;
            modality = descriptor.getModality();
        }
        Modality modality2 = modality;
        if (modality2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil", "getMinimalModality"));
        }
        return modality2;
    }

    @NotNull
    private static Collection<CallableMemberDescriptor> filterVisibleFakeOverrides(final @NotNull ClassDescriptor current, @NotNull Collection<CallableMemberDescriptor> toFilter) {
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "org/jetbrains/jet/lang/resolve/OverridingUtil", "filterVisibleFakeOverrides"));
        }
        if (toFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toFilter", "org/jetbrains/jet/lang/resolve/OverridingUtil", "filterVisibleFakeOverrides"));
        }
        List<CallableMemberDescriptor> list = KotlinPackage.filter(toFilter, new Function1<CallableMemberDescriptor, Boolean>(){

            @Override
            public Boolean invoke(CallableMemberDescriptor descriptor) {
                return descriptor.getVisibility() != Visibilities.PRIVATE && Visibilities.isVisible(descriptor, current);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil", "filterVisibleFakeOverrides"));
        }
        return list;
    }

    @NotNull
    private static Collection<CallableMemberDescriptor> extractMembersOverridableInBothWays(@NotNull CallableMemberDescriptor overrider, @NotNull Queue<CallableMemberDescriptor> extractFrom, @NotNull DescriptorSink sink) {
        if (overrider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overrider", "org/jetbrains/jet/lang/resolve/OverridingUtil", "extractMembersOverridableInBothWays"));
        }
        if (extractFrom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extractFrom", "org/jetbrains/jet/lang/resolve/OverridingUtil", "extractMembersOverridableInBothWays"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "org/jetbrains/jet/lang/resolve/OverridingUtil", "extractMembersOverridableInBothWays"));
        }
        ArrayList<CallableMemberDescriptor> overridable = new ArrayList<CallableMemberDescriptor>();
        overridable.add(overrider);
        Iterator iterator2 = extractFrom.iterator();
        while (iterator2.hasNext()) {
            CallableMemberDescriptor candidate = (CallableMemberDescriptor)iterator2.next();
            if (overrider == candidate) {
                iterator2.remove();
                continue;
            }
            OverrideCompatibilityInfo.Result result1 = DEFAULT.isOverridableBy(candidate, overrider).getResult();
            OverrideCompatibilityInfo.Result result2 = DEFAULT.isOverridableBy(overrider, candidate).getResult();
            if (result1 == OverrideCompatibilityInfo.Result.OVERRIDABLE && result2 == OverrideCompatibilityInfo.Result.OVERRIDABLE) {
                overridable.add(candidate);
                iterator2.remove();
                continue;
            }
            if (result1 != OverrideCompatibilityInfo.Result.CONFLICT && result2 != OverrideCompatibilityInfo.Result.CONFLICT) continue;
            sink.conflict(overrider, candidate);
            iterator2.remove();
        }
        ArrayList<CallableMemberDescriptor> arrayList = overridable;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil", "extractMembersOverridableInBothWays"));
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    public static void resolveUnknownVisibilityForMember(@NotNull CallableMemberDescriptor memberDescriptor, @Nullable Function1<CallableMemberDescriptor, Unit> cannotInferVisibility) {
        void var3_6;
        if (memberDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberDescriptor", "org/jetbrains/jet/lang/resolve/OverridingUtil", "resolveUnknownVisibilityForMember"));
        }
        for (CallableMemberDescriptor callableMemberDescriptor : memberDescriptor.getOverriddenDescriptors()) {
            if (callableMemberDescriptor.getVisibility() != Visibilities.INHERITED) continue;
            OverridingUtil.resolveUnknownVisibilityForMember(callableMemberDescriptor, cannotInferVisibility);
        }
        if (memberDescriptor.getVisibility() != Visibilities.INHERITED) {
            return;
        }
        Visibility maxVisibility = OverridingUtil.computeVisibilityToInherit(memberDescriptor);
        if (maxVisibility == null) {
            if (cannotInferVisibility != null) {
                cannotInferVisibility.invoke(memberDescriptor);
            }
            Visibility visibility = Visibilities.PUBLIC;
        } else {
            Visibility visibility = maxVisibility;
        }
        if (memberDescriptor instanceof PropertyDescriptorImpl) {
            ((PropertyDescriptorImpl)memberDescriptor).setVisibility((Visibility)var3_6);
            for (PropertyAccessorDescriptor accessor : ((PropertyDescriptor)memberDescriptor).getAccessors()) {
                OverridingUtil.resolveUnknownVisibilityForMember(accessor, maxVisibility == null ? null : cannotInferVisibility);
            }
        } else if (memberDescriptor instanceof FunctionDescriptorImpl) {
            ((FunctionDescriptorImpl)memberDescriptor).setVisibility((Visibility)var3_6);
        } else {
            assert (memberDescriptor instanceof PropertyAccessorDescriptorImpl);
            ((PropertyAccessorDescriptorImpl)memberDescriptor).setVisibility((Visibility)var3_6);
        }
    }

    @Nullable
    private static Visibility computeVisibilityToInherit(@NotNull CallableMemberDescriptor memberDescriptor) {
        if (memberDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberDescriptor", "org/jetbrains/jet/lang/resolve/OverridingUtil", "computeVisibilityToInherit"));
        }
        Set<? extends CallableMemberDescriptor> overriddenDescriptors = memberDescriptor.getOverriddenDescriptors();
        Visibility maxVisibility = OverridingUtil.findMaxVisibility(overriddenDescriptors);
        if (maxVisibility == null) {
            return null;
        }
        if (memberDescriptor.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            for (CallableMemberDescriptor callableMemberDescriptor : overriddenDescriptors) {
                if (callableMemberDescriptor.getModality() == Modality.ABSTRACT || callableMemberDescriptor.getVisibility().equals(maxVisibility)) continue;
                return null;
            }
            return maxVisibility;
        }
        return maxVisibility.normalize();
    }

    @Nullable
    private static Visibility findMaxVisibility(@NotNull Collection<? extends CallableMemberDescriptor> descriptors) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/jet/lang/resolve/OverridingUtil", "findMaxVisibility"));
        }
        if (descriptors.isEmpty()) {
            return Visibilities.INTERNAL;
        }
        Visibility maxVisibility = null;
        for (CallableMemberDescriptor callableMemberDescriptor : descriptors) {
            Visibility visibility = callableMemberDescriptor.getVisibility();
            assert (visibility != Visibilities.INHERITED) : "Visibility should have been computed for " + callableMemberDescriptor;
            if (maxVisibility == null) {
                maxVisibility = visibility;
                continue;
            }
            Integer compareResult = Visibilities.compare(visibility, maxVisibility);
            if (compareResult == null) {
                maxVisibility = null;
                continue;
            }
            if (compareResult <= 0) continue;
            maxVisibility = visibility;
        }
        if (maxVisibility == null) {
            return null;
        }
        for (CallableMemberDescriptor callableMemberDescriptor : descriptors) {
            Integer compareResult = Visibilities.compare(maxVisibility, callableMemberDescriptor.getVisibility());
            if (compareResult != null && compareResult >= 0) continue;
            return null;
        }
        return maxVisibility;
    }

    @NotNull
    @KotlinSignature(value="fun getTopmostOverridenDescriptors(originalDescriptor: CallableDescriptor): List<out CallableDescriptor>")
    public static List<? extends CallableDescriptor> getTopmostOverridenDescriptors(@NotNull CallableDescriptor originalDescriptor) {
        if (originalDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalDescriptor", "org/jetbrains/jet/lang/resolve/OverridingUtil", "getTopmostOverridenDescriptors"));
        }
        List list = DFS.dfs(Collections.singletonList(originalDescriptor), new DFS.Neighbors<CallableDescriptor>(){

            @Override
            @NotNull
            public Iterable<? extends CallableDescriptor> getNeighbors(CallableDescriptor current) {
                Set<? extends CallableDescriptor> set = current.getOverriddenDescriptors();
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil$4", "getNeighbors"));
                }
                return set;
            }
        }, new DFS.CollectingNodeHandler<CallableDescriptor, CallableDescriptor, ArrayList<CallableDescriptor>>(new ArrayList()){

            @Override
            public void afterChildren(CallableDescriptor current) {
                if (current.getOverriddenDescriptors().isEmpty()) {
                    ((ArrayList)this.result).add(current);
                }
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil", "getTopmostOverridenDescriptors"));
        }
        return list;
    }

    public static boolean traverseOverridenDescriptors(@NotNull CallableDescriptor originalDescriptor, final @NotNull Function1<CallableDescriptor, Boolean> handler) {
        if (originalDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalDescriptor", "org/jetbrains/jet/lang/resolve/OverridingUtil", "traverseOverridenDescriptors"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "org/jetbrains/jet/lang/resolve/OverridingUtil", "traverseOverridenDescriptors"));
        }
        return DFS.dfs(Collections.singletonList(originalDescriptor), new DFS.Neighbors<CallableDescriptor>(){

            @Override
            @NotNull
            public Iterable<? extends CallableDescriptor> getNeighbors(CallableDescriptor current) {
                Set<? extends CallableDescriptor> set = current.getOverriddenDescriptors();
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil$6", "getNeighbors"));
                }
                return set;
            }
        }, new DFS.AbstractNodeHandler<CallableDescriptor, Boolean>(){
            private boolean result = true;

            @Override
            public boolean beforeChildren(CallableDescriptor current) {
                if (!((Boolean)handler.invoke(current)).booleanValue()) {
                    this.result = false;
                }
                return this.result;
            }

            @Override
            public Boolean result() {
                return this.result;
            }
        });
    }

    public static class OverrideCompatibilityInfo {
        private static final OverrideCompatibilityInfo SUCCESS = new OverrideCompatibilityInfo(Result.OVERRIDABLE, "SUCCESS");
        private final Result overridable;
        private final String message;

        @NotNull
        public static OverrideCompatibilityInfo success() {
            OverrideCompatibilityInfo overrideCompatibilityInfo = SUCCESS;
            if (overrideCompatibilityInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil$OverrideCompatibilityInfo", "success"));
            }
            return overrideCompatibilityInfo;
        }

        @NotNull
        public static OverrideCompatibilityInfo nameMismatch() {
            OverrideCompatibilityInfo overrideCompatibilityInfo = new OverrideCompatibilityInfo(Result.INCOMPATIBLE, "nameMismatch");
            if (overrideCompatibilityInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil$OverrideCompatibilityInfo", "nameMismatch"));
            }
            return overrideCompatibilityInfo;
        }

        @NotNull
        public static OverrideCompatibilityInfo typeParameterNumberMismatch() {
            OverrideCompatibilityInfo overrideCompatibilityInfo = new OverrideCompatibilityInfo(Result.INCOMPATIBLE, "typeParameterNumberMismatch");
            if (overrideCompatibilityInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil$OverrideCompatibilityInfo", "typeParameterNumberMismatch"));
            }
            return overrideCompatibilityInfo;
        }

        @NotNull
        public static OverrideCompatibilityInfo receiverPresenceMismatch() {
            OverrideCompatibilityInfo overrideCompatibilityInfo = new OverrideCompatibilityInfo(Result.INCOMPATIBLE, "receiverPresenceMismatch");
            if (overrideCompatibilityInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil$OverrideCompatibilityInfo", "receiverPresenceMismatch"));
            }
            return overrideCompatibilityInfo;
        }

        @NotNull
        public static OverrideCompatibilityInfo valueParameterNumberMismatch() {
            OverrideCompatibilityInfo overrideCompatibilityInfo = new OverrideCompatibilityInfo(Result.INCOMPATIBLE, "valueParameterNumberMismatch");
            if (overrideCompatibilityInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil$OverrideCompatibilityInfo", "valueParameterNumberMismatch"));
            }
            return overrideCompatibilityInfo;
        }

        @NotNull
        public static OverrideCompatibilityInfo boundsMismatch(TypeParameterDescriptor superTypeParameter, TypeParameterDescriptor subTypeParameter) {
            OverrideCompatibilityInfo overrideCompatibilityInfo = new OverrideCompatibilityInfo(Result.INCOMPATIBLE, "boundsMismatch");
            if (overrideCompatibilityInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil$OverrideCompatibilityInfo", "boundsMismatch"));
            }
            return overrideCompatibilityInfo;
        }

        @NotNull
        public static OverrideCompatibilityInfo valueParameterTypeMismatch(JetType superValueParameter, JetType subValueParameter, Result result2) {
            OverrideCompatibilityInfo overrideCompatibilityInfo = new OverrideCompatibilityInfo(result2, "valueParameterTypeMismatch");
            if (overrideCompatibilityInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil$OverrideCompatibilityInfo", "valueParameterTypeMismatch"));
            }
            return overrideCompatibilityInfo;
        }

        @NotNull
        public static OverrideCompatibilityInfo memberKindMismatch() {
            OverrideCompatibilityInfo overrideCompatibilityInfo = new OverrideCompatibilityInfo(Result.INCOMPATIBLE, "memberKindMismatch");
            if (overrideCompatibilityInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil$OverrideCompatibilityInfo", "memberKindMismatch"));
            }
            return overrideCompatibilityInfo;
        }

        @NotNull
        public static OverrideCompatibilityInfo returnTypeMismatch(JetType substitutedSuperReturnType, JetType unsubstitutedSubReturnType) {
            OverrideCompatibilityInfo overrideCompatibilityInfo = new OverrideCompatibilityInfo(Result.CONFLICT, "returnTypeMismatch: " + unsubstitutedSubReturnType + " >< " + substitutedSuperReturnType);
            if (overrideCompatibilityInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil$OverrideCompatibilityInfo", "returnTypeMismatch"));
            }
            return overrideCompatibilityInfo;
        }

        @NotNull
        public static OverrideCompatibilityInfo varOverriddenByVal() {
            OverrideCompatibilityInfo overrideCompatibilityInfo = new OverrideCompatibilityInfo(Result.INCOMPATIBLE, "varOverriddenByVal");
            if (overrideCompatibilityInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil$OverrideCompatibilityInfo", "varOverriddenByVal"));
            }
            return overrideCompatibilityInfo;
        }

        @NotNull
        public static OverrideCompatibilityInfo externalConditionFailed(Class<? extends ExternalOverridabilityCondition> conditionClass) {
            OverrideCompatibilityInfo overrideCompatibilityInfo = new OverrideCompatibilityInfo(Result.INCOMPATIBLE, "externalConditionFailed: " + conditionClass.getName());
            if (overrideCompatibilityInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil$OverrideCompatibilityInfo", "externalConditionFailed"));
            }
            return overrideCompatibilityInfo;
        }

        public OverrideCompatibilityInfo(Result success, String message) {
            this.overridable = success;
            this.message = message;
        }

        public Result getResult() {
            return this.overridable;
        }

        public String getMessage() {
            return this.message;
        }

        public static enum Result {
            OVERRIDABLE,
            INCOMPATIBLE,
            CONFLICT;

        }
    }

    public static interface DescriptorSink {
        public void addToScope(@NotNull CallableMemberDescriptor var1);

        public void conflict(@NotNull CallableMemberDescriptor var1, @NotNull CallableMemberDescriptor var2);
    }
}

