/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetMultiDeclaration;
import org.jetbrains.jet.lang.psi.JetOperationExpression;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetThisExpression;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.InlineDescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.CallResolverExtension;
import org.jetbrains.jet.lang.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.jet.lang.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.InlineUtil;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetToken;
import org.jetbrains.jet.lexer.JetTokens;

public class InlineCallResolverExtension
implements CallResolverExtension {
    private final SimpleFunctionDescriptor descriptor;
    private final Set<CallableDescriptor> inlinableParameters;
    private final boolean isEffectivelyPublicApiFunction;

    public InlineCallResolverExtension(@NotNull SimpleFunctionDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "<init>"));
        }
        this.inlinableParameters = new HashSet<CallableDescriptor>();
        assert (descriptor.getInlineStrategy().isInline()) : "This extension should be created only for inline functions but not " + descriptor;
        this.descriptor = descriptor;
        this.isEffectivelyPublicApiFunction = InlineCallResolverExtension.isEffectivelyPublicApi(descriptor);
        for (ValueParameterDescriptor param : descriptor.getValueParameters()) {
            if (!InlineCallResolverExtension.isInlinableParameter(param)) continue;
            this.inlinableParameters.add(param);
        }
        ReceiverParameterDescriptor receiverParameter = descriptor.getReceiverParameter();
        if (receiverParameter != null && InlineCallResolverExtension.isInlinableParameter(receiverParameter)) {
            this.inlinableParameters.add(receiverParameter);
        }
    }

    @Override
    public <F extends CallableDescriptor> void run(@NotNull ResolvedCall<F> resolvedCall, @NotNull BasicCallResolutionContext context2) {
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "run"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "run"));
        }
        JetExpression expression = context2.call.getCalleeExpression();
        if (expression == null) {
            return;
        }
        F targetDescriptor = resolvedCall.getResultingDescriptor();
        this.checkCallWithReceiver(context2, (CallableDescriptor)targetDescriptor, resolvedCall.getThisObject(), expression);
        this.checkCallWithReceiver(context2, (CallableDescriptor)targetDescriptor, resolvedCall.getReceiverArgument(), expression);
        if (this.inlinableParameters.contains(targetDescriptor) && !InlineCallResolverExtension.isInsideCall(expression)) {
            context2.trace.report(Errors.USAGE_IS_NOT_INLINABLE.on(expression, expression, this.descriptor));
        }
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : resolvedCall.getValueArguments().entrySet()) {
            ResolvedValueArgument value = entry.getValue();
            ValueParameterDescriptor valueDescriptor = entry.getKey();
            if (value instanceof DefaultValueArgument) continue;
            for (ValueArgument argument : value.getArguments()) {
                this.checkValueParameter(context2, (CallableDescriptor)targetDescriptor, argument, valueDescriptor);
            }
        }
        this.checkVisibility((CallableDescriptor)targetDescriptor, expression, context2);
        this.checkRecursion(context2, (CallableDescriptor)targetDescriptor, expression);
    }

    private static boolean isInsideCall(JetExpression expression) {
        JetToken token;
        JetExpression parent = JetPsiUtil.getParentCallIfPresent(expression);
        if (parent instanceof JetBinaryExpression && ((token = JetPsiUtil.getOperationToken((JetOperationExpression)((Object)parent))) == JetTokens.EQ || token == JetTokens.ANDAND || token == JetTokens.OROR)) {
            return false;
        }
        return parent != null;
    }

    private void checkValueParameter(@NotNull BasicCallResolutionContext context2, @NotNull CallableDescriptor targetDescriptor, @NotNull ValueArgument targetArgument, @NotNull ValueParameterDescriptor targetParameterDescriptor) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "checkValueParameter"));
        }
        if (targetDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDescriptor", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "checkValueParameter"));
        }
        if (targetArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetArgument", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "checkValueParameter"));
        }
        if (targetParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetParameterDescriptor", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "checkValueParameter"));
        }
        JetExpression argumentExpression = targetArgument.getArgumentExpression();
        if (argumentExpression == null) {
            return;
        }
        CallableDescriptor argumentCallee = InlineCallResolverExtension.getCalleeDescriptor(context2, argumentExpression, false);
        if (argumentCallee != null && this.inlinableParameters.contains(argumentCallee)) {
            boolean isTargetInlineFunction;
            boolean bl = isTargetInlineFunction = targetDescriptor instanceof SimpleFunctionDescriptor && ((SimpleFunctionDescriptor)targetDescriptor).getInlineStrategy().isInline();
            if (!isTargetInlineFunction || !InlineCallResolverExtension.isInlinableParameter(targetParameterDescriptor)) {
                context2.trace.report(Errors.USAGE_IS_NOT_INLINABLE.on(argumentExpression, argumentExpression, this.descriptor));
            } else if (InlineDescriptorUtils.allowsNonLocalReturns(argumentCallee) && !InlineDescriptorUtils.allowsNonLocalReturns(targetParameterDescriptor)) {
                context2.trace.report(Errors.NON_LOCAL_RETURN_NOT_ALLOWED.on(argumentExpression, argumentExpression, argumentCallee, this.descriptor));
            } else {
                this.checkNonLocalReturn(context2, argumentCallee, argumentExpression);
            }
        }
    }

    private void checkCallWithReceiver(@NotNull BasicCallResolutionContext context2, @NotNull CallableDescriptor targetDescriptor, @NotNull ReceiverValue receiver, @Nullable JetExpression expression) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "checkCallWithReceiver"));
        }
        if (targetDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDescriptor", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "checkCallWithReceiver"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "checkCallWithReceiver"));
        }
        if (!receiver.exists()) {
            return;
        }
        CallableDescriptor varDescriptor = null;
        JetExpression receiverExpression = null;
        if (receiver instanceof ExpressionReceiver) {
            receiverExpression = ((ExpressionReceiver)receiver).getExpression();
            varDescriptor = InlineCallResolverExtension.getCalleeDescriptor(context2, receiverExpression, true);
        } else if (receiver instanceof ExtensionReceiver) {
            ExtensionReceiver extensionReceiver = (ExtensionReceiver)receiver;
            CallableDescriptor extension = extensionReceiver.getDeclarationDescriptor();
            varDescriptor = extension.getReceiverParameter();
            assert (varDescriptor != null) : "Extension should have receiverParameterDescriptor: " + extension;
            receiverExpression = expression;
        }
        if (this.inlinableParameters.contains(varDescriptor)) {
            this.checkLambdaInvokeOrExtensionCall(context2, varDescriptor, targetDescriptor, receiverExpression);
        }
    }

    @Nullable
    private static CallableDescriptor getCalleeDescriptor(@NotNull BasicCallResolutionContext context2, @NotNull JetExpression expression, boolean unwrapVariableAsFunction) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "getCalleeDescriptor"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "getCalleeDescriptor"));
        }
        if (!(expression instanceof JetSimpleNameExpression) && !(expression instanceof JetThisExpression)) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> thisCall = CallUtilPackage.getResolvedCall(expression, context2.trace.getBindingContext());
        if (unwrapVariableAsFunction && thisCall instanceof VariableAsFunctionResolvedCall) {
            return ((VariableAsFunctionResolvedCall)((Object)thisCall)).getVariableCall().getResultingDescriptor();
        }
        return thisCall != null ? thisCall.getResultingDescriptor() : null;
    }

    private void checkLambdaInvokeOrExtensionCall(@NotNull BasicCallResolutionContext context2, @NotNull CallableDescriptor lambdaDescriptor, @NotNull CallableDescriptor callDescriptor, @NotNull JetExpression receiverExpresssion) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "checkLambdaInvokeOrExtensionCall"));
        }
        if (lambdaDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambdaDescriptor", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "checkLambdaInvokeOrExtensionCall"));
        }
        if (callDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callDescriptor", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "checkLambdaInvokeOrExtensionCall"));
        }
        if (receiverExpresssion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverExpresssion", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "checkLambdaInvokeOrExtensionCall"));
        }
        boolean inlinableCall = InlineCallResolverExtension.isInvokeOrInlineExtension(callDescriptor);
        if (!inlinableCall) {
            context2.trace.report(Errors.USAGE_IS_NOT_INLINABLE.on(receiverExpresssion, receiverExpresssion, this.descriptor));
        } else {
            this.checkNonLocalReturn(context2, lambdaDescriptor, receiverExpresssion);
        }
    }

    public void checkRecursion(@NotNull BasicCallResolutionContext context2, @NotNull CallableDescriptor targetDescriptor, @NotNull JetElement expression) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "checkRecursion"));
        }
        if (targetDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDescriptor", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "checkRecursion"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "checkRecursion"));
        }
        if (targetDescriptor.getOriginal() == this.descriptor) {
            context2.trace.report(Errors.RECURSION_IN_INLINE.on(expression, expression, this.descriptor));
        }
    }

    private static boolean isInlinableParameter(@NotNull CallableDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "isInlinableParameter"));
        }
        JetType type = descriptor.getReturnType();
        return type != null && KotlinBuiltIns.getInstance().isExactFunctionOrExtensionFunctionType(type) && !type.isNullable() && !InlineUtil.hasNoinlineAnnotation(descriptor);
    }

    private static boolean isInvokeOrInlineExtension(@NotNull CallableDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "isInvokeOrInlineExtension"));
        }
        if (!(descriptor instanceof SimpleFunctionDescriptor)) {
            return false;
        }
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        boolean isInvoke = descriptor.getName().asString().equals("invoke") && containingDeclaration instanceof ClassDescriptor && KotlinBuiltIns.getInstance().isExactFunctionOrExtensionFunctionType(((ClassDescriptor)containingDeclaration).getDefaultType());
        return isInvoke || ((SimpleFunctionDescriptor)descriptor).getInlineStrategy().isInline();
    }

    private void checkVisibility(@NotNull CallableDescriptor declarationDescriptor, @NotNull JetElement expression, @NotNull BasicCallResolutionContext context2) {
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "checkVisibility"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "checkVisibility"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "checkVisibility"));
        }
        if (this.isEffectivelyPublicApiFunction && !InlineCallResolverExtension.isEffectivelyPublicApi(declarationDescriptor) && declarationDescriptor.getVisibility() != Visibilities.LOCAL) {
            context2.trace.report(Errors.INVISIBLE_MEMBER_FROM_INLINE.on(expression, declarationDescriptor, this.descriptor));
        }
    }

    private static boolean isEffectivelyPublicApi(DeclarationDescriptorWithVisibility descriptor) {
        DeclarationDescriptorWithVisibility parent = descriptor;
        while (parent != null) {
            if (!parent.getVisibility().isPublicAPI()) {
                return false;
            }
            parent = DescriptorUtils.getParentOfType(parent, DeclarationDescriptorWithVisibility.class);
        }
        return true;
    }

    private void checkNonLocalReturn(@NotNull BasicCallResolutionContext context2, @NotNull CallableDescriptor inlinableParameterDescriptor, @NotNull JetExpression parameterUsage) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "checkNonLocalReturn"));
        }
        if (inlinableParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inlinableParameterDescriptor", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "checkNonLocalReturn"));
        }
        if (parameterUsage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterUsage", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "checkNonLocalReturn"));
        }
        if (!InlineDescriptorUtils.allowsNonLocalReturns(inlinableParameterDescriptor)) {
            return;
        }
        if (!InlineDescriptorUtils.checkNonLocalReturnUsage(this.descriptor, parameterUsage, context2.trace)) {
            context2.trace.report(Errors.NON_LOCAL_RETURN_NOT_ALLOWED.on(parameterUsage, parameterUsage, inlinableParameterDescriptor, this.descriptor));
        }
    }

    @Nullable
    public static PsiElement getDeclaration(JetExpression expression) {
        while ((expression = (JetExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, JetDeclaration.class)) instanceof JetMultiDeclaration || expression instanceof JetProperty) {
        }
        return expression;
    }
}

