/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.tasks;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetSuperExpression;
import org.jetbrains.jet.lang.resolve.calls.CallResolverUtil;
import org.jetbrains.jet.lang.resolve.calls.autocasts.AutoCastUtils;
import org.jetbrains.jet.lang.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.tasks.CallableDescriptorCollector;
import org.jetbrains.jet.lang.resolve.calls.tasks.CallableDescriptorCollectors;
import org.jetbrains.jet.lang.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.jet.lang.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.jet.lang.resolve.calls.tasks.ResolutionTask;
import org.jetbrains.jet.lang.resolve.calls.tasks.ResolutionTaskHolder;
import org.jetbrains.jet.lang.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScopeUtils;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.QualifierReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingUtils;

public class TaskPrioritizer {
    public static <D extends CallableDescriptor> void splitLexicallyLocalDescriptors(@NotNull Collection<ResolutionCandidate<D>> allDescriptors, @NotNull DeclarationDescriptor containerOfTheCurrentLocality, @NotNull Collection<ResolutionCandidate<D>> local, @NotNull Collection<ResolutionCandidate<D>> nonlocal) {
        if (allDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allDescriptors", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "splitLexicallyLocalDescriptors"));
        }
        if (containerOfTheCurrentLocality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containerOfTheCurrentLocality", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "splitLexicallyLocalDescriptors"));
        }
        if (local == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "local", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "splitLexicallyLocalDescriptors"));
        }
        if (nonlocal == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nonlocal", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "splitLexicallyLocalDescriptors"));
        }
        for (ResolutionCandidate<D> resolvedCall : allDescriptors) {
            if (ExpressionTypingUtils.isLocal(containerOfTheCurrentLocality, resolvedCall.getDescriptor())) {
                local.add(resolvedCall);
                continue;
            }
            nonlocal.add(resolvedCall);
        }
    }

    @Nullable
    public static JetSuperExpression getReceiverSuper(@NotNull ReceiverValue receiver) {
        ExpressionReceiver expressionReceiver;
        JetExpression expression;
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "getReceiverSuper"));
        }
        if (receiver instanceof ExpressionReceiver && (expression = (expressionReceiver = (ExpressionReceiver)receiver).getExpression()) instanceof JetSuperExpression) {
            return (JetSuperExpression)expression;
        }
        return null;
    }

    @NotNull
    public static <D extends CallableDescriptor, F extends D> List<ResolutionTask<D, F>> computePrioritizedTasks(@NotNull BasicCallResolutionContext context2, @NotNull Name name, @NotNull TracingStrategy tracing, @NotNull CallableDescriptorCollectors<D> callableDescriptorCollectors) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "computePrioritizedTasks"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "computePrioritizedTasks"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "computePrioritizedTasks"));
        }
        if (callableDescriptorCollectors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableDescriptorCollectors", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "computePrioritizedTasks"));
        }
        ReceiverValue explicitReceiver = context2.call.getExplicitReceiver();
        ResolutionTaskHolder result2 = new ResolutionTaskHolder(context2, new MyPriorityProvider(context2), tracing);
        TaskPrioritizerContext taskPrioritizerContext = new TaskPrioritizerContext(name, result2, context2, context2.scope, callableDescriptorCollectors);
        if (explicitReceiver instanceof QualifierReceiver) {
            QualifierReceiver qualifierReceiver = (QualifierReceiver)explicitReceiver;
            TaskPrioritizer.doComputeTasks(ReceiverValue.NO_RECEIVER, taskPrioritizerContext.replaceScope(qualifierReceiver.getNestedClassesAndPackageMembersScope()));
            ReceiverValue classObjectReceiver = qualifierReceiver.getClassObjectReceiver();
            if (classObjectReceiver.exists()) {
                TaskPrioritizer.doComputeTasks(classObjectReceiver, taskPrioritizerContext);
            }
        } else {
            TaskPrioritizer.doComputeTasks(explicitReceiver, taskPrioritizerContext);
        }
        List list = result2.getTasks();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "computePrioritizedTasks"));
        }
        return list;
    }

    private static <D extends CallableDescriptor, F extends D> void doComputeTasks(@NotNull ReceiverValue receiver, @NotNull TaskPrioritizerContext<D, F> c) {
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "doComputeTasks"));
        }
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "doComputeTasks"));
        }
        ProgressIndicatorProvider.checkCanceled();
        boolean resolveInvoke = c.context.call.getThisObject().exists();
        if (resolveInvoke) {
            TaskPrioritizer.addCandidatesForInvoke(receiver, c);
            return;
        }
        LinkedHashSet<ReceiverValue> implicitReceivers = Sets.newLinkedHashSet(JetScopeUtils.getImplicitReceiversHierarchyValues(c.scope));
        if (receiver.exists()) {
            TaskPrioritizer.addCandidatesForExplicitReceiver(receiver, implicitReceivers, c, true);
            return;
        }
        TaskPrioritizer.addCandidatesForNoReceiver(implicitReceivers, c);
    }

    private static <D extends CallableDescriptor, F extends D> void addCandidatesForExplicitReceiver(@NotNull ReceiverValue explicitReceiver, @NotNull Collection<ReceiverValue> implicitReceivers, @NotNull TaskPrioritizerContext<D, F> c, boolean isExplicit) {
        if (explicitReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitReceiver", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "addCandidatesForExplicitReceiver"));
        }
        if (implicitReceivers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "implicitReceivers", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "addCandidatesForExplicitReceiver"));
        }
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "addCandidatesForExplicitReceiver"));
        }
        List<JetType> variantsForExplicitReceiver = AutoCastUtils.getAutoCastVariants(explicitReceiver, c.context);
        for (CallableDescriptorCollector callableDescriptorCollector : c.callableDescriptorCollectors) {
            ArrayList members = Lists.newArrayList();
            for (JetType type : variantsForExplicitReceiver) {
                Collection membersForThisVariant = callableDescriptorCollector.getMembersByName(type, c.name, c.context.trace);
                TaskPrioritizer.convertWithReceivers(membersForThisVariant, explicitReceiver, ReceiverValue.NO_RECEIVER, members, TaskPrioritizer.createKind(ExplicitReceiverKind.THIS_OBJECT, isExplicit), c.context.call);
            }
            c.result.addCandidates(members);
        }
        for (CallableDescriptorCollector callableDescriptorCollector : c.callableDescriptorCollectors) {
            for (ReceiverValue implicitReceiver : implicitReceivers) {
                TaskPrioritizer.addMemberExtensionCandidates(implicitReceiver, explicitReceiver, callableDescriptorCollector, c, TaskPrioritizer.createKind(ExplicitReceiverKind.RECEIVER_ARGUMENT, isExplicit));
            }
            Collection extensions = TaskPrioritizer.convertWithImpliedThis(c.scope, explicitReceiver, callableDescriptorCollector.getNonMembersByName(c.scope, c.name, c.context.trace), TaskPrioritizer.createKind(ExplicitReceiverKind.RECEIVER_ARGUMENT, isExplicit), c.context.call);
            c.result.addCandidates(extensions);
        }
    }

    private static ExplicitReceiverKind createKind(ExplicitReceiverKind kind, boolean isExplicit) {
        if (isExplicit) {
            return kind;
        }
        return ExplicitReceiverKind.NO_EXPLICIT_RECEIVER;
    }

    private static <D extends CallableDescriptor, F extends D> void addMemberExtensionCandidates(@NotNull ReceiverValue thisObject, @NotNull ReceiverValue receiverParameter, @NotNull CallableDescriptorCollector<D> callableDescriptorCollector, TaskPrioritizerContext<D, F> c, @NotNull ExplicitReceiverKind receiverKind) {
        if (thisObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisObject", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "addMemberExtensionCandidates"));
        }
        if (receiverParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverParameter", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "addMemberExtensionCandidates"));
        }
        if (callableDescriptorCollector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableDescriptorCollector", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "addMemberExtensionCandidates"));
        }
        if (receiverKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverKind", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "addMemberExtensionCandidates"));
        }
        Collection<D> memberExtensions = callableDescriptorCollector.getNonMembersByName(thisObject.getType().getMemberScope(), c.name, c.context.trace);
        c.result.addCandidates(TaskPrioritizer.convertWithReceivers(memberExtensions, thisObject, receiverParameter, receiverKind, c.context.call));
    }

    private static <D extends CallableDescriptor, F extends D> void addCandidatesForNoReceiver(@NotNull Collection<ReceiverValue> implicitReceivers, @NotNull TaskPrioritizerContext<D, F> c) {
        if (implicitReceivers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "implicitReceivers", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "addCandidatesForNoReceiver"));
        }
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "addCandidatesForNoReceiver"));
        }
        ArrayList localsList = Lists.newArrayList();
        ArrayList nonlocalsList = Lists.newArrayList();
        for (CallableDescriptorCollector callableDescriptorCollector : c.callableDescriptorCollectors) {
            Collection members = TaskPrioritizer.convertWithImpliedThisAndNoReceiver(c.scope, callableDescriptorCollector.getNonExtensionsByName(c.scope, c.name, c.context.trace), c.context.call);
            ArrayList<ResolutionCandidate<D>> nonlocals = Lists.newArrayList();
            ArrayList<ResolutionCandidate<D>> locals = Lists.newArrayList();
            TaskPrioritizer.splitLexicallyLocalDescriptors(members, c.scope.getContainingDeclaration(), locals, nonlocals);
            localsList.add(locals);
            nonlocalsList.add(nonlocals);
        }
        c.result.addCandidates(localsList);
        for (ReceiverValue implicitReceiver : implicitReceivers) {
            TaskPrioritizer.addCandidatesForExplicitReceiver(implicitReceiver, implicitReceivers, c, false);
        }
        c.result.addCandidates(nonlocalsList);
    }

    private static <D extends CallableDescriptor, F extends D> void addCandidatesForInvoke(@NotNull ReceiverValue explicitReceiver, @NotNull TaskPrioritizerContext<D, F> c) {
        if (explicitReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitReceiver", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "addCandidatesForInvoke"));
        }
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "addCandidatesForInvoke"));
        }
        List<ReceiverValue> implicitReceivers = JetScopeUtils.getImplicitReceiversHierarchyValues(c.scope);
        ReceiverValue variableReceiver = c.context.call.getThisObject();
        assert (variableReceiver.exists()) : "'Invoke' call hasn't got variable receiver";
        if (!explicitReceiver.exists()) {
            TaskPrioritizer.addCandidatesForExplicitReceiver(variableReceiver, implicitReceivers, c, true);
        }
        if (explicitReceiver.exists()) {
            TaskPrioritizer.addCandidatesWhenInvokeIsMemberAndExtensionToExplicitReceiver(variableReceiver, explicitReceiver, c, ExplicitReceiverKind.BOTH_RECEIVERS);
            return;
        }
        for (ReceiverValue implicitReceiver : implicitReceivers) {
            TaskPrioritizer.addCandidatesWhenInvokeIsMemberAndExtensionToExplicitReceiver(variableReceiver, implicitReceiver, c, ExplicitReceiverKind.THIS_OBJECT);
        }
    }

    private static <D extends CallableDescriptor, F extends D> void addCandidatesWhenInvokeIsMemberAndExtensionToExplicitReceiver(@NotNull ReceiverValue thisObject, @NotNull ReceiverValue receiverParameter, @NotNull TaskPrioritizerContext<D, F> c, @NotNull ExplicitReceiverKind receiverKind) {
        if (thisObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisObject", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "addCandidatesWhenInvokeIsMemberAndExtensionToExplicitReceiver"));
        }
        if (receiverParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverParameter", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "addCandidatesWhenInvokeIsMemberAndExtensionToExplicitReceiver"));
        }
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "addCandidatesWhenInvokeIsMemberAndExtensionToExplicitReceiver"));
        }
        if (receiverKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverKind", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "addCandidatesWhenInvokeIsMemberAndExtensionToExplicitReceiver"));
        }
        for (CallableDescriptorCollector callableDescriptorCollector : c.callableDescriptorCollectors) {
            TaskPrioritizer.addMemberExtensionCandidates(thisObject, receiverParameter, callableDescriptorCollector, c, receiverKind);
        }
    }

    private static <D extends CallableDescriptor> Collection<ResolutionCandidate<D>> convertWithReceivers(@NotNull Collection<D> descriptors, @NotNull ReceiverValue thisObject, @NotNull ReceiverValue receiverParameter, @NotNull ExplicitReceiverKind explicitReceiverKind, @NotNull Call call) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "convertWithReceivers"));
        }
        if (thisObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisObject", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "convertWithReceivers"));
        }
        if (receiverParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverParameter", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "convertWithReceivers"));
        }
        if (explicitReceiverKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitReceiverKind", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "convertWithReceivers"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "convertWithReceivers"));
        }
        ArrayList<ResolutionCandidate<D>> result2 = Lists.newArrayList();
        TaskPrioritizer.convertWithReceivers(descriptors, thisObject, receiverParameter, result2, explicitReceiverKind, call);
        return result2;
    }

    private static <D extends CallableDescriptor> void convertWithReceivers(@NotNull Collection<D> descriptors, @NotNull ReceiverValue thisObject, @NotNull ReceiverValue receiverParameter, @NotNull Collection<ResolutionCandidate<D>> result2, @NotNull ExplicitReceiverKind explicitReceiverKind, @NotNull Call call) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "convertWithReceivers"));
        }
        if (thisObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisObject", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "convertWithReceivers"));
        }
        if (receiverParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverParameter", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "convertWithReceivers"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "convertWithReceivers"));
        }
        if (explicitReceiverKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitReceiverKind", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "convertWithReceivers"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "convertWithReceivers"));
        }
        for (CallableDescriptor descriptor : descriptors) {
            ResolutionCandidate<CallableDescriptor> candidate = ResolutionCandidate.create(call, descriptor);
            candidate.setThisObject(thisObject);
            candidate.setReceiverArgument(receiverParameter);
            candidate.setExplicitReceiverKind(explicitReceiverKind);
            result2.add(candidate);
        }
    }

    public static <D extends CallableDescriptor> Collection<ResolutionCandidate<D>> convertWithImpliedThisAndNoReceiver(@NotNull JetScope scope, @NotNull Collection<? extends D> descriptors, @NotNull Call call) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "convertWithImpliedThisAndNoReceiver"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "convertWithImpliedThisAndNoReceiver"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "convertWithImpliedThisAndNoReceiver"));
        }
        return TaskPrioritizer.convertWithImpliedThis(scope, ReceiverValue.NO_RECEIVER, descriptors, ExplicitReceiverKind.NO_EXPLICIT_RECEIVER, call);
    }

    public static <D extends CallableDescriptor> Collection<ResolutionCandidate<D>> convertWithImpliedThis(@NotNull JetScope scope, @NotNull ReceiverValue receiverParameter, @NotNull Collection<? extends D> descriptors, @NotNull ExplicitReceiverKind receiverKind, @NotNull Call call) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "convertWithImpliedThis"));
        }
        if (receiverParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverParameter", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "convertWithImpliedThis"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "convertWithImpliedThis"));
        }
        if (receiverKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverKind", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "convertWithImpliedThis"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "convertWithImpliedThis"));
        }
        ArrayList<ResolutionCandidate<D>> result2 = Lists.newArrayList();
        for (CallableDescriptor descriptor : descriptors) {
            ResolutionCandidate<CallableDescriptor> candidate = ResolutionCandidate.create(call, descriptor);
            candidate.setReceiverArgument(receiverParameter);
            candidate.setExplicitReceiverKind(receiverKind);
            if (!TaskPrioritizer.setImpliedThis(scope, candidate)) continue;
            result2.add(candidate);
        }
        return result2;
    }

    private static <D extends CallableDescriptor> boolean setImpliedThis(@NotNull JetScope scope, @NotNull ResolutionCandidate<D> candidate) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "setImpliedThis"));
        }
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "setImpliedThis"));
        }
        ReceiverParameterDescriptor expectedThisObject = candidate.getDescriptor().getExpectedThisObject();
        if (expectedThisObject == null) {
            return true;
        }
        List<ReceiverParameterDescriptor> receivers = scope.getImplicitReceiversHierarchy();
        for (ReceiverParameterDescriptor receiver : receivers) {
            if (!JetTypeChecker.DEFAULT.isSubtypeOf(receiver.getType(), expectedThisObject.getType())) continue;
            candidate.setThisObject(expectedThisObject.getValue());
            return true;
        }
        return false;
    }

    public static <D extends CallableDescriptor, F extends D> List<ResolutionTask<D, F>> computePrioritizedTasksFromCandidates(@NotNull BasicCallResolutionContext context2, @NotNull Collection<ResolutionCandidate<D>> candidates, @NotNull TracingStrategy tracing) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "computePrioritizedTasksFromCandidates"));
        }
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "computePrioritizedTasksFromCandidates"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "computePrioritizedTasksFromCandidates"));
        }
        ResolutionTaskHolder result2 = new ResolutionTaskHolder(context2, new MyPriorityProvider(context2), tracing);
        result2.addCandidates(candidates);
        return result2.getTasks();
    }

    private static class TaskPrioritizerContext<D extends CallableDescriptor, F extends D> {
        @NotNull
        public final Name name;
        @NotNull
        public final ResolutionTaskHolder<D, F> result;
        @NotNull
        public final BasicCallResolutionContext context;
        @NotNull
        public final JetScope scope;
        @NotNull
        public final CallableDescriptorCollectors<D> callableDescriptorCollectors;

        private TaskPrioritizerContext(@NotNull Name name, @NotNull ResolutionTaskHolder<D, F> result2, @NotNull BasicCallResolutionContext context2, @NotNull JetScope scope, @NotNull CallableDescriptorCollectors<D> callableDescriptorCollectors) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer$TaskPrioritizerContext", "<init>"));
            }
            if (result2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer$TaskPrioritizerContext", "<init>"));
            }
            if (context2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer$TaskPrioritizerContext", "<init>"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer$TaskPrioritizerContext", "<init>"));
            }
            if (callableDescriptorCollectors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableDescriptorCollectors", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer$TaskPrioritizerContext", "<init>"));
            }
            this.name = name;
            this.result = result2;
            this.context = context2;
            this.scope = scope;
            this.callableDescriptorCollectors = callableDescriptorCollectors;
        }

        private TaskPrioritizerContext<D, F> replaceScope(JetScope newScope) {
            return new TaskPrioritizerContext<D, F>(this.name, this.result, this.context, newScope, this.callableDescriptorCollectors);
        }
    }

    private static class MyPriorityProvider<D extends CallableDescriptor>
    implements ResolutionTaskHolder.PriorityProvider<ResolutionCandidate<D>> {
        private final BasicCallResolutionContext context;

        public MyPriorityProvider(BasicCallResolutionContext context2) {
            this.context = context2;
        }

        @Override
        public int getPriority(ResolutionCandidate<D> call) {
            return (this.isVisible(call) ? 2 : 0) + (this.isSynthesized(call) ? 0 : 1);
        }

        @Override
        public int getMaxPriority() {
            return 3;
        }

        private boolean isVisible(ResolutionCandidate<D> call) {
            if (call == null) {
                return false;
            }
            D candidateDescriptor = call.getDescriptor();
            if (ErrorUtils.isError(candidateDescriptor)) {
                return true;
            }
            return Visibilities.isVisible(candidateDescriptor, this.context.scope.getContainingDeclaration());
        }

        private boolean isSynthesized(ResolutionCandidate<D> call) {
            D descriptor = call.getDescriptor();
            return descriptor instanceof CallableMemberDescriptor && CallResolverUtil.isOrOverridesSynthesized((CallableMemberDescriptor)descriptor);
        }
    }
}

