/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.analyzer.AnalyzeExhaust;
import org.jetbrains.jet.context.ContextPackage;
import org.jetbrains.jet.context.GlobalContextImpl;
import org.jetbrains.jet.di.InjectorForTopDownAnalyzerForJvm;
import org.jetbrains.jet.lang.descriptors.PackageFragmentProvider;
import org.jetbrains.jet.lang.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.ImportPath;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisParameters;
import org.jetbrains.jet.lang.resolve.java.mapping.JavaToKotlinClassMap;
import org.jetbrains.jet.lang.resolve.kotlin.incremental.IncrementalPackageFragmentProvider;
import org.jetbrains.jet.lang.resolve.kotlin.incremental.cache.IncrementalCache;
import org.jetbrains.jet.lang.resolve.kotlin.incremental.cache.IncrementalCacheProvider;
import org.jetbrains.jet.lang.resolve.name.Name;

public enum TopDownAnalyzerFacadeForJVM {
    INSTANCE;

    public static final List<ImportPath> DEFAULT_IMPORTS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static AnalyzeExhaust analyzeFilesWithJavaIntegration(Project project, Collection<JetFile> files, BindingTrace trace, Predicate<PsiFile> filesToAnalyzeCompletely, ModuleDescriptorImpl module, List<String> moduleIds, @Nullable IncrementalCacheProvider incrementalCacheProvider) {
        GlobalContextImpl globalContext = ContextPackage.GlobalContext();
        TopDownAnalysisParameters topDownAnalysisParameters = TopDownAnalysisParameters.create(globalContext.getStorageManager(), globalContext.getExceptionTracker(), filesToAnalyzeCompletely, false, false);
        InjectorForTopDownAnalyzerForJvm injector = new InjectorForTopDownAnalyzerForJvm(project, topDownAnalysisParameters, trace, module);
        ArrayList<PackageFragmentProvider> additionalProviders = new ArrayList<PackageFragmentProvider>();
        if (moduleIds != null && incrementalCacheProvider != null) {
            for (String moduleId : moduleIds) {
                IncrementalCache incrementalCache = incrementalCacheProvider.getIncrementalCache(moduleId);
                additionalProviders.add(new IncrementalPackageFragmentProvider(files, module, globalContext.getStorageManager(), injector.getDeserializationGlobalContextForJava(), incrementalCache, moduleId, injector.getJavaDescriptorResolver()));
            }
        }
        additionalProviders.add(injector.getJavaDescriptorResolver().getPackageFragmentProvider());
        injector.getTopDownAnalyzer().analyzeFiles(topDownAnalysisParameters, files, additionalProviders);
        AnalyzeExhaust analyzeExhaust = AnalyzeExhaust.success(trace.getBindingContext(), module);
        AnalyzeExhaust analyzeExhaust2 = analyzeExhaust;
        if (analyzeExhaust2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegration"));
        }
        return analyzeExhaust2;
        finally {
            injector.destroy();
        }
    }

    @NotNull
    public static ModuleDescriptorImpl createJavaModule(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/java/TopDownAnalyzerFacadeForJVM", "createJavaModule"));
        }
        ModuleDescriptorImpl moduleDescriptorImpl = new ModuleDescriptorImpl(Name.special(name), DEFAULT_IMPORTS, JavaToKotlinClassMap.getInstance());
        if (moduleDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/TopDownAnalyzerFacadeForJVM", "createJavaModule"));
        }
        return moduleDescriptorImpl;
    }

    static {
        DEFAULT_IMPORTS = ImmutableList.of(new ImportPath("java.lang.*"), new ImportPath("kotlin.*"), new ImportPath("kotlin.jvm.*"), new ImportPath("kotlin.io.*"));
    }
}

