/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.kotlin;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.descriptors.serialization.JavaProtoBuf;
import org.jetbrains.jet.descriptors.serialization.NameResolver;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.descriptors.serialization.descriptors.AnnotatedCallableKind;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedCallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.java.resolver.ErrorReporter;
import org.jetbrains.jet.lang.resolve.kotlin.DescriptorLoadersStorage;
import org.jetbrains.jet.lang.resolve.kotlin.DeserializedResolverUtils;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinClassFinder;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.jet.lang.resolve.kotlin.SignatureDeserializer;
import org.jetbrains.jet.lang.resolve.name.ClassId;
import org.jetbrains.jet.lang.resolve.name.Name;

public abstract class BaseDescriptorLoader {
    protected KotlinClassFinder kotlinClassFinder;
    protected ErrorReporter errorReporter;
    protected DescriptorLoadersStorage storage;

    public abstract void setKotlinClassFinder(@NotNull KotlinClassFinder var1);

    public abstract void setErrorReporter(@NotNull ErrorReporter var1);

    public abstract void setStorage(@NotNull DescriptorLoadersStorage var1);

    @Nullable
    protected static DescriptorLoadersStorage.MemberSignature getCallableSignature(@NotNull ProtoBuf.Callable proto, @NotNull NameResolver nameResolver, @NotNull AnnotatedCallableKind kind) {
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/lang/resolve/kotlin/BaseDescriptorLoader", "getCallableSignature"));
        }
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/jet/lang/resolve/kotlin/BaseDescriptorLoader", "getCallableSignature"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/lang/resolve/kotlin/BaseDescriptorLoader", "getCallableSignature"));
        }
        SignatureDeserializer deserializer = new SignatureDeserializer(nameResolver);
        switch (kind) {
            case FUNCTION: {
                if (!proto.hasExtension(JavaProtoBuf.methodSignature)) break;
                return deserializer.methodSignature(proto.getExtension(JavaProtoBuf.methodSignature));
            }
            case PROPERTY_GETTER: {
                if (!proto.hasExtension(JavaProtoBuf.propertySignature)) break;
                return deserializer.methodSignature(proto.getExtension(JavaProtoBuf.propertySignature).getGetter());
            }
            case PROPERTY_SETTER: {
                if (!proto.hasExtension(JavaProtoBuf.propertySignature)) break;
                return deserializer.methodSignature(proto.getExtension(JavaProtoBuf.propertySignature).getSetter());
            }
            case PROPERTY: {
                if (!proto.hasExtension(JavaProtoBuf.propertySignature)) break;
                JavaProtoBuf.JavaPropertySignature propertySignature = proto.getExtension(JavaProtoBuf.propertySignature);
                if (propertySignature.hasField()) {
                    JavaProtoBuf.JavaFieldSignature field = propertySignature.getField();
                    String type = deserializer.typeDescriptor(field.getType());
                    Name name = nameResolver.getName(field.getName());
                    return DescriptorLoadersStorage.MemberSignature.fromFieldNameAndDesc(name, type);
                }
                if (!propertySignature.hasSyntheticMethod()) break;
                return deserializer.methodSignature(propertySignature.getSyntheticMethod());
            }
        }
        return null;
    }

    @Nullable
    protected KotlinJvmBinaryClass findClassWithAnnotationsAndInitializers(@NotNull ClassOrPackageFragmentDescriptor container, @NotNull ProtoBuf.Callable proto, @NotNull NameResolver nameResolver, @NotNull AnnotatedCallableKind kind) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "org/jetbrains/jet/lang/resolve/kotlin/BaseDescriptorLoader", "findClassWithAnnotationsAndInitializers"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/lang/resolve/kotlin/BaseDescriptorLoader", "findClassWithAnnotationsAndInitializers"));
        }
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/jet/lang/resolve/kotlin/BaseDescriptorLoader", "findClassWithAnnotationsAndInitializers"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/lang/resolve/kotlin/BaseDescriptorLoader", "findClassWithAnnotationsAndInitializers"));
        }
        if (container instanceof PackageFragmentDescriptor) {
            return this.findPackagePartClass((PackageFragmentDescriptor)container, proto, nameResolver);
        }
        if (DescriptorUtils.isClassObject(container) && BaseDescriptorLoader.isStaticFieldInOuter(proto)) {
            return this.findKotlinClassByDescriptor((ClassOrPackageFragmentDescriptor)container.getContainingDeclaration());
        }
        if (DescriptorUtils.isTrait(container) && kind == AnnotatedCallableKind.PROPERTY) {
            PackageFragmentDescriptor containingPackage = DescriptorUtils.getParentOfType(container, PackageFragmentDescriptor.class);
            assert (containingPackage != null) : "Trait must have a package fragment among his parents: " + container;
            if (proto.hasExtension(JavaProtoBuf.implClassName)) {
                Name tImplName = nameResolver.getName(proto.getExtension(JavaProtoBuf.implClassName));
                return this.kotlinClassFinder.findKotlinClass(new ClassId(containingPackage.getFqName(), tImplName));
            }
            return null;
        }
        return this.findKotlinClassByDescriptor(container);
    }

    @Nullable
    private KotlinJvmBinaryClass findPackagePartClass(@NotNull PackageFragmentDescriptor container, @NotNull ProtoBuf.Callable proto, @NotNull NameResolver nameResolver) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "org/jetbrains/jet/lang/resolve/kotlin/BaseDescriptorLoader", "findPackagePartClass"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/lang/resolve/kotlin/BaseDescriptorLoader", "findPackagePartClass"));
        }
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/jet/lang/resolve/kotlin/BaseDescriptorLoader", "findPackagePartClass"));
        }
        if (proto.hasExtension(JavaProtoBuf.implClassName)) {
            return this.kotlinClassFinder.findKotlinClass(new ClassId(container.getFqName(), BaseDescriptorLoader.getPackagePartClassName(proto, nameResolver)));
        }
        return null;
    }

    @NotNull
    public static Name getPackagePartClassName(@NotNull DeserializedCallableMemberDescriptor deserializedCallableMember) {
        if (deserializedCallableMember == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deserializedCallableMember", "org/jetbrains/jet/lang/resolve/kotlin/BaseDescriptorLoader", "getPackagePartClassName"));
        }
        Name name = BaseDescriptorLoader.getPackagePartClassName(deserializedCallableMember.getProto(), deserializedCallableMember.getNameResolver());
        if (name == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/BaseDescriptorLoader", "getPackagePartClassName"));
        }
        return name;
    }

    @NotNull
    private static Name getPackagePartClassName(@NotNull ProtoBuf.Callable proto, @NotNull NameResolver nameResolver) {
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/lang/resolve/kotlin/BaseDescriptorLoader", "getPackagePartClassName"));
        }
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/jet/lang/resolve/kotlin/BaseDescriptorLoader", "getPackagePartClassName"));
        }
        Name name = nameResolver.getName(proto.getExtension(JavaProtoBuf.implClassName));
        if (name == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/BaseDescriptorLoader", "getPackagePartClassName"));
        }
        return name;
    }

    private static boolean isStaticFieldInOuter(@NotNull ProtoBuf.Callable proto) {
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/lang/resolve/kotlin/BaseDescriptorLoader", "isStaticFieldInOuter"));
        }
        if (!proto.hasExtension(JavaProtoBuf.propertySignature)) {
            return false;
        }
        JavaProtoBuf.JavaPropertySignature propertySignature = proto.getExtension(JavaProtoBuf.propertySignature);
        return propertySignature.hasField() && propertySignature.getField().getIsStaticInOuter();
    }

    @Nullable
    protected KotlinJvmBinaryClass findKotlinClassByDescriptor(@NotNull ClassOrPackageFragmentDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/kotlin/BaseDescriptorLoader", "findKotlinClassByDescriptor"));
        }
        if (descriptor instanceof ClassDescriptor) {
            return this.kotlinClassFinder.findKotlinClass(DeserializedResolverUtils.kotlinClassIdToJavaClassId(DeserializedResolverUtils.getClassId((ClassDescriptor)descriptor)));
        }
        if (descriptor instanceof PackageFragmentDescriptor) {
            return this.kotlinClassFinder.findKotlinClass(PackageClassUtils.getPackageClassId(((PackageFragmentDescriptor)descriptor).getFqName()));
        }
        throw new IllegalStateException("Unrecognized descriptor: " + descriptor);
    }
}

