/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.kotlin;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.SLRUCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.jet.lang.resolve.kotlin.VirtualFileKotlinClass;

public final class KotlinBinaryClassCache
implements Disposable {
    private final ThreadLocal<SLRUCache<VirtualFile, Ref<VirtualFileKotlinClass>>> cache = new ThreadLocal<SLRUCache<VirtualFile, Ref<VirtualFileKotlinClass>>>(){

        @Override
        protected SLRUCache<VirtualFile, Ref<VirtualFileKotlinClass>> initialValue() {
            return new SLRUCache<VirtualFile, Ref<VirtualFileKotlinClass>>(2, 2){

                @Override
                @NotNull
                public Ref<VirtualFileKotlinClass> createValue(VirtualFile virtualFile) {
                    Ref<VirtualFileKotlinClass> ref = Ref.create(VirtualFileKotlinClass.OBJECT$.create(virtualFile));
                    if (ref == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/KotlinBinaryClassCache$1$1", "createValue"));
                    }
                    return ref;
                }
            };
        }
    };

    @Nullable
    public static KotlinJvmBinaryClass getKotlinBinaryClass(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/lang/resolve/kotlin/KotlinBinaryClassCache", "getKotlinBinaryClass"));
        }
        if (file.getFileType() != JavaClassFileType.INSTANCE) {
            return null;
        }
        KotlinBinaryClassCache service = ServiceManager.getService(KotlinBinaryClassCache.class);
        return service.cache.get().get(file).get();
    }

    @Override
    public void dispose() {
        this.cache.remove();
    }
}

