/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsExpressionImpl;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import java.util.ArrayList;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KObject;
import kotlin.jvm.internal.KotlinClass;
import kotlin.reflect.jvm.internal.InternalPackage;
import kotlin.reflect.jvm.internal.KClassImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.psi.JetCallableReferenceExpression;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.reference.ReferenceTranslator;
import org.jetbrains.k2js.translate.utils.AnnotationsUtils;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;

@KotlinClass(abiVersion=18, data={"G\f)Y2)\u00197mC\ndWMU3gKJ,gnY3Ue\u0006t7\u000f\\1u_JT1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0003le)\u001c(\"\u0003;sC:\u001cH.\u0019;f\u0015%\u0011XMZ3sK:\u001cWMC\u0002B]fTaa[8uY&t'\"D5t\u0007>t7\u000f\u001e:vGR|'O\u0003\u0006eKN\u001c'/\u001b9u_JT!cQ1mY\u0006\u0014G.\u001a#fg\u000e\u0014\u0018\u000e\u001d;pe*\u0019!.\u001a;\u000b\t1\fgn\u001a\u0006\fI\u0016\u001c8M]5qi>\u00148OC\u0004C_>dW-\u00198\u000b\u0017%\u001cX\t\u001f;f]NLwN\u001c\u0006\tSNlU-\u001c2fe*)\u0011n\u001d,be*\u0011\u0002K]8qKJ$\u0018\u0010R3tGJL\u0007\u000f^8s\u00151Q5/\u0012=qe\u0016\u001c8/[8o\u0015\r\u0019w.\u001c\u0006\u0007O>|w\r\\3\u000b\t\u0011\f'\u000f\u001e\u0006\tG>l\u0007/\u001b7fe*9!-Y2lK:$'B\u00016t\u0015\r\t7\u000f\u001e\u0006\u000bKb\u0004(/Z:tS>t'B\b&fi\u000e\u000bG\u000e\\1cY\u0016\u0014VMZ3sK:\u001cW-\u0012=qe\u0016\u001c8/[8o\u0015\r\u00018/\u001b\u0006\bG>tG/\u001a=u\u0015I!&/\u00198tY\u0006$\u0018n\u001c8D_:$X\r\u001f;\u000bEQ\u0014\u0018M\\:mCR,\u0017i]'f[\n,'OR;oGRLwN\u001c*fM\u0016\u0014XM\\2f\u0015=\u0019G.Y:t\t\u0016\u001c8M]5qi>\u0014(bD\"mCN\u001cH)Z:de&\u0004Ho\u001c:\u000b/Q\u0014\u0018M\\:mCR,gi\u001c:D_:\u001cHO];di>\u0014(B\u0005$v]\u000e$\u0018n\u001c8EKN\u001c'/\u001b9u_JTQ\u0004\u001e:b]Nd\u0017\r^3G_J,\u0005\u0010^3og&|gNR;oGRLwN\u001c\u0006\u001eiJ\fgn\u001d7bi\u00164uN]#yi\u0016t7/[8o!J|\u0007/\u001a:us*!BO]1og2\fG/\u001a$pe\u001a+hn\u0019;j_:T!\u0004\u001e:b]Nd\u0017\r^3G_JlU-\u001c2fe\u001a+hn\u0019;j_:T!\u0004\u001e:b]Nd\u0017\r^3G_JlU-\u001c2feB\u0013x\u000e]3sifTA\u0003\u001e:b]Nd\u0017\r^3G_J\u0004&o\u001c9feRL(\u0002\b;sC:\u001cH.\u0019;f\r>\u0014Hk\u001c9MKZ,G\u000e\u0015:pa\u0016\u0014H/\u001f\u0006/y\rd\u0017m]:._\nTWm\u0019;.M>\u0014XfQ1mY\u0006\u0014G.\u001a*fM\u0016\u0014XM\\2f)J\fgn\u001d7bi>\u0014h\b{\u0001\u000b\u0005A\t!\u0002\u0002\u0005\u0001!\tQA\u0001C\u0001\u0011\u0007)!\u0001B\u0001\t\u0005\u0015\u0011A1\u0001E\u0003\u000b\r!!\u0001\u0003\u0001\r\u0001\u0015\t\u0001rA\u0003\u0004\t\rA1\u0001\u0004\u0001\u0006\u0005\u0011\u0005\u00012B\u0003\u0003\t\u0011Aa!\u0002\u0002\u0005\n!5Qa\u0001\u0003\u0006\u0011\u0015a\u0001!B\u0002\u0005\u0007!9A\u0002A\u0003\u0003\t\u0015AQ!B\u0002\u0005\u000b!IA\u0002A\u0003\u0002\u0011))!\u0001b\u0004\t\u0016\u0015\u0011A\u0001\u0003\u0005\f\u000b\t!\t\u0002c\u0006\u0006\u0005\u0011I\u0001\u0002D\u0003\u0003\t'AI\"\u0002\u0002\u0005\u0015!iQa\u0001C\u000b\u0011'a\u0001!\u0002\u0002\u0005\u0016!MQA\u0001\u0003\u0006\u0011%)!\u0001\"\u0003\t\u001e\u0015\u0019A\u0011\u0004\u0005\u000f\u0019\u0001)!\u0001b\u0001\t\u001f\u0015\u0019A1\u0004E\u0010\u0019\u0001)!\u0001\"\u0007\t\u001d\u0015\u0011A1\u0004E\u0010\u000b\r!Q\u0001C\t\r\u0001\u0015\u0011A!\u0002\u0005\u0012\u000b\r!Q\u0001\u0003\n\r\u0001\u0015\u0011A!\u0002\u0005\u0013\u000b\r!)\u0001\u0003\f\r\u0001\u0011\u0001\u0017\u0001$\u0002\u0012\u0010\u00155Aaq\u0001\r$e\u0011Q!\u0001E\u0003k\u0001I\"!B\u0001\t\b5\u001aB!\u0001\r\u0005;\u001b!\u0001\u0001#\u0003\u000e\u0005\u0015\t\u00012\u0002)\u0004\u0001\u0005\u0012Q!\u0001\u0005\u0007#\u000e)A\u0001B\u0005\u0002\t\u0003i\u0011\u0001#\u0004.'\u0011\t\u0001tBO\u0007\t\u0001AI!\u0004\u0002\u0006\u0003!-\u0001k\u0001\u0001\"\u0005\u0015\t\u0001BB)\u0004\u000b\u0011=\u0011\"\u0001C\u0001\u001b\u0005Ai!L\n\u0005\u0003aAQT\u0002\u0003\u0001\u0011\u0013i!!B\u0001\t\fA\u001b\u0001!\t\u0002\u0006\u0003!1\u0011kA\u0003\u0005\u0011%\tA\u0011A\u0007\u0002\u0011\u001bi3\u0003B\u0001\u0019\u0012u5A\u0001\u0001E\u0005\u001b\t)\u0011\u0001C\u0004Q\u0007\u0001\t#!B\u0001\t\u0017E\u001bQ\u0001\"\u0005\n\u0003!]Q\"\u0001\u0005\r[s!\u0001\u0001\u0007\u0002\u001e\u000e\u0011\u0001\u00012D\u0007\u0003\u000b\u0005AQ\u0002U\u0002\u0001;\u001b!\u0001\u0001C\b\u000e\u0005\u0015\t\u0001B\u0004)\u0004\u0002\u0005\u0012Q!\u0001\u0005\f#\u000e9AAA\u0005\u0002\u0011/i\u0011\u0001#\b\u000e\u0003!yQF\n\u0003\u00021Aij\u0001\u0002\u0001\t\n5\u0011Q!\u0001E\u0006!\u000e\u0001QT\u0002\u0003\u0001\u0011Ci!!B\u0001\t A\u001b\t!(\u0004\u0005\u0001!yQBA\u0003\u0002\u00119\u00016!A\u0011\u0003\u000b\u0005A1\"U\u0002\n\tAI\u0011\u0001c\u0006\u000e\u0003!5Q\"\u0001\u0005\u0011\u001b\u0005Aq\",\u000f\u0005\u0003a\rRT\u0002\u0003\u0001\u0011\u0013i!!B\u0001\t\"A\u001b\u0001!(\u0004\u0005\u0001!yQBA\u0003\u0002\u00119\u00016\u0011A\u0011\u0003\u000b\u0005A1\"U\u0002\b\tGI\u0011\u0001c\u0006\u000e\u0003!\tR\"\u0001\u0005\u0010[s!\u0011\u0001'\n\u001e\u000e\u0011\u0001\u0001\u0012B\u0007\u0003\u000b\u0005A\t\u0003U\u0002\u0001;\u001b!\u0001\u0001C\b\u000e\u0005\u0015\t\u0001B\u0004)\u0004\u0002\u0005\u0012Q!\u0001\u0005\f#\u000e9AQE\u0005\u0002\u0011/i\u0011\u0001C\t\u000e\u0003!yQ\u0016\b\u0003\u00021Mij\u0001\u0002\u0001\t\n5\u0011Q!\u0001\u0005\b!\u000e\u0001QT\u0002\u0003\u0001\u0011=i!!B\u0001\t\u001dA\u001b\t!\t\u0002\u0006\u0003!Y\u0011kA\u0004\u0005'%\t\u0001rC\u0007\u0002\u00111i\u0011\u0001C\b.:\u0011\t\u0001tEO\u0007\t\u0001AI!\u0004\u0002\u0006\u0003!\u0005\u0002k\u0001\u0001\u001e\u000e\u0011\u0001\u0001bD\u0007\u0003\u000b\u0005Aa\u0002UB\u0001C\t)\u0011\u0001C\u0006R\u0007\u001d!9#C\u0001\t\u00185\t\u0001\"E\u0007\u0002\u0011=iK\u0004B\u0001\u0019)u5A\u0001\u0001E\u0005\u001b\t)\u0011\u0001#\tQ\u0007\u0001ij\u0001\u0002\u0001\t\u001f5\u0011Q!\u0001\u0005\u000f!\u000e\u0005\u0011EA\u0003\u0002\u0011-\t6a\u0002\u0003\u0015\u0013\u0005A9\"D\u0001\t#5\t\u0001bDW\u001d\t\u0005AJ#(\u0004\u0005\u0001!%QBA\u0003\u0002\u0011\u001d\u00016\u0001AO\u0007\t\u0001Aq\"\u0004\u0002\u0006\u0003!q\u0001k!\u0001\"\u0005\u0015\t\u0001bC)\u0004\u000f\u0011%\u0012\"\u0001E\f\u001b\u0005AA\"D\u0001\t\u001f5fB!\u0001\r\u0016;\u001b!\u0001\u0001#\u0003\u000e\u0005\u0015\t\u0001b\u0002)\u0004\u0001u5A\u0001\u0001\u0005\u0010\u001b\t)\u0011\u0001\u0003\bQ\u0007\u0003\t#!B\u0001\t\u0017E\u001bq\u0001B\u000b\n\u0003!]Q\"\u0001\u0005\r\u001b\u0005Aq\",\u000f\u0005\u0003a-RT\u0002\u0003\u0001\u0011\u0013i!!B\u0001\t\u000fA\u001b\u0001!(\u0004\u0005\u0001!yQBA\u0003\u0002\u00119\u00016\u0011A\u0011\u0003\u000b\u0005A1\"U\u0002\b\tWI\u0011\u0001c\u0006\u000e\u0003!aQ\"\u0001\u0005\u0010k\u0001\u0001"})
public final class CallableReferenceTranslator
implements KObject {
    public static final /* synthetic */ KClassImpl $kotlinClass;
    public static final CallableReferenceTranslator INSTANCE$;

    static {
        $kotlinClass = InternalPackage.kClassFromKotlin(CallableReferenceTranslator.class);
        new CallableReferenceTranslator();
    }

    @NotNull
    public final JsExpression translate(@JetValueParameter(name="expression") @NotNull JetCallableReferenceExpression expression, @JetValueParameter(name="context") @NotNull TranslationContext context2) {
        JsExpression jsExpression;
        DeclarationDescriptor descriptor;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/reference/CallableReferenceTranslator", "translate"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/CallableReferenceTranslator", "translate"));
        }
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        DeclarationDescriptor declarationDescriptor = descriptor = BindingUtils.getDescriptorForReferenceExpression(context2.bindingContext(), expression.getCallableReference());
        if (declarationDescriptor instanceof PropertyDescriptor) {
            DeclarationDescriptor declarationDescriptor2 = descriptor;
            if (declarationDescriptor2 == null) {
                throw new TypeCastException("org.jetbrains.jet.lang.descriptors.DeclarationDescriptor! cannot be cast to org.jetbrains.jet.lang.descriptors.PropertyDescriptor");
            }
            jsExpression = this.translateForProperty((PropertyDescriptor)declarationDescriptor2, context2);
        } else if (declarationDescriptor instanceof FunctionDescriptor) {
            DeclarationDescriptor declarationDescriptor3 = descriptor;
            if (declarationDescriptor3 == null) {
                throw new TypeCastException("org.jetbrains.jet.lang.descriptors.DeclarationDescriptor! cannot be cast to org.jetbrains.jet.lang.descriptors.FunctionDescriptor");
            }
            jsExpression = this.translateForFunction((FunctionDescriptor)declarationDescriptor3, context2);
        } else {
            throw (Throwable)new IllegalArgumentException("Expected property or function: " + descriptor + ", expression=" + expression.getText());
        }
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallableReferenceTranslator", "translate"));
        }
        return jsExpression;
    }

    private final JsExpression translateForFunction(@JetValueParameter(name="descriptor") FunctionDescriptor descriptor, @JetValueParameter(name="context") TranslationContext context2) {
        if (JsDescriptorUtils.isBuiltin(descriptor)) {
            throw (Throwable)new UnsupportedOperationException("callable references for builtin functions are not supported yet");
        }
        return this.isConstructor(descriptor) ? this.translateForConstructor(descriptor, context2) : (this.isExtension(descriptor) ? this.translateForExtensionFunction(descriptor, context2) : (this.isMember(descriptor) ? this.translateForMemberFunction(descriptor, context2) : ReferenceTranslator.translateAsFQReference(descriptor, context2)));
    }

    private final JsExpression translateForProperty(@JetValueParameter(name="descriptor") PropertyDescriptor descriptor, @JetValueParameter(name="context") TranslationContext context2) {
        if (JsDescriptorUtils.isBuiltin(descriptor)) {
            throw (Throwable)new UnsupportedOperationException("callable references for builtin properties are not supported yet");
        }
        return this.isExtension(descriptor) ? this.translateForExtensionProperty(descriptor, context2) : (this.isMember(descriptor) ? this.translateForMemberProperty(descriptor, context2) : this.translateForTopLevelProperty(descriptor, context2));
    }

    private final boolean isConstructor(@JetValueParameter(name="descriptor") CallableDescriptor descriptor) {
        return descriptor instanceof ConstructorDescriptor;
    }

    private final boolean isExtension(@JetValueParameter(name="descriptor") CallableDescriptor descriptor) {
        return JsDescriptorUtils.isExtension(descriptor);
    }

    private final boolean isMember(@JetValueParameter(name="descriptor") CallableDescriptor descriptor) {
        return JsDescriptorUtils.getContainingDeclaration(descriptor) instanceof ClassDescriptor;
    }

    private final JsExpression isVar(@JetValueParameter(name="descriptor") PropertyDescriptor descriptor) {
        return descriptor.isVar() ? JsLiteral.TRUE : JsLiteral.FALSE;
    }

    private final JsExpression translateForTopLevelProperty(@JetValueParameter(name="descriptor") PropertyDescriptor descriptor, @JetValueParameter(name="context") TranslationContext context2) {
        DeclarationDescriptor packageDescriptor = JsDescriptorUtils.getContainingDeclaration(descriptor);
        KotlinPackage.assert(packageDescriptor instanceof PackageFragmentDescriptor, "Expected PackageFragmentDescriptor: " + packageDescriptor);
        JsNameRef jsPackageNameRef = context2.getQualifiedReference(packageDescriptor);
        JsName jsPropertyName = context2.getNameForDescriptor(descriptor);
        JsStringLiteral jsPropertyNameAsString = context2.program().getStringLiteral(jsPropertyName.toString());
        return new JsInvocation(context2.namer().callableRefForTopLevelPropertyReference(), jsPackageNameRef, jsPropertyNameAsString, this.isVar(descriptor));
    }

    private final JsExpression translateForMemberProperty(@JetValueParameter(name="descriptor") PropertyDescriptor descriptor, @JetValueParameter(name="context") TranslationContext context2) {
        JsName jsPropertyName = context2.getNameForDescriptor(descriptor);
        JsStringLiteral jsPropertyNameAsString = context2.program().getStringLiteral(jsPropertyName.toString());
        return new JsInvocation(context2.namer().callableRefForMemberPropertyReference(), jsPropertyNameAsString, this.isVar(descriptor));
    }

    private final JsExpression translateForExtensionProperty(@JetValueParameter(name="descriptor") PropertyDescriptor descriptor, @JetValueParameter(name="context") TranslationContext context2) {
        PropertyGetterDescriptor propertyGetterDescriptor = descriptor.getGetter();
        if (propertyGetterDescriptor == null) {
            Intrinsics.throwNpe();
        }
        JsNameRef jsGetterNameRef = context2.getQualifiedReference(propertyGetterDescriptor);
        Name propertyName = descriptor.getName();
        JsStringLiteral jsPropertyNameAsString = context2.program().getStringLiteral(propertyName.asString());
        ArrayList<JsExpressionImpl> argumentList = new ArrayList<JsExpressionImpl>(3);
        argumentList.add(jsPropertyNameAsString);
        argumentList.add(jsGetterNameRef);
        if (descriptor.isVar()) {
            PropertySetterDescriptor propertySetterDescriptor = descriptor.getSetter();
            if (propertySetterDescriptor == null) {
                Intrinsics.throwNpe();
            }
            JsNameRef jsSetterNameRef = context2.getQualifiedReference(propertySetterDescriptor);
            argumentList.add(jsSetterNameRef);
        }
        if (AnnotationsUtils.isNativeObject(descriptor)) {
            return this.translateForMemberProperty(descriptor, context2);
        }
        return new JsInvocation(context2.namer().callableRefForExtensionPropertyReference(), (List<JsExpression>)argumentList);
    }

    private final JsExpression translateForConstructor(@JetValueParameter(name="descriptor") FunctionDescriptor descriptor, @JetValueParameter(name="context") TranslationContext context2) {
        JsExpression jsFunctionRef = ReferenceTranslator.translateAsFQReference(descriptor, context2);
        return new JsInvocation(context2.namer().callableRefForConstructorReference(), jsFunctionRef);
    }

    private final JsExpression translateForExtensionFunction(@JetValueParameter(name="descriptor") FunctionDescriptor descriptor, @JetValueParameter(name="context") TranslationContext context2) {
        ReceiverParameterDescriptor receiverParameterDescriptor = descriptor.getReceiverParameter();
        KotlinPackage.assert(receiverParameterDescriptor != null, "receiverParameter for extension should not be null");
        JsExpression jsFunctionRef = ReferenceTranslator.translateAsFQReference(descriptor, context2);
        if (Intrinsics.areEqual(descriptor.getVisibility(), Visibilities.LOCAL)) {
            return jsFunctionRef;
        }
        if (AnnotationsUtils.isNativeObject(descriptor)) {
            ReceiverParameterDescriptor receiverParameterDescriptor2 = receiverParameterDescriptor;
            if (receiverParameterDescriptor2 == null) {
                Intrinsics.throwNpe();
            }
            JetType jetType = receiverParameterDescriptor2.getType();
            ClassDescriptor receiverClassDescriptor = DescriptorUtils.getClassDescriptorForType(jetType);
            return this.translateAsMemberFunctionReference(descriptor, receiverClassDescriptor, context2);
        }
        return new JsInvocation(context2.namer().callableRefForExtensionFunctionReference(), jsFunctionRef);
    }

    private final JsExpression translateForMemberFunction(@JetValueParameter(name="descriptor") FunctionDescriptor descriptor, @JetValueParameter(name="context") TranslationContext context2) {
        DeclarationDescriptor declarationDescriptor = JsDescriptorUtils.getContainingDeclaration(descriptor);
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        if (classDescriptor == null) {
            throw (Throwable)new IllegalArgumentException("Expected ClassDescriptor: " + descriptor);
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        return this.translateAsMemberFunctionReference(descriptor, classDescriptor2, context2);
    }

    private final JsExpression translateAsMemberFunctionReference(@JetValueParameter(name="descriptor") CallableDescriptor descriptor, @JetValueParameter(name="classDescriptor") ClassDescriptor classDescriptor, @JetValueParameter(name="context") TranslationContext context2) {
        JsNameRef jsClassNameRef = context2.getQualifiedReference(classDescriptor);
        JsName funName = context2.getNameForDescriptor(descriptor);
        JsStringLiteral funNameAsString = context2.program().getStringLiteral(funName.toString());
        return new JsInvocation(context2.namer().callableRefForMemberFunctionReference(), jsClassNameRef, funNameAsString);
    }

    CallableReferenceTranslator() {
        INSTANCE$ = this;
    }
}

