/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import com.google.dart.compiler.backend.js.ast.SourceInfoAwareJsNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class JsBlock
extends SourceInfoAwareJsNode
implements JsStatement {
    private final List<JsStatement> statements;

    public JsBlock() {
        this(new ArrayList<JsStatement>());
    }

    public JsBlock(JsStatement statement) {
        this(Collections.singletonList(statement));
    }

    public JsBlock(JsStatement ... statements) {
        this(Arrays.asList(statements));
    }

    public JsBlock(List<JsStatement> statements) {
        this.statements = statements;
    }

    public List<JsStatement> getStatements() {
        return this.statements;
    }

    public boolean isEmpty() {
        return this.statements.isEmpty();
    }

    public boolean isGlobalBlock() {
        return false;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitBlock(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor) {
        visitor.acceptWithInsertRemove(this.statements);
    }
}

