/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.containers.HashMap;
import gnu.trove.TObjectIntHashMap;
import java.util.Comparator;
import java.util.Map;
import java.util.Stack;

public class PluginDescriptorComparator
implements Comparator<IdeaPluginDescriptor> {
    private final TObjectIntHashMap<PluginId> myIdToNumberMap = new TObjectIntHashMap();
    private int myAvailableNumber = 1;

    public PluginDescriptorComparator(IdeaPluginDescriptor[] descriptors) {
        HashMap<PluginId, IdeaPluginDescriptor> idToDescriptorMap = new HashMap<PluginId, IdeaPluginDescriptor>();
        for (IdeaPluginDescriptor descriptor : descriptors) {
            idToDescriptorMap.put(descriptor.getPluginId(), descriptor);
        }
        this.myIdToNumberMap.put(PluginId.getId("com.intellij"), 0);
        Stack<PluginId> visited = new Stack<PluginId>();
        for (int idx = 0; idx < descriptors.length && this.myIdToNumberMap.size() != descriptors.length; ++idx) {
            this.assignNumbers(descriptors[idx].getPluginId(), idToDescriptorMap, visited);
            visited.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignNumbers(PluginId id, Map<PluginId, IdeaPluginDescriptor> idToDescriptorMap, Stack<PluginId> visited) {
        visited.push(id);
        try {
            PluginId[] parentIds;
            IdeaPluginDescriptor ideaPluginDescriptor = idToDescriptorMap.get(id);
            if (ideaPluginDescriptor == null || !ideaPluginDescriptor.isEnabled()) {
                return;
            }
            for (PluginId parentId : parentIds = ideaPluginDescriptor.getDependentPluginIds()) {
                if (!visited.contains(parentId)) continue;
                ideaPluginDescriptor.setEnabled(false);
                break;
            }
            for (PluginId parentId1 : parentIds) {
                this.assignNumbers(parentId1, idToDescriptorMap, visited);
            }
            if (!this.myIdToNumberMap.contains(id)) {
                this.myIdToNumberMap.put(id, this.myAvailableNumber++);
            }
        }
        finally {
            visited.pop();
        }
    }

    @Override
    public int compare(IdeaPluginDescriptor d1, IdeaPluginDescriptor d2) {
        return this.myIdToNumberMap.get(d1.getPluginId()) - this.myIdToNumberMap.get(d2.getPluginId());
    }
}

