/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringUtilRt {
    public static boolean charsEqualIgnoreCase(char a, char b) {
        return a == b || StringUtilRt.toUpperCase(a) == StringUtilRt.toUpperCase(b) || StringUtilRt.toLowerCase(a) == StringUtilRt.toLowerCase(b);
    }

    @NotNull
    public static String toUpperCase(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtilRt", "toUpperCase"));
        }
        StringBuilder answer = null;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            char upcased = StringUtilRt.toUpperCase(c);
            if (answer == null && upcased != c) {
                answer = new StringBuilder(s.length());
                answer.append(s.substring(0, i));
            }
            if (answer == null) continue;
            answer.append(upcased);
        }
        String string = answer == null ? s : answer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtilRt", "toUpperCase"));
        }
        return string;
    }

    public static char toUpperCase(char a) {
        if (a < 'a') {
            return a;
        }
        if (a <= 'z') {
            return (char)(a + -32);
        }
        return Character.toUpperCase(a);
    }

    public static char toLowerCase(char a) {
        if (a < 'A' || a >= 'a' && a <= 'z') {
            return a;
        }
        if (a <= 'Z') {
            return (char)(a + 32);
        }
        return Character.toLowerCase(a);
    }

    @NotNull
    public static String convertLineSeparators(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtilRt", "convertLineSeparators"));
        }
        String string = StringUtilRt.convertLineSeparators(text, false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtilRt", "convertLineSeparators"));
        }
        return string;
    }

    @NotNull
    public static String convertLineSeparators(@NotNull String text, boolean keepCarriageReturn) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtilRt", "convertLineSeparators"));
        }
        String string = StringUtilRt.convertLineSeparators(text, "\n", null, keepCarriageReturn);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtilRt", "convertLineSeparators"));
        }
        return string;
    }

    @NotNull
    public static String convertLineSeparators(@NotNull String text, @NotNull String newSeparator) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtilRt", "convertLineSeparators"));
        }
        if (newSeparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSeparator", "com/intellij/openapi/util/text/StringUtilRt", "convertLineSeparators"));
        }
        String string = StringUtilRt.convertLineSeparators(text, newSeparator, null);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtilRt", "convertLineSeparators"));
        }
        return string;
    }

    @NotNull
    public static String convertLineSeparators(@NotNull String text, @NotNull String newSeparator, @Nullable int[] offsetsToKeep) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtilRt", "convertLineSeparators"));
        }
        if (newSeparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSeparator", "com/intellij/openapi/util/text/StringUtilRt", "convertLineSeparators"));
        }
        String string = StringUtilRt.convertLineSeparators(text, newSeparator, offsetsToKeep, false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtilRt", "convertLineSeparators"));
        }
        return string;
    }

    @NotNull
    public static String convertLineSeparators(@NotNull String text, @NotNull String newSeparator, @Nullable int[] offsetsToKeep, boolean keepCarriageReturn) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtilRt", "convertLineSeparators"));
        }
        if (newSeparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSeparator", "com/intellij/openapi/util/text/StringUtilRt", "convertLineSeparators"));
        }
        String string = ((Object)StringUtilRt.unifyLineSeparators(text, newSeparator, offsetsToKeep, keepCarriageReturn)).toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtilRt", "convertLineSeparators"));
        }
        return string;
    }

    @NotNull
    public static CharSequence unifyLineSeparators(@NotNull CharSequence text, @NotNull String newSeparator, @Nullable int[] offsetsToKeep, boolean keepCarriageReturn) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtilRt", "unifyLineSeparators"));
        }
        if (newSeparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSeparator", "com/intellij/openapi/util/text/StringUtilRt", "unifyLineSeparators"));
        }
        StringBuilder buffer = null;
        int intactLength = 0;
        boolean newSeparatorIsSlashN = "\n".equals(newSeparator);
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\n') {
                if (!newSeparatorIsSlashN) {
                    if (buffer == null) {
                        buffer = new StringBuilder(text.length());
                        buffer.append(text, 0, intactLength);
                    }
                    buffer.append(newSeparator);
                    StringUtilRt.shiftOffsets(offsetsToKeep, buffer.length(), 1, newSeparator.length());
                    continue;
                }
                if (buffer == null) {
                    ++intactLength;
                    continue;
                }
                buffer.append(c);
                continue;
            }
            if (c == '\r') {
                boolean followedByLineFeed;
                boolean bl = followedByLineFeed = i < text.length() - 1 && text.charAt(i + 1) == '\n';
                if (!followedByLineFeed && keepCarriageReturn) {
                    if (buffer == null) {
                        ++intactLength;
                        continue;
                    }
                    buffer.append(c);
                    continue;
                }
                if (buffer == null) {
                    buffer = new StringBuilder(text.length());
                    buffer.append(text, 0, intactLength);
                }
                buffer.append(newSeparator);
                if (followedByLineFeed) {
                    ++i;
                    StringUtilRt.shiftOffsets(offsetsToKeep, buffer.length(), 2, newSeparator.length());
                    continue;
                }
                StringUtilRt.shiftOffsets(offsetsToKeep, buffer.length(), 1, newSeparator.length());
                continue;
            }
            if (buffer == null) {
                ++intactLength;
                continue;
            }
            buffer.append(c);
        }
        CharSequence charSequence = buffer == null ? text : buffer;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtilRt", "unifyLineSeparators"));
        }
        return charSequence;
    }

    private static void shiftOffsets(int[] offsets, int changeOffset, int oldLength, int newLength) {
        if (offsets == null) {
            return;
        }
        int shift = newLength - oldLength;
        if (shift == 0) {
            return;
        }
        for (int i = 0; i < offsets.length; ++i) {
            int offset = offsets[i];
            if (offset < changeOffset + oldLength) continue;
            int n = i;
            offsets[n] = offsets[n] + shift;
        }
    }

    @NotNull
    public static String getShortName(@NotNull String fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "com/intellij/openapi/util/text/StringUtilRt", "getShortName"));
        }
        String string = StringUtilRt.getShortName(fqName, '.');
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtilRt", "getShortName"));
        }
        return string;
    }

    @NotNull
    public static String getShortName(@NotNull String fqName, char separator) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "com/intellij/openapi/util/text/StringUtilRt", "getShortName"));
        }
        int lastPointIdx = fqName.lastIndexOf(separator);
        if (lastPointIdx >= 0) {
            String string = fqName.substring(lastPointIdx + 1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtilRt", "getShortName"));
            }
            return string;
        }
        String string = fqName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtilRt", "getShortName"));
        }
        return string;
    }

    public static boolean endsWithChar(@Nullable CharSequence s, char suffix) {
        return s != null && s.length() != 0 && s.charAt(s.length() - 1) == suffix;
    }

    public static boolean startsWithIgnoreCase(@NonNls @NotNull String str, @NonNls @NotNull String prefix) {
        int prefixLength;
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/openapi/util/text/StringUtilRt", "startsWithIgnoreCase"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/openapi/util/text/StringUtilRt", "startsWithIgnoreCase"));
        }
        int stringLength = str.length();
        return stringLength >= (prefixLength = prefix.length()) && str.regionMatches(true, 0, prefix, 0, prefixLength);
    }

    public static boolean endsWithIgnoreCase(@NonNls @NotNull CharSequence text, @NonNls @NotNull CharSequence suffix) {
        int l2;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtilRt", "endsWithIgnoreCase"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/openapi/util/text/StringUtilRt", "endsWithIgnoreCase"));
        }
        int l1 = text.length();
        if (l1 < (l2 = suffix.length())) {
            return false;
        }
        for (int i = l1 - 1; i >= l1 - l2; --i) {
            if (StringUtilRt.charsEqualIgnoreCase(text.charAt(i), suffix.charAt(i + l2 - l1))) continue;
            return false;
        }
        return true;
    }

    public static int lastIndexOf(@NotNull CharSequence s, char c, int start, int end) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtilRt", "lastIndexOf"));
        }
        for (int i = end - 1; i >= start; --i) {
            if (s.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }
}

