/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModel;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.impl.PomTransactionBase;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.pom.tree.TreeAspectEvent;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLock;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiToDocumentSynchronizer;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.text.DiffLog;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.text.BlockSupport;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DocumentCommitProcessor {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.DocumentCommitThread");

    public abstract void commitSynchronously(@NotNull Document var1, @NotNull Project var2);

    public abstract void commitAsynchronously(@NotNull Project var1, @NotNull Document var2, @NonNls @NotNull Object var3);

    @Nullable(value="returns runnable to execute under write action in AWT to finish the commit")
    public Processor<Document> doCommit(final @NotNull CommitTask task, final @NotNull PsiFile file, final boolean synchronously) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/psi/impl/DocumentCommitProcessor", "doCommit"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/DocumentCommitProcessor", "doCommit"));
        }
        Document document = task.document;
        final long startDocModificationTimeStamp = document.getModificationStamp();
        final FileElement myTreeElementBeingReparsedSoItWontBeCollected = ((PsiFileImpl)file).calcTreeElement();
        CharSequence chars = document.getImmutableCharSequence();
        final CharSequence oldPsiText = myTreeElementBeingReparsedSoItWontBeCollected.getChars();
        TextRange changedPsiRange = DocumentCommitProcessor.getChangedPsiRange(file, oldPsiText, chars);
        if (changedPsiRange == null) {
            return null;
        }
        Boolean data2 = document.getUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY);
        if (data2 != null) {
            document.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, null);
            file.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, data2);
        }
        BlockSupport blockSupport = BlockSupport.getInstance(file.getProject());
        final DiffLog diffLog = blockSupport.reparseRange(file, changedPsiRange, chars, task.indicator);
        return new Processor<Document>(){

            @Override
            public boolean process(Document document) {
                ApplicationManager.getApplication().assertWriteAccessAllowed();
                DocumentCommitProcessor.this.log("Finishing", task, synchronously, document.getModificationStamp(), startDocModificationTimeStamp);
                if (document.getModificationStamp() != startDocModificationTimeStamp || ((PsiDocumentManagerBase)PsiDocumentManager.getInstance(file.getProject())).getCachedViewProvider(document) != file.getViewProvider()) {
                    return false;
                }
                DocumentCommitProcessor.doActualPsiChange(file, diffLog);
                DocumentCommitProcessor.this.assertAfterCommit(document, file, oldPsiText, myTreeElementBeingReparsedSoItWontBeCollected);
                return true;
            }
        };
    }

    @Nullable
    public static TextRange getChangedPsiRange(@NotNull PsiFile file, @NotNull CharSequence oldPsiText, @NotNull CharSequence newDocumentText) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/DocumentCommitProcessor", "getChangedPsiRange"));
        }
        if (oldPsiText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldPsiText", "com/intellij/psi/impl/DocumentCommitProcessor", "getChangedPsiRange"));
        }
        if (newDocumentText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newDocumentText", "com/intellij/psi/impl/DocumentCommitProcessor", "getChangedPsiRange"));
        }
        if (!file.getViewProvider().supportsIncrementalReparse(file.getLanguage())) {
            return new TextRange(0, newDocumentText.length());
        }
        int commonPrefixLength = StringUtil.commonPrefixLength(oldPsiText, newDocumentText);
        if (commonPrefixLength == newDocumentText.length() && newDocumentText.length() == oldPsiText.length()) {
            return null;
        }
        int commonSuffixLength = StringUtil.commonSuffixLength(oldPsiText, newDocumentText);
        return new TextRange(commonPrefixLength, Math.max(commonPrefixLength, oldPsiText.length() - commonSuffixLength));
    }

    public static void doActualPsiChange(final @NotNull PsiFile file, final @NotNull DiffLog diffLog) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/DocumentCommitProcessor", "doActualPsiChange"));
        }
        if (diffLog == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffLog", "com/intellij/psi/impl/DocumentCommitProcessor", "doActualPsiChange"));
        }
        CodeStyleManager.getInstance(file.getProject()).performActionWithFormatterDisabled(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object2 = PsiLock.LOCK;
                synchronized (object2) {
                    file.getViewProvider().beforeContentsSynchronized();
                    Document document = file.getViewProvider().getDocument();
                    PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(file.getProject());
                    PsiToDocumentSynchronizer.DocumentChangeTransaction transaction = documentManager.getSynchronizer().getTransaction(document);
                    PsiFileImpl fileImpl = (PsiFileImpl)file;
                    if (transaction == null) {
                        final PomModel model = PomManager.getModel(fileImpl.getProject());
                        model.runTransaction(new PomTransactionBase(fileImpl, model.getModelAspect(TreeAspect.class)){

                            @Override
                            public PomModelEvent runInner() {
                                return new TreeAspectEvent(model, diffLog.performActualPsiChange(file));
                            }
                        });
                    } else {
                        diffLog.performActualPsiChange(file);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertAfterCommit(@NotNull Document document, @NotNull PsiFile file, @NotNull CharSequence oldPsiText, @NotNull FileElement myTreeElementBeingReparsedSoItWontBeCollected) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/DocumentCommitProcessor", "assertAfterCommit"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/DocumentCommitProcessor", "assertAfterCommit"));
        }
        if (oldPsiText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldPsiText", "com/intellij/psi/impl/DocumentCommitProcessor", "assertAfterCommit"));
        }
        if (myTreeElementBeingReparsedSoItWontBeCollected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myTreeElementBeingReparsedSoItWontBeCollected", "com/intellij/psi/impl/DocumentCommitProcessor", "assertAfterCommit"));
        }
        if (myTreeElementBeingReparsedSoItWontBeCollected.getTextLength() != document.getTextLength()) {
            String documentText = document.getText();
            String fileText = file.getText();
            LOG.error("commitDocument left PSI inconsistent: " + file + "; file len=" + myTreeElementBeingReparsedSoItWontBeCollected.getTextLength() + "; doc len=" + document.getTextLength() + "; doc.getText() == file.getText(): " + Comparing.equal(fileText, documentText), new Attachment("file psi text", fileText), new Attachment("old text", documentText), new Attachment("old psi file text", ((Object)oldPsiText).toString()));
            file.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, Boolean.TRUE);
            try {
                BlockSupport blockSupport = BlockSupport.getInstance(file.getProject());
                DiffLog diffLog = blockSupport.reparseRange(file, new TextRange(0, documentText.length()), documentText, this.createProgressIndicator());
                DocumentCommitProcessor.doActualPsiChange(file, diffLog);
                if (myTreeElementBeingReparsedSoItWontBeCollected.getTextLength() != document.getTextLength()) {
                    LOG.error("PSI is broken beyond repair in: " + file);
                }
            }
            finally {
                file.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, null);
            }
        }
    }

    public void log(@NonNls String msg, @Nullable CommitTask task, boolean synchronously, Object ... args) {
    }

    @NotNull
    protected ProgressIndicator createProgressIndicator() {
        EmptyProgressIndicator emptyProgressIndicator = new EmptyProgressIndicator();
        if (emptyProgressIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/DocumentCommitProcessor", "createProgressIndicator"));
        }
        return emptyProgressIndicator;
    }

    protected static class CommitTask {
        public final Document document;
        public final Project project;
        public final ProgressIndicator indicator;
        public final Object reason;
        public boolean removed;

        public CommitTask(@NotNull Document document, @NotNull Project project, @NotNull ProgressIndicator indicator, @NotNull Object reason) {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/DocumentCommitProcessor$CommitTask", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/DocumentCommitProcessor$CommitTask", "<init>"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/psi/impl/DocumentCommitProcessor$CommitTask", "<init>"));
            }
            if (reason == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/DocumentCommitProcessor$CommitTask", "<init>"));
            }
            this.document = document;
            this.project = project;
            this.indicator = indicator;
            this.reason = reason;
        }

        @NonNls
        public String toString() {
            return "Project: " + this.project.getName() + ", Doc: " + this.document + " (" + ((Object)StringUtil.first(this.document.getImmutableCharSequence(), 12, true)).toString().replaceAll("\n", " ") + ")" + (this.indicator.isCanceled() ? " (Canceled)" : "") + (this.removed ? "Removed" : "");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CommitTask)) {
                return false;
            }
            CommitTask task = (CommitTask)o;
            return this.document.equals(task.document) && this.project.equals(task.project);
        }

        public int hashCode() {
            int result2 = this.document.hashCode();
            result2 = 31 * result2 + this.project.hashCode();
            return result2;
        }
    }
}

