/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.impl.cache.ModifierFlags;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.PsiFieldStub;
import com.intellij.psi.impl.java.stubs.PsiMethodStub;
import com.intellij.psi.impl.java.stubs.PsiModifierListStub;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.CharTable;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RecordUtil {
    private RecordUtil() {
    }

    public static boolean isDeprecatedByAnnotation(@NotNull LighterAST tree, @NotNull LighterASTNode modList) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/impl/cache/RecordUtil", "isDeprecatedByAnnotation"));
        }
        if (modList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modList", "com/intellij/psi/impl/cache/RecordUtil", "isDeprecatedByAnnotation"));
        }
        for (LighterASTNode child : tree.getChildren(modList)) {
            String name;
            LighterASTNode id;
            LighterASTNode ref;
            if (child.getTokenType() != JavaElementType.ANNOTATION || (ref = LightTreeUtil.firstChildOfType(tree, child, JavaElementType.JAVA_CODE_REFERENCE)) == null || (id = LightTreeUtil.firstChildOfType(tree, ref, JavaTokenType.IDENTIFIER)) == null || !"Deprecated".equals(name = RecordUtil.intern(tree.getCharTable(), id))) continue;
            return true;
        }
        return false;
    }

    public static boolean isDeprecatedByDocComment(@NotNull LighterAST tree, @NotNull LighterASTNode comment) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/impl/cache/RecordUtil", "isDeprecatedByDocComment"));
        }
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/psi/impl/cache/RecordUtil", "isDeprecatedByDocComment"));
        }
        String text = LightTreeUtil.toFilteredString(tree, comment, null);
        return text.contains("@deprecated");
    }

    public static int packModifierList(@NotNull LighterAST tree, @NotNull LighterASTNode modList, @NotNull StubElement parent) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/impl/cache/RecordUtil", "packModifierList"));
        }
        if (modList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modList", "com/intellij/psi/impl/cache/RecordUtil", "packModifierList"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/impl/cache/RecordUtil", "packModifierList"));
        }
        int packed = 0;
        LighterASTNode modListOwner = tree.getParent(modList);
        if (modListOwner != null && modListOwner.getTokenType() == parent.getStubType()) {
            StubElement grandParent = parent.getParentStub();
            if (parent instanceof PsiClassStub) {
                if (grandParent instanceof PsiClassStub && ((PsiClassStub)grandParent).isInterface()) {
                    packed |= 1;
                    packed |= 8;
                }
                if (((PsiClassStub)parent).isInterface()) {
                    packed |= 0x400;
                    if (grandParent instanceof PsiClassStub) {
                        packed |= 8;
                    }
                } else if (((PsiClassStub)parent).isEnum()) {
                    if (!(grandParent instanceof PsiFileStub)) {
                        packed |= 8;
                    }
                    boolean isFinal = true;
                    List<LighterASTNode> enumConstants = LightTreeUtil.getChildrenOfType(tree, modListOwner, JavaElementType.ENUM_CONSTANT);
                    for (LighterASTNode constant : enumConstants) {
                        if (LightTreeUtil.firstChildOfType(tree, constant, JavaElementType.ENUM_CONSTANT_INITIALIZER) == null) continue;
                        isFinal = false;
                        break;
                    }
                    if (isFinal) {
                        packed |= 0x10;
                    }
                    List<LighterASTNode> methods = LightTreeUtil.getChildrenOfType(tree, modListOwner, JavaElementType.METHOD);
                    for (LighterASTNode method : methods) {
                        LighterASTNode mods = LightTreeUtil.requiredChildOfType(tree, method, JavaElementType.MODIFIER_LIST);
                        if (LightTreeUtil.firstChildOfType(tree, mods, JavaTokenType.ABSTRACT_KEYWORD) == null) continue;
                        packed |= 0x400;
                        break;
                    }
                }
            } else if (parent instanceof PsiMethodStub) {
                if (grandParent instanceof PsiClassStub && ((PsiClassStub)grandParent).isInterface()) {
                    packed |= 1;
                    packed |= 0x400;
                }
            } else if (parent instanceof PsiFieldStub && (parent.getStubType() == JavaElementType.ENUM_CONSTANT || grandParent instanceof PsiClassStub && ((PsiClassStub)grandParent).isInterface())) {
                packed |= 1;
                packed |= 8;
                packed |= 0x10;
            }
        }
        for (LighterASTNode child : tree.getChildren(modList)) {
            int flag = ModifierFlags.KEYWORD_TO_MODIFIER_FLAG_MAP.get(child.getTokenType());
            if (flag == 0) continue;
            packed |= flag;
        }
        if ((packed & 0x200) != 0) {
            packed &= 0xFFFFFBFF;
        }
        if ((packed & 7) == 0) {
            packed |= 0x1000;
        }
        return packed;
    }

    @NotNull
    public static String intern(@NotNull CharTable table, @NotNull LighterASTNode node) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/psi/impl/cache/RecordUtil", "intern"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/cache/RecordUtil", "intern"));
        }
        assert (node instanceof LighterASTTokenNode) : node;
        String string = ((Object)table.intern(((LighterASTTokenNode)node).getText())).toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/cache/RecordUtil", "intern"));
        }
        return string;
    }

    public static boolean isStaticNonPrivateMember(@NotNull StubElement<?> stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/cache/RecordUtil", "isStaticNonPrivateMember"));
        }
        StubElement<PsiModifierList> type = stub.findChildStubByType(JavaStubElementTypes.MODIFIER_LIST);
        if (!(type instanceof PsiModifierListStub)) {
            return false;
        }
        int mask = ((PsiModifierListStub)type).getModifiersMask();
        return ModifierFlags.hasModifierProperty("static", mask) && !ModifierFlags.hasModifierProperty("private", mask);
    }
}

