/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiAnnotationStub;
import com.intellij.psi.impl.meta.MetaRegistry;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PairFunction;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiAnnotationImpl
extends JavaStubPsiElement<PsiAnnotationStub>
implements PsiAnnotation {
    private static final PairFunction<Project, String, PsiAnnotation> ANNOTATION_CREATOR = new PairFunction<Project, String, PsiAnnotation>(){

        @Override
        public PsiAnnotation fun(Project project, String text) {
            return JavaPsiFacade.getInstance(project).getElementFactory().createAnnotationFromText(text, null);
        }
    };

    public PsiAnnotationImpl(PsiAnnotationStub stub) {
        super(stub, JavaStubElementTypes.ANNOTATION);
    }

    public PsiAnnotationImpl(ASTNode node) {
        super(node);
    }

    @Override
    public PsiJavaCodeReferenceElement getNameReferenceElement() {
        PsiAnnotationStub stub = (PsiAnnotationStub)this.getStub();
        if (stub != null) {
            return PsiTreeUtil.getRequiredChildOfType(stub.getPsiElement(), PsiJavaCodeReferenceElement.class);
        }
        return PsiTreeUtil.getChildOfType(this, PsiJavaCodeReferenceElement.class);
    }

    @Override
    public PsiAnnotationMemberValue findAttributeValue(String attributeName) {
        return PsiImplUtil.findAttributeValue(this, attributeName);
    }

    @Override
    @Nullable
    public PsiAnnotationMemberValue findDeclaredAttributeValue(@NonNls String attributeName) {
        return PsiImplUtil.findDeclaredAttributeValue(this, attributeName);
    }

    @Override
    public <T extends PsiAnnotationMemberValue> T setDeclaredAttributeValue(@NonNls String attributeName, @Nullable T value) {
        PsiAnnotationMemberValue t = PsiImplUtil.setDeclaredAttributeValue(this, attributeName, value, ANNOTATION_CREATOR);
        return (T)t;
    }

    @Override
    public String toString() {
        return "PsiAnnotation";
    }

    @Override
    @NotNull
    public PsiAnnotationParameterList getParameterList() {
        PsiAnnotationParameterList psiAnnotationParameterList = this.getRequiredStubOrPsiChild(JavaStubElementTypes.ANNOTATION_PARAMETER_LIST);
        if (psiAnnotationParameterList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiAnnotationImpl", "getParameterList"));
        }
        return psiAnnotationParameterList;
    }

    @Override
    @Nullable
    public String getQualifiedName() {
        PsiJavaCodeReferenceElement nameRef = this.getNameReferenceElement();
        if (nameRef == null) {
            return null;
        }
        return nameRef.getCanonicalText();
    }

    @Override
    public final void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/tree/java/PsiAnnotationImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitAnnotation(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public PsiMetaData getMetaData() {
        return MetaRegistry.getMetaBase(this);
    }

    @Override
    @Nullable
    public PsiAnnotationOwner getOwner() {
        PsiElement ctx;
        PsiElement parent = this.getParent();
        if (parent instanceof PsiAnnotationOwner) {
            return (PsiAnnotationOwner)((Object)parent);
        }
        if (parent instanceof PsiNewExpression) {
            return ((PsiNewExpression)parent).getOwner(this);
        }
        if (parent instanceof PsiReferenceExpression ? (ctx = parent.getParent()) instanceof PsiMethodReferenceExpression : parent instanceof PsiJavaCodeReferenceElement && ((ctx = PsiTreeUtil.skipParentsOfType(parent, PsiJavaCodeReferenceElement.class)) instanceof PsiReferenceList || ctx instanceof PsiNewExpression || ctx instanceof PsiTypeElement)) {
            return new PsiClassReferenceType((PsiJavaCodeReferenceElement)parent, null);
        }
        PsiTypeElement typeElement = null;
        PsiElement anchor = null;
        if (parent instanceof PsiMethod) {
            typeElement = ((PsiMethod)parent).getReturnTypeElement();
            anchor = ((PsiMethod)parent).getParameterList();
        } else if (parent instanceof PsiField || parent instanceof PsiParameter || parent instanceof PsiLocalVariable) {
            typeElement = ((PsiVariable)parent).getTypeElement();
            anchor = ((PsiVariable)parent).getNameIdentifier();
        }
        if (typeElement != null && anchor != null) {
            return JavaSharedImplUtil.getType(typeElement, anchor, this);
        }
        return null;
    }
}

