/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.lang.reflect.Modifier;
import net.sf.cglib.core.AbstractClassGenerator;
import org.jetbrains.annotations.NotNull;

public class InstanceofCheckerGenerator {
    private static final InstanceofCheckerGenerator ourInstance;
    private final ConcurrentFactoryMap<Class, Condition<Object>> myCache = new ConcurrentFactoryMap<Class, Condition<Object>>(){

        @Override
        protected Condition<Object> create(final Class key) {
            if (key.isAnonymousClass() || Modifier.isPrivate(key.getModifiers())) {
                return new Condition<Object>(){

                    @Override
                    public boolean value(Object o) {
                        return key.isInstance(o);
                    }
                };
            }
            return new InstanceofClassGenerator(key).createClass();
        }
    };

    public static InstanceofCheckerGenerator getInstance() {
        return ourInstance;
    }

    @NotNull
    public Condition<Object> getInstanceofChecker(Class<?> someClass) {
        Condition condition = (Condition)this.myCache.get(someClass);
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/InstanceofCheckerGenerator", "getInstanceofChecker"));
        }
        return condition;
    }

    static {
        try {
            ourInstance = new InstanceofCheckerGenerator();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static class InstanceofClassGenerator
    extends AbstractClassGenerator {
        private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source("IntellijInstanceof");
        private final Class<?> myCheckedClass;

        public InstanceofClassGenerator(Class<?> checkedClass) {
            super(SOURCE);
            this.myCheckedClass = checkedClass;
        }

        @Override
        protected ClassLoader getDefaultClassLoader() {
            return this.myCheckedClass.getClassLoader();
        }

        public Condition<Object> createClass() {
            return (Condition)super.create(this.myCheckedClass);
        }

        @Override
        protected Object firstInstance(Class type) throws Exception {
            return type.newInstance();
        }
    }
}

