/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.Tag;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

class JDOMElementBinding
implements Binding {
    private final Accessor myAccessor;
    private final String myTagName;

    public JDOMElementBinding(Accessor accessor) {
        this.myAccessor = accessor;
        Tag tag = XmlSerializerImpl.findAnnotation(this.myAccessor.getAnnotations(), Tag.class);
        assert (tag != null) : "jdom.Element property without @Tag annotation: " + accessor;
        this.myTagName = tag.value();
    }

    @Override
    @Nullable
    public Object deserialize(Object context, Object ... nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/util/xmlb/JDOMElementBinding", "deserialize"));
        }
        Element[] result2 = new Element[nodes.length];
        System.arraycopy(nodes, 0, result2, 0, nodes.length);
        if (this.myAccessor.getValueClass().isArray()) {
            this.myAccessor.write(context, result2);
        } else {
            assert (result2.length == 1);
            this.myAccessor.write(context, result2[0]);
        }
        return context;
    }

    @Override
    public boolean isBoundTo(Object node) {
        return node instanceof Element && ((Element)node).getName().equals(this.myTagName);
    }

    @Override
    public Class getBoundNodeType() {
        throw new UnsupportedOperationException("Method getBoundNodeType is not supported in " + this.getClass());
    }

    @Override
    public void init() {
    }
}

