/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.intrinsics;

import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.intrinsics.IntrinsicMethod;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public class CompareTo
extends IntrinsicMethod {
    @Override
    @NotNull
    public Type generateImpl(@NotNull ExpressionCodegen codegen, @NotNull InstructionAdapter v, @NotNull Type returnType, @Nullable PsiElement element, @Nullable List<JetExpression> arguments, StackValue receiver) {
        JetExpression argument;
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/jet/codegen/intrinsics/CompareTo", "generateImpl"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/intrinsics/CompareTo", "generateImpl"));
        }
        if (returnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/jet/codegen/intrinsics/CompareTo", "generateImpl"));
        }
        assert (arguments != null);
        if (arguments.size() == 1) {
            argument = arguments.get(0);
        } else if (arguments.size() == 2) {
            receiver = codegen.gen(arguments.get(0));
            argument = arguments.get(1);
        } else {
            throw new IllegalStateException("Invalid arguments to compareTo: " + arguments);
        }
        Type type = AsmUtil.comparisonOperandType(receiver.type, codegen.expressionType(argument));
        receiver.put(type, v);
        codegen.gen(argument, type);
        if (type == Type.INT_TYPE) {
            v.invokestatic("kotlin/jvm/internal/Intrinsics", "compare", "(II)I", false);
        } else if (type == Type.LONG_TYPE) {
            v.invokestatic("kotlin/jvm/internal/Intrinsics", "compare", "(JJ)I", false);
        } else if (type == Type.FLOAT_TYPE) {
            v.invokestatic("java/lang/Float", "compare", "(FF)I", false);
        } else if (type == Type.DOUBLE_TYPE) {
            v.invokestatic("java/lang/Double", "compare", "(DD)I", false);
        } else {
            throw new UnsupportedOperationException();
        }
        Type type2 = Type.INT_TYPE;
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/intrinsics/CompareTo", "generateImpl"));
        }
        return type2;
    }
}

