/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.when;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.constants.EnumValue;

public class WhenByEnumsMapping {
    private final Map<EnumValue, Integer> map = new HashMap<EnumValue, Integer>();
    private final String enumClassInternalName;
    private final String outerClassInternalNameForExpression;
    private final String mappingsClassInternalName;
    private final int fieldNumber;

    public WhenByEnumsMapping(String enumClassInternalName, String outerClassInternalNameForExpression, int fieldNumber) {
        this.enumClassInternalName = enumClassInternalName;
        this.outerClassInternalNameForExpression = outerClassInternalNameForExpression;
        this.mappingsClassInternalName = outerClassInternalNameForExpression + "$WhenMappings";
        this.fieldNumber = fieldNumber;
    }

    public int getIndexByEntry(@NotNull EnumValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/jet/codegen/when/WhenByEnumsMapping", "getIndexByEntry"));
        }
        Integer result2 = this.map.get(value);
        assert (result2 != null) : "entry " + value + " has no mapping";
        return result2;
    }

    public void putFirstTime(EnumValue value, int index) {
        if (!this.map.containsKey(value)) {
            this.map.put(value, index);
        }
    }

    public int size() {
        return this.map.size();
    }

    public String getFieldName() {
        return "$EnumSwitchMapping$" + this.fieldNumber;
    }

    public String getEnumClassInternalName() {
        return this.enumClassInternalName;
    }

    public String getOuterClassInternalNameForExpression() {
        return this.outerClassInternalNameForExpression;
    }

    public String getMappingsClassInternalName() {
        return this.mappingsClassInternalName;
    }

    public Iterable<Map.Entry<EnumValue, Integer>> enumValuesToIntMapping() {
        return this.map.entrySet();
    }
}

