/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors.impl;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.descriptors.SourceElement;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.DeclarationDescriptorNonRootImpl;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.ReceiverParameterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.ScriptCodeDescriptor;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.RedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ScriptReceiver;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class ScriptDescriptorImpl
extends DeclarationDescriptorNonRootImpl
implements ScriptDescriptor {
    private final int priority;
    private List<ValueParameterDescriptor> valueParameters;
    private final ScriptCodeDescriptor scriptCodeDescriptor;
    private final ReceiverParameterDescriptor implicitReceiver;
    private final MutableClassDescriptor classDescriptor;
    private final WritableScopeImpl classScope;
    private WritableScope scopeForBodyResolution;
    private PropertyDescriptor scriptResultProperty;

    public ScriptDescriptorImpl(@NotNull DeclarationDescriptor containingDeclaration, int priority, @NotNull JetScope scriptScope, @NotNull Name className, @NotNull SourceElement source) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/jet/lang/descriptors/impl/ScriptDescriptorImpl", "<init>"));
        }
        if (scriptScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptScope", "org/jetbrains/jet/lang/descriptors/impl/ScriptDescriptorImpl", "<init>"));
        }
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/jet/lang/descriptors/impl/ScriptDescriptorImpl", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/jet/lang/descriptors/impl/ScriptDescriptorImpl", "<init>"));
        }
        super(containingDeclaration, Annotations.EMPTY, NAME, source);
        this.scriptCodeDescriptor = new ScriptCodeDescriptor(this);
        this.implicitReceiver = new ReceiverParameterDescriptorImpl(this, KotlinBuiltIns.getInstance().getAnyType(), new ScriptReceiver(this));
        this.priority = priority;
        this.classDescriptor = new MutableClassDescriptor(containingDeclaration, scriptScope, ClassKind.CLASS, false, className, SourceElement.NO_SOURCE);
        this.classDescriptor.addSupertype(KotlinBuiltIns.getInstance().getAnyType());
        this.classDescriptor.setModality(Modality.FINAL);
        this.classDescriptor.setVisibility(Visibilities.PUBLIC);
        this.classDescriptor.setTypeParameterDescriptors(Collections.<TypeParameterDescriptor>emptyList());
        this.classScope = new WritableScopeImpl(JetScope.EMPTY, this.classDescriptor, RedeclarationHandler.DO_NOTHING, "script members");
        this.classScope.changeLockLevel(WritableScope.LockLevel.BOTH);
        this.classDescriptor.setScopeForMemberLookup(this.classScope);
        this.classDescriptor.createTypeConstructor();
    }

    public void initialize(@NotNull JetType returnType, @NotNull List<? extends PropertyDescriptorImpl> properties, @NotNull List<? extends FunctionDescriptor> functions2) {
        if (returnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/jet/lang/descriptors/impl/ScriptDescriptorImpl", "initialize"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/jet/lang/descriptors/impl/ScriptDescriptorImpl", "initialize"));
        }
        if (functions2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functions", "org/jetbrains/jet/lang/descriptors/impl/ScriptDescriptorImpl", "initialize"));
        }
        assert (this.valueParameters != null) : "setValueParameters() must be called before this method";
        this.scriptCodeDescriptor.initialize(this.implicitReceiver, this.valueParameters, returnType);
        this.scriptResultProperty = ScriptDescriptorImpl.createScriptResultProperty(this);
        this.classScope.addPropertyDescriptor(this.scriptResultProperty);
        for (PropertyDescriptorImpl propertyDescriptorImpl : properties) {
            this.classScope.addPropertyDescriptor(propertyDescriptorImpl);
        }
        for (FunctionDescriptor functionDescriptor : functions2) {
            this.classScope.addFunctionDescriptor(functionDescriptor);
        }
    }

    @NotNull
    public static PropertyDescriptor createScriptResultProperty(@NotNull ScriptDescriptor scriptDescriptor) {
        if (scriptDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptDescriptor", "org/jetbrains/jet/lang/descriptors/impl/ScriptDescriptorImpl", "createScriptResultProperty"));
        }
        PropertyDescriptorImpl propertyDescriptor = PropertyDescriptorImpl.create(scriptDescriptor.getClassDescriptor(), Annotations.EMPTY, Modality.FINAL, Visibilities.PUBLIC, false, Name.identifier("rv"), CallableMemberDescriptor.Kind.DECLARATION, SourceElement.NO_SOURCE);
        JetType returnType = scriptDescriptor.getScriptCodeDescriptor().getReturnType();
        assert (returnType != null) : "Return type not initialized for " + scriptDescriptor;
        propertyDescriptor.setType(returnType, Collections.emptyList(), scriptDescriptor.getThisAsReceiverParameter(), ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER);
        propertyDescriptor.initialize(null, null);
        PropertyDescriptorImpl propertyDescriptorImpl = propertyDescriptor;
        if (propertyDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/ScriptDescriptorImpl", "createScriptResultProperty"));
        }
        return propertyDescriptorImpl;
    }

    @Override
    @NotNull
    public PropertyDescriptor getScriptResultProperty() {
        PropertyDescriptor propertyDescriptor = this.scriptResultProperty;
        if (propertyDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/ScriptDescriptorImpl", "getScriptResultProperty"));
        }
        return propertyDescriptor;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    @NotNull
    public ScriptCodeDescriptor getScriptCodeDescriptor() {
        ScriptCodeDescriptor scriptCodeDescriptor = this.scriptCodeDescriptor;
        if (scriptCodeDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/ScriptDescriptorImpl", "getScriptCodeDescriptor"));
        }
        return scriptCodeDescriptor;
    }

    @Override
    @NotNull
    public ReceiverParameterDescriptor getThisAsReceiverParameter() {
        ReceiverParameterDescriptor receiverParameterDescriptor = this.implicitReceiver;
        if (receiverParameterDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/ScriptDescriptorImpl", "getThisAsReceiverParameter"));
        }
        return receiverParameterDescriptor;
    }

    @Override
    public DeclarationDescriptor substitute(@NotNull TypeSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/jet/lang/descriptors/impl/ScriptDescriptorImpl", "substitute"));
        }
        throw new IllegalStateException("nothing to substitute in script");
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data2) {
        return visitor.visitScriptDescriptor(this, data2);
    }

    public void setValueParameters(@NotNull List<ValueParameterDescriptor> valueParameters) {
        if (valueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameters", "org/jetbrains/jet/lang/descriptors/impl/ScriptDescriptorImpl", "setValueParameters"));
        }
        this.valueParameters = valueParameters;
        ConstructorDescriptorImpl constructorDescriptor = ScriptDescriptorImpl.createConstructor(this, valueParameters);
        constructorDescriptor.setReturnType(this.classDescriptor.getDefaultType());
        this.classDescriptor.getConstructors().add(constructorDescriptor);
        this.classDescriptor.setPrimaryConstructor(constructorDescriptor);
        for (ValueParameterDescriptor valueParameter : valueParameters) {
            this.classScope.addPropertyDescriptor(ScriptDescriptorImpl.createPropertyFromScriptParameter(this, valueParameter));
        }
    }

    @NotNull
    public static ConstructorDescriptorImpl createConstructor(@NotNull ScriptDescriptor scriptDescriptor, @NotNull List<ValueParameterDescriptor> valueParameters) {
        if (scriptDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptDescriptor", "org/jetbrains/jet/lang/descriptors/impl/ScriptDescriptorImpl", "createConstructor"));
        }
        if (valueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameters", "org/jetbrains/jet/lang/descriptors/impl/ScriptDescriptorImpl", "createConstructor"));
        }
        ConstructorDescriptorImpl constructorDescriptorImpl = ConstructorDescriptorImpl.create(scriptDescriptor.getClassDescriptor(), Annotations.EMPTY, true, SourceElement.NO_SOURCE).initialize(Collections.<TypeParameterDescriptor>emptyList(), valueParameters, Visibilities.PUBLIC, false);
        if (constructorDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/ScriptDescriptorImpl", "createConstructor"));
        }
        return constructorDescriptorImpl;
    }

    @NotNull
    public static PropertyDescriptor createPropertyFromScriptParameter(@NotNull ScriptDescriptor scriptDescriptor, @NotNull ValueParameterDescriptor parameter) {
        if (scriptDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptDescriptor", "org/jetbrains/jet/lang/descriptors/impl/ScriptDescriptorImpl", "createPropertyFromScriptParameter"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/jet/lang/descriptors/impl/ScriptDescriptorImpl", "createPropertyFromScriptParameter"));
        }
        PropertyDescriptorImpl propertyDescriptor = PropertyDescriptorImpl.create(scriptDescriptor.getClassDescriptor(), Annotations.EMPTY, Modality.FINAL, Visibilities.PUBLIC, false, parameter.getName(), CallableMemberDescriptor.Kind.DECLARATION, SourceElement.NO_SOURCE);
        propertyDescriptor.setType(parameter.getType(), Collections.emptyList(), scriptDescriptor.getThisAsReceiverParameter(), ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER);
        propertyDescriptor.initialize(null, null);
        PropertyDescriptorImpl propertyDescriptorImpl = propertyDescriptor;
        if (propertyDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/ScriptDescriptorImpl", "createPropertyFromScriptParameter"));
        }
        return propertyDescriptorImpl;
    }

    @Override
    @NotNull
    public ClassDescriptor getClassDescriptor() {
        MutableClassDescriptor mutableClassDescriptor = this.classDescriptor;
        if (mutableClassDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/ScriptDescriptorImpl", "getClassDescriptor"));
        }
        return mutableClassDescriptor;
    }

    @Override
    @NotNull
    public WritableScope getScopeForBodyResolution() {
        WritableScope writableScope = this.scopeForBodyResolution;
        if (writableScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/ScriptDescriptorImpl", "getScopeForBodyResolution"));
        }
        return writableScope;
    }

    public void setScopeForBodyResolution(@NotNull WritableScope scopeForBodyResolution) {
        if (scopeForBodyResolution == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeForBodyResolution", "org/jetbrains/jet/lang/descriptors/impl/ScriptDescriptorImpl", "setScopeForBodyResolution"));
        }
        assert (this.scopeForBodyResolution == null) : "Scope for body resolution already set for " + this;
        this.scopeForBodyResolution = scopeForBodyResolution;
    }
}

