/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifiableCodeBlock;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.ReadOnly;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpressionImpl;
import org.jetbrains.jet.lang.psi.JetModifiableBlockHelper;
import org.jetbrains.jet.lang.psi.JetStatementExpression;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lexer.JetTokens;

public class JetBlockExpression
extends JetExpressionImpl
implements PsiModifiableCodeBlock,
JetStatementExpression {
    public JetBlockExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/psi/JetBlockExpression", "<init>"));
        }
        super(node);
    }

    @Override
    public boolean shouldChangeModificationCount(PsiElement place) {
        return JetModifiableBlockHelper.shouldChangeModificationCount(place);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetBlockExpression", "accept"));
        }
        return visitor.visitBlockExpression(this, data2);
    }

    @ReadOnly
    @NotNull
    public List<JetElement> getStatements() {
        List<JetElement> list = Arrays.asList(this.findChildrenByClass(JetElement.class));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetBlockExpression", "getStatements"));
        }
        return list;
    }

    @Nullable
    public TextRange getLastBracketRange() {
        PsiElement rBrace = this.getRBrace();
        return rBrace != null ? rBrace.getTextRange() : null;
    }

    @Nullable
    public PsiElement getRBrace() {
        return this.findChildByType(JetTokens.RBRACE);
    }

    @Nullable
    public PsiElement getLBrace() {
        return this.findChildByType(JetTokens.LBRACE);
    }
}

