/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageViewDescriptor;
import org.jetbrains.jet.lang.descriptors.SourceElement;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.EnumClassObjectDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.MutablePackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.PackageLikeBuilder;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclarationContainer;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetEnumEntry;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetNamedDeclarationUtil;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetPackageDirective;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetTypedef;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.DescriptorToSourceUtils;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.ImportsResolver;
import org.jetbrains.jet.lang.resolve.ModifiersChecker;
import org.jetbrains.jet.lang.resolve.MutablePackageFragmentProvider;
import org.jetbrains.jet.lang.resolve.ScriptHeaderResolver;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisContext;
import org.jetbrains.jet.lang.resolve.TraceBasedRedeclarationHandler;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.name.SpecialNames;
import org.jetbrains.jet.lang.resolve.scopes.ChainedScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WriteThroughScope;
import org.jetbrains.jet.lang.resolve.source.SourcePackage;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.storage.LockBasedStorageManager;
import org.jetbrains.jet.utils.DFS;

public class TypeHierarchyResolver {
    private static final DFS.Neighbors<ClassDescriptor> CLASS_INHERITANCE_EDGES = new DFS.Neighbors<ClassDescriptor>(){

        @Override
        @NotNull
        public Iterable<ClassDescriptor> getNeighbors(ClassDescriptor current) {
            ArrayList<ClassDescriptor> result2 = new ArrayList<ClassDescriptor>();
            for (JetType supertype : current.getDefaultType().getConstructor().getSupertypes()) {
                ClassifierDescriptor descriptor = supertype.getConstructor().getDeclarationDescriptor();
                if (!(descriptor instanceof ClassDescriptor)) continue;
                result2.add((ClassDescriptor)descriptor);
            }
            DeclarationDescriptor container = current.getContainingDeclaration();
            if (container instanceof ClassDescriptor) {
                result2.add((ClassDescriptor)container);
            }
            ArrayList<ClassDescriptor> arrayList = result2;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$1", "getNeighbors"));
            }
            return arrayList;
        }
    };
    @NotNull
    private ImportsResolver importsResolver;
    @NotNull
    private DescriptorResolver descriptorResolver;
    @NotNull
    private ScriptHeaderResolver scriptHeaderResolver;
    @NotNull
    private MutablePackageFragmentProvider packageFragmentProvider;
    @NotNull
    private BindingTrace trace;

    public void setImportsResolver(@NotNull ImportsResolver importsResolver) {
        if (importsResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importsResolver", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "setImportsResolver"));
        }
        this.importsResolver = importsResolver;
    }

    public void setDescriptorResolver(@NotNull DescriptorResolver descriptorResolver) {
        if (descriptorResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorResolver", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "setDescriptorResolver"));
        }
        this.descriptorResolver = descriptorResolver;
    }

    public void setScriptHeaderResolver(@NotNull ScriptHeaderResolver scriptHeaderResolver) {
        if (scriptHeaderResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptHeaderResolver", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "setScriptHeaderResolver"));
        }
        this.scriptHeaderResolver = scriptHeaderResolver;
    }

    public void setPackageFragmentProvider(@NotNull MutablePackageFragmentProvider packageFragmentProvider) {
        if (packageFragmentProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFragmentProvider", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "setPackageFragmentProvider"));
        }
        this.packageFragmentProvider = packageFragmentProvider;
    }

    public void setTrace(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "setTrace"));
        }
        this.trace = trace;
    }

    public void process(@NotNull TopDownAnalysisContext c, @NotNull JetScope outerScope, @NotNull PackageLikeBuilder owner, @NotNull Collection<? extends PsiElement> declarations) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "process"));
        }
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "process"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "process"));
        }
        if (declarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "process"));
        }
        LinkedList<JetDeclarationContainer> forDeferredResolve = new LinkedList<JetDeclarationContainer>();
        forDeferredResolve.addAll(this.collectPackageFragmentsAndClassifiers(c, outerScope, owner, declarations));
        while (!forDeferredResolve.isEmpty()) {
            JetDeclarationContainer declarationContainer = (JetDeclarationContainer)forDeferredResolve.poll();
            assert (declarationContainer != null);
            DeclarationDescriptor descriptorForDeferredResolve = c.forDeferredResolver.get(declarationContainer);
            JetScope scope = c.normalScope.get(declarationContainer);
            if (descriptorForDeferredResolve instanceof MutableClassDescriptor) {
                forDeferredResolve.addAll(this.collectPackageFragmentsAndClassifiers(c, scope, ((MutableClassDescriptor)descriptorForDeferredResolve).getBuilder(), declarationContainer.getDeclarations()));
                continue;
            }
            if (descriptorForDeferredResolve instanceof MutablePackageFragmentDescriptor) {
                forDeferredResolve.addAll(this.collectPackageFragmentsAndClassifiers(c, scope, ((MutablePackageFragmentDescriptor)descriptorForDeferredResolve).getBuilder(), declarationContainer.getDeclarations()));
                continue;
            }
            assert (false);
        }
        this.importsResolver.processTypeImports(c);
        this.createTypeConstructors(c);
        this.resolveTypesInClassHeaders(c);
        c.setClassesTopologicalOrder(TypeHierarchyResolver.topologicallySortClassesAndObjects(c));
        this.detectAndDisconnectLoops(c);
    }

    @NotNull
    private Collection<JetDeclarationContainer> collectPackageFragmentsAndClassifiers(@NotNull TopDownAnalysisContext c, @NotNull JetScope outerScope, @NotNull PackageLikeBuilder owner, @NotNull Iterable<? extends PsiElement> declarations) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "collectPackageFragmentsAndClassifiers"));
        }
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "collectPackageFragmentsAndClassifiers"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "collectPackageFragmentsAndClassifiers"));
        }
        if (declarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "collectPackageFragmentsAndClassifiers"));
        }
        ArrayList<JetDeclarationContainer> forDeferredResolve = new ArrayList<JetDeclarationContainer>();
        ClassifierCollector collector2 = new ClassifierCollector(c, outerScope, owner, forDeferredResolve);
        for (PsiElement psiElement : declarations) {
            psiElement.accept(collector2);
        }
        ArrayList<JetDeclarationContainer> arrayList = forDeferredResolve;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "collectPackageFragmentsAndClassifiers"));
        }
        return arrayList;
    }

    @NotNull
    private static ClassKind getClassKind(@NotNull JetClass jetClass) {
        if (jetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetClass", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "getClassKind"));
        }
        if (jetClass.isTrait()) {
            ClassKind classKind = ClassKind.TRAIT;
            if (classKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "getClassKind"));
            }
            return classKind;
        }
        if (jetClass.isAnnotation()) {
            ClassKind classKind = ClassKind.ANNOTATION_CLASS;
            if (classKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "getClassKind"));
            }
            return classKind;
        }
        if (jetClass.isEnum()) {
            ClassKind classKind = ClassKind.ENUM_CLASS;
            if (classKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "getClassKind"));
            }
            return classKind;
        }
        ClassKind classKind = ClassKind.CLASS;
        if (classKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "getClassKind"));
        }
        return classKind;
    }

    private void createTypeConstructors(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "createTypeConstructors"));
        }
        for (Map.Entry<JetClassOrObject, ClassDescriptorWithResolutionScopes> entry : c.getDeclaredClasses().entrySet()) {
            JetClassOrObject classOrObject = entry.getKey();
            MutableClassDescriptor descriptor = (MutableClassDescriptor)entry.getValue();
            if (classOrObject instanceof JetClass) {
                this.descriptorResolver.resolveMutableClassDescriptor(c.getTopDownAnalysisParameters(), (JetClass)classOrObject, descriptor, this.trace);
            } else if (classOrObject instanceof JetObjectDeclaration) {
                descriptor.setModality(Modality.FINAL);
                descriptor.setVisibility(ModifiersChecker.resolveVisibilityFromModifiers(classOrObject, ModifiersChecker.getDefaultClassVisibility(descriptor)));
                descriptor.setTypeParameterDescriptors(Collections.<TypeParameterDescriptor>emptyList());
            }
            descriptor.createTypeConstructor();
            ClassKind kind = descriptor.getKind();
            if (kind != ClassKind.ENUM_ENTRY && kind != ClassKind.OBJECT) continue;
            MutableClassDescriptor classObject = (MutableClassDescriptor)descriptor.getClassObjectDescriptor();
            assert (classObject != null) : "Enum entries and named objects should have class objects: " + classOrObject.getText();
            classObject.setSupertypes(Collections.singleton(descriptor.getDefaultType()));
            classObject.createTypeConstructor();
        }
    }

    private void resolveTypesInClassHeaders(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "resolveTypesInClassHeaders"));
        }
        for (Map.Entry<JetClassOrObject, ClassDescriptorWithResolutionScopes> entry : c.getDeclaredClasses().entrySet()) {
            JetClassOrObject classOrObject = entry.getKey();
            if (!(classOrObject instanceof JetClass)) continue;
            ClassDescriptorWithResolutionScopes descriptor = entry.getValue();
            this.descriptorResolver.resolveGenericBounds((JetClass)classOrObject, descriptor, descriptor.getScopeForClassHeaderResolution(), descriptor.getTypeConstructor().getParameters(), this.trace);
        }
        for (Map.Entry<JetClassOrObject, ClassDescriptorWithResolutionScopes> entry : c.getDeclaredClasses().entrySet()) {
            this.descriptorResolver.resolveSupertypesForMutableClassDescriptor(entry.getKey(), (MutableClassDescriptor)entry.getValue(), this.trace);
        }
    }

    @NotNull
    private static List<MutableClassDescriptor> topologicallySortClassesAndObjects(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "topologicallySortClassesAndObjects"));
        }
        Collection<ClassDescriptorWithResolutionScopes> sourceClasses = c.getAllClasses();
        List<ClassDescriptor> allClassesOrdered = DFS.topologicalOrder(sourceClasses, CLASS_INHERITANCE_EDGES);
        allClassesOrdered.retainAll(sourceClasses);
        List<ClassDescriptor> list = allClassesOrdered;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "topologicallySortClassesAndObjects"));
        }
        return list;
    }

    private void detectAndDisconnectLoops(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "detectAndDisconnectLoops"));
        }
        ArrayList<2> tasks = new ArrayList<2>();
        for (final MutableClassDescriptor mutableClassDescriptor : c.getClassesTopologicalOrder()) {
            for (final JetType supertype : mutableClassDescriptor.getSupertypes()) {
                ClassDescriptor superclass;
                ClassifierDescriptor supertypeDescriptor = supertype.getConstructor().getDeclarationDescriptor();
                if (!(supertypeDescriptor instanceof ClassDescriptor) || !TypeHierarchyResolver.isReachable(superclass = (ClassDescriptor)supertypeDescriptor, mutableClassDescriptor, new HashSet<ClassDescriptor>())) continue;
                tasks.add(new Runnable(){

                    @Override
                    public void run() {
                        mutableClassDescriptor.getSupertypes().remove(supertype);
                    }
                });
                TypeHierarchyResolver.reportCyclicInheritanceHierarchyError(this.trace, mutableClassDescriptor, superclass);
            }
        }
        for (Runnable runnable2 : tasks) {
            runnable2.run();
        }
    }

    private static boolean isReachable(@NotNull ClassDescriptor from, @NotNull MutableClassDescriptor to, @NotNull Set<ClassDescriptor> visited) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "isReachable"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "isReachable"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "isReachable"));
        }
        if (!visited.add(from)) {
            return false;
        }
        for (ClassDescriptor superclass : CLASS_INHERITANCE_EDGES.getNeighbors(from)) {
            if (superclass != to && !TypeHierarchyResolver.isReachable(superclass, to, visited)) continue;
            return true;
        }
        return false;
    }

    public static void reportCyclicInheritanceHierarchyError(@NotNull BindingTrace trace, @NotNull ClassDescriptor classDescriptor, @NotNull ClassDescriptor superclass) {
        PsiNameIdentifierOwner namedElement;
        PsiElement nameIdentifier;
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "reportCyclicInheritanceHierarchyError"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "reportCyclicInheritanceHierarchyError"));
        }
        if (superclass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superclass", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "reportCyclicInheritanceHierarchyError"));
        }
        PsiElement psiElement = DescriptorToSourceUtils.classDescriptorToDeclaration(classDescriptor);
        PsiElement elementToMark = null;
        if (psiElement instanceof JetClassOrObject) {
            JetClassOrObject classOrObject = (JetClassOrObject)psiElement;
            for (JetDelegationSpecifier delegationSpecifier : classOrObject.getDelegationSpecifiers()) {
                JetType supertype;
                JetTypeReference typeReference = delegationSpecifier.getTypeReference();
                if (typeReference == null || (supertype = trace.get(BindingContext.TYPE, typeReference)) == null || supertype.getConstructor() != superclass.getTypeConstructor()) continue;
                elementToMark = typeReference;
            }
        }
        if (elementToMark == null && psiElement instanceof PsiNameIdentifierOwner && (nameIdentifier = (namedElement = (PsiNameIdentifierOwner)psiElement).getNameIdentifier()) != null) {
            elementToMark = nameIdentifier;
        }
        if (elementToMark != null) {
            trace.report(Errors.CYCLIC_INHERITANCE_HIERARCHY.on(elementToMark));
        }
    }

    private class ClassifierCollector
    extends JetVisitorVoid {
        private final TopDownAnalysisContext c;
        private final JetScope outerScope;
        private final PackageLikeBuilder owner;
        private final Collection<JetDeclarationContainer> forDeferredResolve;

        public ClassifierCollector(@NotNull TopDownAnalysisContext c, @NotNull JetScope outerScope, @NotNull PackageLikeBuilder owner, @NotNull Collection<JetDeclarationContainer> forDeferredResolve) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "<init>"));
            }
            if (outerScope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "<init>"));
            }
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "<init>"));
            }
            if (forDeferredResolve == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forDeferredResolve", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "<init>"));
            }
            this.c = c;
            this.outerScope = outerScope;
            this.owner = owner;
            this.forDeferredResolve = forDeferredResolve;
        }

        @Override
        public void visitJetFile(@NotNull JetFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "visitJetFile"));
            }
            MutablePackageFragmentDescriptor packageFragment = this.getOrCreatePackageFragmentForFile(file);
            this.c.getPackageFragments().put(file, packageFragment);
            this.c.addFile(file);
            PackageViewDescriptor packageView = packageFragment.getContainingDeclaration().getPackage(packageFragment.getFqName());
            ChainedScope rootPlusPackageScope = new ChainedScope(packageView, "Root scope for " + file, packageView.getMemberScope(), this.outerScope);
            WriteThroughScope packageScope = new WriteThroughScope(rootPlusPackageScope, packageFragment.getMemberScope(), new TraceBasedRedeclarationHandler(TypeHierarchyResolver.this.trace), "package in file " + file.getName());
            packageScope.changeLockLevel(WritableScope.LockLevel.BOTH);
            this.c.getFileScopes().put(file, packageScope);
            if (file.isScript()) {
                TypeHierarchyResolver.this.scriptHeaderResolver.processScriptHierarchy(this.c, file.getScript(), packageScope);
            }
            this.prepareForDeferredCall(packageScope, packageFragment, file);
        }

        @Override
        public void visitClass(@NotNull JetClass klass) {
            if (klass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "visitClass"));
            }
            MutableClassDescriptor mutableClassDescriptor = this.createClassDescriptorForClass(klass, this.owner.getOwnerForChildren());
            this.owner.addClassifierDescriptor(mutableClassDescriptor);
        }

        @Override
        public void visitObjectDeclaration(@NotNull JetObjectDeclaration declaration) {
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "visitObjectDeclaration"));
            }
            if (declaration.isObjectLiteral()) {
                this.createClassDescriptorForSingleton(declaration, SpecialNames.NO_NAME_PROVIDED, ClassKind.CLASS);
                return;
            }
            MutableClassDescriptor descriptor = this.createClassDescriptorForSingleton(declaration, JetPsiUtil.safeName(declaration.getName()), ClassKind.OBJECT);
            this.owner.addClassifierDescriptor(descriptor);
            TypeHierarchyResolver.this.trace.record(BindingContext.FQNAME_TO_CLASS_DESCRIPTOR, JetNamedDeclarationUtil.getUnsafeFQName(declaration), descriptor);
            descriptor.getBuilder().setClassObjectDescriptor(this.createSyntheticClassObjectForSingleton(descriptor));
        }

        @Override
        public void visitEnumEntry(@NotNull JetEnumEntry declaration) {
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "visitEnumEntry"));
            }
            MutableClassDescriptor descriptor = this.createClassDescriptorForSingleton(declaration, JetPsiUtil.safeName(declaration.getName()), ClassKind.ENUM_ENTRY);
            this.owner.addClassifierDescriptor(descriptor);
            descriptor.getBuilder().setClassObjectDescriptor(this.createSyntheticClassObjectForSingleton(descriptor));
        }

        @Override
        public void visitTypedef(@NotNull JetTypedef typedef) {
            if (typedef == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typedef", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "visitTypedef"));
            }
            TypeHierarchyResolver.this.trace.report(Errors.UNSUPPORTED.on(typedef, "TypeHierarchyResolver"));
        }

        @Override
        public void visitClassObject(@NotNull JetClassObject classObject) {
            if (classObject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classObject", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "visitClassObject"));
            }
            JetObjectDeclaration objectDeclaration = classObject.getObjectDeclaration();
            DeclarationDescriptor container = this.owner.getOwnerForChildren();
            MutableClassDescriptor classObjectDescriptor = this.createClassDescriptorForSingleton(objectDeclaration, SpecialNames.getClassObjectName(container.getName()), ClassKind.CLASS_OBJECT);
            PackageLikeBuilder.ClassObjectStatus status = DescriptorUtils.isEnumEntry(container) || DescriptorUtils.isObject(container) || this.c.getTopDownAnalysisParameters().isDeclaredLocally() ? PackageLikeBuilder.ClassObjectStatus.NOT_ALLOWED : this.owner.setClassObjectDescriptor(classObjectDescriptor);
            switch (status) {
                case DUPLICATE: {
                    TypeHierarchyResolver.this.trace.report(Errors.MANY_CLASS_OBJECTS.on(classObject));
                    break;
                }
                case NOT_ALLOWED: {
                    TypeHierarchyResolver.this.trace.report(Errors.CLASS_OBJECT_NOT_ALLOWED.on(classObject));
                    break;
                }
            }
        }

        @NotNull
        private MutablePackageFragmentDescriptor getOrCreatePackageFragmentForFile(@NotNull JetFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "getOrCreatePackageFragmentForFile"));
            }
            JetPackageDirective packageDirective = file.getPackageDirective();
            assert (packageDirective != null) : "scripts are not supported";
            MutablePackageFragmentDescriptor fragment = TypeHierarchyResolver.this.packageFragmentProvider.getOrCreateFragment(packageDirective.getFqName());
            ModuleDescriptor module = TypeHierarchyResolver.this.packageFragmentProvider.getModule();
            DescriptorResolver.resolvePackageHeader(packageDirective, module, TypeHierarchyResolver.this.trace);
            DescriptorResolver.registerFileInPackage(TypeHierarchyResolver.this.trace, file);
            TypeHierarchyResolver.this.trace.record(BindingContext.FILE_TO_PACKAGE_FRAGMENT, file, fragment);
            MutablePackageFragmentDescriptor mutablePackageFragmentDescriptor = fragment;
            if (mutablePackageFragmentDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "getOrCreatePackageFragmentForFile"));
            }
            return mutablePackageFragmentDescriptor;
        }

        @NotNull
        private MutableClassDescriptor createSyntheticClassObjectForSingleton(@NotNull ClassDescriptor classDescriptor) {
            if (classDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "createSyntheticClassObjectForSingleton"));
            }
            MutableClassDescriptor classObject = new MutableClassDescriptor(classDescriptor, this.outerScope, ClassKind.CLASS_OBJECT, false, SpecialNames.getClassObjectName(classDescriptor.getName()), SourceElement.NO_SOURCE);
            classObject.setModality(Modality.FINAL);
            classObject.setVisibility(DescriptorUtils.getSyntheticClassObjectVisibility());
            classObject.setTypeParameterDescriptors(Collections.<TypeParameterDescriptor>emptyList());
            this.createPrimaryConstructorForObject(null, classObject);
            MutableClassDescriptor mutableClassDescriptor = classObject;
            if (mutableClassDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "createSyntheticClassObjectForSingleton"));
            }
            return mutableClassDescriptor;
        }

        @NotNull
        private MutableClassDescriptor createClassDescriptorForClass(@NotNull JetClass klass, @NotNull DeclarationDescriptor containingDeclaration) {
            if (klass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "createClassDescriptorForClass"));
            }
            if (containingDeclaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "createClassDescriptorForClass"));
            }
            ClassKind kind = TypeHierarchyResolver.getClassKind(klass);
            boolean isInner = kind == ClassKind.CLASS && klass.isInner();
            MutableClassDescriptor descriptor = new MutableClassDescriptor(containingDeclaration, this.outerScope, kind, isInner, JetPsiUtil.safeName(klass.getName()), SourcePackage.toSourceElement(klass));
            this.c.getDeclaredClasses().put(klass, descriptor);
            TypeHierarchyResolver.this.trace.record(BindingContext.FQNAME_TO_CLASS_DESCRIPTOR, JetNamedDeclarationUtil.getUnsafeFQName(klass), descriptor);
            if (descriptor.getKind() == ClassKind.ENUM_CLASS) {
                EnumClassObjectDescriptor classObject = new EnumClassObjectDescriptor(LockBasedStorageManager.NO_LOCKS, descriptor);
                descriptor.getBuilder().setClassObjectDescriptor(classObject);
            }
            this.prepareForDeferredCall(descriptor.getScopeForMemberDeclarationResolution(), descriptor, klass);
            MutableClassDescriptor mutableClassDescriptor = descriptor;
            if (mutableClassDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "createClassDescriptorForClass"));
            }
            return mutableClassDescriptor;
        }

        @NotNull
        private MutableClassDescriptor createClassDescriptorForSingleton(@NotNull JetClassOrObject declaration, @NotNull Name name, @NotNull ClassKind kind) {
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "createClassDescriptorForSingleton"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "createClassDescriptorForSingleton"));
            }
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "createClassDescriptorForSingleton"));
            }
            MutableClassDescriptor descriptor = new MutableClassDescriptor(this.owner.getOwnerForChildren(), this.outerScope, kind, false, name, SourcePackage.toSourceElement(declaration));
            this.prepareForDeferredCall(descriptor.getScopeForMemberDeclarationResolution(), descriptor, declaration);
            this.createPrimaryConstructorForObject(declaration, descriptor);
            TypeHierarchyResolver.this.trace.record(BindingContext.CLASS, declaration, descriptor);
            this.c.getDeclaredClasses().put(declaration, descriptor);
            MutableClassDescriptor mutableClassDescriptor = descriptor;
            if (mutableClassDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "createClassDescriptorForSingleton"));
            }
            return mutableClassDescriptor;
        }

        @NotNull
        private ConstructorDescriptorImpl createPrimaryConstructorForObject(@Nullable JetClassOrObject object2, @NotNull MutableClassDescriptor mutableClassDescriptor) {
            if (mutableClassDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mutableClassDescriptor", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "createPrimaryConstructorForObject"));
            }
            ConstructorDescriptorImpl constructorDescriptor = DescriptorResolver.createAndRecordPrimaryConstructorForObject(object2, mutableClassDescriptor, TypeHierarchyResolver.this.trace);
            mutableClassDescriptor.setPrimaryConstructor(constructorDescriptor);
            ConstructorDescriptorImpl constructorDescriptorImpl = constructorDescriptor;
            if (constructorDescriptorImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "createPrimaryConstructorForObject"));
            }
            return constructorDescriptorImpl;
        }

        private void prepareForDeferredCall(@NotNull JetScope outerScope, @NotNull DeclarationDescriptor descriptorForDeferredResolve, @NotNull JetDeclarationContainer container) {
            if (outerScope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "prepareForDeferredCall"));
            }
            if (descriptorForDeferredResolve == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorForDeferredResolve", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "prepareForDeferredCall"));
            }
            if (container == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "prepareForDeferredCall"));
            }
            this.forDeferredResolve.add(container);
            this.c.normalScope.put(container, outerScope);
            this.c.forDeferredResolver.put(container, descriptorForDeferredResolve);
        }
    }
}

