/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import com.google.common.collect.Lists;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaPsiFacadeKotlinHacks {
    private final JavaFileManager javaFileManager;
    private final List<PsiElementFinder> extensionPsiElementFinders;

    public JavaPsiFacadeKotlinHacks(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jet/lang/resolve/java/JavaPsiFacadeKotlinHacks", "<init>"));
        }
        this.javaFileManager = JavaPsiFacadeKotlinHacks.findJavaFileManager(project);
        this.extensionPsiElementFinders = Lists.newArrayList();
        for (PsiElementFinder finder : project.getExtensions(PsiElementFinder.EP_NAME)) {
            if (finder instanceof KotlinFinderMarker) continue;
            this.extensionPsiElementFinders.add(finder);
        }
    }

    @NotNull
    private static JavaFileManager findJavaFileManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jet/lang/resolve/java/JavaPsiFacadeKotlinHacks", "findJavaFileManager"));
        }
        JavaFileManager javaFileManager = ServiceManager.getService(project, JavaFileManager.class);
        if (javaFileManager != null) {
            JavaFileManager javaFileManager2 = javaFileManager;
            if (javaFileManager2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JavaPsiFacadeKotlinHacks", "findJavaFileManager"));
            }
            return javaFileManager2;
        }
        throw new IllegalStateException("JavaFileManager component is not found in project");
    }

    @Nullable
    public PsiPackage findPackage(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/jet/lang/resolve/java/JavaPsiFacadeKotlinHacks", "findPackage"));
        }
        PsiPackage psiPackage = this.javaFileManager.findPackage(qualifiedName);
        if (psiPackage != null) {
            return psiPackage;
        }
        for (PsiElementFinder finder : this.extensionPsiElementFinders) {
            psiPackage = finder.findPackage(qualifiedName);
            if (psiPackage == null) continue;
            return psiPackage;
        }
        return null;
    }

    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/jet/lang/resolve/java/JavaPsiFacadeKotlinHacks", "findClass"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/java/JavaPsiFacadeKotlinHacks", "findClass"));
        }
        ProgressIndicatorProvider.checkCanceled();
        PsiClass aClass = this.javaFileManager.findClass(qualifiedName, scope);
        if (aClass != null) {
            return aClass;
        }
        for (PsiElementFinder finder : this.extensionPsiElementFinders) {
            aClass = finder.findClass(qualifiedName, scope);
            if (aClass == null) continue;
            return aClass;
        }
        return null;
    }

    public static interface KotlinFinderMarker {
    }
}

